/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_si extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_HT = "\u0dc4\u0dba\u0dd2\u0da7\u0dd2";
        final String metaValue_MD = "\u0db8\u0ddc\u0dbd\u0dca\u0da9\u0ddd\u0dc0\u0dcf\u0dc0";
        final String metaValue_TO = "\u0da7\u0ddc\u0d82\u0d9c\u0dcf";
        final String metaValue_ar = "\u0d85\u0dbb\u0dcf\u0db6\u0dd2";
        final String metaValue_bn = "\u0db6\u0dd9\u0d82\u0d9c\u0dcf\u0dbd\u0dd2";
        final String metaValue_el = "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0d9a";
        final String metaValue_gu = "\u0d9c\u0dd4\u0da2\u0dbb\u0dcf\u0da7\u0dd2";
        final String metaValue_he = "\u0dc4\u0dd3\u0db6\u0df2";
        final String metaValue_hy = "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4";
        final String metaValue_ja = "\u0da2\u0db4\u0db1\u0dca";
        final String metaValue_ka = "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4";
        final String metaValue_km = "\u0d9a\u0db8\u0dbb\u0dca";
        final String metaValue_kn = "\u0d9a\u0dab\u0dca\u0dab\u0da9";
        final String metaValue_ko = "\u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4";
        final String metaValue_la = "\u0dbd\u0dad\u0dd2\u0db1\u0dca";
        final String metaValue_lo = "\u0dbd\u0dcf\u0d95";
        final String metaValue_ml = "\u0db8\u0dbd\u0dba\u0dcf\u0dbd\u0db8\u0dca";
        final String metaValue_or = "\u0d94\u0dbb\u0dd2\u0dba\u0dcf";
        final String metaValue_si = "\u0dc3\u0dd2\u0d82\u0dc4\u0dbd";
        final String metaValue_ta = "\u0daf\u0dd9\u0db8\u0dc5";
        final String metaValue_te = "\u0dad\u0dd9\u0dc5\u0dd2\u0d9f\u0dd4";
        final String metaValue_th = "\u0dad\u0dcf\u0dba\u0dd2";
        final Object[][] data = new Object[][] {
            { "sbp", "\u0dc3\u0d82\u0d9c\u0dd4" },
            { "nyn", "\u0db1\u0dba\u0db1\u0dca\u0d9a\u0ddc\u0dc5\u0dda" },
            { "luo", "\u0dbd\u0dd4\u0d94" },
            { "Zsym", "\u0dc3\u0d82\u0d9a\u0dda\u0dad" },
            { "fil", "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1" },
            { "luy", "\u0dbd\u0dd4\u0dba\u0dd2\u0dba\u0dcf" },
            { "es_ES", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "teo", "\u0da7\u0dd9\u0dc3\u0ddd" },
            { "ab", "\u0d87\u0db6\u0dca\u0d9a\u0dcf\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "AC", "\u0d87\u0dc3\u0dd9\u0db1\u0dca\u0dc2\u0db1\u0dca \u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1" },
            { "AD", "\u0d87\u0db1\u0dca\u0da9\u0ddd\u0dbb\u0dcf\u0dc0" },
            { "AE", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d91\u0db8\u0dd2\u0dbb\u0dca \u0dbb\u0dcf\u0da2\u0dca\u200d\u0dba\u0dba" },
            { "nl_BE", "\u0dc6\u0dca\u0dbd\u0dd9\u0db8\u0dd2\u0dc1\u0dca" },
            { "AF", "\u0d87\u0dc6\u0dca\u0d9c\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "af", "\u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4" },
            { "AG", "\u0d87\u0db1\u0dca\u0da7\u0dd2\u0d9c\u0dd4\u0dc0\u0dcf \u0dc3\u0dc4 \u0db6\u0dcf\u0db6\u0dd2\u0dba\u0dd4\u0da9\u0dcf\u0dc0" },
            { "AI", "\u0d87\u0db1\u0dca\u0d9c\u0dd4\u0dba\u0dd2\u0dbd\u0dcf\u0dc0" },
            { "ak", "\u0d85\u0d9a\u0dcf\u0db1\u0dca" },
            { "AL", "\u0d87\u0dbd\u0dca\u0db6\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AM", "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "am", "\u0d87\u0db8\u0dca\u0dc4\u0dcf\u0dbb\u0dd2\u0d9a\u0dca" },
            { "Arab", metaValue_ar },
            { "AO", "\u0d87\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dcf\u0dc0" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u0d87\u0db1\u0dca\u0da7\u0dcf\u0d9a\u0dca\u0da7\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "ar", metaValue_ar },
            { "AR", "\u0d86\u0dbb\u0dca\u0da2\u0dd9\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf\u0dc0" },
            { "AS", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf\u0dc0" },
            { "as", "\u0d87\u0dc3\u0db8\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "AT", "\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AU", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AW", "\u0d85\u0dbb\u0dd4\u0db6\u0dcf\u0dc0" },
            { "sdh", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d9a\u0dd4\u0dbb\u0dca\u0daf\u0dd2" },
            { "en_US", "\u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "AX", "\u0d95\u0dbd\u0db1\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "AZ", "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dba" },
            { "az", "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dca" },
            { "BA", "\u0db6\u0ddc\u0dc3\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0dc4\u0dbb\u0dca\u0dc3\u0d9c\u0ddc\u0dc0\u0dd3\u0db1\u0dcf\u0dc0" },
            { "ba", "\u0db6\u0dcf\u0dc2\u0dca\u0d9a\u0dd2\u0dbb\u0dca" },
            { "BB", "\u0db6\u0dcf\u0dbb\u0dca\u0db6\u0da9\u0ddd\u0dc3\u0dca" },
            { "BD", "\u0db6\u0d82\u0d9c\u0dca\u0dbd\u0dcf\u0daf\u0dda\u0dc1\u0dba" },
            { "BE", "\u0db6\u0dd9\u0dbd\u0dca\u0da2\u0dd2\u0dba\u0db8" },
            { "be", "\u0db6\u0dd9\u0dbd\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "BF", "\u0db6\u0dbb\u0dca\u0d9a\u0dd2\u0db1\u0dcf \u0dc6\u0dcf\u0dc3\u0ddd" },
            { "BG", "\u0db6\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "bg", "\u0db6\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "BH", "\u0db6\u0dc4\u0dbb\u0dda\u0db1\u0dca" },
            { "BI", "\u0db6\u0dd4\u0dbb\u0dd4\u0db1\u0dca\u0daf\u0dd2" },
            { "BJ", "\u0db6\u0dd9\u0db1\u0dd2\u0db1\u0dca" },
            { "BL", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db6\u0dbb\u0dca\u0dad\u0dbd\u0dd9\u0db8\u0dd2" },
            { "BM", "\u0db6\u0dbb\u0dca\u0db8\u0dd2\u0dba\u0dd4\u0da9\u0dcf" },
            { "bm", "\u0db6\u0db8\u0dca\u0db6\u0dbb\u0dcf" },
            { "bn", metaValue_bn },
            { "BN", "\u0db6\u0df2\u0db1\u0dcf\u0dba\u0dd2" },
            { "BO", "\u0db6\u0ddc\u0dbd\u0dd3\u0dc0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "bo", "\u0da7\u0dd2\u0db6\u0dd9\u0da7\u0dca" },
            { "BQ", "\u0d9a\u0dd0\u0dbb\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "BR", "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd\u0dba" },
            { "br", "\u0db6\u0dca\u200d\u0dbb\u0dda\u0da7\u0ddc\u0db1\u0dca" },
            { "BS", "\u0db6\u0dc4\u0db8\u0dcf\u0dc3\u0dca" },
            { "bs", "\u0db6\u0ddc\u0dc3\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "xog", "\u0dc3\u0ddc\u0d9c\u0dcf" },
            { "BT", "\u0db7\u0dd6\u0dad\u0dcf\u0db1\u0dba" },
            { "BV", "\u0db6\u0dd4\u0dc0\u0da7\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca" },
            { "BW", "\u0db6\u0ddc\u0da7\u0dca\u0dc3\u0dca\u0dc0\u0dcf\u0db1\u0dcf" },
            { "Mymr", "\u0db8\u0dd2\u0dba\u0db1\u0dca\u0db8\u0dcf\u0dbb" },
            { "BY", "\u0db6\u0dd9\u0dbd\u0dbb\u0dd4\u0dc3\u0dca" },
            { "seh", "\u0dc3\u0dd9\u0db1\u0dcf" },
            { "BZ", "\u0db6\u0dd9\u0dbd\u0dd3\u0dc3\u0dca" },
            { "CA", "\u0d9a\u0dd0\u0db1\u0da9\u0dcf\u0dc0" },
            { "ca", "\u0d9a\u0dd0\u0da7\u0dbd\u0db1\u0dca" },
            { "CC", "\u0d9a\u0ddc\u0d9a\u0ddd\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "mzn", "\u0db8\u0dd0\u0dc3\u0db1\u0dca\u0da9\u0dbb\u0db1\u0dd2" },
            { "ses", "\u0d9a\u0ddd\u0dba\u0dd2\u0dbb\u0dcf\u0db6\u0ddc\u0dbb\u0ddc \u0dc3\u0dd9\u0db1\u0dca\u0db1\u0dd2" },
            { "CD", "\u0d9a\u0ddc\u0d82\u0d9c\u0ddc - \u0d9a\u0dd2\u0db1\u0dca\u0dc1\u0dcf\u0dc3\u0dcf" },
            { "ce", "\u0da0\u0dd9\u0da0\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "CF", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0da2\u0db1\u0dbb\u0da2\u0dba" },
            { "CG", "\u0d9a\u0ddc\u0d82\u0d9c\u0ddc - \u0db6\u0dca\u200d\u0dbb\u0dc3\u0dcf\u0dc0\u0dd2\u0dbd\u0dca" },
            { "CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca\u0da7\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "CI", "\u0d9a\u0ddd\u0da7\u0dca \u0daf\u0dd2 \u0d85\u0dba\u0dd2\u0dc0\u0dbb\u0dd2" },
            { "CK", "\u0d9a\u0dd4\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "CL", "\u0da0\u0dd2\u0dbd\u0dd3" },
            { "CM", "\u0d9a\u0dd0\u0db8\u0dbb\u0dd6\u0db1\u0dca" },
            { "CN", "\u0da0\u0dd3\u0db1\u0dba" },
            { "CO", "\u0d9a\u0ddc\u0dc5\u0ddc\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "co", "\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0d91\u0dc1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "CP", "\u0d9a\u0dca\u0dbd\u0dd3\u0db4\u0dbb\u0dca\u0da7\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "Orya", metaValue_or },
            { "CR", "\u0d9a\u0ddc\u0dc3\u0dca\u0da7\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "cs", "\u0da0\u0dd9\u0dad\u0dca" },
            { "CU", "\u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0dc0" },
            { "CV", "\u0d9a\u0dda\u0db4\u0dca \u0dc0\u0dbb\u0dca\u0da9\u0dca" },
            { "cv", "\u0da0\u0dc0\u0dda\u0dc2\u0dca" },
            { "CW", "\u0d9a\u0dd4\u0dbb\u0d9a\u0dcf\u0dc0\u0ddd" },
            { "CX", "\u0d9a\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dca\u0db8\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "CY", "\u0dc3\u0dba\u0dd2\u0db4\u0dca\u200d\u0dbb\u0dc3\u0dba" },
            { "cy", "\u0dc0\u0dda\u0dbd\u0dca\u0dc3\u0dca" },
            { "CZ", "\u0da0\u0dd9\u0d9a\u0dca \u0da2\u0db1\u0dbb\u0da2\u0dba" },
            { "da", "\u0da9\u0dd0\u0db1\u0dd2\u0dc1\u0dca" },
            { "pt_PT", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "DE", "\u0da2\u0dbb\u0dca\u0db8\u0db1\u0dd2\u0dba" },
            { "de", "\u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "cgg", "\u0da0\u0dd2\u0d9c\u0dcf" },
            { "DG", "\u0daf\u0dd2\u0dba\u0dcf\u0d9c\u0ddd \u0d9c\u0dcf\u0dbb\u0dca\u0dc3\u0dd2\u0dba\u0dcf" },
            { "DJ", "\u0da2\u0dd2\u0db6\u0dd4\u0da7\u0dd2" },
            { "DK", "\u0da9\u0dd9\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dca\u0d9a\u0dba" },
            { "Brai", "\u0db6\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dca" },
            { "DM", "\u0da9\u0ddc\u0db8\u0dd2\u0db1\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "DO", "\u0da9\u0ddc\u0db8\u0dd2\u0db1\u0dd2\u0d9a\u0dcf \u0da2\u0db1\u0dbb\u0da2\u0dba" },
            { "bem", "\u0db6\u0dd9\u0db8\u0dca\u0db6\u0dcf" },
            { "dv", "\u0daf\u0dd2\u0dc0\u0dd9\u0dc4\u0dd2" },
            { "es_419", "\u0dbd\u0dad\u0dd2\u0db1\u0dca \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "DZ", "\u0d87\u0dbd\u0dca\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "dz", "\u0da9\u0dd2\u0dc3\u0ddc\u0db1\u0dca\u0d9a\u0dcf" },
            { "bez", "\u0db6\u0dd9\u0db1\u0dcf" },
            { "EA", "\u0dc3\u0dd9\u0dba\u0dd4\u0da7\u0dcf \u0dc3\u0dc4 \u0db8\u0dd9\u0dbd\u0dd2\u0dbd\u0dca\u0dbd\u0dcf" },
            { "EC", "\u0d89\u0d9a\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba" },
            { "dje", "\u0dc6\u0dbb\u0dca\u0db8\u0dcf" },
            { "EE", "\u0d91\u0dc3\u0dca\u0dad\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ee", "\u0d89\u0dc0\u0dca" },
            { "EG", "\u0d8a\u0da2\u0dd2\u0db4\u0dca\u0dad\u0dd4\u0dc0" },
            { "ro_MD", metaValue_MD },
            { "EH", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dc3\u0dc4\u0dbb\u0dcf\u0dc0" },
            { "el", metaValue_el },
            { "en", "\u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "eo", "\u0d91\u0dc3\u0dca\u0db4\u0dd0\u0dbb\u0db1\u0dca\u0da7\u0ddd" },
            { "chr", "\u0da0\u0dd9\u0dbb\u0ddc\u0d9a\u0dd3" },
            { "ER", "\u0d91\u0dbb\u0dd2\u0dad\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ES", "\u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4\u0dba" },
            { "es", "\u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "ET", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0dc0" },
            { "et", "\u0d91\u0dc3\u0dca\u0dad\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "EU", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dcf \u0dc3\u0d82\u0d9c\u0db8\u0dba" },
            { "eu", "\u0db6\u0ddc\u0dc3\u0dca\u0d9a\u0ddd" },
            { "Hang", "\u0dc4\u0dd0\u0db1\u0dca\u0d9c\u0dd4\u0dbd\u0dca" },
            { "shi", "\u0da7\u0da0\u0dda\u0dbd\u0dca\u0dc4\u0dd2\u0da7\u0dca" },
            { "hsb", "\u0d89\u0dc4\u0dc5 \u0dc3\u0ddd\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Hani", "\u0dc4\u0db1\u0dca" },
            { "fa", "\u0db4\u0dbb\u0dca\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Hans", "\u0dc3\u0dd4\u0dc5\u0dd4\u0d9a\u0dc5" },
            { "Hant", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a" },
            { "aeb", "\u0da7\u0dd2\u0dba\u0dd4\u0db1\u0dd2\u0dc3\u0dd2\u0dba\u0db1\u0dd4 \u0d85\u0dbb\u0dcf\u0db6\u0dd2" },
            { "FI", "\u0dc6\u0dd2\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "fi", "\u0dc6\u0dd2\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad" },
            { "FJ", "\u0dc6\u0dd3\u0da2\u0dd3" },
            { "fj", "\u0dc6\u0dd3\u0da2\u0dd2" },
            { "FK", "\u0dc6\u0ddd\u0d9a\u0dca\u0dbd\u0db1\u0dca\u0dad \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "FM", "\u0db8\u0dba\u0dd2\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "bgn", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0db6\u0dbd\u0ddc\u0da0\u0dd2" },
            { "FO", "\u0dc6\u0dd0\u0dbb\u0ddd \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "fo", "\u0dc6\u0dcf\u0dbb\u0ddd\u0dc3\u0dca" },
            { "Taml", metaValue_ta },
            { "FR", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1\u0dba" },
            { "fr", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "fy", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dc6\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "GA", "\u0d9c\u0dd0\u0db6\u0ddc\u0db1\u0dca" },
            { "ga", "\u0d85\u0dba\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad" },
            { "GB", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0dbb\u0dcf\u0da2\u0db0\u0dcf\u0db1\u0dd2\u0dba" },
            { "GD", "\u0d9c\u0dca\u200d\u0dbb\u0dd0\u0db1\u0da9\u0dcf\u0dc0" },
            { "GE", "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GF", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0d9c\u0dba\u0db1\u0dcf\u0dc0" },
            { "GG", "\u0d9c\u0dbb\u0dca\u0db1\u0dca\u0dc3\u0dd2\u0dba" },
            { "GH", "\u0d9d\u0dcf\u0db1\u0dcf\u0dc0" },
            { "GI", "\u0da2\u0dd2\u0db6\u0dca\u200d\u0dbb\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0" },
            { "GL", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "gl", "\u0d9c\u0dd0\u0dbd\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "GM", "\u0d9c\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GN", "\u0d9c\u0dd2\u0dab\u0dd2\u0dba\u0dcf\u0dc0" },
            { "gn", "\u0d9c\u0dd4\u0dc0\u0dcf\u0dbb\u0db1\u0dd2" },
            { "GP", "\u0d9c\u0dca\u0dc0\u0ddd\u0da9\u0dbd\u0ddd\u0db4\u0dca" },
            { "GQ", "\u0dc3\u0db8\u0d9a \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "und", "\u0db1\u0ddc\u0daf\u0db1\u0dca\u0db1\u0dcf \u0db7\u0dcf\u0dc2\u0dcf\u0dc0" },
            { "GR", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2\u0dba" },
            { "GS", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dd0\u0db1\u0dca\u0da9\u0dca\u0dc0\u0dd2\u0da0\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "GT", "\u0d9c\u0ddd\u0dad\u0db8\u0dcf\u0dbd\u0dcf\u0dc0" },
            { "gu", metaValue_gu },
            { "GU", "\u0d9c\u0dd4\u0dc0\u0dcf\u0db8\u0dca" },
            { "gv", "\u0db8\u0dd0\u0db1\u0dca\u0d9a\u0dca\u0dc3\u0dca" },
            { "GW", "\u0d9c\u0dd2\u0db1\u0dd2 \u0db6\u0dd2\u0dc3\u0dc0\u0dca" },
            { "GY", "\u0d9c\u0dba\u0db1\u0dcf\u0dc0" },
            { "ha", "\u0dc4\u0ddd\u0dc3\u0dcf" },
            { "ckb", "\u0dc3\u0ddc\u0dbb\u0dcf\u0db1\u0dd2 \u0d9a\u0dd4\u0dbb\u0dca\u0daf\u0dd2\u0dc2\u0dca" },
            { "zxx", "\u0dc0\u0dcf\u0d9c\u0dca \u0dc0\u0dd2\u0daf\u0dca\u200d\u0dba\u0dcf \u0d85\u0db1\u0dca\u0dad\u0dbb\u0dca\u0d9c\u0dad\u0dba\u0d9a\u0dca \u0db1\u0dd0\u0dad" },
            { "he", metaValue_he },
            { "hi", "\u0dc4\u0dd2\u0db1\u0dca\u0daf\u0dd2" },
            { "de_AT", "\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "HK", "\u0dc4\u0ddc\u0d82\u0d9a\u0ddc\u0d82 \u0da0\u0dd3\u0db1 \u0dc0\u0dd2\u0dc1\u0dda\u0dc2 \u0db4\u0dbb\u0dd2\u0db4\u0dcf\u0dbd\u0db1 \u0d9a\u0dbd\u0dcf\u0db4\u0dba" },
            { "HM", "\u0dc4\u0dbb\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0dca\u0da9\u0ddc\u0db1\u0dbd\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "HN", "\u0dc4\u0ddc\u0db1\u0dca\u0da9\u0dd4\u0dbb\u0dcf\u0dc3\u0dca" },
            { "HR", "\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0d92\u0dc2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "hr", "\u0d9a\u0dca\u200d\u0dbb\u0ddd\u0dba\u0dda\u0dc1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "agq", "\u0d87\u0d9c\u0db8\u0dca" },
            { "gsw", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dd2" },
            { "ht", metaValue_HT },
            { "HT", metaValue_HT },
            { "HU", "\u0dc4\u0db1\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "hu", "\u0dc4\u0db1\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "hy", metaValue_hy },
            { "IC", "\u0d9a\u0dd0\u0db1\u0dbb\u0dd2 \u0dc3\u0dd6\u0db4\u0dad\u0dca" },
            { "ID", "\u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "id", "\u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "IE", "\u0d85\u0dba\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "ig", "\u0d89\u0d9c\u0dca\u0db6\u0ddd" },
            { "naq", "\u0db1\u0dcf\u0db8\u0dcf" },
            { "ii", "\u0dc3\u0dd2\u0da0\u0dd4\u0d86\u0db1\u0dca \u0dba\u0dd3" },
            { "IL", "\u0d8a\u0dc1\u0dca\u200d\u0dbb\u0dcf\u0dba\u0dbd\u0dba" },
            { "IM", "\u0d85\u0dba\u0dd2\u0dbd\u0dca \u0d94\u0dc6\u0dca \u0db8\u0dd1\u0db1\u0dca" },
            { "IN", "\u0d89\u0db1\u0dca\u0daf\u0dd2\u0dba\u0dcf\u0dc0" },
            { "IO", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d89\u0db1\u0dca\u0daf\u0dd3\u0dba \u0dc3\u0dcf\u0d9c\u0dbb \u0db6\u0dbd \u0db4\u0dca\u200d\u0dbb\u0daf\u0dda\u0dc1\u0dba" },
            { "IQ", "\u0d89\u0dbb\u0dcf\u0d9a\u0dba" },
            { "IR", "\u0d89\u0dbb\u0dcf\u0db1\u0dba" },
            { "IS", "\u0d85\u0dba\u0dd2\u0dc3\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "is", "\u0d85\u0dba\u0dd2\u0dc3\u0dca\u0dbd\u0db1\u0dca\u0dad" },
            { "IT", "\u0d89\u0dad\u0dcf\u0dbd\u0dd2\u0dba" },
            { "it", "\u0d89\u0dad\u0dcf\u0dbd\u0dd2" },
            { "iu", "\u0d89\u0db1\u0dd4\u0d9a\u0dca\u0da7\u0dd2\u0da7\u0dd4\u0da7\u0dca" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "\u0da2\u0dbb\u0dca\u0dc3\u0dd2" },
            { "Beng", metaValue_bn },
            { "JM", "\u0da2\u0dd0\u0db8\u0dd9\u0dba\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "JO", "\u0da2\u0ddd\u0dbb\u0dca\u0daf\u0dcf\u0db1\u0dba" },
            { "JP", "\u0da2\u0db4\u0dcf\u0db1\u0dba" },
            { "sma", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dcf\u0db8\u0dd2" },
            { "jv", "\u0da2\u0dcf\u0dc0\u0dcf" },
            { "guz", "\u0d9c\u0dd4\u0dc3\u0dd3" },
            { "smj", "\u0dbd\u0dd4\u0dbd\u0dda \u0dc3\u0dcf\u0db8\u0dd2" },
            { "de_CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0d8b\u0dc3\u0dc3\u0dca \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "smn", "\u0d89\u0db1\u0dcf\u0dbb\u0dd2 \u0dc3\u0dcf\u0db8\u0dd2" },
            { "ka", metaValue_ka },
            { "sms", "\u0dc3\u0dca\u0d9a\u0ddc\u0dbd\u0dca\u0da7\u0dca \u0dc3\u0dcf\u0db8\u0dd2" },
            { "KE", "\u0d9a\u0dd9\u0db1\u0dca\u0dba\u0dcf\u0dc0" },
            { "419", "\u0dbd\u0dad\u0dd2\u0db1\u0dca \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "KG", "\u0d9a\u0dd2\u0dbb\u0dca\u0d9c\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "KH", "\u0d9a\u0dcf\u0db8\u0dca\u0db6\u0ddd\u0da2\u0dba" },
            { "KI", "\u0d9a\u0dd2\u0dbb\u0dd2\u0db6\u0dad\u0dd2" },
            { "ki", "\u0d9a\u0dd2\u0d9a\u0dd4\u0dba\u0dd4" },
            { "mas", "\u0db8\u0dc3\u0dcf\u0dba\u0dd2" },
            { "kk", "\u0d9a\u0dc3\u0dcf\u0d9b\u0dca" },
            { "kl", "\u0d9a\u0dbd\u0dcf\u0dbd\u0dd2\u0dc3\u0da7\u0dca" },
            { "km", metaValue_km },
            { "KM", "\u0d9a\u0ddc\u0db8\u0ddc\u0dbb\u0ddd\u0dc3\u0dca" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0d9a\u0dd2\u0da7\u0dca\u0dc3\u0dca \u0dc3\u0dc4 \u0db1\u0dda\u0dc0\u0dd2\u0dc3\u0dca" },
            { "fr_CA", "\u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "ko", metaValue_ko },
            { "KP", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "KR", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ks", "\u0d9a\u0dcf\u0dc2\u0dca\u0db8\u0dd3\u0dbb\u0dca" },
            { "ku", "\u0d9a\u0dd4\u0dbb\u0dca\u0daf\u0dd2" },
            { "fr_CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "KW", "\u0d9a\u0dd4\u0dc0\u0dda\u0da7\u0dba" },
            { "kw", "\u0d9a\u0ddd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "KY", "\u0d9a\u0dda\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "ky", "\u0d9a\u0dd2\u0dbb\u0dca\u0d9c\u0dd2\u0dc3\u0dca" },
            { "KZ", "\u0d9a\u0dc3\u0d9a\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "Cyrl", "\u0dc3\u0dd2\u0dbb\u0dd2\u0dbd\u0dd2\u0d9a\u0dca" },
            { "la", metaValue_la },
            { "LA", "\u0dbd\u0dcf\u0d95\u0dc3\u0dba" },
            { "LB", "\u0dbd\u0dd9\u0db6\u0db1\u0db1\u0dba" },
            { "lb", "\u0dbd\u0d9a\u0dca\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca" },
            { "LC", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dbd\u0dd4\u0dc3\u0dd2\u0dba\u0dcf" },
            { "lg", "\u0d9c\u0db1\u0dca\u0da9\u0dcf" },
            { "nds", "\u0db4\u0dc4\u0dc5 \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "LI", "\u0dbd\u0dd2\u0d9a\u0dca\u0da7\u0db1\u0dca\u0dc3\u0dca\u0da7\u0dba\u0dd2\u0db1\u0dca" },
            { "LK", "\u0dc1\u0dca\u200d\u0dbb\u0dd3 \u0dbd\u0d82\u0d9a\u0dcf\u0dc0" },
            { "Tibt", "\u0da7\u0dd2\u200d\u0db6\u0dd9\u0da7\u0dca" },
            { "ln", "\u0dbd\u0dd2\u0db1\u0dca\u0d9c\u0dbd\u0dcf" },
            { "lo", metaValue_lo },
            { "LR", "\u0dbd\u0dba\u0dd2\u0db6\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "LS", "\u0dbd\u0dd9\u0dc3\u0dad\u0ddd" },
            { "LT", "\u0dbd\u0dd2\u0dad\u0dd4\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "lt", "\u0dbd\u0dd2\u0dad\u0dd4\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "LU", "\u0dbd\u0d9a\u0dca\u0dc1\u0db8\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca" },
            { "lu", "\u0dbd\u0dd4" },
            { "LV", "\u0dbd\u0dd0\u0da7\u0dca\u0dc0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "lv", "\u0dbd\u0dd0\u0da7\u0dca\u0dc0\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Kana", "\u0d9a\u0dad\u0d9a\u0db1\u0dcf" },
            { "LY", "\u0dbd\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "vun", "\u0dc0\u0dd4\u0db1\u0dca\u0da2\u0ddd" },
            { "lag", "\u0dbd\u0d82\u0d9c\u0dd2" },
            { "Thaa", "\u0dad\u0dcf\u0db1" },
            { "MA", "\u0db8\u0ddc\u0dbb\u0ddc\u0d9a\u0dca\u0d9a\u0ddd\u0dc0" },
            { "MC", "\u0db8\u0ddc\u0db1\u0dd0\u0d9a\u0ddd\u0dc0" },
            { "MD", metaValue_MD },
            { "ME", "\u0db8\u0ddc\u0db1\u0dca\u0da7\u0dd9\u0db1\u0dd3\u0d9c\u0dca\u200d\u0dbb\u0ddd" },
            { "MF", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db8\u0dcf\u0dbb\u0dca\u0da7\u0dd2\u0db1\u0dca" },
            { "MG", "\u0db8\u0dd0\u0da9\u0d9c\u0dc3\u0dca\u0d9a\u0dbb\u0dba" },
            { "mg", "\u0db8\u0dbd\u0d9c\u0dcf\u0dc3\u0dd2" },
            { "Thai", metaValue_th },
            { "MH", "\u0db8\u0dcf\u0dc2\u0dbd\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "mi", "\u0db8\u0dcf\u0dc0\u0ddc\u0dbb\u0dd2" },
            { "MK", "\u0db8\u0dd0\u0dc3\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "mk", "\u0db8\u0dd0\u0dc3\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ml", metaValue_ml },
            { "ML", "\u0db8\u0dcf\u0dbd\u0dd2" },
            { "MM", "\u0db8\u0dd2\u0dba\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dba (\u0db6\u0dd4\u0dbb\u0dd4\u0db8\u0dba)" },
            { "MN", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "mn", "\u0db8\u0ddc\u0d82\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "MO", "\u0db8\u0d9a\u0dcf\u0dc0\u0dd4 \u0da0\u0dd3\u0db1 \u0dc0\u0dd2\u0dc1\u0dda\u0dc2 \u0db4\u0dbb\u0dd2\u0db4\u0dcf\u0dbd\u0db1 \u0d9a\u0dbd\u0dcf\u0db4\u0dba" },
            { "MP", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0db8\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dcf \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "MQ", "\u0db8\u0dbb\u0dca\u0da7\u0dd2\u0db1\u0dd2\u0d9a\u0dca" },
            { "MR", "\u0db8\u0ddc\u0dbb\u0dd2\u0da7\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "mr", "\u0db8\u0dbb\u0dcf\u0dad\u0dd2" },
            { "MS", "\u0db8\u0ddc\u0db1\u0dca\u0dc3\u0dd9\u0dbb\u0dcf\u0da7\u0dca" },
            { "ms", "\u0db8\u0dd0\u0dbd\u0dda" },
            { "MT", "\u0db8\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0" },
            { "mt", "\u0db8\u0ddc\u0dbd\u0dca\u0da7\u0dd2\u0dc3\u0dca" },
            { "MU", "\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2\u0dba" },
            { "MV", "\u0db8\u0dcf\u0dbd \u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1" },
            { "MW", "\u0db8\u0dbd\u0dcf\u0dc0\u0dd2" },
            { "MX", "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd\u0dc0" },
            { "MY", "\u0db8\u0dd0\u0dbd\u0dda\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "my", "\u0db6\u0dd4\u0dbb\u0dd4\u0db8" },
            { "Armn", metaValue_hy },
            { "MZ", "\u0db8\u0ddc\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0d9a\u0dca" },
            { "dsb", "\u0db4\u0dc4\u0dc5 \u0dc3\u0ddd\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "NA", "\u0db1\u0dd0\u0db8\u0dd3\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "nb", "\u0db1\u0ddd\u0dc0\u0dda\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db6\u0ddc\u0d9a\u0dca\u0db8\u0dcf\u0dbd\u0dca" },
            { "NC", "\u0db1\u0dc0 \u0d9a\u0dd0\u0dbd\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "nd", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d91\u0db1\u0dca\u0da9\u0dd2\u0db6\u0dd9\u0dbd\u0dd9" },
            { "NE", "\u0db1\u0dba\u0dd2\u0da2\u0dbb\u0dca" },
            { "ne", "\u0db1\u0dda\u0db4\u0dcf\u0dbd" },
            { "NF", "\u0db1\u0ddd\u0dc6\u0ddd\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "NG", "\u0db1\u0dba\u0dd2\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "NI", "\u0db1\u0dd2\u0d9a\u0dbb\u0d9c\u0dd4\u0dc0\u0dcf\u0dc0" },
            { "NL", "\u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "nl", "\u0dbd\u0db1\u0dca\u0daf\u0dda\u0dc3\u0dd2" },
            { "nn", "\u0db1\u0ddc\u0dc0\u0dda\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db1\u0dba\u0dd2\u0db1\u0ddd\u0dbb\u0dca\u0dc3\u0dca\u0d9a\u0dca" },
            { "NO", "\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dda" },
            { "NP", "\u0db1\u0dda\u0db4\u0dcf\u0dbd\u0dba" },
            { "NR", "\u0db1\u0dcf\u0dc0\u0dd4\u0dbb\u0dd4" },
            { "NU", "\u0db1\u0dd2\u0dba\u0dd6" },
            { "rof", "\u0dbb\u0ddd\u0db8\u0dca\u0db6\u0ddd" },
            { "NZ", "\u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "kab", "\u0d9a\u0dd0\u0db6\u0dbd\u0dcf" },
            { "kam", "\u0d9a\u0dd0\u0db8\u0dca\u0db6\u0dcf" },
            { "mer", "\u0db8\u0dd9\u0dbb\u0dd4" },
            { "OM", "\u0d95\u0db8\u0dcf\u0db1\u0dba" },
            { "om", "\u0d94\u0dbb\u0ddc\u0db8\u0ddd" },
            { "or", metaValue_or },
            { "mfe", "\u0db8\u0ddc\u0dbb\u0dd2\u0dc3\u0dca\u0dba\u0dd9\u0db8\u0dca" },
            { "PA", "\u0db4\u0dd0\u0db1\u0db8\u0dcf\u0dc0" },
            { "pa", "\u0da2\u0db1\u0dca\u0da2\u0dcf\u0db6\u0dd2" },
            { "dua", "\u0da9\u0dd4\u0d86\u0dbd\u0dcf" },
            { "en_GB", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "PE", "\u0db4\u0dda\u0dbb\u0dd4" },
            { "PF", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "PG", "\u0db4\u0dd0\u0db4\u0dd4\u0dc0\u0dcf \u0db1\u0dd2\u0dc0\u0dca \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "PH", "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1\u0dba" },
            { "PK", "\u0db4\u0dcf\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "PL", "\u0db4\u0ddd\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "pl", "\u0db4\u0ddd\u0dbd\u0db1\u0dca\u0dad" },
            { "PM", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db4\u0dd2\u0dba\u0dbb\u0dda \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0ddd\u0dbd\u0db1\u0dca" },
            { "PN", "\u0db4\u0dd2\u0da7\u0dca\u0d9a\u0dd9\u0dba\u0dca\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "PR", "\u0db4\u0dd4\u0dc0\u0dbb\u0dca\u0da7\u0ddd \u0dbb\u0dd2\u0d9a\u0ddd" },
            { "PS", "\u0db4\u0dbd\u0dc3\u0dca\u0dad\u0dd3\u0db1 \u0dbb\u0dcf\u0da2\u0dca\u200d\u0dba\u0dba" },
            { "ps", "\u0db4\u0dc2\u0dca\u0da7\u0ddc" },
            { "PT", "\u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dcf\u0dbd\u0dba" },
            { "pt", "\u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "PW", "\u0db4\u0dbd\u0dcf\u0dc0\u0dd4" },
            { "PY", "\u0db4\u0dd0\u0dbb\u0d9c\u0dd4\u0dc0\u0dda" },
            { "pt_BR", "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd \u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "Hebr", metaValue_he },
            { "mgh", "\u0db8\u0d9b\u0dd4\u0dc0\u0dcf-\u0db8\u0dd3\u0da7\u0ddd" },
            { "QA", "\u0d9a\u0da7\u0dcf\u0dbb\u0dca" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0db8\u0dd9\u0da7\u0dcf" },
            { "QO", "\u0d88\u0dad \u0d95\u0dc2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "qu", "\u0d9a\u0dca\u0dc0\u0dd3\u0da0\u0dd4\u0dc0\u0dcf" },
            { "brx", "\u0db6\u0ddc\u0da9\u0ddc" },
            { "kde", "\u0db8\u0dd0\u0d9a\u0ddc\u0db1\u0dca\u0da9\u0dca" },
            { "001", "\u0dbd\u0ddd\u0d9a\u0dba" },
            { "Ethi", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "002", "\u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "003", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "RE", "\u0dbb\u0dd3\u0dba\u0dd4\u0db1\u0dd2\u0dba\u0db1\u0dca" },
            { "005", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "009", "\u0d95\u0dc2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "rm", "\u0dbb\u0ddc\u0db8\u0dd1\u0db1\u0dca\u0dc1\u0dca" },
            { "rn", "\u0dbb\u0dd4\u0db1\u0dca\u0da9\u0dd2" },
            { "RO", "\u0dbb\u0dd4\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ro", "\u0dbb\u0ddc\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "RS", "\u0dc3\u0dbb\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RU", "\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ru", "\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "RW", "\u0dbb\u0dd4\u0dc0\u0db1\u0dca\u0da9\u0dcf\u0dc0" },
            { "rw", "\u0d9a\u0dd2\u0db1\u0dca\u0dba\u0dbb\u0dca\u0dc0\u0db1\u0dca\u0da9\u0dcf" },
            { "kea", "\u0d9a\u0db6\u0dd4\u0dc0\u0dd9\u0dbb\u0dca\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0ddd" },
            { "en_AU", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "SA", "\u0dc3\u0dde\u0daf\u0dd2 \u0d85\u0dbb\u0dcf\u0db6\u0dd2\u0dba" },
            { "sa", "\u0dc3\u0d82\u0dc3\u0dca\u0d9a\u0dd8\u0dad" },
            { "SB", "\u0dc3\u0ddc\u0dbd\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "twq", "\u0da7\u0dc3\u0dc0\u0dcf\u0d9a\u0dca" },
            { "011", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SC", "\u0dc3\u0dd3\u0dc1\u0dd9\u0dbd\u0dca\u0dc3\u0dca" },
            { "SD", "\u0dc3\u0dd6\u0da9\u0dcf\u0db1\u0dba" },
            { "sd", "\u0dc3\u0dd2\u0db1\u0dca\u0db0\u0dd2" },
            { "013", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SE", "\u0dc3\u0dca\u0dc0\u0dd3\u0da9\u0db1\u0dba" },
            { "se", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dc3\u0dcf\u0db8\u0dd2" },
            { "014", "\u0db4\u0dd9\u0dbb\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "015", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SG", "\u0dc3\u0dd2\u0d82\u0d9c\u0db4\u0dca\u0db4\u0dd6\u0dbb\u0dd4\u0dc0" },
            { "sg", "\u0dc3\u0db1\u0dca\u0d9c\u0dca\u200d\u0dbb\u0ddd" },
            { "SH", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dc4\u0dd9\u0dbd\u0dda\u0db1\u0dcf" },
            { "si", metaValue_si },
            { "017", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SI", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "018", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SJ", "\u0dc3\u0dca\u0dc0\u0dd9\u0dbd\u0dca\u0db6\u0dbb\u0dca\u0da9\u0dca \u0dc3\u0dc4 \u0da2\u0dda\u0db1\u0dca \u0db8\u0dba\u0dda\u0db1\u0dca" },
            { "019", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SK", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dd0\u0d9a\u0dd2\u0dba\u0dcf\u0dc0" },
            { "sk", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dd0\u0d9a\u0dca" },
            { "SL", "\u0dc3\u0dd2\u0dba\u0dbb\u0dcf\u0dbd\u0dd2\u0dba\u0ddd\u0db1\u0dca" },
            { "sl", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "SM", "\u0dc3\u0dd0\u0db1\u0dca \u0db8\u0dd0\u0dbb\u0dd2\u0db1\u0ddd" },
            { "SN", "\u0dc3\u0dd9\u0db1\u0d9c\u0dcf\u0dbd\u0dba" },
            { "sn", "\u0dc1\u0ddd\u0db1\u0dcf" },
            { "SO", "\u0dc3\u0ddd\u0db8\u0dcf\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "so", "\u0dc3\u0ddd\u0db8\u0dcf\u0dbd\u0dd2" },
            { "arn", "\u0db8\u0db4\u0dd4\u0da0\u0dd9" },
            { "sq", "\u0d87\u0dbd\u0dca\u0db6\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "SR", "\u0dc3\u0dd4\u0dbb\u0dd2\u0db1\u0dcf\u0db8\u0dba" },
            { "sr", "\u0dc3\u0dbb\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "SS", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dd4\u0da9\u0dcf\u0db1\u0dba" },
            { "ST", "\u0dc3\u0dcf\u0d95 \u0dad\u0ddd\u0db8\u0dca \u0dc3\u0dc4 \u0db4\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dca\u0dc3\u0dd2\u0db4\u0dca" },
            { "su", "\u0dc3\u0db1\u0dca\u0da9\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "SV", "\u0d91\u0dbd\u0dca \u0dc3\u0dd0\u0dbd\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba" },
            { "sv", "\u0dc3\u0dca\u0dc0\u0dd3\u0da9\u0db1\u0dca" },
            { "sw", "\u0dc3\u0dca\u0dc0\u0dcf\u0dc4\u0dd2\u0dbd\u0dd2" },
            { "SX", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db8\u0dcf\u0dbb\u0dca\u0da7\u0dd9\u0db1\u0dca" },
            { "SY", "\u0dc3\u0dd2\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SZ", "\u0dc3\u0dca\u0dc0\u0dcf\u0dc3\u0dd2\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "ta", metaValue_ta },
            { "TA", "\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dca\u0da7\u0db1\u0dca \u0daf \u0d9a\u0dd4\u0db1\u0dca\u0dc4\u0dcf" },
            { "asa", "\u0d85\u0dc3\u0dd4" },
            { "021", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4\u0daf\u0dd2\u0d9c \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "142", "\u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "TC", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0dc3\u0dca \u0dc3\u0dc4 \u0d9a\u0dba\u0dd2\u0d9a\u0ddc\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "143", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "TD", "\u0da0\u0dd0\u0da0\u0dca" },
            { "te", metaValue_te },
            { "145", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "TF", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0daf\u0dd6\u0db4\u0dad\u0dca \u0dc3\u0db8\u0dd6\u0dc4\u0dba" },
            { "TG", "\u0da7\u0ddc\u0d9c\u0ddd" },
            { "tg", "\u0da7\u0da2\u0dd2\u0d9a\u0dca" },
            { "th", metaValue_th },
            { "TH", "\u0dad\u0dcf\u0dba\u0dd2\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "ti", "\u0da7\u0dd2\u0d9c\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dca\u0dba\u0dcf" },
            { "TJ", "\u0da7\u0da2\u0dd2\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "en_CA", "\u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "029", "\u0d9a\u0dd0\u0dbb\u0dd3\u0db6\u0dd2\u0dba\u0db1\u0dca" },
            { "TK", "\u0da7\u0ddc\u0d9a\u0dbd\u0dcf\u0dc0\u0dd4" },
            { "tk", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dca" },
            { "TL", "\u0da7\u0dd2\u0db8\u0ddd\u0dbb\u0dca - \u0dbd\u0dd9\u0dc3\u0dca\u0dad\u0dca" },
            { "TM", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "TN", "\u0da7\u0dd2\u0dba\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "to", metaValue_TO },
            { "TO", metaValue_TO },
            { "dyo", "\u0da2\u0ddc\u0dbd-\u0dc6\u0ddd\u0db1\u0dd2\u0dba\u0dd2" },
            { "TR", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dd2\u0dba" },
            { "tr", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dd2" },
            { "TT", "\u0da7\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dd2\u0da9\u0dd1\u0da9\u0dca \u0dc3\u0dc4 \u0da7\u0ddc\u0db6\u0dd0\u0d9c\u0ddd" },
            { "tt", "\u0da7\u0dcf\u0da7\u0dbb\u0dca" },
            { "TV", "\u0da7\u0dd4\u0dc0\u0dcf\u0dbd\u0dd6" },
            { "TW", "\u0dad\u0dcf\u0dba\u0dd2\u0dc0\u0dcf\u0db1\u0dba" },
            { "TZ", "\u0da7\u0dd0\u0db1\u0dca\u0dc3\u0dcf\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "nmg", "\u0d9a\u0dd4\u0dc0\u0dcf\u0dc3\u0dd2\u0d94" },
            { "Zzzz", "\u0db1\u0ddc\u0daf\u0dad\u0dca \u0d85\u0d9a\u0dca\u0dc2\u0dbb \u0db8\u0dcf\u0dbd\u0dcf\u0dc0" },
            { "150", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "UA", "\u0dba\u0dd4\u0d9a\u0dca\u0dbb\u0dda\u0db1\u0dba" },
            { "030", "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "151", "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "154", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "sw_CD", "\u0d9a\u0ddc\u0db1\u0dca\u0d9c\u0ddd \u0dc3\u0dca\u0dc0\u0dcf\u0dc4\u0dd2\u0dbd\u0dd2" },
            { "034", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "155", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "035", "\u0d85\u0d9c\u0dca\u0db1\u0dd2\u0daf\u0dd2\u0d9c \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "UG", "\u0d8b\u0d9c\u0db1\u0dca\u0da9\u0dcf\u0dc0" },
            { "ug", "\u0d8b\u0dba\u0dd2\u0d9c\u0dbb\u0dca" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u0db4\u0ddc\u0daf\u0dd4." },
            { "039", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4\u0daf\u0dd2\u0d9c \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "uk", "\u0dba\u0dd4\u0d9a\u0dca\u0dbb\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Sinh", metaValue_si },
            { "UM", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0da2\u0db1\u0db4\u0daf \u0d88\u0dad \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "ur", "\u0d8b\u0dbb\u0dca\u0daf\u0dd4" },
            { "US", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0da2\u0db1\u0db4\u0daf\u0dba" },
            { "haw", "\u0dc4\u0dc0\u0dcf\u0dba\u0dd2" },
            { "UY", "\u0d8b\u0dbb\u0dd4\u0d9c\u0dd4\u0dc0\u0dda" },
            { "UZ", "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "uz", "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dca" },
            { "tzm", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d87\u0da7\u0dca\u0dbd\u0dc3\u0dca \u0da7\u0db8\u0dc3\u0dd2\u0da7\u0dca" },
            { "VA", "\u0dc0\u0dad\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db1\u0d9c\u0dbb\u0dba" },
            { "nds_NL", "\u0db4\u0dc4\u0dc5 \u0dc3\u0dd0\u0d9a\u0dca\u0dc3\u0db1\u0dca" },
            { "VC", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dc0\u0dd2\u0db1\u0dca\u0dc3\u0db1\u0dca\u0da7\u0dca \u0dc3\u0dc4 \u0d9c\u0dca\u200d\u0dbb\u0dd9\u0db1\u0da9\u0dd2\u0db1\u0dca\u0dc3\u0dca" },
            { "VE", "\u0dc0\u0dd9\u0db1\u0dd2\u0dc3\u0dd2\u0dba\u0dd4\u0dbd\u0dcf\u0dc0" },
            { "VG", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0dc0\u0dbb\u0dca\u0da2\u0dd2\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "VI", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc0\u0dbb\u0dca\u0da2\u0dd2\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "vi", "\u0dc0\u0dd2\u0dba\u0da7\u0dca\u0db1\u0dcf\u0db8\u0dca" },
            { "khq", "\u0d9a\u0ddc\u0dba\u0dd2\u0dbb\u0dcf \u0da0\u0dd2\u0db1\u0dd2" },
            { "VN", "\u0dc0\u0dd2\u0dba\u0da7\u0dca\u0db1\u0dcf\u0db8\u0dba" },
            { "quc", "\u0d9a\u0dd2\u0dba\u0dd2\u0da0\u0dda" },
            { "VU", "\u0dc0\u0db1\u0dd4\u0dc0\u0dcf\u0da7\u0dd4" },
            { "rwk", "\u0dbb\u0dca\u0dc0\u0dcf" },
            { "gag", "\u0d9c\u0d9c\u0dcf\u0dc3\u0dca" },
            { "053", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dbd\u0dda\u0dc2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "054", "\u0db8\u0dd9\u0dbd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "WF", "\u0dc0\u0dd0\u0dbd\u0dd2\u0dc3\u0dca \u0dc3\u0dc4 \u0dc6\u0dd4\u0da7\u0dd4\u0db1\u0dcf" },
            { "Grek", metaValue_el },
            { "057", "\u0db8\u0dba\u0dd2\u0d9a\u0dca\u200d\u0dbb\u0ddd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9a\u0dc5\u0dcf\u0db4\u0dba" },
            { "jgo", "\u0db1\u0ddc\u0db8\u0dca\u0db6\u0dcf" },
            { "lkt", "\u0dbd\u0d9a\u0ddc\u0da7" },
            { "wo", "\u0dc0\u0ddc\u0dbd\u0ddc\u0dc6\u0dca" },
            { "zgh", "\u0dc3\u0db8\u0dca\u0db8\u0dad \u0db8\u0ddc\u0dbb\u0ddc\u0d9a\u0dca\u0d9a\u0ddd \u0da7\u0db8\u0dc3\u0dd2\u0d9c\u0dca\u0dad\u0dca" },
            { "ar_001", "\u0db1\u0dc0\u0dd3\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0d85\u0dbb\u0dcf\u0db6\u0dd2" },
            { "WS", "\u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf" },
            { "Mong", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Latn", metaValue_la },
            { "061", "\u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "xh", "\u0dc1\u0ddd\u0dc3\u0dcf" },
            { "XK", "\u0d9a\u0ddc\u0dc3\u0ddd\u0dc0\u0ddd" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0d85\u0dbd\u0dd2\u0d9b\u0dd2\u0dad" },
            { "wbp", "\u0dc0\u0ddc\u0db4\u0dd2\u0dbb\u0dd2" },
            { "moh", "\u0db8\u0ddc\u0dc4\u0ddc\u0dc0\u0dca\u0d9a\u0dca" },
            { "YE", "\u0dba\u0dda\u0db8\u0db1\u0dba" },
            { "nqo", "\u0d91\u0db1\u0dca\u2018\u0d9a\u0ddd" },
            { "yo", "\u0dba\u0ddc\u0dbb\u0dd6\u0db6\u0dcf" },
            { "es_MX", "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "YT", "\u0db8\u0dba\u0ddd\u0da7\u0dca" },
            { "vai", "\u0dc0\u0dba\u0dd2" },
            { "ZA", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "kln", "\u0d9a\u0dbd\u0dd9\u0db1\u0dca\u0da2\u0db1\u0dca" },
            { "Deva", "\u0daf\u0dda\u0dc0\u0db1\u0dcf\u0d9c\u0dbb\u0dd3" },
            { "zh", "\u0da0\u0dd3\u0db1" },
            { "Hira", "\u0dc4\u0dd2\u0dbb\u0d9f\u0db1\u0dcf" },
            { "ZM", "\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "Bopo", "\u0db6\u0ddc\u0db4\u0ddc\u0db8\u0ddc\u0dc6\u0ddd" },
            { "zu", "\u0dc3\u0dd4\u0dbd\u0dd4" },
            { "ZW", "\u0dc3\u0dd2\u0db8\u0dca\u0db6\u0dcf\u0db6\u0dca\u0dc0\u0dda" },
            { "Geor", metaValue_ka },
            { "ZZ", "\u0dc4\u0db3\u0dd4\u0db1\u0dcf \u0db1\u0ddc\u0d9c\u0dad\u0dca \u0d9a\u0dc5\u0dcf\u0db4\u0dba" },
            { "ebu", "\u0d91\u0db8\u0dca\u0db6\u0dd4" },
            { "jmc", "\u0db8\u0dd0\u0d9a\u0dcf\u0db8\u0dd3" },
            { "zh_Hans", "\u0dc3\u0dd4\u0dc5\u0dd4\u0d9a\u0dc5 \u0da0\u0dd3\u0db1" },
            { "koi", "\u0d9a\u0ddc\u0db8\u0dd2-\u0db4\u0dbb\u0dca\u0db8\u0dd2\u0dba\u0dcf\u0d9a\u0dca" },
            { "kok", "\u0d9a\u0ddc\u0db1\u0dca\u0d9a\u0db1\u0dd2" },
            { "nus", "\u0db1\u0ddc\u0dba\u0dbb\u0dca" },
            { "dav", "\u0da7\u0dba\u0dd2\u0da7\u0dcf" },
            { "lrc", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dbd\u0dd4\u0dbb\u0dd2" },
            { "zh_Hant", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a \u0da0\u0dd3\u0db1" },
            { "mua", "\u0db8\u0dd4\u0db1\u0dca\u0da9\u0db1\u0dca" },
            { "Khmr", metaValue_km },
            { "saq", "\u0dc3\u0db8\u0dca\u0db6\u0dd4\u0dbb\u0dd4" },
            { "Guru", "\u0d9c\u0dd4\u0dbb\u0dca\u0db8\u0dd4\u0d9b\u0dd2" },
            { "ksb", "\u0dc1\u0dcf\u0db8\u0dca\u0db6\u0dbd\u0dcf" },
            { "Telu", metaValue_te },
            { "ksf", "\u0db6\u0dcf\u0dc6\u0dd2\u0dba\u0dcf" },
        };
        return data;
    }
}
