/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "ar\u0101bu";
        final String metaValue_bn = "beng\u0101\u013cu";
        final String metaValue_bo = "tibetie\u0161u";
        final String metaValue_el = "grie\u0137u";
        final String metaValue_gu = "gud\u017earatu";
        final String metaValue_he = "ivrits";
        final String metaValue_hy = "arm\u0113\u0146u";
        final String metaValue_ja = "jap\u0101\u0146u";
        final String metaValue_jv = "javie\u0161u";
        final String metaValue_ka = "gruz\u012bnu";
        final String metaValue_km = "khmeru";
        final String metaValue_ko = "korejie\u0161u";
        final String metaValue_la = "lat\u012b\u0146u";
        final String metaValue_lo = "laosie\u0161u";
        final String metaValue_ml = "malajalu";
        final String metaValue_mn = "mongo\u013cu";
        final String metaValue_my = "birmie\u0161u";
        final String metaValue_or = "oriju";
        final String metaValue_pa = "pand\u017eabu";
        final String metaValue_si = "sing\u0101\u013cu";
        final String metaValue_ta = "tamilu";
        final String metaValue_te = "telugu";
        final String metaValue_th = "taju";
        final String metaValue_tl = "tagalu";
        final String metaValue_zh = "\u0137\u012bnie\u0161u";
        final String metaValue_arc = "aramie\u0161u";
        final String metaValue_ban = "balie\u0161u";
        final String metaValue_cop = "koptu";
        final String metaValue_got = "gotu";
        final String metaValue_phn = "feni\u0137ie\u0161u";
        final String metaValue_ssy = "saho";
        final String metaValue_syr = "s\u012brie\u0161u";
        final String metaValue_Hans = "\u0137\u012bnie\u0161u vienk\u0101r\u0161ot\u0101";
        final String metaValue_Hant = "\u0137\u012bnie\u0161u tradicion\u0101l\u0101";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0136elnes v\u0101cu" },
            { "Ogam", "ogamiskais raksts" },
            { "mwl", "mirandie\u0161u" },
            { "Zsym", "simboli" },
            { "cch", "atsamu" },
            { "mwr", "marvaru" },
            { "egy", "\u0113\u0123iptie\u0161u" },
            { "raj", "rad\u017east\u0101\u0146u" },
            { "tem", "temnu" },
            { "teo", "teso" },
            { "rap", "rapanuju" },
            { "ter", "tereno" },
            { "AC", "Debesbrauk\u0161anas sala" },
            { "rar", "rarotongie\u0161u" },
            { "tet", "tetumu" },
            { "AD", "Andora" },
            { "AE", "Apvienotie Ar\u0101bu Emir\u0101ti" },
            { "nl_BE", "fl\u0101mu" },
            { "AF", "Afganist\u0101na" },
            { "AG", "Antigva un Barbuda" },
            { "AI", "Angilja" },
            { "AL", "Alb\u0101nija" },
            { "AM", "Arm\u0113nija" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argent\u012bna" },
            { "AS", "Amerik\u0101\u0146u Samoa" },
            { "AT", "Austrija" },
            { "AU", "Austr\u0101lija" },
            { "AW", "Aruba" },
            { "en_US", "ASV ang\u013cu" },
            { "AX", "Olandes salas" },
            { "mye", "mjenu" },
            { "AZ", "Azerbaid\u017e\u0101na" },
            { "%%AREVELA", "austrumarm\u0113\u0146u" },
            { "BA", "Bosnija un Hercegovina" },
            { "BB", "Barbadosa" },
            { "ceb", "sebu\u0101\u0146u" },
            { "BD", "Banglade\u0161a" },
            { "kum", "kumiku" },
            { "BE", "Be\u013c\u0123ija" },
            { "gmh", "vidusaug\u0161v\u0101cu" },
            { "BF", "Burkinafaso" },
            { "BG", "Bulg\u0101rija" },
            { "BH", "Bahreina" },
            { "BI", "Burundi" },
            { "BJ", "Benina" },
            { "BL", "Senbartelm\u012b" },
            { "BM", "Bermudu salas" },
            { "kut", "kutenaju" },
            { "myv", "erzju" },
            { "BN", "Bruneja" },
            { "BO", "Bol\u012bvija" },
            { "BQ", "N\u012bderlandes Kar\u012bbu salas" },
            { "BR", "Braz\u012blija" },
            { "BS", "Bahamu salas" },
            { "xog", "sogu" },
            { "BT", "But\u0101na" },
            { "BV", "Buv\u0113 sala" },
            { "BW", "Botsv\u0101na" },
            { "BY", "Baltkrievija" },
            { "BZ", "Beliza" },
            { "CA", "Kan\u0101da" },
            { "CC", "Kokosu jeb K\u012blinga salas" },
            { "mzn", "mazander\u0101\u0146u" },
            { "CD", "Kongo-Kin\u0161asa" },
            { "CF", "Centr\u0101l\u0101frikas Republika" },
            { "CG", "Kongo - Brazavila" },
            { "CH", "\u0160veice" },
            { "CI", "Kotdivu\u0101ra" },
            { "CK", "Kuka salas" },
            { "CL", "\u010c\u012ble" },
            { "CM", "Kamer\u016bna" },
            { "CN", "\u0136\u012bna" },
            { "CO", "Kolumbija" },
            { "CP", "Klipertona sala" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Kaboverde" },
            { "CW", "Kirasao" },
            { "CX", "Ziemsv\u0113tku sala" },
            { "CY", "Kipra" },
            { "CZ", "\u010cehija" },
            { "eka", "ekad\u017euku" },
            { "DE", "V\u0101cija" },
            { "goh", "senaug\u0161v\u0101cu" },
            { "ace", "a\u010dinu" },
            { "cgg", "kiga" },
            { "DG", "Djego Garsijas atols" },
            { "DJ", "D\u017eibutija" },
            { "DK", "D\u0101nija" },
            { "ach", "a\u010dolu" },
            { "gon", "gondu valodas" },
            { "Brai", "Braila raksts" },
            { "Brah", "brahmi" },
            { "DM", "Dominika" },
            { "DO", "Dominik\u0101na" },
            { "gor", "gorontalu" },
            { "got", metaValue_got },
            { "zun", "zunju" },
            { "tig", "tigru" },
            { "DZ", "Al\u017e\u012brija" },
            { "pag", "pangasinanu" },
            { "pal", "pehlevi" },
            { "EA", "Se\u016bta un Melilja" },
            { "chb", "\u010dib\u010du" },
            { "pam", "pampanganu" },
            { "EC", "Ekvadora" },
            { "pap", "papjamento" },
            { "ada", "adangmu" },
            { "EE", "Igaunija" },
            { "tiv", "tivu" },
            { "EG", "\u0112\u0123ipte" },
            { "EH", "Rietumsah\u0101ra" },
            { "chg", "d\u017eagatajs" },
            { "pau", "palavie\u0161u" },
            { "chk", "\u010d\u016bku" },
            { "chn", "\u010dinuku \u017eargons" },
            { "chm", "marie\u0161u" },
            { "chp", "\u010dipevaianu" },
            { "cho", "\u010doktavu" },
            { "chr", "\u010diroku" },
            { "ER", "Eritreja" },
            { "ES", "Sp\u0101nija" },
            { "ET", "Etiopija" },
            { "EU", "Eiropas Savien\u012bba" },
            { "elx", "elamie\u0161u" },
            { "chy", "\u0161ejenu" },
            { "ady", "adigu" },
            { "FI", "Somija" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Folklenda salas" },
            { "FM", "Mikron\u0113zija" },
            { "FO", "F\u0113ru Salas" },
            { "Taml", metaValue_ta },
            { "FR", "Francija" },
            { "tkl", "tokelavie\u0161u" },
            { "grb", "grebo" },
            { "root", "sakne" },
            { "grc", "sengrie\u0137u" },
            { "GA", "Gabona" },
            { "vot", "votu" },
            { "GB", "Lielbrit\u0101nija" },
            { "GD", "Gren\u0101da" },
            { "GE", "Gruzija" },
            { "GF", "Fran\u010du Gvi\u0101na" },
            { "GG", "G\u0113rnsija" },
            { "GH", "Gana" },
            { "GI", "Gibralt\u0101rs" },
            { "afh", "afrihili" },
            { "GL", "Grenlande" },
            { "enm", "vidusang\u013cu" },
            { "GM", "Gambija" },
            { "GN", "Gvineja" },
            { "GP", "Gvadelupa" },
            { "GQ", "Ekvatori\u0101l\u0101 Gvineja" },
            { "GR", "Grie\u0137ija" },
            { "GS", "Dienvidd\u017eord\u017eija un Dienvidsendvi\u010du salas" },
            { "GT", "Gvatemala" },
            { "GU", "Guama" },
            { "GW", "Gvineja-Bisava" },
            { "tli", "tlinkitu" },
            { "tlh", "klingo\u0146u" },
            { "GY", "Gaj\u0101na" },
            { "ckb", "kurdu (Sorani)" },
            { "zxx", "bez lingvistiska satura" },
            { "de_AT", "Austrijas v\u0101cu" },
            { "HK", "\u0136\u012bnas \u012bpa\u0161\u0101s p\u0101rvaldes apgabals Honkonga" },
            { "HM", "H\u0113rda un Makdonalda salas" },
            { "HN", "Hondurasa" },
            { "HR", "Horv\u0101tija" },
            { "agq", "aghemu" },
            { "gsw", "\u0160veices v\u0101cu" },
            { "HT", "Haiti" },
            { "HU", "Ung\u0101rija" },
            { "tmh", "tuaregu" },
            { "IC", "Kan\u0101riju salas" },
            { "ID", "Indon\u0113zija" },
            { "peo", "senpersu" },
            { "IE", "\u012arija" },
            { "nap", "neapolie\u0161u" },
            { "naq", "nama" },
            { "zza", "zazaki" },
            { "IL", "Izra\u0113la" },
            { "IM", "Mena" },
            { "IN", "Indija" },
            { "IO", "Indijas oke\u0101na Britu teritorija" },
            { "IQ", "Ir\u0101ka" },
            { "IR", "Ir\u0101na" },
            { "IS", "\u012aslande" },
            { "IT", "It\u0101lija" },
            { "Zmth", "matem\u0101tiskais pieraksts" },
            { "%%POSIX", "datoru" },
            { "JE", "D\u017e\u0113rsija" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jord\u0101nija" },
            { "JP", "Jap\u0101na" },
            { "ain", "ainu" },
            { "guz", "gusii" },
            { "tog", "njasas tongu" },
            { "de_CH", "\u0160veices aug\u0161v\u0101cu" },
            { "KE", "Kenija" },
            { "419", "Lat\u012b\u0146amerika" },
            { "KG", "Kirgizst\u0101na" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komoru salas" },
            { "KN", "Sentkitsa un Nevisa" },
            { "Knda", "kannaru" },
            { "Zinh", "mantot\u0101" },
            { "fr_CA", "Kan\u0101das fran\u010du" },
            { "KP", "Zieme\u013ckoreja" },
            { "KR", "Dienvidkoreja" },
            { "fr_CH", "\u0160veices fran\u010du" },
            { "KW", "Kuveita" },
            { "tpi", "tokpisins" },
            { "KY", "Kaimanu salas" },
            { "KZ", "Kazahst\u0101na" },
            { "Cyrl", "kirilica" },
            { "LA", "Laosa" },
            { "LB", "Lib\u0101na" },
            { "phn", metaValue_phn },
            { "LC", "Sentl\u016bsija" },
            { "Cyrs", "sensl\u0101vu" },
            { "gwi", "ku\u010dinu" },
            { "nds", "lejasv\u0101cu" },
            { "LI", "Lihten\u0161teina" },
            { "LK", "\u0160rilanka" },
            { "akk", "akadie\u0161u" },
            { "cop", metaValue_cop },
            { "LR", "Lib\u0113rija" },
            { "LS", "Lesoto" },
            { "LT", "Lietuva" },
            { "LU", "Luksemburga" },
            { "LV", "Latvija" },
            { "Kana", "katakana" },
            { "LY", "L\u012bbija" },
            { "lad", "ladino" },
            { "vun", "vund\u017eo" },
            { "lah", "landu" },
            { "lag", "langi" },
            { "Thaa", "taana" },
            { "MA", "Maroka" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Melnkalne" },
            { "MF", "Senmart\u0113na" },
            { "lam", "lambu" },
            { "MG", "Madagaskara" },
            { "Thai", metaValue_th },
            { "MH", "M\u0101r\u0161ala salas" },
            { "ale", "aleutu" },
            { "MK", "Ma\u0137edonija" },
            { "ML", "Mali" },
            { "MM", "Mjanma (Birma)" },
            { "MN", "Mongolija" },
            { "new", "nevaru" },
            { "MO", "\u0136\u012bnas \u012bpa\u0161\u0101s p\u0101rvaldes apgabals Makao" },
            { "MP", "Zieme\u013cu Marianas salas" },
            { "MQ", "Martinika" },
            { "MR", "Maurit\u0101nija" },
            { "MS", "Montserrata" },
            { "MT", "Malta" },
            { "MU", "Maur\u012bcija" },
            { "alt", "dienvidaltajie\u0161u" },
            { "MV", "Mald\u012bvija" },
            { "MW", "Mal\u0101vija" },
            { "MX", "Meksika" },
            { "MY", "Malaizija" },
            { "MZ", "Mozambika" },
            { "NA", "Nam\u012bbija" },
            { "NC", "Jaunkaledonija" },
            { "%%WADEGILE", "Veida-D\u017eailza romaniz\u0101cija" },
            { "NE", "Nig\u0113ra" },
            { "NF", "Norfolkas sala" },
            { "NG", "Nig\u0113rija" },
            { "trv", "taroko" },
            { "NI", "Nikaragva" },
            { "NL", "N\u012bderlande" },
            { "NO", "Norv\u0113\u0123ija" },
            { "NP", "Nep\u0101la" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "cim\u0161i\u0101\u0146u" },
            { "NZ", "Jaunz\u0113lande" },
            { "rom", "\u010dig\u0101nu" },
            { "crh", "Krimas tat\u0101ru" },
            { "ang", "senang\u013cu" },
            { "OM", "Om\u0101na" },
            { "anp", "angika" },
            { "Xpeo", "senperie\u0161u" },
            { "PA", "Panama" },
            { "csb", "ka\u0161ubu" },
            { "en_GB", "Lielbrit\u0101nijas ang\u013cu" },
            { "PE", "Peru" },
            { "PF", "Fran\u010du Polin\u0113zija" },
            { "PG", "Papua-Jaungvineja" },
            { "PH", "Filip\u012bnas" },
            { "PK", "Pakist\u0101na" },
            { "PL", "Polija" },
            { "ewo", "evondu" },
            { "PM", "Senpj\u0113ra un Mikelona" },
            { "PN", "Pitk\u0113rna" },
            { "PR", "Puertoriko" },
            { "Bali", metaValue_ban },
            { "PS", "Palest\u012bna" },
            { "PT", "Portug\u0101le" },
            { "PW", "Palau" },
            { "nia", "njasu" },
            { "PY", "Paragvaja" },
            { "tum", "tumbuku" },
            { "Hebr", metaValue_he },
            { "QA", "Katara" },
            { "%%SCOTLAND", "Skotijas ang\u013cu" },
            { "niu", "niu\u0101\u0146u" },
            { "QO", "Oke\u0101nijas att\u0101l\u0101s salas" },
            { "lez", "lezg\u012bnu" },
            { "%%FONUPA", "UPA fon\u0113tika" },
            { "tvl", "tuvalie\u0161u" },
            { "001", "pasaule" },
            { "002", "\u0100frika" },
            { "003", "Zieme\u013camerika" },
            { "RE", "Reinjona" },
            { "005", "Dienvidamerika" },
            { "jbo", "lo\u017ebans" },
            { "009", "Oke\u0101nija" },
            { "RO", "Rum\u0101nija" },
            { "RS", "Serbija" },
            { "RU", "Krievija" },
            { "RW", "Ruanda" },
            { "SA", "Sa\u016bda Ar\u0101bija" },
            { "pon", "ponapie\u0161u" },
            { "SB", "Z\u0101lamana salas" },
            { "twq", "tasavaku" },
            { "011", "Rietum\u0101frika" },
            { "SC", "\u0160ei\u0161elu salas" },
            { "SD", "Sud\u0101na" },
            { "013", "Centr\u0101lamerika" },
            { "SE", "Zviedrija" },
            { "arc", metaValue_arc },
            { "014", "Austrum\u0101frika" },
            { "015", "Zieme\u013c\u0101frika" },
            { "SG", "Singap\u016bra" },
            { "SH", "Sv.Hel\u0113nas sala" },
            { "017", "Vidus\u0101frika" },
            { "SI", "Slov\u0113nija" },
            { "018", "Dienvid\u0101frika" },
            { "SJ", "Svalb\u0101ra un Jana Majena sala" },
            { "019", "Amerika" },
            { "SK", "Slov\u0101kija" },
            { "SL", "Sjerraleone" },
            { "SM", "Sanmar\u012bno" },
            { "SN", "Seneg\u0101la" },
            { "SO", "Som\u0101lija" },
            { "arn", "arauk\u0101\u0146u" },
            { "arp", "arapahu" },
            { "SR", "Surinama" },
            { "SS", "Dienvidsud\u0101na" },
            { "ST", "Santome un Prinsipi" },
            { "SV", "Salvadora" },
            { "SX", "Sintm\u0101rtena" },
            { "SY", "S\u012brija" },
            { "yao", "jao" },
            { "SZ", "Svazilenda" },
            { "arw", "aravaku" },
            { "yap", "japie\u0161u" },
            { "TA", "Tristana da Ku\u0146as salas" },
            { "asa", "asu" },
            { "021", "Amerikas zieme\u013cu da\u013ca" },
            { "TC", "T\u0113rksas un Kaikosas salas" },
            { "yav", "janba\u0146u" },
            { "TD", "\u010cada" },
            { "TF", "Francijas Dienvidj\u016bru Zemes" },
            { "TG", "Togo" },
            { "TH", "Taizeme" },
            { "TJ", "Tad\u017eikist\u0101na" },
            { "029", "Kar\u012bbu j\u016bras re\u0123ions" },
            { "TK", "Tokelau" },
            { "TL", "Austrumtimora" },
            { "ybb", "jembu" },
            { "TM", "Turkmenist\u0101na" },
            { "TN", "Tunisija" },
            { "TO", "Tonga" },
            { "TR", "Turcija" },
            { "TT", "Trinid\u0101da un Tob\u0101go" },
            { "TV", "Tuvalu" },
            { "TW", "Taiv\u0101na" },
            { "ast", "ast\u016brie\u0161u" },
            { "TZ", "Tanz\u0101nija" },
            { "nmg", "kvasio" },
            { "Zzzz", "nezin\u0101ma rakst\u012bba" },
            { "UA", "Ukraina" },
            { "rup", "arom\u016bnu" },
            { "030", "Austrum\u0101zija" },
            { "tyv", "tuvie\u0161u" },
            { "sw_CD", "Kongo svahili" },
            { "034", "Dienvid\u0101zija" },
            { "hai", "haidu" },
            { "035", "Centr\u0101laustrum\u0101zija" },
            { "UG", "Uganda" },
            { "039", "Dienvideiropa" },
            { "Sinh", metaValue_si },
            { "UM", "ASV Aizj\u016bras salas" },
            { "US", "Amerikas Savienot\u0101s Valstis" },
            { "haw", "havajie\u0161u" },
            { "%%1959ACAD", "akad\u0113misk\u0101" },
            { "UY", "Urugvaja" },
            { "UZ", "Uzbekist\u0101na" },
            { "tzm", "Centr\u0101lmarokas tamaz\u012bts" },
            { "nnh", "ngjemb\u016bnu" },
            { "VA", "Vatik\u0101ns" },
            { "pro", "senprovansie\u0161u" },
            { "VC", "Sentvinsenta un Grenad\u012bnas" },
            { "VE", "Venecu\u0113la" },
            { "VG", "Britu Vird\u017e\u012bnas" },
            { "VI", "ASV Vird\u017e\u012bnas" },
            { "VN", "Vjetnama" },
            { "VU", "Vanuatu" },
            { "nog", "nogaju" },
            { "rwk", "ruanda" },
            { "non", "sennorv\u0113\u0123u" },
            { "053", "Austr\u0101l\u0101zija" },
            { "%%AREVMDA", "rietumarm\u0113\u0146u" },
            { "054", "Melan\u0113zija" },
            { "WF", "Volisa un Futuna" },
            { "057", "Mikron\u0113zijas re\u0123ions" },
            { "jgo", "jgo" },
            { "lkt", "lakotu" },
            { "wae", "Vallisas v\u0101cu" },
            { "WS", "Samoa" },
            { "wal", "valamu" },
            { "was", "va\u0161o" },
            { "war", "varaju" },
            { "awa", "avadhu" },
            { "061", "Polin\u0113zija" },
            { "XK", "Kosova" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "bez rakst\u012bbas" },
            { "wbp", "varlpir\u012b" },
            { "YE", "Jemena" },
            { "nqo", "nko" },
            { "fan", "fangu" },
            { "fat", "fantu" },
            { "YT", "Majota" },
            { "ZA", "Dienvid\u0101frikas Republika" },
            { "Deva", "dev\u0101nag\u0101ri" },
            { "Hira", "hiragana" },
            { "ZM", "Zambija" },
            { "%%PINYIN", "pi\u0146ji\u0146a romaniz\u0101cija" },
            { "ZW", "Zimbabve" },
            { "ZZ", "nezin\u0101ms re\u0123ions" },
            { "Runr", "r\u016bnu raksts" },
            { "lol", "mongu" },
            { "nso", "zieme\u013csotu" },
            { "loz", "lozu" },
            { "jmc", "ma\u010damu" },
            { "hil", "hiligainonu" },
            { "nus", "nueru" },
            { "dak", "dakotu" },
            { "hit", "hetu" },
            { "dar", "dargu" },
            { "dav", "taitu" },
            { "Maya", "maiju" },
            { "lrc", "zieme\u013cluru" },
            { "Copt", metaValue_cop },
            { "nwc", "klasisk\u0101 nevaru" },
            { "udm", "udmurtu" },
            { "Khmr", metaValue_km },
            { "sad", "sandavu" },
            { "sah", "jakutu" },
            { "sam", "sam\u0101rijas aramie\u0161u" },
            { "saq", "samburu" },
            { "sas", "sasaku" },
            { "sat", "santalu" },
            { "jpr", "j\u016bdpersie\u0161u" },
            { "Guru", metaValue_pa },
            { "sba", "ngambeju" },
            { "lua", "lubalulva" },
            { "sbp", "sangu" },
            { "lui", "luisenu" },
            { "nyn", "\u0146ankolu" },
            { "nym", "\u0146amvezu" },
            { "lun", "lundu" },
            { "nyo", "\u0146oru" },
            { "luo", "luo" },
            { "fil", "filip\u012bnie\u0161u" },
            { "hmn", "hmongu" },
            { "del", "delav\u0113ru" },
            { "lus", "lu\u0161eju" },
            { "bal", "belud\u017eu" },
            { "den", "sleivu" },
            { "ban", metaValue_ban },
            { "uga", "ugaritie\u0161u" },
            { "luy", "luhju" },
            { "bas", "basu" },
            { "bax", "bamumu" },
            { "jrb", "j\u016bdar\u0101bu" },
            { "es_ES", "Eiropas sp\u0101\u0146u" },
            { "nzi", "nzemu" },
            { "sco", "skotu" },
            { "scn", "sic\u012blie\u0161u" },
            { "aa", "af\u0101ru" },
            { "ab", "abh\u0101zu" },
            { "ae", "avesta" },
            { "af", "afrikandu" },
            { "ak", "akanu" },
            { "bbj", "gomalu" },
            { "am", "amharu" },
            { "Arab", metaValue_ar },
            { "an", "aragonie\u0161u" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana vai hiragana" },
            { "as", "asamie\u0161u" },
            { "Lina", "line\u0101r\u0101 A" },
            { "av", "av\u0101ru" },
            { "Linb", "line\u0101r\u0101 B" },
            { "sdh", "dienvidkurdu" },
            { "ay", "aimaru" },
            { "az", "azerbaid\u017e\u0101\u0146u" },
            { "ba", "ba\u0161k\u012bru" },
            { "be", "baltkrievu" },
            { "bg", "bulg\u0101ru" },
            { "bi", "bi\u0161lam\u0101" },
            { "bm", "bambaru" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogribu" },
            { "br", "breto\u0146u" },
            { "bs", "bosnie\u0161u" },
            { "see", "seneku" },
            { "Mymr", metaValue_my },
            { "seh", "senu" },
            { "sel", "selkupu" },
            { "ca", "katal\u0101\u0146u" },
            { "ses", "koiraboro senni" },
            { "ce", "\u010de\u010denu" },
            { "ch", "\u010damorru" },
            { "co", "korsik\u0101\u0146u" },
            { "Orya", metaValue_or },
            { "cr", "kr\u012b" },
            { "cs", "\u010dehu" },
            { "cu", "bazn\u012bcsl\u0101vu" },
            { "cv", "\u010duva\u0161u" },
            { "cy", "velsie\u0161u" },
            { "Yiii", "ji" },
            { "da", "d\u0101\u0146u" },
            { "pt_PT", "Eiropas portug\u0101\u013cu" },
            { "de", "v\u0101cu" },
            { "bej", "bed\u017eu" },
            { "din", "dinku" },
            { "bem", "bembu" },
            { "sga", "sen\u012bru" },
            { "dv", "mald\u012bvie\u0161u" },
            { "es_419", "Lat\u012b\u0146amerikas sp\u0101\u0146u" },
            { "dz", "dzongke" },
            { "bez", "bena" },
            { "dje", "zarmu" },
            { "ee", "evu" },
            { "bfd", "bafutu" },
            { "ro_MD", "mold\u0101vu" },
            { "el", metaValue_el },
            { "en", "ang\u013cu" },
            { "eo", "esperanto" },
            { "es", "sp\u0101\u0146u" },
            { "et", "igau\u0146u" },
            { "eu", "basku" },
            { "Hang", "hangila" },
            { "Samr", "samarie\u0161u" },
            { "shi", "\u0161ilhu" },
            { "Hani", metaValue_zh },
            { "hsb", "aug\u0161sorbu" },
            { "shn", "\u0161anu" },
            { "fa", "persie\u0161u" },
            { "Hans", metaValue_Hans },
            { "Hant", metaValue_Hant },
            { "az_Arab", "dienvidazerbaid\u017e\u0101\u0146u" },
            { "ff", "fulu" },
            { "shu", "\u010cadas ar\u0101bu" },
            { "fi", "somu" },
            { "fj", "fid\u017eie\u0161u" },
            { "fon", "fonu" },
            { "bgn", "rietumbelud\u017eu" },
            { "yue", "kantonie\u0161u" },
            { "fo", "f\u0113ru" },
            { "umb", "umbundu" },
            { "fr", "fran\u010du" },
            { "sid", "sidamu" },
            { "fy", "rietumfr\u012bzu" },
            { "ga", "\u012bru" },
            { "gd", "g\u0113lu" },
            { "gl", "galisie\u0161u" },
            { "gn", "gvaranu" },
            { "bho", "bhod\u017ep\u016bru" },
            { "und", "nezin\u0101ma valoda" },
            { "gu", metaValue_gu },
            { "gv", "menie\u0161u" },
            { "ha", "hausu" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupu" },
            { "bik", "bikolu" },
            { "bin", "binu" },
            { "ho", "hirimotu" },
            { "hr", "horv\u0101tu" },
            { "ht", "haitie\u0161u" },
            { "hu", "ung\u0101ru" },
            { "hy", metaValue_hy },
            { "hz", "hereru" },
            { "%%FONIPA", "Starptautiskais fon\u0113tiskais alfab\u0113ts" },
            { "ia", "interlingva" },
            { "id", "indon\u0113zie\u0161u" },
            { "ie", "interlingve" },
            { "ig", "igbo" },
            { "ii", "Si\u010dua\u0146as ji" },
            { "frm", "vidusfran\u010du" },
            { "ik", "inupiaku" },
            { "fro", "senfran\u010du" },
            { "io", "ido" },
            { "frs", "austrumfr\u012bzu" },
            { "frr", "zieme\u013cfr\u012bzu" },
            { "is", "\u012bslandie\u0161u" },
            { "it", "it\u0101\u013cu" },
            { "iu", "inu\u012btu" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "doi", "dogru" },
            { "bkm", "komu" },
            { "sma", "dienvids\u0101mu" },
            { "jv", metaValue_jv },
            { "mad", "madurie\u0161u" },
            { "smj", "Luleo s\u0101mu" },
            { "mag", "magahie\u0161u" },
            { "maf", "mafu" },
            { "mai", "maithili" },
            { "smn", "Inari s\u0101mu" },
            { "ka", metaValue_ka },
            { "bla", "siksiku" },
            { "mak", "makasaru" },
            { "sms", "skolts\u0101mu" },
            { "man", "mandingu" },
            { "kg", "kongu" },
            { "Goth", metaValue_got },
            { "ki", "kikuju" },
            { "mas", "masaju" },
            { "kj", "kva\u0146amu" },
            { "kk", "kazahu" },
            { "kl", "grenlandie\u0161u" },
            { "km", metaValue_km },
            { "kn", "kannadu" },
            { "ko", metaValue_ko },
            { "kr", "kanuru" },
            { "ks", "ka\u0161mirie\u0161u" },
            { "ku", "kurdu" },
            { "kv", "komie\u0161u" },
            { "kw", "kornie\u0161u" },
            { "ky", "kirg\u012bzu" },
            { "snk", "soninku" },
            { "la", metaValue_la },
            { "lb", "luksemburgie\u0161u" },
            { "lg", "gandu" },
            { "Roro", "rongorongo" },
            { "li", "limburgie\u0161u" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "fri\u016blu" },
            { "lo", metaValue_lo },
            { "lt", "lietuvie\u0161u" },
            { "lu", "lubakatanga" },
            { "lv", "latvie\u0161u" },
            { "sog", "sogdie\u0161u" },
            { "mg", "malagasu" },
            { "mh", "m\u0101r\u0161alie\u0161u" },
            { "mi", "maoru" },
            { "mk", "ma\u0137edonie\u0161u" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "maratu" },
            { "ms", "malajie\u0161u" },
            { "mt", "maltie\u0161u" },
            { "my", metaValue_my },
            { "Armn", metaValue_hy },
            { "mdf", "mok\u0161u" },
            { "mde", "mabu" },
            { "Armi", metaValue_arc },
            { "dsb", "lejassorbu" },
            { "na", "nauruie\u0161u" },
            { "nb", "norv\u0113\u0123u bukmols" },
            { "nd", "zieme\u013cndebelu" },
            { "ne", "nep\u0101lie\u0161u" },
            { "ng", "ndongu" },
            { "mdr", "mandaru" },
            { "nl", "holandie\u0161u" },
            { "nn", "jaunnorv\u0113\u0123u" },
            { "no", "norv\u0113\u0123u" },
            { "nr", "dienvidndebelu" },
            { "nv", "navahu" },
            { "kaa", "karakalpaku" },
            { "ny", "\u010di\u010deva" },
            { "kac", "ka\u010dinu" },
            { "kab", "kabilu" },
            { "%%POLYTON", "politons" },
            { "oc", "oksit\u0101\u0146u" },
            { "kaj", "kad\u017ei" },
            { "kam", "kambu" },
            { "men", "mendu" },
            { "oj", "od\u017eibvu" },
            { "mer", "meru" },
            { "om", "oromu" },
            { "kaw", "k\u0101vi" },
            { "or", metaValue_or },
            { "os", "oset\u012bnu" },
            { "kbd", "kabardie\u0161u" },
            { "mfe", "Maur\u012bcijas kreolu" },
            { "srn", "sranantogo" },
            { "pa", metaValue_pa },
            { "dua", "dualu" },
            { "srr", "ser\u0113ru" },
            { "kbl", "ka\u0146embu" },
            { "pi", "p\u0101li" },
            { "pl", "po\u013cu" },
            { "dum", "vidusholandie\u0161u" },
            { "ps", "pu\u0161tu" },
            { "pt", "portug\u0101\u013cu" },
            { "mga", "vidus\u012bru" },
            { "pt_BR", "Braz\u012blijas portug\u0101\u013cu" },
            { "kcg", "katabu" },
            { "mgh", "makua-meetto" },
            { "bra", "brad\u017eie\u0161u" },
            { "Laoo", metaValue_lo },
            { "mgo", "mgo" },
            { "ssy", metaValue_ssy },
            { "qu", "ke\u010dvu" },
            { "zap", "sapoteku" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "Ethi", "etiopie\u0161u" },
            { "rm", "retorom\u0101\u0146u" },
            { "rn", "rundu" },
            { "ro", "rum\u0101\u0146u" },
            { "%%SAAHO", metaValue_ssy },
            { "ru", "krievu" },
            { "bss", "nkosi" },
            { "rw", "ki\u0146aruanda" },
            { "zbl", "blissimbolika" },
            { "kea", "kaboverdie\u0161u" },
            { "mic", "mikmaku" },
            { "suk", "sukumu" },
            { "en_AU", "Austr\u0101lijas ang\u013cu" },
            { "sa", "sanskrits" },
            { "%%UCCOR", "vienot\u0101 ortogr\u0101fija" },
            { "sc", "sard\u012bnie\u0161u" },
            { "sus", "susu" },
            { "sd", "sindhu" },
            { "se", "zieme\u013cs\u0101mu" },
            { "min", "minangkabavu" },
            { "sg", "sango" },
            { "sh", "serbu-horv\u0101tu" },
            { "si", metaValue_si },
            { "sux", "\u0161umeru" },
            { "sk", "slov\u0101ku" },
            { "sl", "slov\u0113\u0146u" },
            { "sm", "samo\u0101\u0146u" },
            { "sn", "\u0161onu" },
            { "so", "som\u0101\u013cu" },
            { "sq", "alb\u0101\u0146u" },
            { "sr", "serbu" },
            { "ss", "svatu" },
            { "Java", metaValue_jv },
            { "st", "dienvidsotu" },
            { "su", "sundanie\u0161u" },
            { "%%NEDIS", "Natisona dialekts" },
            { "sv", "zviedru" },
            { "sw", "svahili" },
            { "ibb", "ibibio" },
            { "iba", "ibanu" },
            { "ta", metaValue_ta },
            { "142", "\u0100zija" },
            { "bua", "burjatu" },
            { "143", "Centr\u0101l\u0101zija" },
            { "te", metaValue_te },
            { "145", "Rietum\u0101zija" },
            { "tg", "tad\u017eiku" },
            { "th", metaValue_th },
            { "ti", "tigrinja" },
            { "bug", "bugu" },
            { "kfo", "koru" },
            { "en_CA", "Kan\u0101das ang\u013cu" },
            { "tk", "turkm\u0113\u0146u" },
            { "tl", metaValue_tl },
            { "tn", "cvanu" },
            { "to", "tongie\u0161u" },
            { "bum", "bulu" },
            { "dyo", "diola-fonj\u012b" },
            { "tr", "turku" },
            { "ts", "congu" },
            { "swb", "komoru" },
            { "tt", "tat\u0101ru" },
            { "dyu", "di\u016blu" },
            { "tw", "tv\u012b" },
            { "ty", "taitie\u0161u" },
            { "150", "Eiropa" },
            { "151", "Austrumeiropa" },
            { "154", "Zieme\u013ceiropa" },
            { "dzg", "dazu" },
            { "155", "Rietumeiropa" },
            { "ug", "uiguru" },
            { "Kore", metaValue_ko },
            { "Ital", "vecit\u0101\u013cu" },
            { "Zyyy", "visp\u0101r\u0113j\u0101" },
            { "uk", "ukrai\u0146u" },
            { "ur", "urdu" },
            { "xal", "kalmiku" },
            { "zen", "zenagu" },
            { "uz", "uzbeku" },
            { "kha", "khasu" },
            { "%%1996", "v\u0101cu ortogr\u0101fija no 1996. gada" },
            { "nds_NL", "lejassak\u0161u" },
            { "ve", "vendu" },
            { "vi", "vjetnamie\u0161u" },
            { "kho", "hotanie\u0161u" },
            { "khq", "koira\u010diin\u012b" },
            { "%%TARASK", "Tara\u0161kevi\u010da ortogr\u0101fija" },
            { "vo", "volapiks" },
            { "syc", "klasisk\u0101 s\u012brie\u0161u" },
            { "Osma", "osma\u0146u turku" },
            { "quc", "ki\u010de" },
            { "gaa", "ga" },
            { "wa", "valo\u0146u" },
            { "gag", "gagauzu" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "Lydi", "l\u012bdie\u0161u" },
            { "Xsux", "\u0161umeru-akadie\u0161u \u0137\u012b\u013craksts" },
            { "wo", "volofu" },
            { "zgh", "standarta marok\u0101\u0146u berberu" },
            { "ar_001", "m\u016bsdienu standarta ar\u0101bu" },
            { "gay", "gajo" },
            { "Mong", metaValue_mn },
            { "mnc", "mand\u017e\u016bru" },
            { "gba", "gbaju" },
            { "mni", "manip\u016bru" },
            { "Latn", metaValue_la },
            { "xh", "khosu" },
            { "byn", "bilinu" },
            { "osa", "va\u017e\u0101\u017eu" },
            { "byv", "medumbu" },
            { "Moon", "M\u016bna raksts" },
            { "moh", "mohauku" },
            { "kkj", "kako" },
            { "Syrc", metaValue_syr },
            { "yi", "jidi\u0161s" },
            { "mos", "mosu" },
            { "yo", "jorubu" },
            { "es_MX", "Meksikas sp\u0101\u0146u" },
            { "Syrj", "rietums\u012brie\u0161u" },
            { "ota", "turku osma\u0146u" },
            { "vai", "vaju" },
            { "za", "d\u017euanu" },
            { "kln", "kalend\u017e\u012bnu" },
            { "zh", metaValue_zh },
            { "Bopo", "bopomofo" },
            { "zu", "zulu" },
            { "%%MONOTON", "monotons" },
            { "Geor", metaValue_ka },
            { "kmb", "kimbundu" },
            { "gez", "g\u0113zu" },
            { "Syrn", "austrums\u012brie\u0161u" },
            { "Tglg", metaValue_tl },
            { "Egyd", "demotiskais raksts" },
            { "Egyh", "hier\u0101tiskais raksts" },
            { "ebu", "kjembu" },
            { "Egyp", "\u0113\u0123iptie\u0161u hieroglifi" },
            { "zh_Hans", metaValue_Hans },
            { "koi", "komie\u0161u-permie\u0161u" },
            { "Hung", "senung\u0101ru" },
            { "kok", "konkanu" },
            { "%%1901", "tradicion\u0101l\u0101 v\u0101cu ortogr\u0101fija" },
            { "kos", "kosr\u0101jie\u0161u" },
            { "zh_Hant", metaValue_Hant },
            { "Sund", "zundu" },
            { "kpe", "kpellu" },
            { "ilo", "iloku" },
            { "%%VALENCIA", "valensie\u0161u" },
            { "mua", "mundangu" },
            { "mul", "vair\u0101kas valodas" },
            { "cad", "kadu" },
            { "mus", "kr\u012bku" },
            { "gil", "kiribatie\u0161u" },
            { "%%KKCOR", "tradicion\u0101l\u0101 ortogr\u0101fija" },
            { "Cher", "irok\u0113zu" },
            { "car", "kar\u012bbu" },
            { "cay", "kajuga" },
            { "krc", "kara\u010daju un balk\u0101ru" },
            { "inh", "ingu\u0161u" },
            { "krl", "kar\u0113\u013cu" },
            { "efi", "efiku" },
            { "kru", "kuruhu" },
            { "ksb", "\u0161ambalu" },
            { "Telu", metaValue_te },
            { "ksf", "bafiju" },
        };
        return data;
    }
}
