/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bo = "tibetskt";
        final String metaValue_el = "grikskt";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraiskt";
        final String metaValue_hy = "armenskt";
        final String metaValue_ja = "japanskt";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreanskt";
        final String metaValue_ml = "malayalam";
        final String metaValue_or = "oriya";
        final String metaValue_ta = "tamilskt";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailendskt";
        final Object[][] data = new Object[][] {
            { "sbp", "sangu" },
            { "nyn", "nyankole" },
            { "luo", "luo" },
            { "Zsym", "tekin" },
            { "fil", "filipiniskt" },
            { "luy", "luyia" },
            { "teo", "teso" },
            { "ab", "abkhasiskt" },
            { "AC", "Ascension" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Sameindu Emirr\u00edkini" },
            { "nl_BE", "flamskt" },
            { "AF", "Afganistan" },
            { "af", "afrikaans" },
            { "AG", "Antigua & Barbuda" },
            { "AI", "Anguilla" },
            { "ak", "akan" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "am", "amhariskt" },
            { "Arab", "arabisk" },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "ar", "arabiskt" },
            { "AS", "Amerikanska Samoa" },
            { "as", "assamesiskt" },
            { "AT", "Eysturr\u00edki" },
            { "AU", "Avstralia" },
            { "AW", "Aruba" },
            { "sdh", "su\u00f0ur kurdiskt" },
            { "AX", "\u00c1land" },
            { "ay", "aymara" },
            { "AZ", "Aserbadjan" },
            { "az", "aserbajdsjanskt" },
            { "BA", "Bosnia-Hersegovina" },
            { "ba", "bashkir" },
            { "BB", "Barbados" },
            { "BD", "Bangladesj" },
            { "BE", "Belgia" },
            { "be", "hvitarussiskt" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "bg", "bulgarskt" },
            { "BH", "Barein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "bm", "bambara" },
            { "BN", "Brunei" },
            { "bn", "bengalskt" },
            { "bo", metaValue_bo },
            { "BO", "Bolivia" },
            { "BQ", "Ni\u00f0urlonds Karibia" },
            { "BR", "Brasil" },
            { "br", "bretonskt" },
            { "BS", "Bahamaoyggjar" },
            { "bs", "bosniskt" },
            { "xog", "soga" },
            { "BT", "Butan" },
            { "BV", "Bouvetoyggj" },
            { "BW", "Botsvana" },
            { "Mymr", "myanmarskt" },
            { "BY", "Hv\u00edtarussland" },
            { "seh", "sena" },
            { "BZ", "Belis" },
            { "CA", "Kanada" },
            { "ca", "katalani" },
            { "CC", "Kokosoyggjar" },
            { "mzn", "mazanderani" },
            { "ses", "koyraboro senni" },
            { "CD", "Kongo, Dem. L\u00fd\u00f0veldi\u00f0" },
            { "ce", "tjetjenskt" },
            { "CF", "Mi\u00f0afrikal\u00fd\u00f0veldi\u00f0" },
            { "CG", "Kongo" },
            { "CH", "Sveis" },
            { "CI", "F\u00edlabeinsstrondin" },
            { "CK", "Cooksoyggjar" },
            { "CL", "Kili" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolombia" },
            { "co", "korsikanskt" },
            { "CP", "Clipperton" },
            { "Orya", metaValue_or },
            { "CR", "Kosta Rika" },
            { "cs", "kekkiskt" },
            { "CU", "Kuba" },
            { "CV", "Gr\u00f8nh\u00f8vdaoyggjar" },
            { "cv", "chuvash" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "J\u00f3laoyggjin" },
            { "CY", "K\u00fdpros" },
            { "cy", "walisiskt" },
            { "CZ", "Kekkia" },
            { "da", "danskt" },
            { "pt_PT", "portugiskiskt (Evropa)" },
            { "DE", "T\u00fdskland" },
            { "de", "t\u00fdskt" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibuti" },
            { "DK", "Danmark" },
            { "Brai", "blindaskrift" },
            { "DM", "Dominika" },
            { "DO", "Dominikal\u00fd\u00f0veldi\u00f0" },
            { "bem", "bemba" },
            { "dv", "divehi" },
            { "DZ", "Algeria" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "EA", "Ceuta og Melilla" },
            { "EC", "Ekvador" },
            { "dje", "sarma" },
            { "EE", "Estland" },
            { "ee", "ewe" },
            { "EG", "Egyptaland" },
            { "EH", "Vestursahara" },
            { "ro_MD", "moldaviskt" },
            { "el", metaValue_el },
            { "en", "enskt" },
            { "eo", "esperanto" },
            { "chr", "cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Spania" },
            { "es", "spanskt" },
            { "ET", "Etiopia" },
            { "et", "estiskt" },
            { "EU", "Evropasamveldi\u00f0" },
            { "eu", "baskiskt" },
            { "Hang", "hangul" },
            { "shi", "tachelhit" },
            { "hsb", "ovara sorbian" },
            { "Hani", "han" },
            { "fa", "persiskt" },
            { "Hans", "einkult" },
            { "Hant", "vanligt" },
            { "FI", "Finnland" },
            { "fi", "finskt" },
            { "FJ", "Fiji" },
            { "fj", "fijim\u00e1l" },
            { "FK", "Falklandsoyggjar" },
            { "FM", "Mikronesiasamveldi\u00f0" },
            { "bgn", "vestur balochi" },
            { "yue", "kantones\u00edskt" },
            { "FO", "F\u00f8royar" },
            { "fo", "f\u00f8royskt" },
            { "Taml", metaValue_ta },
            { "FR", "Frakland" },
            { "fr", "franskt" },
            { "fy", "vestur fr\u00edsiskt" },
            { "GA", "Gabon" },
            { "ga", "\u00edrskt" },
            { "GB", "St\u00f3rabretland" },
            { "GD", "Grenada" },
            { "gd", "skotskt g\u00e6liskt" },
            { "GE", "Georgia" },
            { "GF", "Franska Gujana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f8nland" },
            { "gl", "galisiskt" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "gn", "guarani" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorguinea" },
            { "und", "\u00f3kent m\u00e1l" },
            { "GR", "Grikkaland" },
            { "GS", "Su\u00f0urgeorgia og Su\u00f0ursandwichoyggjar" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "manx" },
            { "GW", "Guinea-Bissau" },
            { "tlh", "klingonskt" },
            { "GY", "Gujana" },
            { "ha", "hausa" },
            { "ckb", "mi\u00f0kurdiskt" },
            { "zxx", "einki m\u00e1lsligt innihald" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "HK", "Hong Kong SAR Kina" },
            { "HM", "Heard og McDonaldoyggjar" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "hr", "kroatiskt" },
            { "agq", "aghem" },
            { "gsw", "t\u00fdskt (Sveis)" },
            { "HT", "Haiti" },
            { "ht", "haitiskt" },
            { "HU", "Ungarn" },
            { "hu", "ungarskt" },
            { "hy", metaValue_hy },
            { "ia", "interlingua" },
            { "IC", "Kanariuoyggjar" },
            { "ID", "Indonesia" },
            { "id", "indonesiskt" },
            { "IE", "\u00cdrland" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "naq", "nama" },
            { "ii", "sichuan yi" },
            { "IL", "\u00cdsrael" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "St\u00f3ra Bretlands Indiahavoyggjar" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "\u00cdsland" },
            { "is", "\u00edslendskt" },
            { "IT", "Italia" },
            { "it", "italskt" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "Beng", "bengali" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "sma", "su\u00f0ur s\u00e1miskt" },
            { "jv", "javanskt" },
            { "guz", "gusii" },
            { "smj", "lule s\u00e1miskt" },
            { "de_CH", "h\u00f8gt t\u00fdskt (Sveis)" },
            { "smn", "inari sami" },
            { "ka", "georgiskt" },
            { "sms", "skolt s\u00e1miskt" },
            { "KE", "Kenja" },
            { "419", "Lat\u00ednamerika" },
            { "KG", "Kirgisia" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kk", "kazakh" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "KM", "Komoroyggjar" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "St. Kitts & Nevis" },
            { "ko", metaValue_ko },
            { "KP", "Nor\u00f0urkorea" },
            { "KR", "Su\u00f0urkorea" },
            { "ks", "kashmiri" },
            { "ku", "kurdiskt" },
            { "KW", "Kuvait" },
            { "kw", "corniskt" },
            { "tpi", "tok pisin" },
            { "KY", "Caymanoyggjar" },
            { "ky", "kyrgyz" },
            { "KZ", "Kasakstan" },
            { "Cyrl", "kyrilliskt" },
            { "LA", "Laos" },
            { "la", "lat\u00edn" },
            { "LB", "Libanon" },
            { "lb", "luksemborgskt" },
            { "LC", "St. Lusia" },
            { "lg", "ganda" },
            { "nds", "l\u00e1gt t\u00fdskt" },
            { "LI", "Liktinstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "lo", "laoskt" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Litava" },
            { "lt", "litaviskt" },
            { "LU", "Luksemborg" },
            { "lu", "luba-katanga" },
            { "LV", "Lettland" },
            { "lv", "lettiskt" },
            { "Kana", "katakana" },
            { "LY", "Libya" },
            { "vun", "vunjo" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marokko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St-Martin" },
            { "MG", "Madagaskar" },
            { "mg", "malagassiskt" },
            { "Thai", metaValue_th },
            { "MH", "Marshalloyggjar" },
            { "mi", "maori" },
            { "MK", "Maked\u00f3nia" },
            { "mk", "maked\u00f3nskt" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "mn", "mongolskt" },
            { "MO", "Makao SAR Kina" },
            { "MP", "Nor\u00f0aru Mariuoyggjar" },
            { "MQ", "Martinique" },
            { "MR", "M\u00f3ritania" },
            { "mr", "marathi" },
            { "MS", "Montserrat" },
            { "ms", "malaiiskt" },
            { "MT", "Malta" },
            { "mt", "maltiskt" },
            { "MU", "M\u00f3ritius" },
            { "MV", "Maldivoyggjar" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "MY", "Malaisia" },
            { "my", "burmesiskt" },
            { "Armn", metaValue_hy },
            { "MZ", "Mosambik" },
            { "dsb", "l\u00e1gt sorbian" },
            { "NA", "Namibia" },
            { "nb", "norskt b\u00f3km\u00e1l" },
            { "NC", "N\u00fdkaled\u00f3nia" },
            { "%%WADEGILE", "Wade-Giles" },
            { "nd", "nor\u00f0ur ndebele" },
            { "NE", "Niger" },
            { "ne", "nepalskt" },
            { "NF", "Norfolksoyggj" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Ni\u00f0urlond" },
            { "nl", "h\u00e1lendskt" },
            { "nn", "n\u00fdnorskt" },
            { "NO", "Noreg" },
            { "no", "norskt" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "ny", "nyanja" },
            { "NZ", "N\u00fds\u00e6land" },
            { "kab", "kabyle" },
            { "%%POLYTON", "polyton\u00edsk" },
            { "oc", "occitan" },
            { "kam", "kamba" },
            { "mer", "meru" },
            { "OM", "Oman" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetiskt" },
            { "mfe", "morisyen" },
            { "PA", "Panama" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "PE", "Peru" },
            { "PF", "Franska Polynesia" },
            { "PG", "Papua N\u00fdguinea" },
            { "PH", "Filipsoyggjar" },
            { "PK", "Pakistan" },
            { "PL", "P\u00f3lland" },
            { "pl", "p\u00f3lskt" },
            { "PM", "Saint Pierre og Miquelon" },
            { "PN", "Pitcairnoyggjar" },
            { "PR", "Puerto Riko" },
            { "PS", "Palestinskt land\u00f8ki" },
            { "ps", "pashto" },
            { "PT", "Portugal" },
            { "pt", "portugiskiskt" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "pt_BR", "portugiskiskt (Brasilia)" },
            { "Hebr", metaValue_he },
            { "mgh", "makhuwa-meetto" },
            { "QA", "Katar" },
            { "Laoo", "lao" },
            { "mgo", "meta\u02bc" },
            { "QO", "fjarskoti Osiania" },
            { "qu", "quechua" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "001", "heimur" },
            { "Ethi", "etiopiskt" },
            { "002", "Afrika" },
            { "003", "Nor\u00f0uramerika" },
            { "RE", "R\u00e9union" },
            { "005", "Su\u00f0uramerika" },
            { "009", "Osiania" },
            { "rm", "retoromanskt" },
            { "rn", "rundi" },
            { "RO", "Rumenia" },
            { "ro", "rumenskt" },
            { "RS", "Serbia" },
            { "RU", "Russland" },
            { "ru", "russiskt" },
            { "bss", "bakossi" },
            { "RW", "Ruanda" },
            { "rw", "kinyarwanda" },
            { "kea", "gr\u00f8nh\u00f8vdaoyggjarskt" },
            { "SA", "Saudiarabia" },
            { "sa", "sanskrit" },
            { "SB", "Salomonoyggjar" },
            { "twq", "tasawaq" },
            { "011", "Vesturafrika" },
            { "SC", "Seyskelloyggjar" },
            { "SD", "Sudan" },
            { "sd", "sindhi" },
            { "013", "Mi\u00f0amerika" },
            { "SE", "Sv\u00f8r\u00edki" },
            { "se", "nor\u00f0ur s\u00e1miskt" },
            { "014", "Eysturafrika" },
            { "015", "Nor\u00f0urafrika" },
            { "SG", "Singapor" },
            { "sg", "sango" },
            { "SH", "St. Helena" },
            { "sh", "serbokroatiskt" },
            { "017", "Mi\u00f0afrika" },
            { "SI", "Slovenia" },
            { "si", "singalesiskt" },
            { "018", "sunnari partur av Afrika" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "sk", "slovakiskt" },
            { "SL", "Sierra Leona" },
            { "sl", "slovenskt" },
            { "SM", "San Marino" },
            { "sm", "samoiskt" },
            { "SN", "Senegal" },
            { "sn", "shona" },
            { "SO", "Somalia" },
            { "so", "somaliskt" },
            { "arn", "mapuche" },
            { "sq", "albanskt" },
            { "SR", "Surinam" },
            { "sr", "serbiskt" },
            { "SS", "Su\u00f0ursudan" },
            { "ss", "swatiskt" },
            { "ST", "Sao Tome & Prinsipi" },
            { "st", "sesotho" },
            { "su", "sundanesiskt" },
            { "SV", "El Salvador" },
            { "sv", "svenskt" },
            { "sw", "swahili" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00fdria" },
            { "SZ", "Svasiland" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "Amerika nor\u00f0anfyri Meksiko" },
            { "142", "Asia" },
            { "TC", "Turks- og Caicosoyggjar" },
            { "143", "Mi\u00f0asia" },
            { "TD", "Kjad" },
            { "te", metaValue_te },
            { "145", "Vesturasia" },
            { "TF", "Fronsku sunnaru landa\u00f8ki" },
            { "TG", "Togo" },
            { "tg", "tajik" },
            { "th", metaValue_th },
            { "TH", "Tailand" },
            { "ti", "tigrinya" },
            { "TJ", "Tadsjikistan" },
            { "029", "Karibia" },
            { "TK", "Tokelau" },
            { "tk", "turkmenskt" },
            { "TL", "Eysturtimor" },
            { "tl", "tagalog" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesia" },
            { "tn", "tswana" },
            { "TO", "Tonga" },
            { "to", "tonganskt" },
            { "dyo", "jola-fonyi" },
            { "TR", "Turkaland" },
            { "tr", "turkiskt" },
            { "ts", "tsonga" },
            { "swb", "shimaor\u00e9" },
            { "TT", "Trinidad & Tobago" },
            { "tt", "tatar" },
            { "TV", "Tuvalu" },
            { "TW", "Taivan" },
            { "tw", "twi" },
            { "ty", "tahitiskt" },
            { "TZ", "Tansania" },
            { "nmg", "kwasio" },
            { "Zzzz", "\u00f3kend skrift" },
            { "150", "Evropa" },
            { "UA", "Ukraina" },
            { "030", "Eysturasia" },
            { "151", "Eysturevropa" },
            { "154", "Nor\u00f0urevropa" },
            { "sw_CD", "kongo svahili" },
            { "034", "Su\u00f0urasia" },
            { "155", "Vesturevropa" },
            { "035", "\u00datsynningsasia" },
            { "UG", "Uganda" },
            { "ug", "uyghur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "vanlig" },
            { "039", "Su\u00f0urevropa" },
            { "uk", "ukrainskt" },
            { "Sinh", "sinhala" },
            { "UM", "Sambandsr\u00edki Amerikas fjarskotnu oyggjar" },
            { "ur", "urdu" },
            { "US", "Sambandsr\u00edki Amerika" },
            { "haw", "hawaiianskt" },
            { "UY", "Uruguai" },
            { "UZ", "Usbekistan" },
            { "uz", "usbekiskt" },
            { "tzm", "mi\u00f0atlasfj\u00f8ll tamazight" },
            { "VA", "Vatikanb\u00fdur" },
            { "nds_NL", "l\u00e1gt saksiskt" },
            { "VC", "St. Vinsent & Grenadinoyggjar" },
            { "VE", "Venesuela" },
            { "ve", "venda" },
            { "VG", "St\u00f3ra Bretlands Jomfr\u00faoyggjar" },
            { "VI", "Sambandsr\u00edki Amerikas Jomfr\u00faoyggjar" },
            { "vi", "vjetnamesiskt" },
            { "khq", "koyra chiini" },
            { "VN", "Vjetnam" },
            { "quc", "k\u02bciche\u02bc" },
            { "VU", "Vanuatu" },
            { "rwk", "rwa" },
            { "gag", "gagauz" },
            { "053", "Avstralasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis- og Futunaoyggjar" },
            { "Grek", metaValue_el },
            { "057", "Mikronesi \u00f8ki" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wo", "wolof" },
            { "zgh", "vanligt marokanskt tamazight" },
            { "WS", "Samoa" },
            { "Mong", "mongolsk" },
            { "061", "Polynesia" },
            { "Latn", "lat\u00ednskt" },
            { "xh", "xhosa" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u00f3skriva" },
            { "wbp", "warlpiri" },
            { "moh", "mohawk" },
            { "YE", "Jemen" },
            { "nqo", "n\u02bcko" },
            { "yi", "jiddiskt" },
            { "yo", "yoruba" },
            { "YT", "Mayotte" },
            { "vai", "vai" },
            { "ZA", "Su\u00f0urafrika" },
            { "kln", "kalenjin" },
            { "Deva", "devanagari" },
            { "zh", "kinesiskt" },
            { "Hira", "hiragana" },
            { "ZM", "Sambia" },
            { "Bopo", "bopomofo" },
            { "%%PINYIN", "pinyin" },
            { "zu", "sulu" },
            { "ZW", "Simbabvi" },
            { "%%MONOTON", "monoton\u00edsk" },
            { "ZZ", "\u00f3kent \u00f8ki" },
            { "Geor", "georgianskt" },
            { "ebu", "embu" },
            { "jmc", "machame" },
            { "zh_Hans", "einkult kinesiskt" },
            { "koi", "komi-permyak" },
            { "kok", "konkani" },
            { "nus", "nuer" },
            { "dav", "taita" },
            { "lrc", "nor\u00f0ur luri" },
            { "zh_Hant", "vanligt kinesiskt" },
            { "mua", "mundang" },
            { "Khmr", metaValue_km },
            { "saq", "samburu" },
            { "efi", "efik" },
            { "Guru", "gurmukhi" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
