/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.util;

import com.sun.jndi.dns.DnsClient;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.ResourceRecord;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import sun.net.dns.ResolverConfiguration;

public class DnsDetect {
    private static final int TIMEOUT = 1000;
    private static final int RETRIES = 4;
    private static final int CLASS_INTERNET = 1;
    private static final int TYPE_CNAME = 5;
    private static final int TYPE_TXT = 16;
    private Method queryMethod;
    private DnsClient dns;
    private String postfix;
    private List<String> searchlist;

    public DnsDetect(String stackUuid) throws IOException {
        this.postfix = stackUuid == null ? "" : "_" + stackUuid;
        ResolverConfiguration rc = ResolverConfiguration.open();
        List<String> dnsList = rc.nameservers();
        try {
            this.dns = new DnsClient(dnsList.toArray(new String[0]), 1000, 4);
            this.queryMethod = DnsClient.class.getDeclaredMethod("query", DnsName.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            this.queryMethod.setAccessible(true);
        }
        catch (NoSuchMethodException | NamingException ex) {
            throw new IOException(ex);
        }
        this.searchlist = rc.searchlist();
        this.searchlist.add(0, "");
    }

    private String query(String name, int type) throws IOException {
        for (String domain : this.searchlist) {
            try {
                Object rrsObject = this.queryMethod.invoke((Object)this.dns, new DnsName(domain == "" ? name : name + '.' + domain), 1, type, true, false);
                Class<?> rrsClass = Class.forName("com.sun.jndi.dns.ResourceRecords");
                Field rrsVector = rrsClass.getDeclaredField("answer");
                rrsVector.setAccessible(true);
                Vector rrs = (Vector)rrsVector.get(rrsObject);
                if (rrs.size() <= 0) continue;
                return ((ResourceRecord)rrs.get(0)).getRdata().toString();
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | InvalidNameException ex) {
                throw new IOException(name, ex);
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof NameNotFoundException) continue;
                throw new IOException(ex);
            }
        }
        return null;
    }

    public String queryEndpoint() throws IOException {
        String result = this.query("crs-endpoint" + this.postfix, 5);
        return result == null ? null : (result.endsWith(".") ? result.substring(0, result.length() - 1) : result);
    }

    public String queryMailbox() throws IOException {
        return this.query("crs-mailbox" + this.postfix, 16);
    }

    public String getRecordNamePostfix() {
        return this.postfix;
    }
}

