/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.legacy8ujsse.sun.security.ssl.krb5;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.SSLKeyException;
import org.openjsse.legacy8ujsse.sun.security.ssl.Debug;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeInStream;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeMessage;
import org.openjsse.legacy8ujsse.sun.security.ssl.ProtocolVersion;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;

final class KerberosPreMasterSecret {
    private ProtocolVersion protocolVersion;
    private byte[] preMaster;
    private byte[] encrypted;

    KerberosPreMasterSecret(ProtocolVersion protocolVersion, SecureRandom generator, EncryptionKey sessionKey) throws IOException {
        if (sessionKey.getEType() == 16) {
            throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
        }
        this.protocolVersion = protocolVersion;
        this.preMaster = KerberosPreMasterSecret.generatePreMaster(generator, protocolVersion);
        try {
            EncryptedData eData = new EncryptedData(sessionKey, this.preMaster, 0);
            this.encrypted = eData.getBytes();
        }
        catch (KrbException e) {
            throw (SSLKeyException)new SSLKeyException("Kerberos premaster secret error").initCause(e);
        }
    }

    KerberosPreMasterSecret(ProtocolVersion currentVersion, ProtocolVersion clientVersion, SecureRandom generator, HandshakeInStream input, EncryptionKey sessionKey) throws IOException {
        boolean versionMismatch;
        this.encrypted = input.getBytes16();
        if (HandshakeMessage.debug != null && Debug.isOn("handshake") && this.encrypted != null) {
            Debug.println(System.out, "encrypted premaster secret", this.encrypted);
        }
        if (sessionKey.getEType() == 16) {
            throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
        }
        try {
            EncryptedData data = new EncryptedData(sessionKey.getEType(), null, this.encrypted);
            byte[] temp = data.decrypt(sessionKey, 0);
            if (HandshakeMessage.debug != null && Debug.isOn("handshake") && this.encrypted != null) {
                Debug.println(System.out, "decrypted premaster secret", temp);
            }
            if (temp.length == 52 && data.getEType() == 1) {
                if (KerberosPreMasterSecret.paddingByteIs(temp, 52, (byte)4) || KerberosPreMasterSecret.paddingByteIs(temp, 52, (byte)0)) {
                    temp = Arrays.copyOf(temp, 48);
                }
            } else if (temp.length == 56 && data.getEType() == 3 && KerberosPreMasterSecret.paddingByteIs(temp, 56, (byte)8)) {
                temp = Arrays.copyOf(temp, 48);
            }
            this.preMaster = temp;
            this.protocolVersion = ProtocolVersion.valueOf(this.preMaster[0], this.preMaster[1]);
            if (HandshakeMessage.debug != null && Debug.isOn("handshake")) {
                System.out.println("Kerberos PreMasterSecret version: " + this.protocolVersion);
            }
        }
        catch (Exception e) {
            this.preMaster = null;
            this.protocolVersion = currentVersion;
        }
        boolean bl = versionMismatch = this.protocolVersion.v != clientVersion.v;
        if (versionMismatch && clientVersion.v <= 769) {
            boolean bl2 = versionMismatch = this.protocolVersion.v != currentVersion.v;
        }
        if (this.preMaster == null || this.preMaster.length != 48 || versionMismatch) {
            if (HandshakeMessage.debug != null && Debug.isOn("handshake")) {
                System.out.println("Kerberos PreMasterSecret error, generating random secret");
                if (this.preMaster != null) {
                    Debug.println(System.out, "Invalid secret", this.preMaster);
                }
            }
            this.preMaster = KerberosPreMasterSecret.generatePreMaster(generator, clientVersion);
            this.protocolVersion = clientVersion;
        }
    }

    private static boolean paddingByteIs(byte[] data, int len, byte b) {
        for (int i = 48; i < len; ++i) {
            if (data[i] == b) continue;
            return false;
        }
        return true;
    }

    KerberosPreMasterSecret(ProtocolVersion protocolVersion, SecureRandom generator) {
        this.protocolVersion = protocolVersion;
        this.preMaster = KerberosPreMasterSecret.generatePreMaster(generator, protocolVersion);
    }

    private static byte[] generatePreMaster(SecureRandom rand, ProtocolVersion ver) {
        byte[] pm = new byte[48];
        rand.nextBytes(pm);
        pm[0] = ver.major;
        pm[1] = ver.minor;
        return pm;
    }

    byte[] getUnencrypted() {
        return this.preMaster;
    }

    byte[] getEncrypted() {
        return this.encrypted;
    }
}

