/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.legacy8ujsse.sun.security.ssl.krb5;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import org.openjsse.legacy8ujsse.sun.security.ssl.Debug;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeInStream;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeMessage;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeOutStream;
import org.openjsse.legacy8ujsse.sun.security.ssl.KerberosClientKeyExchange;
import org.openjsse.legacy8ujsse.sun.security.ssl.Krb5Helper;
import org.openjsse.legacy8ujsse.sun.security.ssl.ProtocolVersion;
import org.openjsse.legacy8ujsse.sun.security.ssl.krb5.KerberosPreMasterSecret;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.ServiceCreds;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.EncTicketPart;
import sun.security.krb5.internal.Ticket;

public final class KerberosClientKeyExchangeImpl
extends KerberosClientKeyExchange {
    private KerberosPreMasterSecret preMaster;
    private byte[] encodedTicket;
    private KerberosPrincipal peerPrincipal;
    private KerberosPrincipal localPrincipal;

    @Override
    public void init(String serverName, AccessControlContext acc, ProtocolVersion protocolVersion, SecureRandom rand) throws IOException {
        KerberosTicket ticket = KerberosClientKeyExchangeImpl.getServiceTicket(serverName, acc);
        this.encodedTicket = ticket.getEncoded();
        this.peerPrincipal = ticket.getServer();
        this.localPrincipal = ticket.getClient();
        EncryptionKey sessionKey = new EncryptionKey(ticket.getSessionKeyType(), ticket.getSessionKey().getEncoded());
        this.preMaster = new KerberosPreMasterSecret(protocolVersion, rand, sessionKey);
    }

    @Override
    public void init(ProtocolVersion protocolVersion, ProtocolVersion clientVersion, SecureRandom rand, HandshakeInStream input, AccessControlContext acc, Object serviceCreds) throws IOException {
        this.encodedTicket = input.getBytes16();
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(System.out, "encoded Kerberos service ticket", this.encodedTicket);
        }
        EncryptionKey sessionKey = null;
        try {
            KerberosKey[] serverKeys;
            Ticket t = new Ticket(this.encodedTicket);
            EncryptedData encPart = t.encPart;
            PrincipalName ticketSname = t.sname;
            final ServiceCreds creds = (ServiceCreds)serviceCreds;
            final KerberosPrincipal princ = new KerberosPrincipal(ticketSname.toString());
            if (creds.getName() == null) {
                SecurityManager sm = System.getSecurityManager();
                try {
                    if (sm != null) {
                        sm.checkPermission(Krb5Helper.getServicePermission(ticketSname.toString(), "accept"), acc);
                    }
                }
                catch (SecurityException se) {
                    serviceCreds = null;
                    if (debug != null && Debug.isOn("handshake")) {
                        System.out.println("Permission to access Kerberos secret key denied");
                    }
                    throw new IOException("Kerberos service not allowedy");
                }
            }
            if ((serverKeys = AccessController.doPrivileged(new PrivilegedAction<KerberosKey[]>(){

                @Override
                public KerberosKey[] run() {
                    return creds.getKKeys(princ);
                }
            })).length == 0) {
                throw new IOException("Found no key for " + princ + (creds.getName() == null ? "" : ", this keytab is for " + creds.getName() + " only"));
            }
            int encPartKeyType = encPart.getEType();
            Integer encPartKeyVersion = encPart.getKeyVersionNumber();
            KerberosKey dkey = null;
            try {
                dkey = KerberosClientKeyExchangeImpl.findKey(encPartKeyType, encPartKeyVersion, serverKeys);
            }
            catch (KrbException ke) {
                throw new IOException("Cannot find key matching version number", ke);
            }
            if (dkey == null) {
                throw new IOException("Cannot find key of appropriate type to decrypt ticket - need etype " + encPartKeyType);
            }
            EncryptionKey secretKey = new EncryptionKey(encPartKeyType, dkey.getEncoded());
            byte[] bytes = encPart.decrypt(secretKey, 2);
            byte[] temp = encPart.reset(bytes);
            EncTicketPart encTicketPart = new EncTicketPart(temp);
            this.peerPrincipal = new KerberosPrincipal(encTicketPart.cname.getName());
            this.localPrincipal = new KerberosPrincipal(ticketSname.getName());
            sessionKey = encTicketPart.key;
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("server principal: " + ticketSname);
                System.out.println("cname: " + encTicketPart.cname.toString());
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("KerberosWrapper error getting session key, generating random secret (" + e.getMessage() + ")");
            }
            sessionKey = null;
        }
        input.getBytes16();
        this.preMaster = sessionKey != null ? new KerberosPreMasterSecret(protocolVersion, clientVersion, rand, input, sessionKey) : new KerberosPreMasterSecret(clientVersion, rand);
    }

    @Override
    public int messageLength() {
        return 6 + this.encodedTicket.length + this.preMaster.getEncrypted().length;
    }

    @Override
    public void send(HandshakeOutStream s) throws IOException {
        s.putBytes16(this.encodedTicket);
        s.putBytes16(null);
        s.putBytes16(this.preMaster.getEncrypted());
    }

    @Override
    public void print(PrintStream s) throws IOException {
        s.println("*** ClientKeyExchange, Kerberos");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(s, "Kerberos service ticket", this.encodedTicket);
            Debug.println(s, "Random Secret", this.preMaster.getUnencrypted());
            Debug.println(s, "Encrypted random Secret", this.preMaster.getEncrypted());
        }
    }

    private static KerberosTicket getServiceTicket(String serverName, final AccessControlContext acc) throws IOException {
        PrincipalName principal;
        if ("localhost".equals(serverName) || "localhost.localdomain".equals(serverName)) {
            String localHost;
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Get the local hostname");
            }
            if ((localHost = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        return InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        if (HandshakeMessage.debug != null && Debug.isOn("handshake")) {
                            System.out.println("Warning, cannot get the local hostname: " + e.getMessage());
                        }
                        return null;
                    }
                }
            })) != null) {
                serverName = localHost;
            }
        }
        String serviceName = "host/" + serverName;
        try {
            principal = new PrincipalName(serviceName, 3);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Invalid service principal name: " + serviceName);
            ioe.initCause(e);
            throw ioe;
        }
        String realm = principal.getRealmAsString();
        final String serverPrincipal = principal.toString();
        final String tgsPrincipal = "krbtgt/" + realm + "@" + realm;
        final String clientPrincipal = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServicePermission(serverPrincipal, "initiate"), acc);
        }
        try {
            KerberosTicket ticket = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                @Override
                public KerberosTicket run() throws Exception {
                    return Krb5Util.getTicketFromSubjectAndTgs((GSSCaller)GSSCaller.CALLER_SSL_CLIENT, (String)clientPrincipal, (String)serverPrincipal, (String)tgsPrincipal, (AccessControlContext)acc);
                }
            });
            if (ticket == null) {
                throw new IOException("Failed to find any kerberos service ticket for " + serverPrincipal);
            }
            return ticket;
        }
        catch (PrivilegedActionException e) {
            IOException ioe = new IOException("Attempt to obtain kerberos service ticket for " + serverPrincipal + " failed!");
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public byte[] getUnencryptedPreMasterSecret() {
        return this.preMaster.getUnencrypted();
    }

    @Override
    public KerberosPrincipal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    @Override
    public KerberosPrincipal getLocalPrincipal() {
        return this.localPrincipal;
    }

    private static boolean versionMatches(Integer v1, int v2) {
        if (v1 == null || v1 == 0 || v2 == 0) {
            return true;
        }
        return v1.equals(v2);
    }

    private static KerberosKey findKey(int etype, Integer version, KerberosKey[] keys) throws KrbException {
        int kv;
        int ktype;
        int i;
        boolean etypeFound = false;
        int kvno_found = 0;
        KerberosKey key_found = null;
        for (i = 0; i < keys.length; ++i) {
            ktype = keys[i].getKeyType();
            if (etype != ktype) continue;
            kv = keys[i].getVersionNumber();
            etypeFound = true;
            if (KerberosClientKeyExchangeImpl.versionMatches(version, kv)) {
                return keys[i];
            }
            if (kv <= kvno_found) continue;
            key_found = keys[i];
            kvno_found = kv;
        }
        if (etype == 1 || etype == 3) {
            for (i = 0; i < keys.length; ++i) {
                ktype = keys[i].getKeyType();
                if (ktype != 1 && ktype != 3) continue;
                kv = keys[i].getVersionNumber();
                etypeFound = true;
                if (KerberosClientKeyExchangeImpl.versionMatches(version, kv)) {
                    return new KerberosKey(keys[i].getPrincipal(), keys[i].getEncoded(), etype, kv);
                }
                if (kv <= kvno_found) continue;
                key_found = new KerberosKey(keys[i].getPrincipal(), keys[i].getEncoded(), etype, kv);
                kvno_found = kv;
            }
        }
        if (etypeFound) {
            return key_found;
        }
        return null;
    }
}

