/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.legacy8ujsse.sun.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.SSLProtocolException;
import org.openjsse.legacy8ujsse.sun.security.ssl.ExtensionType;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeInStream;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeOutStream;
import org.openjsse.legacy8ujsse.sun.security.ssl.HelloExtension;

final class EllipticPointFormatsExtension
extends HelloExtension {
    static final int FMT_UNCOMPRESSED = 0;
    static final int FMT_ANSIX962_COMPRESSED_PRIME = 1;
    static final int FMT_ANSIX962_COMPRESSED_CHAR2 = 2;
    static final HelloExtension DEFAULT = new EllipticPointFormatsExtension(new byte[]{0});
    private final byte[] formats;

    private EllipticPointFormatsExtension(byte[] formats) {
        super(ExtensionType.EXT_EC_POINT_FORMATS);
        this.formats = formats;
    }

    EllipticPointFormatsExtension(HandshakeInStream s, int len) throws IOException {
        super(ExtensionType.EXT_EC_POINT_FORMATS);
        this.formats = s.getBytes8();
        boolean uncompressed = false;
        for (byte format : this.formats) {
            if (format != 0) continue;
            uncompressed = true;
            break;
        }
        if (!uncompressed) {
            throw new SSLProtocolException("Peer does not support uncompressed points");
        }
    }

    @Override
    int length() {
        return 5 + this.formats.length;
    }

    @Override
    void send(HandshakeOutStream s) throws IOException {
        s.putInt16(this.type.id);
        s.putInt16(this.formats.length + 1);
        s.putBytes8(this.formats);
    }

    private static String toString(byte format) {
        int f = format & 0xFF;
        switch (f) {
            case 0: {
                return "uncompressed";
            }
            case 1: {
                return "ansiX962_compressed_prime";
            }
            case 2: {
                return "ansiX962_compressed_char2";
            }
        }
        return "unknown-" + f;
    }

    @Override
    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        for (byte format : this.formats) {
            list.add(EllipticPointFormatsExtension.toString(format));
        }
        return "Extension " + this.type + ", formats: " + list;
    }
}

