/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.openjsse.sun.security.ssl.Alert;
import org.openjsse.sun.security.ssl.ClientHandshakeContext;
import org.openjsse.sun.security.ssl.ConnectionContext;
import org.openjsse.sun.security.ssl.DHKeyExchange;
import org.openjsse.sun.security.ssl.HandshakeContext;
import org.openjsse.sun.security.ssl.HandshakeOutStream;
import org.openjsse.sun.security.ssl.HandshakeProducer;
import org.openjsse.sun.security.ssl.JsseJce;
import org.openjsse.sun.security.ssl.RSASignature;
import org.openjsse.sun.security.ssl.Record;
import org.openjsse.sun.security.ssl.SSLConsumer;
import org.openjsse.sun.security.ssl.SSLCredentials;
import org.openjsse.sun.security.ssl.SSLHandshake;
import org.openjsse.sun.security.ssl.SSLLogger;
import org.openjsse.sun.security.ssl.SSLPossession;
import org.openjsse.sun.security.ssl.ServerHandshakeContext;
import org.openjsse.sun.security.ssl.SignatureScheme;
import org.openjsse.sun.security.ssl.SupportedGroupsExtension;
import org.openjsse.sun.security.ssl.Utilities;
import org.openjsse.sun.security.ssl.X509Authentication;
import org.openjsse.sun.security.util.HexDumpEncoder;
import sun.security.util.KeyUtil;

final class DHServerKeyExchange {
    static final SSLConsumer dhHandshakeConsumer = new DHServerKeyExchangeConsumer();
    static final HandshakeProducer dhHandshakeProducer = new DHServerKeyExchangeProducer();

    DHServerKeyExchange() {
    }

    static final class DHServerKeyExchangeConsumer
    implements SSLConsumer {
        private DHServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            DHPublicKey publicKey;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            DHServerKeyExchangeMessage skem = new DHServerKeyExchangeMessage(chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming DH ServerKeyExchange handshake message", skem);
            }
            try {
                KeyFactory kf = JsseJce.getKeyFactory("DiffieHellman");
                DHPublicKeySpec spec = new DHPublicKeySpec(new BigInteger(1, skem.y), new BigInteger(1, skem.p), new BigInteger(1, skem.g));
                publicKey = (DHPublicKey)kf.generatePublic(spec);
            }
            catch (GeneralSecurityException gse) {
                throw chc.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "Could not generate DHPublicKey", gse);
            }
            if (!chc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), publicKey)) {
                throw chc.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "DH ServerKeyExchange does not comply to algorithm constraints");
            }
            SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(publicKey.getParams());
            chc.handshakeCredentials.add(new DHKeyExchange.DHECredentials(publicKey, namedGroup));
        }
    }

    static final class DHServerKeyExchangeProducer
    implements HandshakeProducer {
        private DHServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            DHServerKeyExchangeMessage skem = new DHServerKeyExchangeMessage(shc);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced DH ServerKeyExchange handshake message", skem);
            }
            skem.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class DHServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] p;
        private final byte[] g;
        private final byte[] y;
        private final boolean useExplicitSigAlgorithm;
        private final SignatureScheme signatureScheme;
        private final byte[] paramsSignature;

        DHServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            DHKeyExchange.DHEPossession dhePossession = null;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (possession instanceof DHKeyExchange.DHEPossession) {
                    dhePossession = (DHKeyExchange.DHEPossession)possession;
                    if (x509Possession == null) continue;
                    break;
                }
                if (!(possession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)possession;
                if (dhePossession == null) continue;
                break;
            }
            if (dhePossession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No DHE credentials negotiated for server key exchange");
            }
            DHPublicKey publicKey = dhePossession.publicKey;
            DHParameterSpec params = publicKey.getParams();
            this.p = Utilities.toByteArray(params.getP());
            this.g = Utilities.toByteArray(params.getG());
            this.y = Utilities.toByteArray(publicKey.getY());
            if (x509Possession == null) {
                this.paramsSignature = null;
                this.signatureScheme = null;
                this.useExplicitSigAlgorithm = false;
            } else {
                this.useExplicitSigAlgorithm = shc.negotiatedProtocol.useTLS12PlusSpec();
                Signature signer = null;
                if (this.useExplicitSigAlgorithm) {
                    Map.Entry<SignatureScheme, Signature> schemeAndSigner = SignatureScheme.getSignerOfPreferableAlgorithm(shc.peerRequestedSignatureSchemes, x509Possession, shc.negotiatedProtocol);
                    if (schemeAndSigner == null) {
                        throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No supported signature algorithm for " + x509Possession.popPrivateKey.getAlgorithm() + "  key");
                    }
                    this.signatureScheme = schemeAndSigner.getKey();
                    signer = schemeAndSigner.getValue();
                } else {
                    this.signatureScheme = null;
                    try {
                        signer = DHServerKeyExchangeMessage.getSignature(x509Possession.popPrivateKey.getAlgorithm(), x509Possession.popPrivateKey);
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException e) {
                        throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + x509Possession.popPrivateKey.getAlgorithm(), e);
                    }
                }
                byte[] signature = null;
                try {
                    this.updateSignature(signer, shc.clientHelloRandom.randomBytes, shc.serverHelloRandom.randomBytes);
                    signature = signer.sign();
                }
                catch (SignatureException ex) {
                    throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign dhe parameters: " + x509Possession.popPrivateKey.getAlgorithm(), ex);
                }
                this.paramsSignature = signature;
            }
        }

        DHServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            Signature signer;
            ClientHandshakeContext chc = (ClientHandshakeContext)handshakeContext;
            this.p = Record.getBytes16(m);
            this.g = Record.getBytes16(m);
            this.y = Record.getBytes16(m);
            try {
                KeyUtil.validate(new DHPublicKeySpec(new BigInteger(1, this.y), new BigInteger(1, this.p), new BigInteger(1, this.p)));
            }
            catch (InvalidKeyException ike) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: invalid parameters", ike);
            }
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)cd;
                break;
            }
            if (x509Credentials == null) {
                if (m.hasRemaining()) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: unknown extra data");
                }
                this.signatureScheme = null;
                this.paramsSignature = null;
                this.useExplicitSigAlgorithm = false;
                return;
            }
            this.useExplicitSigAlgorithm = chc.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                int ssid = Record.getInt16(m);
                this.signatureScheme = SignatureScheme.valueOf(ssid);
                if (this.signatureScheme == null) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + ssid + ") used in DH ServerKeyExchange handshake message");
                }
                if (!chc.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in DH ServerKeyExchange handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            this.paramsSignature = Record.getBytes16(m);
            if (this.useExplicitSigAlgorithm) {
                try {
                    signer = this.signatureScheme.getVerifier(x509Credentials.popPublicKey);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException nsae) {
                    throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + this.signatureScheme.name, nsae);
                }
            }
            try {
                signer = DHServerKeyExchangeMessage.getSignature(x509Credentials.popPublicKey.getAlgorithm(), x509Credentials.popPublicKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + x509Credentials.popPublicKey.getAlgorithm(), e);
            }
            try {
                this.updateSignature(signer, chc.clientHelloRandom.randomBytes, chc.serverHelloRandom.randomBytes);
                if (!signer.verify(this.paramsSignature)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature on DH ServerKeyExchange message");
                }
            }
            catch (SignatureException ex) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify DH ServerKeyExchange signature", ex);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int sigLen = 0;
            if (this.paramsSignature != null) {
                sigLen = 2 + this.paramsSignature.length;
                if (this.useExplicitSigAlgorithm) {
                    sigLen += SignatureScheme.sizeInRecord();
                }
            }
            return 6 + this.p.length + this.g.length + this.y.length + sigLen;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putBytes16(this.p);
            hos.putBytes16(this.g);
            hos.putBytes16(this.y);
            if (this.paramsSignature != null) {
                if (this.useExplicitSigAlgorithm) {
                    hos.putInt16(this.signatureScheme.id);
                }
                hos.putBytes16(this.paramsSignature);
            }
        }

        public String toString() {
            if (this.paramsSignature == null) {
                MessageFormat messageFormat = new MessageFormat("\"DH ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"dh_p\": '{'\n{0}\n    '}',\n    \"dh_g\": '{'\n{1}\n    '}',\n    \"dh_Ys\": '{'\n{2}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.p), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.g), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.y), "      ")};
                return messageFormat.format(messageFields);
            }
            if (this.useExplicitSigAlgorithm) {
                MessageFormat messageFormat = new MessageFormat("\"DH ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"dh_p\": '{'\n{0}\n    '}',\n    \"dh_g\": '{'\n{1}\n    '}',\n    \"dh_Ys\": '{'\n{2}\n    '}',\n  '}',\n  \"digital signature\":  '{'\n    \"signature algorithm\": \"{3}\"\n    \"signature\": '{'\n{4}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.p), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.g), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.y), "      "), this.signatureScheme.name, Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "      ")};
                return messageFormat.format(messageFields);
            }
            MessageFormat messageFormat = new MessageFormat("\"DH ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"dh_p\": '{'\n{0}\n    '}',\n    \"dh_g\": '{'\n{1}\n    '}',\n    \"dh_Ys\": '{'\n{2}\n    '}',\n  '}',\n  \"signature\": '{'\n{3}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.p), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.g), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.y), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "    ")};
            return messageFormat.format(messageFields);
        }

        private static Signature getSignature(String keyAlgorithm, Key key) throws NoSuchAlgorithmException, InvalidKeyException {
            Signature signer = null;
            switch (keyAlgorithm) {
                case "DSA": {
                    signer = JsseJce.getSignature("DSA");
                    break;
                }
                case "RSA": {
                    signer = RSASignature.getInstance();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("neither an RSA or a DSA key : " + keyAlgorithm);
                }
            }
            if (signer != null) {
                if (key instanceof PublicKey) {
                    signer.initVerify((PublicKey)key);
                } else {
                    signer.initSign((PrivateKey)key);
                }
            }
            return signer;
        }

        private void updateSignature(Signature sig, byte[] clntNonce, byte[] svrNonce) throws SignatureException {
            sig.update(clntNonce);
            sig.update(svrNonce);
            sig.update((byte)(this.p.length >> 8));
            sig.update((byte)(this.p.length & 0xFF));
            sig.update(this.p);
            sig.update((byte)(this.g.length >> 8));
            sig.update((byte)(this.g.length & 0xFF));
            sig.update(this.g);
            sig.update((byte)(this.y.length >> 8));
            sig.update((byte)(this.y.length & 0xFF));
            sig.update(this.y);
        }
    }
}

