/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.security.ProviderException;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import sun.security.ec.ECOperations;
import sun.security.ec.point.AffinePoint;
import sun.security.ec.point.MutablePoint;
import sun.security.util.ArrayUtil;
import sun.security.util.Function;
import sun.security.util.Optional;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.MutableIntegerModuloP;

public class ECDSAOperations {
    private final ECOperations ecOps;
    private final AffinePoint basePoint;

    public ECDSAOperations(ECOperations eCOperations, ECPoint eCPoint) {
        this.ecOps = eCOperations;
        this.basePoint = ECDSAOperations.toAffinePoint(eCPoint, eCOperations.getField());
    }

    public ECOperations getEcOperations() {
        return this.ecOps;
    }

    public AffinePoint basePointMultiply(byte[] byArray) {
        return this.ecOps.multiply(this.basePoint, byArray).asAffine();
    }

    public static AffinePoint toAffinePoint(ECPoint eCPoint, IntegerFieldModuloP integerFieldModuloP) {
        ImmutableIntegerModuloP immutableIntegerModuloP = integerFieldModuloP.getElement(eCPoint.getAffineX());
        ImmutableIntegerModuloP immutableIntegerModuloP2 = integerFieldModuloP.getElement(eCPoint.getAffineY());
        return new AffinePoint(immutableIntegerModuloP, immutableIntegerModuloP2);
    }

    public static Optional<ECDSAOperations> forParameters(final ECParameterSpec eCParameterSpec) {
        Optional<ECOperations> optional = ECOperations.forParameters(eCParameterSpec);
        return optional.map((Function)new Function<ECOperations, ECDSAOperations>(){

            public ECDSAOperations apply(ECOperations eCOperations) {
                return new ECDSAOperations(eCOperations, eCParameterSpec.getGenerator());
            }
        });
    }

    public byte[] signDigest(byte[] byArray, byte[] byArray2, Seed seed) throws ECOperations.IntermediateValueException {
        byte[] byArray3 = this.ecOps.seedToScalar(seed.getSeedValue());
        Nonce nonce = new Nonce(byArray3);
        return this.signDigest(byArray, byArray2, nonce);
    }

    public byte[] signDigest(byte[] byArray, byte[] byArray2, Nonce nonce) throws ECOperations.IntermediateValueException {
        int n;
        IntegerFieldModuloP integerFieldModuloP = this.ecOps.getOrderField();
        int n2 = integerFieldModuloP.getSize().bitLength();
        if (n2 % 8 != 0 && n2 < byArray2.length * 8) {
            throw new ProviderException("Invalid digest length");
        }
        byte[] byArray3 = nonce.getNonceValue();
        if (byArray3.length != (n = (integerFieldModuloP.getSize().bitLength() + 7) / 8)) {
            throw new ProviderException("Incorrect nonce length");
        }
        MutablePoint mutablePoint = this.ecOps.multiply(this.basePoint, byArray3);
        ImmutableIntegerModuloP immutableIntegerModuloP = mutablePoint.asAffine().getX();
        byte[] byArray4 = new byte[n];
        immutableIntegerModuloP.asByteArray(byArray4);
        immutableIntegerModuloP = integerFieldModuloP.getElement(byArray4);
        immutableIntegerModuloP.asByteArray(byArray4);
        byte[] byArray5 = new byte[2 * n];
        ArrayUtil.reverse(byArray4);
        System.arraycopy(byArray4, 0, byArray5, 0, n);
        if (ECOperations.allZero(byArray4)) {
            throw new ECOperations.IntermediateValueException();
        }
        ImmutableIntegerModuloP immutableIntegerModuloP2 = integerFieldModuloP.getElement(byArray);
        int n3 = Math.min(n, byArray2.length);
        byte[] byArray6 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray6, 0, n3);
        ArrayUtil.reverse(byArray6);
        ImmutableIntegerModuloP immutableIntegerModuloP3 = integerFieldModuloP.getElement(byArray6);
        ImmutableIntegerModuloP immutableIntegerModuloP4 = integerFieldModuloP.getElement(byArray3);
        ImmutableIntegerModuloP immutableIntegerModuloP5 = immutableIntegerModuloP4.multiplicativeInverse();
        MutableIntegerModuloP mutableIntegerModuloP = immutableIntegerModuloP.mutable();
        mutableIntegerModuloP.setProduct(immutableIntegerModuloP2).setSum(immutableIntegerModuloP3).setProduct(immutableIntegerModuloP5);
        mutableIntegerModuloP.asByteArray(byArray4);
        ArrayUtil.reverse(byArray4);
        System.arraycopy(byArray4, 0, byArray5, n, n);
        if (ECOperations.allZero(byArray4)) {
            throw new ECOperations.IntermediateValueException();
        }
        return byArray5;
    }

    public static class Nonce {
        private final byte[] nonceValue;

        public Nonce(byte[] byArray) {
            this.nonceValue = byArray;
        }

        public byte[] getNonceValue() {
            return this.nonceValue;
        }
    }

    public static class Seed {
        private final byte[] seedValue;

        public Seed(byte[] byArray) {
            this.seedValue = byArray;
        }

        public byte[] getSeedValue() {
            return this.seedValue;
        }
    }
}

