/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

public final class Parsing {
    public static int parseUnsignedInt(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        int n2 = string.length();
        if (n2 > 0) {
            char c = string.charAt(0);
            if (c == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", string));
            }
            if (n2 <= 5 || n == 10 && n2 <= 9) {
                return Integer.parseInt(string, n);
            }
            long l = Long.parseLong(string, n);
            if ((l & 0xFFFFFFFF00000000L) == 0L) {
                return (int)l;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", string));
        }
        throw new NumberFormatException("For input string: \"" + string + "\"");
    }

    public static int parseUnsignedInt(String string) throws NumberFormatException {
        return Parsing.parseUnsignedInt(string, 10);
    }
}

