/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import sun.security.jca.JCAUtil;
import sun.security.util.Length;

public final class KeyUtil {
    public static final int getKeySize(Key key) {
        Object object;
        int n = -1;
        if (key instanceof Length) {
            try {
                object = (Length)((Object)key);
                n = object.length();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (n >= 0) {
                return n;
            }
        }
        if (key instanceof SecretKey) {
            object = (SecretKey)key;
            String string = object.getFormat();
            if ("RAW".equals(string) && object.getEncoded() != null) {
                n = object.getEncoded().length * 8;
            }
        } else if (key instanceof RSAKey) {
            object = (RSAKey)((Object)key);
            n = object.getModulus().bitLength();
        } else if (key instanceof ECKey) {
            object = (ECKey)((Object)key);
            n = object.getParams().getOrder().bitLength();
        } else if (key instanceof DSAKey) {
            object = (DSAKey)((Object)key);
            DSAParams dSAParams = object.getParams();
            n = dSAParams != null ? dSAParams.getP().bitLength() : -1;
        } else if (key instanceof DHKey) {
            object = (DHKey)((Object)key);
            n = object.getParams().getP().bitLength();
        }
        return n;
    }

    public static final int getKeySize(AlgorithmParameters algorithmParameters) {
        String string;
        switch (string = algorithmParameters.getAlgorithm()) {
            case "EC": {
                try {
                    ECParameterSpec eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
                    if (eCParameterSpec != null) {
                        return eCParameterSpec.getOrder().bitLength();
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {}
                break;
            }
            case "DiffieHellman": {
                try {
                    DHParameterSpec dHParameterSpec = algorithmParameters.getParameterSpec(DHParameterSpec.class);
                    if (dHParameterSpec != null) {
                        return dHParameterSpec.getP().bitLength();
                    }
                    break;
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    public static final void validate(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("The key to be validated cannot be null");
        }
        if (key instanceof DHPublicKey) {
            KeyUtil.validateDHPublicKey((DHPublicKey)key);
        }
    }

    public static final void validate(KeySpec keySpec) throws InvalidKeyException {
        if (keySpec == null) {
            throw new NullPointerException("The key spec to be validated cannot be null");
        }
        if (keySpec instanceof DHPublicKeySpec) {
            KeyUtil.validateDHPublicKey((DHPublicKeySpec)keySpec);
        }
    }

    public static final boolean isOracleJCEProvider(String string) {
        return string != null && (string.equals("SunJCE") || string.equals("SunMSCAPI") || string.equals("OracleUcrypto") || string.startsWith("SunPKCS11"));
    }

    public static byte[] checkTlsPreMasterSecretKey(int n, int n2, SecureRandom secureRandom, byte[] byArray, boolean bl) {
        if (secureRandom == null) {
            secureRandom = JCAUtil.getSecureRandom();
        }
        byte[] byArray2 = new byte[48];
        secureRandom.nextBytes(byArray2);
        if (!bl && byArray != null) {
            if (byArray.length != 48) {
                return byArray2;
            }
            int n3 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            if (n != n3 && (n > 769 || n2 != n3)) {
                byArray = byArray2;
            }
            return byArray;
        }
        return byArray2;
    }

    private static void validateDHPublicKey(DHPublicKey dHPublicKey) throws InvalidKeyException {
        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
        BigInteger bigInteger = dHParameterSpec.getP();
        BigInteger bigInteger2 = dHParameterSpec.getG();
        BigInteger bigInteger3 = dHPublicKey.getY();
        KeyUtil.validateDHPublicKey(bigInteger, bigInteger2, bigInteger3);
    }

    private static void validateDHPublicKey(DHPublicKeySpec dHPublicKeySpec) throws InvalidKeyException {
        KeyUtil.validateDHPublicKey(dHPublicKeySpec.getP(), dHPublicKeySpec.getG(), dHPublicKeySpec.getY());
    }

    private static void validateDHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        BigInteger bigInteger4 = BigInteger.ONE;
        BigInteger bigInteger5 = bigInteger.subtract(BigInteger.ONE);
        if (bigInteger3.compareTo(bigInteger4) <= 0) {
            throw new InvalidKeyException("Diffie-Hellman public key is too small");
        }
        if (bigInteger3.compareTo(bigInteger5) >= 0) {
            throw new InvalidKeyException("Diffie-Hellman public key is too large");
        }
        BigInteger bigInteger6 = bigInteger.remainder(bigInteger3);
        if (bigInteger6.equals(BigInteger.ZERO)) {
            throw new InvalidKeyException("Invalid Diffie-Hellman parameters");
        }
    }

    public static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

