/*
 * Decompiled with CFR 0.152.
 */
package sun.security.action;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class GetIntegerAction
implements PrivilegedAction<Integer> {
    private String theProp;
    private int defaultVal;
    private boolean defaultSet;

    public GetIntegerAction(String string) {
        this.theProp = string;
    }

    public GetIntegerAction(String string, int n) {
        this.theProp = string;
        this.defaultVal = n;
        this.defaultSet = true;
    }

    @Override
    public Integer run() {
        Integer n = Integer.getInteger(this.theProp);
        if (n == null && this.defaultSet) {
            return new Integer(this.defaultVal);
        }
        return n;
    }

    public static Integer privilegedGetProperty(String string) {
        if (System.getSecurityManager() == null) {
            return Integer.getInteger(string);
        }
        return AccessController.doPrivileged(new GetIntegerAction(string));
    }

    public static Integer privilegedGetProperty(String string, int n) {
        Integer n2 = System.getSecurityManager() == null ? Integer.getInteger(string) : AccessController.doPrivileged(new GetIntegerAction(string));
        return n2 != null ? n2 : n;
    }
}

