/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.util.LinkedList;
import sun.awt.X11.Native;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEmbedHelper;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

public class XEmbedServerTester
implements XEventDispatcher {
    private static final PlatformLogger xembedLog = PlatformLogger.getLogger("sun.awt.X11.xembed.XEmbedServerTester");
    private final Object EVENT_LOCK = new Object();
    static final int SYSTEM_EVENT_MASK = 32768;
    int my_version;
    int server_version;
    XEmbedHelper xembed = new XEmbedHelper();
    boolean focused;
    int focusedKind;
    int focusedServerComponent;
    boolean reparent;
    long parent;
    boolean windowActive;
    boolean xembedActive;
    XBaseWindow window;
    volatile int eventWaited = -1;
    volatile int eventReceived = -1;
    int mapped;
    int accel_key;
    int accel_keysym;
    int accel_mods;
    static Rectangle initialBounds = new Rectangle(0, 0, 100, 100);
    Robot robot;
    Rectangle[] serverBounds;
    private static final int SERVER_BOUNDS = 0;
    private static final int OTHER_FRAME = 1;
    private static final int SERVER_FOCUS = 2;
    private static final int SERVER_MODAL = 3;
    private static final int MODAL_CLOSE = 4;
    LinkedList<Integer> events = new LinkedList();

    private XEmbedServerTester(Rectangle[] rectangleArray, long l) {
        this.parent = l;
        this.focusedKind = -1;
        this.focusedServerComponent = -1;
        this.reparent = false;
        this.windowActive = false;
        this.xembedActive = false;
        this.my_version = 0;
        this.mapped = 1;
        this.serverBounds = rectangleArray;
        if (rectangleArray.length < 5) {
            throw new IllegalArgumentException("There must be at least five areas: server-activation, server-deactivation, server-focus, server-modal show, modal-close");
        }
        try {
            this.robot = new Robot();
            this.robot.setAutoDelay(100);
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't create robot");
        }
        this.initAccel();
        if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
            xembedLog.finer("XEmbed client(tester), embedder window: " + Long.toHexString(l));
        }
    }

    public static XEmbedServerTester getTester(Rectangle[] rectangleArray, long l) {
        return new XEmbedServerTester(rectangleArray, l);
    }

    private void dumpReceivedEvents() {
        if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
            xembedLog.finer("Events received so far:");
            int n = 0;
            for (Integer n2 : this.events) {
                xembedLog.finer(n++ + ":" + XEmbedHelper.msgidToString(n2));
            }
            xembedLog.finer("End of event dump");
        }
    }

    public void test1_1() {
        int n = this.embedCompletely();
        this.waitWindowActivated(n);
        this.requestFocus();
        this.deactivateServer();
        n = this.activateServer(this.getEventPos());
        this.waitFocusGained(n);
        this.checkFocusGained(0);
    }

    public void test1_2() {
        int n = this.embedCompletely();
        this.waitWindowActivated(n);
        this.requestFocus();
        this.checkFocusGained(0);
    }

    public void test1_3() {
        this.embedCompletely();
        this.deactivateServer();
        this.requestFocusNoWait();
        this.checkNotFocused();
    }

    public void test1_4() {
        this.embedCompletely();
        this.deactivateServer();
        this.requestFocusNoWait();
        this.checkNotFocused();
        int n = this.getEventPos();
        this.activateServer(n);
        this.waitFocusGained(n);
        this.checkFocusGained(0);
    }

    public void test1_5() {
        int n = this.embedCompletely();
        this.waitWindowActivated(n);
        this.checkWindowActivated();
    }

    public void test1_6() {
        int n = this.embedCompletely();
        this.waitWindowActivated(n);
        this.requestFocus();
        n = this.deactivateServer();
        this.checkFocused();
    }

    public void test1_7() {
        int n = this.embedCompletely();
        this.waitWindowActivated(n);
        this.requestFocus();
        this.focusServer();
        this.checkFocusLost();
    }

    public void test2_5() {
        int n = this.embedCompletely();
        this.waitWindowActivated(n);
        this.requestFocus();
        this.focusServerNext();
        this.checkFocusedServerNext();
        this.checkFocusLost();
    }

    public void test2_6() {
        int n = this.embedCompletely();
        this.waitWindowActivated(n);
        this.requestFocus();
        this.focusServerPrev();
        this.checkFocusedServerPrev();
        this.checkFocusLost();
    }

    public void test3_1() {
        this.reparent = false;
        this.embedCompletely();
    }

    public void test3_3() {
        this.reparent = true;
        this.embedCompletely();
    }

    public void test3_4() {
        this.my_version = 10;
        this.embedCompletely();
        if (this.server_version != 0) {
            throw new RuntimeException("Version " + this.server_version + " is not minimal");
        }
    }

    public void test3_5() {
        this.embedCompletely();
        this.window.destroy();
        this.sleep(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test3_6() {
        this.embedCompletely();
        this.sleep(1000);
        XToolkit.awtLock();
        try {
            XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.window.getWindow());
            XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.window.getWindow(), XToolkit.getDefaultRootWindow(), 0, 0);
        }
        finally {
            XToolkit.awtUnlock();
        }
        int n = this.getEventPos();
        this.activateServerNoWait(n);
        this.sleep(1000);
        if (this.checkEventList(n, 1) != -1) {
            throw new RuntimeException("Focus was been given to the client after XEmbed has ended");
        }
    }

    public void test4_1() {
        this.mapped = 1;
        int n = this.getEventPos();
        this.embedCompletely();
        this.sleep(1000);
        this.checkMapped();
    }

    public void test4_2() {
        this.mapped = 0;
        this.embedCompletely();
        this.sleep(1000);
        int n = this.getEventPos();
        this.mapped = 1;
        this.updateEmbedInfo();
        this.sleep(1000);
        this.checkMapped();
    }

    public void test4_3() {
        int n = this.getEventPos();
        this.mapped = 1;
        this.embedCompletely();
        n = this.getEventPos();
        this.mapped = 0;
        this.updateEmbedInfo();
        this.sleep(1000);
        this.checkNotMapped();
    }

    public void test4_4() {
        this.mapped = 0;
        this.embedCompletely();
        this.sleep(1000);
        if (XlibUtil.getWindowMapState(this.window.getWindow()) != 0) {
            throw new RuntimeException("Client has been mapped");
        }
    }

    public void test6_1_1() {
        this.embedCompletely();
        this.registerAccelerator();
        this.focusServer();
        int n = this.pressAccelKey();
        this.waitForEvent(n, 14);
    }

    public void test6_1_2() {
        this.embedCompletely();
        this.registerAccelerator();
        this.focusServer();
        this.deactivateServer();
        int n = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(n, 14) != -1) {
            throw new RuntimeException("Accelerator has been activated in inactive embedder");
        }
    }

    public void test6_1_3() {
        this.embedCompletely();
        this.registerAccelerator();
        this.focusServer();
        this.deactivateServer();
        this.unregisterAccelerator();
        int n = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(n, 14) != -1) {
            throw new RuntimeException("Accelerator has been activated after unregistering");
        }
    }

    public void test6_1_4() {
        this.embedCompletely();
        this.registerAccelerator();
        this.requestFocus();
        int n = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(n, 14) != -1) {
            throw new RuntimeException("Accelerator has been activated in focused client");
        }
    }

    public void test6_2_1() {
        this.embedCompletely();
        this.grabKey();
        this.focusServer();
        int n = this.pressAccelKey();
        this.waitSystemEvent(n, 2);
    }

    public void test6_2_2() {
        this.embedCompletely();
        this.grabKey();
        this.focusServer();
        this.deactivateServer();
        int n = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(n, 32770) != -1) {
            throw new RuntimeException("Accelerator has been activated in inactive embedder");
        }
    }

    public void test6_2_3() {
        this.embedCompletely();
        this.grabKey();
        this.focusServer();
        this.deactivateServer();
        this.ungrabKey();
        int n = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(n, 32770) != -1) {
            throw new RuntimeException("Accelerator has been activated after unregistering");
        }
    }

    public void test6_2_4() {
        this.embedCompletely();
        this.grabKey();
        this.requestFocus();
        int n = this.pressAccelKey();
        this.sleep(1000);
        int n2 = this.checkEventList(n, 32770);
        if (n2 != -1 && (n2 = this.checkEventList(n2 + 1, 32770)) != -1) {
            throw new RuntimeException("Accelerator has been activated in focused client");
        }
    }

    public void test7_1() {
        this.embedCompletely();
        int n = this.showModalDialog();
        this.waitForEvent(n, 10);
    }

    public void test7_2() {
        this.embedCompletely();
        int n = this.showModalDialog();
        this.waitForEvent(n, 10);
        n = this.hideModalDialog();
        this.waitForEvent(n, 11);
    }

    public void test9_1() {
        this.embedCompletely();
        this.requestFocus();
        int n = this.pressAccelKey();
        this.waitForEvent(n, 32770);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int embed() {
        int n = this.getEventPos();
        XToolkit.awtLock();
        try {
            XCreateWindowParams xCreateWindowParams = new XCreateWindowParams(new Object[]{"parent window", this.reparent ? XToolkit.getDefaultRootWindow() : this.parent, "bounds", initialBounds, "embedded", Boolean.TRUE, "visible", this.mapped == 1, "event mask", 720897L});
            this.window = new XBaseWindow(xCreateWindowParams);
            if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
                xembedLog.finer("Created tester window: " + this.window);
            }
            XToolkit.addEventDispatcher(this.window.getWindow(), this);
            this.updateEmbedInfo();
            if (this.reparent) {
                xembedLog.finer("Reparenting to embedder");
                XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.window.getWindow(), this.parent, 0, 0);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmbedInfo() {
        long[] lArray = new long[]{this.my_version, this.mapped};
        long l = Native.card32ToData(lArray);
        try {
            XEmbedHelper.XEmbedInfo.setAtomData(this.window.getWindow(), l, lArray.length);
        }
        finally {
            XEmbedHelper.unsafe.freeMemory(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEventPos() {
        Object object = this.EVENT_LOCK;
        synchronized (object) {
            return this.events.size();
        }
    }

    private int embedCompletely() {
        xembedLog.fine("Embedding completely");
        int n = this.getEventPos();
        this.embed();
        this.waitEmbeddedNotify(n);
        return n;
    }

    private int requestFocus() {
        xembedLog.fine("Requesting focus");
        int n = this.getEventPos();
        this.sendMessage(3);
        this.waitFocusGained(n);
        return n;
    }

    private int requestFocusNoWait() {
        xembedLog.fine("Requesting focus without wait");
        int n = this.getEventPos();
        this.sendMessage(3);
        return n;
    }

    private int activateServer(int n) {
        int n2 = this.activateServerNoWait(n);
        this.waitWindowActivated(n2);
        return n2;
    }

    private int activateServerNoWait(int n) {
        xembedLog.fine("Activating server");
        int n2 = this.getEventPos();
        if (this.checkEventList(n, 1) != -1) {
            xembedLog.fine("Activation already received");
            return n2;
        }
        Point point = this.serverBounds[0].getLocation();
        point.x = (int)((double)point.x + this.serverBounds[0].getWidth() / 2.0);
        point.y += 5;
        this.robot.mouseMove(point.x, point.y);
        this.robot.mousePress(16);
        this.robot.mouseRelease(16);
        return n2;
    }

    private int deactivateServer() {
        xembedLog.fine("Deactivating server");
        int n = this.getEventPos();
        Point point = this.serverBounds[1].getLocation();
        point.x = (int)((double)point.x + this.serverBounds[1].getWidth() / 2.0);
        point.y = (int)((double)point.y + this.serverBounds[1].getHeight() / 2.0);
        this.robot.mouseMove(point.x, point.y);
        this.robot.mousePress(16);
        this.robot.delay(50);
        this.robot.mouseRelease(16);
        this.waitWindowDeactivated(n);
        return n;
    }

    private int focusServer() {
        xembedLog.fine("Focusing server");
        boolean bl = this.focused;
        int n = this.getEventPos();
        Point point = this.serverBounds[2].getLocation();
        point.x += 5;
        point.y += 5;
        this.robot.mouseMove(point.x, point.y);
        this.robot.mousePress(16);
        this.robot.delay(50);
        this.robot.mouseRelease(16);
        if (bl) {
            this.waitFocusLost(n);
        }
        return n;
    }

    private int focusServerNext() {
        xembedLog.fine("Focusing next server component");
        int n = this.getEventPos();
        this.sendMessage(6);
        this.waitFocusLost(n);
        return n;
    }

    private int focusServerPrev() {
        xembedLog.fine("Focusing previous server component");
        int n = this.getEventPos();
        this.sendMessage(7);
        this.waitFocusLost(n);
        return n;
    }

    private void waitEmbeddedNotify(int n) {
        this.waitForEvent(n, 0);
    }

    private void waitFocusGained(int n) {
        this.waitForEvent(n, 4);
    }

    private void waitFocusLost(int n) {
        this.waitForEvent(n, 5);
    }

    private void waitWindowActivated(int n) {
        this.waitForEvent(n, 1);
    }

    private void waitWindowDeactivated(int n) {
        this.waitForEvent(n, 2);
    }

    private void waitSystemEvent(int n, int n2) {
        this.waitForEvent(n, n2 | 0x8000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEvent(int n, int n2) {
        Object object = this.EVENT_LOCK;
        synchronized (object) {
            if (this.checkEventList(n, n2) != -1) {
                if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
                    xembedLog.finer("The event " + XEmbedHelper.msgidToString(n2) + " has already been received");
                }
                return;
            }
            if (this.eventReceived == n2) {
                if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
                    xembedLog.finer("Already received " + XEmbedHelper.msgidToString(n2));
                }
                return;
            }
            this.eventReceived = -1;
            this.eventWaited = n2;
            if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
                xembedLog.finer("Waiting for " + XEmbedHelper.msgidToString(n2) + " starting from " + n);
            }
            try {
                this.EVENT_LOCK.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                xembedLog.warning("Event wait interrupted", interruptedException);
            }
            this.eventWaited = -1;
            if (this.checkEventList(n, n2) == -1) {
                this.dumpReceivedEvents();
                throw new RuntimeException("Didn't receive event " + XEmbedHelper.msgidToString(n2) + " but recevied " + XEmbedHelper.msgidToString(this.eventReceived));
            }
            if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
                xembedLog.finer("Successfully recevied " + XEmbedHelper.msgidToString(n2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkEventList(int n, int n2) {
        if (n == -1) {
            return -1;
        }
        Object object = this.EVENT_LOCK;
        synchronized (object) {
            for (int i = n; i < this.events.size(); ++i) {
                if (this.events.get(i) != n2) continue;
                return i;
            }
            return -1;
        }
    }

    private void checkFocusedServerNext() {
        if (this.focusedServerComponent != 0) {
            throw new RuntimeException("Wrong focused server component, should be 0, but it is " + this.focusedServerComponent);
        }
    }

    private void checkFocusedServerPrev() {
        if (this.focusedServerComponent != 2) {
            throw new RuntimeException("Wrong focused server component, should be 2, but it is " + this.focusedServerComponent);
        }
    }

    private void checkFocusGained(int n) {
        if (!this.focused) {
            throw new RuntimeException("Didn't receive FOCUS_GAINED");
        }
        if (this.focusedKind != n) {
            throw new RuntimeException("Kinds don't match, required: " + n + ", current: " + this.focusedKind);
        }
    }

    private void checkNotFocused() {
        if (this.focused) {
            throw new RuntimeException("Focused");
        }
    }

    private void checkFocused() {
        if (!this.focused) {
            throw new RuntimeException("Not Focused");
        }
    }

    private void checkFocusLost() {
        this.checkNotFocused();
        if (this.focusedKind != 5) {
            throw new RuntimeException("Didn't receive FOCUS_LOST");
        }
    }

    private void checkWindowActivated() {
        if (!this.windowActive) {
            throw new RuntimeException("Window is not active");
        }
    }

    private void checkMapped() {
        if (XlibUtil.getWindowMapState(this.window.getWindow()) == 0) {
            throw new RuntimeException("Client is not mapped");
        }
    }

    private void checkNotMapped() {
        if (XlibUtil.getWindowMapState(this.window.getWindow()) != 0) {
            throw new RuntimeException("Client is mapped");
        }
    }

    private void sendMessage(int n) {
        this.xembed.sendMessage(this.parent, n);
    }

    private void sendMessage(int n, int n2, long l, long l2) {
        this.xembed.sendMessage(this.parent, n, n2, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(XEvent xEvent) {
        if (xEvent.get_type() == 33) {
            XClientMessageEvent xClientMessageEvent = xEvent.get_xclient();
            if (xClientMessageEvent.get_message_type() == XEmbedHelper.XEmbed.getAtom()) {
                if (xembedLog.isLoggable(PlatformLogger.Level.FINE)) {
                    xembedLog.fine("Embedded message: " + XEmbedHelper.msgidToString((int)xClientMessageEvent.get_data(1)));
                }
                switch ((int)xClientMessageEvent.get_data(1)) {
                    case 0: {
                        this.xembedActive = true;
                        this.server_version = (int)xClientMessageEvent.get_data(3);
                        break;
                    }
                    case 1: {
                        this.windowActive = true;
                        break;
                    }
                    case 2: {
                        this.windowActive = false;
                        break;
                    }
                    case 4: {
                        this.focused = true;
                        this.focusedKind = (int)xClientMessageEvent.get_data(2);
                        break;
                    }
                    case 5: {
                        this.focused = false;
                        this.focusedKind = 5;
                        this.focusedServerComponent = (int)xClientMessageEvent.get_data(2);
                    }
                }
                Object object = this.EVENT_LOCK;
                synchronized (object) {
                    this.events.add((int)xClientMessageEvent.get_data(1));
                    if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
                        xembedLog.finer("Tester is waiting for " + XEmbedHelper.msgidToString(this.eventWaited));
                    }
                    if ((int)xClientMessageEvent.get_data(1) == this.eventWaited) {
                        this.eventReceived = (int)xClientMessageEvent.get_data(1);
                        if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
                            xembedLog.finer("Notifying waiting object for event " + System.identityHashCode(this.EVENT_LOCK));
                        }
                        this.EVENT_LOCK.notifyAll();
                    }
                }
            }
        } else {
            Object object = this.EVENT_LOCK;
            synchronized (object) {
                int n = xEvent.get_type() | 0x8000;
                this.events.add(n);
                if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
                    xembedLog.finer("Tester is waiting for " + XEmbedHelper.msgidToString(this.eventWaited) + ", but we received " + xEvent + "(" + XEmbedHelper.msgidToString(n) + ")");
                }
                if (n == this.eventWaited) {
                    this.eventReceived = n;
                    if (xembedLog.isLoggable(PlatformLogger.Level.FINER)) {
                        xembedLog.finer("Notifying waiting object" + System.identityHashCode(this.EVENT_LOCK));
                    }
                    this.EVENT_LOCK.notifyAll();
                }
            }
        }
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerAccelerator() {
        this.sendMessage(12, 1, this.accel_keysym, this.accel_mods);
    }

    private void unregisterAccelerator() {
        this.sendMessage(13, 1, 0L, 0L);
    }

    private int pressAccelKey() {
        int n = this.getEventPos();
        this.robot.keyPress(this.accel_key);
        this.robot.keyRelease(this.accel_key);
        return n;
    }

    private void initAccel() {
        this.accel_key = 65;
        this.accel_keysym = XWindow.getKeySymForAWTKeyCode(this.accel_key);
        this.accel_mods = 0;
    }

    private void grabKey() {
        this.sendMessage(108, 0, this.accel_keysym, this.accel_mods);
    }

    private void ungrabKey() {
        this.sendMessage(109, 0, this.accel_keysym, this.accel_mods);
    }

    private int showModalDialog() {
        xembedLog.fine("Showing modal dialog");
        int n = this.getEventPos();
        Point point = this.serverBounds[3].getLocation();
        point.x += 5;
        point.y += 5;
        this.robot.mouseMove(point.x, point.y);
        this.robot.mousePress(16);
        this.robot.delay(50);
        this.robot.mouseRelease(16);
        return n;
    }

    private int hideModalDialog() {
        xembedLog.fine("Hide modal dialog");
        int n = this.getEventPos();
        this.robot.keyPress(32);
        this.robot.keyRelease(32);
        return n;
    }
}

