/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.jcp.xml.dsig.internal.dom.DOMCryptoBinary;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMKeyValue
extends DOMStructure
implements KeyValue {
    private static final String XMLDSIG_11_XMLNS = "http://www.w3.org/2009/xmldsig11#";
    private final PublicKey publicKey;

    public DOMKeyValue(PublicKey publicKey) throws KeyException {
        if (publicKey == null) {
            throw new NullPointerException("key cannot be null");
        }
        this.publicKey = publicKey;
    }

    public DOMKeyValue(Element element) throws MarshalException {
        this.publicKey = this.unmarshalKeyValue(element);
    }

    static KeyValue unmarshal(Element element) throws MarshalException {
        Element element2 = DOMUtils.getFirstChildElement(element);
        if (element2.getLocalName().equals("DSAKeyValue")) {
            return new DSA(element2);
        }
        if (element2.getLocalName().equals("RSAKeyValue")) {
            return new RSA(element2);
        }
        if (element2.getLocalName().equals("ECKeyValue")) {
            return new EC(element2);
        }
        return new Unknown(element2);
    }

    @Override
    public PublicKey getPublicKey() throws KeyException {
        if (this.publicKey == null) {
            throw new KeyException("can't convert KeyValue to PublicKey");
        }
        return this.publicKey;
    }

    @Override
    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "KeyValue", "http://www.w3.org/2000/09/xmldsig#", string);
        this.marshalPublicKey(element, document, string, dOMCryptoContext);
        node.appendChild(element);
    }

    abstract void marshalPublicKey(Node var1, Document var2, String var3, DOMCryptoContext var4) throws MarshalException;

    abstract PublicKey unmarshalKeyValue(Element var1) throws MarshalException;

    private static PublicKey generatePublicKey(KeyFactory keyFactory, KeySpec keySpec) {
        try {
            return keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyValue)) {
            return false;
        }
        try {
            KeyValue keyValue = (KeyValue)object;
            if (this.publicKey == null ? keyValue.getPublicKey() != null : !this.publicKey.equals(keyValue.getPublicKey())) {
                return false;
            }
        }
        catch (KeyException keyException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        if (this.publicKey != null) {
            n = 31 * n + this.publicKey.hashCode();
        }
        return n;
    }

    static final class Unknown
    extends DOMKeyValue {
        private javax.xml.crypto.dom.DOMStructure externalPublicKey;

        Unknown(Element element) throws MarshalException {
            super(element);
        }

        @Override
        PublicKey unmarshalKeyValue(Element element) throws MarshalException {
            this.externalPublicKey = new javax.xml.crypto.dom.DOMStructure(element);
            return null;
        }

        @Override
        void marshalPublicKey(Node node, Document document, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
            node.appendChild(this.externalPublicKey.getNode());
        }
    }

    static final class EC
    extends DOMKeyValue {
        private byte[] ecPublicKey;
        private KeyFactory eckf;
        private ECParameterSpec ecParams;
        private Method encodePoint;
        private Method decodePoint;
        private Method getCurveName;
        private Method getECParameterSpec;

        EC(PublicKey publicKey) throws KeyException {
            super(publicKey);
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            ECPoint eCPoint = eCPublicKey.getW();
            this.ecParams = eCPublicKey.getParams();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws ClassNotFoundException, NoSuchMethodException {
                        EC.this.getMethods();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new KeyException("ECKeyValue not supported", privilegedActionException.getException());
            }
            Object[] objectArray = new Object[]{eCPoint, this.ecParams.getCurve()};
            try {
                this.ecPublicKey = (byte[])this.encodePoint.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new KeyException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new KeyException(invocationTargetException);
            }
        }

        EC(Element element) throws MarshalException {
            super(element);
        }

        void getMethods() throws ClassNotFoundException, NoSuchMethodException {
            Class<?> clazz = Class.forName("sun.security.ec.ECParameters");
            Class[] classArray = new Class[]{ECPoint.class, EllipticCurve.class};
            this.encodePoint = clazz.getMethod("encodePoint", classArray);
            classArray = new Class[]{ECParameterSpec.class};
            this.getCurveName = clazz.getMethod("getCurveName", classArray);
            classArray = new Class[]{byte[].class, EllipticCurve.class};
            this.decodePoint = clazz.getMethod("decodePoint", classArray);
            clazz = Class.forName("sun.security.ec.NamedCurve");
            classArray = new Class[]{String.class};
            this.getECParameterSpec = clazz.getMethod("getECParameterSpec", classArray);
        }

        @Override
        void marshalPublicKey(Node node, Document document, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
            String string2;
            String string3 = DOMUtils.getNSPrefix(dOMCryptoContext, DOMKeyValue.XMLDSIG_11_XMLNS);
            Element element = DOMUtils.createElement(document, "ECKeyValue", DOMKeyValue.XMLDSIG_11_XMLNS, string3);
            Element element2 = DOMUtils.createElement(document, "NamedCurve", DOMKeyValue.XMLDSIG_11_XMLNS, string3);
            Element element3 = DOMUtils.createElement(document, "PublicKey", DOMKeyValue.XMLDSIG_11_XMLNS, string3);
            Object[] objectArray = new Object[]{this.ecParams};
            try {
                string2 = (String)this.getCurveName.invoke(null, objectArray);
                DOMUtils.setAttribute(element2, "URI", "urn:oid:" + string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MarshalException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MarshalException(invocationTargetException);
            }
            string2 = string3 == null || string3.length() == 0 ? "xmlns" : "xmlns:" + string3;
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", string2, DOMKeyValue.XMLDSIG_11_XMLNS);
            element.appendChild(element2);
            String string4 = Base64.encode(this.ecPublicKey);
            element3.appendChild(DOMUtils.getOwnerDocument(element3).createTextNode(string4));
            element.appendChild(element3);
            node.appendChild(element);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        PublicKey unmarshalKeyValue(Element element) throws MarshalException {
            if (this.eckf == null) {
                try {
                    this.eckf = KeyFactory.getInstance("EC");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("unable to create EC KeyFactory: " + noSuchAlgorithmException.getMessage());
                }
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws ClassNotFoundException, NoSuchMethodException {
                        EC.this.getMethods();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new MarshalException("ECKeyValue not supported", privilegedActionException.getException());
            }
            ECParameterSpec eCParameterSpec = null;
            Element element2 = DOMUtils.getFirstChildElement(element);
            if (element2.getLocalName().equals("ECParameters")) {
                throw new UnsupportedOperationException("ECParameters not supported");
            }
            if (!element2.getLocalName().equals("NamedCurve")) throw new MarshalException("Invalid ECKeyValue");
            Object object = DOMUtils.getAttributeValue(element2, "URI");
            if (!((String)object).startsWith("urn:oid:")) throw new MarshalException("Invalid NamedCurve URI");
            String string = ((String)object).substring(8);
            try {
                Object[] objectArray = new Object[]{string};
                eCParameterSpec = (ECParameterSpec)this.getECParameterSpec.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MarshalException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MarshalException(invocationTargetException);
            }
            element2 = DOMUtils.getNextSiblingElement(element2, "PublicKey");
            object = null;
            try {
                Object[] objectArray = new Object[]{Base64.decode(element2), eCParameterSpec.getCurve()};
                object = (ECPoint)this.decodePoint.invoke(null, objectArray);
            }
            catch (Base64DecodingException base64DecodingException) {
                throw new MarshalException("Invalid EC PublicKey", base64DecodingException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MarshalException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MarshalException(invocationTargetException);
            }
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec((ECPoint)object, eCParameterSpec);
            return DOMKeyValue.generatePublicKey(this.eckf, eCPublicKeySpec);
        }
    }

    static final class DSA
    extends DOMKeyValue {
        private DOMCryptoBinary p;
        private DOMCryptoBinary q;
        private DOMCryptoBinary g;
        private DOMCryptoBinary y;
        private DOMCryptoBinary j;
        private KeyFactory dsakf;

        DSA(PublicKey publicKey) throws KeyException {
            super(publicKey);
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            this.p = new DOMCryptoBinary(dSAParams.getP());
            this.q = new DOMCryptoBinary(dSAParams.getQ());
            this.g = new DOMCryptoBinary(dSAParams.getG());
            this.y = new DOMCryptoBinary(dSAPublicKey.getY());
        }

        DSA(Element element) throws MarshalException {
            super(element);
        }

        @Override
        void marshalPublicKey(Node node, Document document, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
            Element element = DOMUtils.createElement(document, "DSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", string);
            Element element2 = DOMUtils.createElement(document, "P", "http://www.w3.org/2000/09/xmldsig#", string);
            Element element3 = DOMUtils.createElement(document, "Q", "http://www.w3.org/2000/09/xmldsig#", string);
            Element element4 = DOMUtils.createElement(document, "G", "http://www.w3.org/2000/09/xmldsig#", string);
            Element element5 = DOMUtils.createElement(document, "Y", "http://www.w3.org/2000/09/xmldsig#", string);
            this.p.marshal(element2, string, dOMCryptoContext);
            this.q.marshal(element3, string, dOMCryptoContext);
            this.g.marshal(element4, string, dOMCryptoContext);
            this.y.marshal(element5, string, dOMCryptoContext);
            element.appendChild(element2);
            element.appendChild(element3);
            element.appendChild(element4);
            element.appendChild(element5);
            node.appendChild(element);
        }

        @Override
        PublicKey unmarshalKeyValue(Element element) throws MarshalException {
            Element element2;
            if (this.dsakf == null) {
                try {
                    this.dsakf = KeyFactory.getInstance("DSA");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("unable to create DSA KeyFactory: " + noSuchAlgorithmException.getMessage());
                }
            }
            if ((element2 = DOMUtils.getFirstChildElement(element)).getLocalName().equals("P")) {
                this.p = new DOMCryptoBinary(element2.getFirstChild());
                element2 = DOMUtils.getNextSiblingElement(element2, "Q");
                this.q = new DOMCryptoBinary(element2.getFirstChild());
                element2 = DOMUtils.getNextSiblingElement(element2);
            }
            if (element2.getLocalName().equals("G")) {
                this.g = new DOMCryptoBinary(element2.getFirstChild());
                element2 = DOMUtils.getNextSiblingElement(element2, "Y");
            }
            this.y = new DOMCryptoBinary(element2.getFirstChild());
            if ((element2 = DOMUtils.getNextSiblingElement(element2)) != null && element2.getLocalName().equals("J")) {
                this.j = new DOMCryptoBinary(element2.getFirstChild());
            }
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.y.getBigNum(), this.p.getBigNum(), this.q.getBigNum(), this.g.getBigNum());
            return DOMKeyValue.generatePublicKey(this.dsakf, dSAPublicKeySpec);
        }
    }

    static final class RSA
    extends DOMKeyValue {
        private DOMCryptoBinary modulus;
        private DOMCryptoBinary exponent;
        private KeyFactory rsakf;

        RSA(PublicKey publicKey) throws KeyException {
            super(publicKey);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            this.exponent = new DOMCryptoBinary(rSAPublicKey.getPublicExponent());
            this.modulus = new DOMCryptoBinary(rSAPublicKey.getModulus());
        }

        RSA(Element element) throws MarshalException {
            super(element);
        }

        @Override
        void marshalPublicKey(Node node, Document document, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
            Element element = DOMUtils.createElement(document, "RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", string);
            Element element2 = DOMUtils.createElement(document, "Modulus", "http://www.w3.org/2000/09/xmldsig#", string);
            Element element3 = DOMUtils.createElement(document, "Exponent", "http://www.w3.org/2000/09/xmldsig#", string);
            this.modulus.marshal(element2, string, dOMCryptoContext);
            this.exponent.marshal(element3, string, dOMCryptoContext);
            element.appendChild(element2);
            element.appendChild(element3);
            node.appendChild(element);
        }

        @Override
        PublicKey unmarshalKeyValue(Element element) throws MarshalException {
            if (this.rsakf == null) {
                try {
                    this.rsakf = KeyFactory.getInstance("RSA");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("unable to create RSA KeyFactory: " + noSuchAlgorithmException.getMessage());
                }
            }
            Element element2 = DOMUtils.getFirstChildElement(element, "Modulus");
            this.modulus = new DOMCryptoBinary(element2.getFirstChild());
            Element element3 = DOMUtils.getNextSiblingElement(element2, "Exponent");
            this.exponent = new DOMCryptoBinary(element3.getFirstChild());
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(this.modulus.getBigNum(), this.exponent.getBigNum());
            return DOMKeyValue.generatePublicKey(this.rsakf, rSAPublicKeySpec);
        }
    }
}

