/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddressImpl;
import java.net.InetAddressImplFactory;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import sun.misc.Unsafe;
import sun.net.InetAddressCachePolicy;
import sun.net.spi.nameservice.NameService;
import sun.net.spi.nameservice.NameServiceDescriptor;
import sun.net.util.IPAddressUtil;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class InetAddress
implements Serializable {
    static final int IPv4 = 1;
    static final int IPv6 = 2;
    static transient boolean preferIPv6Address;
    final transient InetAddressHolder holder = new InetAddressHolder();
    private static List<NameService> nameServices;
    private transient String canonicalHostName = null;
    private static final long serialVersionUID = 3286316764910316507L;
    private static Cache addressCache;
    private static Cache negativeCache;
    private static boolean addressCacheInit;
    static InetAddress[] unknown_array;
    static InetAddressImpl impl;
    private static final HashMap<String, Void> lookupTable;
    private static InetAddress cachedLocalHost;
    private static long cacheTime;
    private static final long maxCacheTime = 5000L;
    private static final Object cacheLock;
    private static final long FIELDS_OFFSET;
    private static final Unsafe UNSAFE;
    private static final ObjectStreamField[] serialPersistentFields;

    InetAddressHolder holder() {
        return this.holder;
    }

    InetAddress() {
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.holder().getHostName(), this.holder().getAddress());
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isReachable(int n) throws IOException {
        return this.isReachable(null, 0, n);
    }

    public boolean isReachable(NetworkInterface networkInterface, int n, int n2) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        return impl.isReachable(this, n2, networkInterface, n);
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean bl) {
        if (this.holder().getHostName() == null) {
            this.holder().hostName = InetAddress.getHostFromNameService(this, bl);
        }
        return this.holder().getHostName();
    }

    public String getCanonicalHostName() {
        if (this.canonicalHostName == null) {
            this.canonicalHostName = InetAddress.getHostFromNameService(this, true);
        }
        return this.canonicalHostName;
    }

    private static String getHostFromNameService(InetAddress inetAddress, boolean bl) {
        String string = null;
        for (NameService nameService : nameServices) {
            try {
                InetAddress[] inetAddressArray;
                string = nameService.getHostByAddr(inetAddress.getAddress());
                if (bl && (inetAddressArray = System.getSecurityManager()) != null) {
                    inetAddressArray.checkConnect(string, -1);
                }
                inetAddressArray = InetAddress.getAllByName0(string, bl);
                boolean bl2 = false;
                if (inetAddressArray != null) {
                    for (int i = 0; !bl2 && i < inetAddressArray.length; ++i) {
                        bl2 = inetAddress.equals(inetAddressArray[i]);
                    }
                }
                if (!bl2) {
                    string = inetAddress.getHostAddress();
                    return string;
                }
                break;
            }
            catch (SecurityException securityException) {
                string = inetAddress.getHostAddress();
                break;
            }
            catch (UnknownHostException unknownHostException) {
                string = inetAddress.getHostAddress();
            }
        }
        return string;
    }

    public byte[] getAddress() {
        return null;
    }

    public String getHostAddress() {
        return null;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object object) {
        return false;
    }

    public String toString() {
        String string = this.holder().getHostName();
        return (string != null ? string : "") + "/" + this.getHostAddress();
    }

    private static void cacheInitIfNeeded() {
        assert (Thread.holdsLock(addressCache));
        if (addressCacheInit) {
            return;
        }
        unknown_array = new InetAddress[1];
        InetAddress.unknown_array[0] = impl.anyLocalAddress();
        addressCache.put(impl.anyLocalAddress().getHostName(), unknown_array);
        addressCacheInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAddresses(String string, InetAddress[] inetAddressArray, boolean bl) {
        string = string.toLowerCase();
        Cache cache = addressCache;
        synchronized (cache) {
            InetAddress.cacheInitIfNeeded();
            if (bl) {
                addressCache.put(string, inetAddressArray);
            } else {
                negativeCache.put(string, inetAddressArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress[] getCachedAddresses(String string) {
        string = string.toLowerCase();
        Cache cache = addressCache;
        synchronized (cache) {
            InetAddress.cacheInitIfNeeded();
            CacheEntry cacheEntry = addressCache.get(string);
            if (cacheEntry == null) {
                cacheEntry = negativeCache.get(string);
            }
            if (cacheEntry != null) {
                return cacheEntry.addresses;
            }
        }
        return null;
    }

    private static NameService createNSProvider(String string) {
        if (string == null) {
            return null;
        }
        NameService nameService = null;
        if (string.equals("default")) {
            nameService = new NameService(){

                @Override
                public InetAddress[] lookupAllHostAddr(String string) throws UnknownHostException {
                    return impl.lookupAllHostAddr(string);
                }

                @Override
                public String getHostByAddr(byte[] byArray) throws UnknownHostException {
                    return impl.getHostByAddr(byArray);
                }
            };
        } else {
            final String string2 = string;
            try {
                nameService = AccessController.doPrivileged(new PrivilegedExceptionAction<NameService>(){

                    @Override
                    public NameService run() {
                        for (NameServiceDescriptor nameServiceDescriptor : ServiceLoader.load(NameServiceDescriptor.class)) {
                            if (!string2.equalsIgnoreCase(nameServiceDescriptor.getType() + "," + nameServiceDescriptor.getProviderName())) continue;
                            try {
                                return nameServiceDescriptor.createNameService();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                System.err.println("Cannot create name service:" + string2 + ": " + exception);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
        return nameService;
    }

    public static InetAddress getByAddress(String string, byte[] byArray) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null) {
            if (byArray.length == 4) {
                return new Inet4Address(string, byArray);
            }
            if (byArray.length == 16) {
                byte[] byArray2 = IPAddressUtil.convertFromIPv4MappedAddress(byArray);
                if (byArray2 != null) {
                    return new Inet4Address(string, byArray2);
                }
                return new Inet6Address(string, byArray);
            }
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        return InetAddress.getAllByName(string)[0];
    }

    private static InetAddress getByName(String string, InetAddress inetAddress) throws UnknownHostException {
        return InetAddress.getAllByName(string, inetAddress)[0];
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        return InetAddress.getAllByName(string, null);
    }

    private static InetAddress[] getAllByName(String string, InetAddress inetAddress) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            InetAddress[] inetAddressArray = new InetAddress[]{impl.loopbackAddress()};
            return inetAddressArray;
        }
        boolean bl = false;
        if (string.charAt(0) == '[') {
            if (string.length() > 2 && string.charAt(string.length() - 1) == ']') {
                string = string.substring(1, string.length() - 1);
                bl = true;
            } else {
                throw new UnknownHostException(string + ": invalid IPv6 address");
            }
        }
        if (Character.digit(string.charAt(0), 16) != -1 || string.charAt(0) == ':') {
            byte[] byArray = null;
            int n = -1;
            String string2 = null;
            byArray = IPAddressUtil.textToNumericFormatV4(string);
            if (byArray == null) {
                int n2 = string.indexOf("%");
                if (n2 != -1 && (n = InetAddress.checkNumericZone(string)) == -1) {
                    string2 = string.substring(n2 + 1);
                }
                if ((byArray = IPAddressUtil.textToNumericFormatV6(string)) == null && string.contains(":")) {
                    throw new UnknownHostException(string + ": invalid IPv6 address");
                }
            } else if (bl) {
                throw new UnknownHostException("[" + string + "]");
            }
            InetAddress[] inetAddressArray = new InetAddress[1];
            if (byArray != null) {
                inetAddressArray[0] = byArray.length == 4 ? new Inet4Address(null, byArray) : (string2 != null ? new Inet6Address(null, byArray, string2) : new Inet6Address(null, byArray, n));
                return inetAddressArray;
            }
        } else if (bl) {
            throw new UnknownHostException("[" + string + "]");
        }
        return InetAddress.getAllByName0(string, inetAddress, true);
    }

    public static InetAddress getLoopbackAddress() {
        return impl.loopbackAddress();
    }

    private static int checkNumericZone(String string) throws UnknownHostException {
        int n = string.indexOf(37);
        int n2 = string.length();
        int n3 = 0;
        if (n == -1) {
            return -1;
        }
        for (int i = n + 1; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == ']') {
                if (i != n + 1) break;
                return -1;
            }
            int n4 = Character.digit(c, 10);
            if (n4 < 0) {
                return -1;
            }
            n3 = n3 * 10 + n4;
        }
        return n3;
    }

    private static InetAddress[] getAllByName0(String string) throws UnknownHostException {
        return InetAddress.getAllByName0(string, true);
    }

    static InetAddress[] getAllByName0(String string, boolean bl) throws UnknownHostException {
        return InetAddress.getAllByName0(string, null, bl);
    }

    private static InetAddress[] getAllByName0(String string, InetAddress inetAddress, boolean bl) throws UnknownHostException {
        InetAddress[] inetAddressArray;
        if (bl && (inetAddressArray = System.getSecurityManager()) != null) {
            inetAddressArray.checkConnect(string, -1);
        }
        if ((inetAddressArray = InetAddress.getCachedAddresses(string)) == null) {
            inetAddressArray = InetAddress.getAddressesFromNameService(string, inetAddress);
        }
        if (inetAddressArray == unknown_array) {
            throw new UnknownHostException(string);
        }
        return (InetAddress[])inetAddressArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress[] getAddressesFromNameService(String string, InetAddress inetAddress) throws UnknownHostException {
        InetAddress[] inetAddressArray = null;
        boolean bl = false;
        UnknownHostException unknownHostException = null;
        inetAddressArray = InetAddress.checkLookupTable(string);
        if (inetAddressArray == null) {
            try {
                for (NameService object2 : nameServices) {
                    try {
                        inetAddressArray = object2.lookupAllHostAddr(string);
                        bl = true;
                        break;
                    }
                    catch (UnknownHostException unknownHostException2) {
                        if (string.equalsIgnoreCase("localhost")) {
                            InetAddress[] inetAddressArray2 = new InetAddress[]{impl.loopbackAddress()};
                            inetAddressArray = inetAddressArray2;
                            bl = true;
                            break;
                        }
                        inetAddressArray = unknown_array;
                        bl = false;
                        unknownHostException = unknownHostException2;
                    }
                }
                if (inetAddress != null && inetAddressArray.length > 1 && !inetAddressArray[0].equals(inetAddress)) {
                    int n;
                    for (n = 1; n < inetAddressArray.length && !inetAddressArray[n].equals(inetAddress); ++n) {
                    }
                    if (n < inetAddressArray.length) {
                        InetAddress inetAddress2 = inetAddress;
                        for (int i = 0; i < n; ++i) {
                            InetAddress inetAddress3 = inetAddressArray[i];
                            inetAddressArray[i] = inetAddress2;
                            inetAddress2 = inetAddress3;
                        }
                        inetAddressArray[n] = inetAddress2;
                    }
                }
                InetAddress.cacheAddresses(string, inetAddressArray, bl);
                if (!bl && unknownHostException != null) {
                    throw unknownHostException;
                }
            }
            finally {
                InetAddress.updateLookupTable(string);
            }
        }
        return inetAddressArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress[] checkLookupTable(String string) {
        InetAddress[] inetAddressArray = lookupTable;
        synchronized (lookupTable) {
            if (!lookupTable.containsKey(string)) {
                lookupTable.put(string, null);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            while (lookupTable.containsKey(string)) {
                try {
                    lookupTable.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            inetAddressArray = InetAddress.getCachedAddresses(string);
            if (inetAddressArray == null) {
                HashMap<String, Void> hashMap = lookupTable;
                synchronized (hashMap) {
                    lookupTable.put(string, null);
                    return null;
                }
            }
            return inetAddressArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookupTable(String string) {
        HashMap<String, Void> hashMap = lookupTable;
        synchronized (hashMap) {
            lookupTable.remove(string);
            lookupTable.notifyAll();
        }
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        return InetAddress.getByAddress(null, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager securityManager = System.getSecurityManager();
        try {
            String string = impl.getLocalHostName();
            if (securityManager != null) {
                securityManager.checkConnect(string, -1);
            }
            if (string.equals("localhost")) {
                return impl.loopbackAddress();
            }
            InetAddress inetAddress = null;
            Object object = cacheLock;
            synchronized (object) {
                long l = System.currentTimeMillis();
                if (cachedLocalHost != null) {
                    if (l - cacheTime < 5000L) {
                        inetAddress = cachedLocalHost;
                    } else {
                        cachedLocalHost = null;
                    }
                }
                if (inetAddress == null) {
                    InetAddress[] inetAddressArray;
                    try {
                        inetAddressArray = InetAddress.getAddressesFromNameService(string, null);
                    }
                    catch (UnknownHostException unknownHostException) {
                        UnknownHostException unknownHostException2 = new UnknownHostException(string + ": " + unknownHostException.getMessage());
                        unknownHostException2.initCause(unknownHostException);
                        throw unknownHostException2;
                    }
                    cachedLocalHost = inetAddressArray[0];
                    cacheTime = l;
                    inetAddress = inetAddressArray[0];
                }
            }
            return inetAddress;
        }
        catch (SecurityException securityException) {
            return impl.loopbackAddress();
        }
    }

    private static native void init();

    static InetAddress anyLocalAddress() {
        return impl.anyLocalAddress();
    }

    static InetAddressImpl loadImpl(String string) {
        Object var1_1 = null;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("impl.prefix", ""));
        try {
            var1_1 = Class.forName("java.net." + string2 + string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access class: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        if (var1_1 == null) {
            try {
                var1_1 = Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        return var1_1;
    }

    private void readObjectNoData(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("hostName", null);
        int n = getField.get("address", 0);
        int n2 = getField.get("family", 0);
        if (n2 != 1 && n2 != 2) {
            throw new InvalidObjectException("invalid address family type: " + n2);
        }
        InetAddressHolder inetAddressHolder = new InetAddressHolder(string, n, n2);
        UNSAFE.putObject((Object)this, FIELDS_OFFSET, (Object)inetAddressHolder);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("hostName", this.holder().hostName);
        putField.put("address", this.holder().address);
        putField.put("family", this.holder().family);
        objectOutputStream.writeFields();
    }

    static {
        NameService nameService;
        preferIPv6Address = false;
        nameServices = null;
        preferIPv6Address = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses"));
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        InetAddress.init();
        addressCache = new Cache(Cache.Type.Positive);
        negativeCache = new Cache(Cache.Type.Negative);
        addressCacheInit = false;
        lookupTable = new HashMap();
        impl = InetAddressImplFactory.create();
        Object object = null;
        String string = "sun.net.spi.nameservice.provider.";
        int n = 1;
        nameServices = new ArrayList<NameService>();
        object = AccessController.doPrivileged(new GetPropertyAction(string + n));
        while (object != null) {
            nameService = InetAddress.createNSProvider((String)object);
            if (nameService != null) {
                nameServices.add(nameService);
            }
            object = AccessController.doPrivileged(new GetPropertyAction(string + ++n));
        }
        if (nameServices.size() == 0) {
            nameService = InetAddress.createNSProvider("default");
            nameServices.add(nameService);
        }
        cachedLocalHost = null;
        cacheTime = 0L;
        cacheLock = new Object();
        try {
            object = Unsafe.getUnsafe();
            FIELDS_OFFSET = ((Unsafe)object).objectFieldOffset(InetAddress.class.getDeclaredField("holder"));
            UNSAFE = object;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("hostName", String.class), new ObjectStreamField("address", Integer.TYPE), new ObjectStreamField("family", Integer.TYPE)};
    }

    static final class Cache {
        private LinkedHashMap<String, CacheEntry> cache;
        private Type type;

        public Cache(Type type) {
            this.type = type;
            this.cache = new LinkedHashMap();
        }

        private int getPolicy() {
            if (this.type == Type.Positive) {
                return InetAddressCachePolicy.get();
            }
            return InetAddressCachePolicy.getNegative();
        }

        public Cache put(String string, InetAddress[] inetAddressArray) {
            int n = this.getPolicy();
            if (n == 0) {
                return this;
            }
            if (n != -1) {
                LinkedList<String> linkedList = new LinkedList<String>();
                long l = System.currentTimeMillis();
                for (String string2 : this.cache.keySet()) {
                    CacheEntry cacheEntry = this.cache.get(string2);
                    if (cacheEntry.expiration < 0L || cacheEntry.expiration >= l) break;
                    linkedList.add(string2);
                }
                for (String string2 : linkedList) {
                    this.cache.remove(string2);
                }
            }
            long l = n == -1 ? -1L : System.currentTimeMillis() + (long)(n * 1000);
            CacheEntry cacheEntry = new CacheEntry(inetAddressArray, l);
            this.cache.put(string, cacheEntry);
            return this;
        }

        public CacheEntry get(String string) {
            int n = this.getPolicy();
            if (n == 0) {
                return null;
            }
            CacheEntry cacheEntry = this.cache.get(string);
            if (cacheEntry != null && n != -1 && cacheEntry.expiration >= 0L && cacheEntry.expiration < System.currentTimeMillis()) {
                this.cache.remove(string);
                cacheEntry = null;
            }
            return cacheEntry;
        }

        static enum Type {
            Positive,
            Negative;

        }
    }

    static final class CacheEntry {
        InetAddress[] addresses;
        long expiration;

        CacheEntry(InetAddress[] inetAddressArray, long l) {
            this.addresses = inetAddressArray;
            this.expiration = l;
        }
    }

    static class InetAddressHolder {
        private String originalHostName;
        String hostName;
        int address;
        int family;

        InetAddressHolder() {
        }

        InetAddressHolder(String string, int n, int n2) {
            this.originalHostName = string;
            this.hostName = string;
            this.address = n;
            this.family = n2;
        }

        void init(String string, int n) {
            this.originalHostName = string;
            this.hostName = string;
            if (n != -1) {
                this.family = n;
            }
        }

        String getHostName() {
            return this.hostName;
        }

        String getOriginalHostName() {
            return this.originalHostName;
        }

        int getAddress() {
            return this.address;
        }

        int getFamily() {
            return this.family;
        }
    }
}

