/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.RenderingHints;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.AWTEventListener;
import java.awt.event.AWTEventListenerProxy;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.HeadlessToolkit;
import sun.awt.NullComponentPeer;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;
import sun.security.action.LoadLibraryAction;
import sun.security.util.SecurityConstants;
import sun.util.CoreResourceBundleControl;

public abstract class Toolkit {
    private static LightweightPeer lightweightMarker;
    private static Toolkit toolkit;
    private static String atNames;
    private static ResourceBundle resources;
    private static ResourceBundle platformResources;
    private static boolean loaded;
    protected final Map<String, Object> desktopProperties = new HashMap<String, Object>();
    protected final PropertyChangeSupport desktopPropsSupport = Toolkit.createPropertyChangeSupport(this);
    private static final int LONG_BITS = 64;
    private int[] calls = new int[64];
    private static volatile long enabledOnToolkitMask;
    private AWTEventListener eventListener = null;
    private WeakHashMap listener2SelectiveListener = new WeakHashMap();

    protected abstract DesktopPeer createDesktopPeer(Desktop var1) throws HeadlessException;

    protected abstract ButtonPeer createButton(Button var1) throws HeadlessException;

    protected abstract TextFieldPeer createTextField(TextField var1) throws HeadlessException;

    protected abstract LabelPeer createLabel(Label var1) throws HeadlessException;

    protected abstract ListPeer createList(List var1) throws HeadlessException;

    protected abstract CheckboxPeer createCheckbox(Checkbox var1) throws HeadlessException;

    protected abstract ScrollbarPeer createScrollbar(Scrollbar var1) throws HeadlessException;

    protected abstract ScrollPanePeer createScrollPane(ScrollPane var1) throws HeadlessException;

    protected abstract TextAreaPeer createTextArea(TextArea var1) throws HeadlessException;

    protected abstract ChoicePeer createChoice(Choice var1) throws HeadlessException;

    protected abstract FramePeer createFrame(Frame var1) throws HeadlessException;

    protected abstract CanvasPeer createCanvas(Canvas var1);

    protected abstract PanelPeer createPanel(Panel var1);

    protected abstract WindowPeer createWindow(Window var1) throws HeadlessException;

    protected abstract DialogPeer createDialog(Dialog var1) throws HeadlessException;

    protected abstract MenuBarPeer createMenuBar(MenuBar var1) throws HeadlessException;

    protected abstract MenuPeer createMenu(Menu var1) throws HeadlessException;

    protected abstract PopupMenuPeer createPopupMenu(PopupMenu var1) throws HeadlessException;

    protected abstract MenuItemPeer createMenuItem(MenuItem var1) throws HeadlessException;

    protected abstract FileDialogPeer createFileDialog(FileDialog var1) throws HeadlessException;

    protected abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1) throws HeadlessException;

    protected MouseInfoPeer getMouseInfoPeer() {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected LightweightPeer createComponent(Component component) {
        if (lightweightMarker == null) {
            lightweightMarker = new NullComponentPeer();
        }
        return lightweightMarker;
    }

    @Deprecated
    protected abstract FontPeer getFontPeer(String var1, int var2);

    protected void loadSystemColors(int[] nArray) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
    }

    public void setDynamicLayout(boolean bl) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
    }

    protected boolean isDynamicLayoutSet() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().isDynamicLayoutSet();
        }
        return false;
    }

    public boolean isDynamicLayoutActive() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().isDynamicLayoutActive();
        }
        return false;
    }

    public abstract Dimension getScreenSize() throws HeadlessException;

    public abstract int getScreenResolution() throws HeadlessException;

    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        }
        return new Insets(0, 0, 0, 0);
    }

    public abstract ColorModel getColorModel() throws HeadlessException;

    @Deprecated
    public abstract String[] getFontList();

    @Deprecated
    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void sync();

    private static void initAssistiveTechnologies() {
        final String string = File.separator;
        final Properties properties = new Properties();
        atNames = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object object;
                Object object2;
                try {
                    object2 = new File(System.getProperty("user.home") + string + ".accessibility.properties");
                    object = new FileInputStream((File)object2);
                    properties.load((InputStream)object);
                    ((FileInputStream)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (properties.size() == 0) {
                    try {
                        object2 = new File(System.getProperty("java.home") + string + "lib" + string + "accessibility.properties");
                        object = new FileInputStream((File)object2);
                        properties.load((InputStream)object);
                        ((FileInputStream)object).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((object2 = System.getProperty("javax.accessibility.screen_magnifier_present")) == null && (object2 = properties.getProperty("screen_magnifier_present", null)) != null) {
                    System.setProperty("javax.accessibility.screen_magnifier_present", (String)object2);
                }
                if ((object = System.getProperty("javax.accessibility.assistive_technologies")) == null && (object = properties.getProperty("assistive_technologies", null)) != null) {
                    System.setProperty("javax.accessibility.assistive_technologies", (String)object);
                }
                return object;
            }
        });
    }

    private static void loadAssistiveTechnologies() {
        if (atNames != null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            StringTokenizer stringTokenizer = new StringTokenizer(atNames, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                try {
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AWTError("Assistive Technology not found: " + string);
                }
                catch (InstantiationException instantiationException) {
                    throw new AWTError("Could not instantiate Assistive Technology: " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AWTError("Could not access Assistive Technology: " + string);
                }
                catch (Exception exception) {
                    throw new AWTError("Error trying to install Assistive Technology: " + string + " " + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Toolkit getDefaultToolkit() {
        if (toolkit == null) {
            try {
                Compiler.disable();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        String string = null;
                        Class<?> clazz = null;
                        try {
                            block9: {
                                string = System.getProperty("awt.toolkit");
                                try {
                                    clazz = Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                    if (classLoader == null) break block9;
                                    try {
                                        clazz = classLoader.loadClass(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException2) {
                                        throw new AWTError("Toolkit not found: " + string);
                                    }
                                }
                            }
                            if (clazz != null) {
                                Toolkit.toolkit = (Toolkit)clazz.newInstance();
                                if (GraphicsEnvironment.isHeadless()) {
                                    Toolkit.toolkit = (Toolkit)new HeadlessToolkit(toolkit);
                                }
                            }
                        }
                        catch (InstantiationException instantiationException) {
                            throw new AWTError("Could not instantiate Toolkit: " + string);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new AWTError("Could not access Toolkit: " + string);
                        }
                        return null;
                    }
                });
                Toolkit.loadAssistiveTechnologies();
            }
            finally {
                Compiler.enable();
            }
        }
        return toolkit;
    }

    public abstract Image getImage(String var1);

    public abstract Image getImage(URL var1);

    public abstract Image createImage(String var1);

    public abstract Image createImage(URL var1);

    public abstract boolean prepareImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract int checkImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract Image createImage(ImageProducer var1);

    public Image createImage(byte[] byArray) {
        return this.createImage(byArray, 0, byArray.length);
    }

    public abstract Image createImage(byte[] var1, int var2, int var3);

    public abstract PrintJob getPrintJob(Frame var1, String var2, Properties var3);

    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getPrintJob(frame, string, jobAttributes, pageAttributes);
        }
        return this.getPrintJob(frame, string, null);
    }

    public abstract void beep();

    public abstract Clipboard getSystemClipboard() throws HeadlessException;

    public Clipboard getSystemSelection() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getSystemSelection();
        }
        GraphicsEnvironment.checkHeadless();
        return null;
    }

    public int getMenuShortcutKeyMask() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        return 2;
    }

    public boolean getLockingKeyState(int n) throws UnsupportedOperationException {
        GraphicsEnvironment.checkHeadless();
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        throw new UnsupportedOperationException("Toolkit.getLockingKeyState");
    }

    public void setLockingKeyState(int n, boolean bl) throws UnsupportedOperationException {
        GraphicsEnvironment.checkHeadless();
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.setLockingKeyState");
        }
        throw new UnsupportedOperationException("Toolkit.setLockingKeyState");
    }

    protected static Container getNativeContainer(Component component) {
        return component.getNativeContainer();
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException, HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().createCustomCursor(image, point, string);
        }
        return new Cursor(0);
    }

    public Dimension getBestCursorSize(int n, int n2) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getBestCursorSize(n, n2);
        }
        return new Dimension(0, 0);
    }

    public int getMaximumCursorColors() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getMaximumCursorColors();
        }
        return 0;
    }

    public boolean isFrameStateSupported(int n) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().isFrameStateSupported(n);
        }
        return n == 0;
    }

    private static void setPlatformResources(ResourceBundle resourceBundle) {
        platformResources = resourceBundle;
    }

    private static native void initIDs();

    static void loadLibraries() {
        if (!loaded) {
            AccessController.doPrivileged(new LoadLibraryAction("awt"));
            loaded = true;
        }
    }

    public static String getProperty(String string, String string2) {
        if (platformResources != null) {
            try {
                return platformResources.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (resources != null) {
            try {
                return resources.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string2;
    }

    public final EventQueue getSystemEventQueue() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAwtEventQueueAccess();
        }
        return this.getSystemEventQueueImpl();
    }

    protected abstract EventQueue getSystemEventQueueImpl();

    static EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueueImpl();
    }

    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1) throws InvalidDnDOperationException;

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        return null;
    }

    public final synchronized Object getDesktopProperty(String string) {
        if (this instanceof HeadlessToolkit) {
            return ((HeadlessToolkit)this).getUnderlyingToolkit().getDesktopProperty(string);
        }
        if (this.desktopProperties.isEmpty()) {
            this.initializeDesktopProperties();
        }
        if (string.equals("awt.dynamicLayoutSupported")) {
            Object object = this.lazilyLoadDesktopProperty(string);
            return object;
        }
        Object object = this.desktopProperties.get(string);
        if (object == null && (object = this.lazilyLoadDesktopProperty(string)) != null) {
            this.setDesktopProperty(string, object);
        }
        if (object instanceof RenderingHints) {
            object = ((RenderingHints)object).clone();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDesktopProperty(String string, Object object) {
        Object object2;
        if (this instanceof HeadlessToolkit) {
            ((HeadlessToolkit)this).getUnderlyingToolkit().setDesktopProperty(string, object);
            return;
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            object2 = this.desktopProperties.get(string);
            this.desktopProperties.put(string, object);
        }
        if (object2 != null || object != null) {
            this.desktopPropsSupport.firePropertyChange(string, object2, object);
        }
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        return null;
    }

    protected void initializeDesktopProperties() {
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.desktopPropsSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.desktopPropsSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.desktopPropsSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.desktopPropsSupport.getPropertyChangeListeners(string);
    }

    public boolean isAlwaysOnTopSupported() {
        return true;
    }

    public abstract boolean isModalityTypeSupported(Dialog.ModalityType var1);

    public abstract boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType var1);

    private static AWTEventListener deProxyAWTEventListener(AWTEventListener aWTEventListener) {
        AWTEventListener aWTEventListener2 = aWTEventListener;
        if (aWTEventListener2 == null) {
            return null;
        }
        if (aWTEventListener instanceof AWTEventListenerProxy) {
            aWTEventListener2 = (AWTEventListener)((AWTEventListenerProxy)aWTEventListener).getListener();
        }
        return aWTEventListener2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAWTEventListener(AWTEventListener aWTEventListener, long l) {
        AWTEventListener aWTEventListener2 = Toolkit.deProxyAWTEventListener(aWTEventListener);
        if (aWTEventListener2 == null) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.ALL_AWT_EVENTS_PERMISSION);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)this.listener2SelectiveListener.get(aWTEventListener2);
            if (selectiveAWTEventListener == null) {
                selectiveAWTEventListener = new SelectiveAWTEventListener(aWTEventListener2, l);
                this.listener2SelectiveListener.put(aWTEventListener2, selectiveAWTEventListener);
                this.eventListener = ToolkitEventMulticaster.add(this.eventListener, selectiveAWTEventListener);
            }
            selectiveAWTEventListener.orEventMasks(l);
            enabledOnToolkitMask |= l;
            long l2 = l;
            for (int i = 0; i < 64 && l2 != 0L; l2 >>>= 1, ++i) {
                if ((l2 & 1L) == 0L) continue;
                int n = i;
                this.calls[n] = this.calls[n] + 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAWTEventListener(AWTEventListener aWTEventListener) {
        AWTEventListener aWTEventListener2 = Toolkit.deProxyAWTEventListener(aWTEventListener);
        if (aWTEventListener == null) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.ALL_AWT_EVENTS_PERMISSION);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)this.listener2SelectiveListener.get(aWTEventListener2);
            if (selectiveAWTEventListener != null) {
                this.listener2SelectiveListener.remove(aWTEventListener2);
                int[] nArray = selectiveAWTEventListener.getCalls();
                for (int i = 0; i < 64; ++i) {
                    int n = i;
                    this.calls[n] = this.calls[n] - nArray[i];
                    assert (this.calls[i] >= 0) : "Negative Listeners count";
                    if (this.calls[i] != 0) continue;
                    enabledOnToolkitMask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            this.eventListener = ToolkitEventMulticaster.remove(this.eventListener, selectiveAWTEventListener == null ? aWTEventListener2 : selectiveAWTEventListener);
        }
    }

    static boolean enabledOnToolkit(long l) {
        return (enabledOnToolkitMask & l) != 0L;
    }

    synchronized int countAWTEventListeners(long l) {
        int n = 0;
        while (l != 0L) {
            l >>>= 1;
            ++n;
        }
        return this.calls[--n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEventListener[] getAWTEventListeners() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.ALL_AWT_EVENTS_PERMISSION);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            EventListener[] eventListenerArray = ToolkitEventMulticaster.getListeners((EventListener)this.eventListener, AWTEventListener.class);
            AWTEventListener[] aWTEventListenerArray = new AWTEventListener[eventListenerArray.length];
            for (int i = 0; i < eventListenerArray.length; ++i) {
                SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)eventListenerArray[i];
                AWTEventListener aWTEventListener = selectiveAWTEventListener.getListener();
                aWTEventListenerArray[i] = new AWTEventListenerProxy(selectiveAWTEventListener.getEventMask(), aWTEventListener);
            }
            return aWTEventListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEventListener[] getAWTEventListeners(long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.ALL_AWT_EVENTS_PERMISSION);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            EventListener[] eventListenerArray = ToolkitEventMulticaster.getListeners((EventListener)this.eventListener, AWTEventListener.class);
            ArrayList<AWTEventListenerProxy> arrayList = new ArrayList<AWTEventListenerProxy>(eventListenerArray.length);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)eventListenerArray[i];
                if ((selectiveAWTEventListener.getEventMask() & l) != l) continue;
                arrayList.add(new AWTEventListenerProxy(selectiveAWTEventListener.getEventMask(), selectiveAWTEventListener.getListener()));
            }
            return arrayList.toArray(new AWTEventListener[0]);
        }
    }

    void notifyAWTEventListeners(AWTEvent aWTEvent) {
        if (this instanceof HeadlessToolkit) {
            ((HeadlessToolkit)this).getUnderlyingToolkit().notifyAWTEventListeners(aWTEvent);
            return;
        }
        AWTEventListener aWTEventListener = this.eventListener;
        if (aWTEventListener != null) {
            aWTEventListener.eventDispatched(aWTEvent);
        }
    }

    public abstract Map<TextAttribute, ?> mapInputMethodHighlight(InputMethodHighlight var1) throws HeadlessException;

    private static PropertyChangeSupport createPropertyChangeSupport(Toolkit toolkit) {
        if (toolkit instanceof SunToolkit || toolkit instanceof HeadlessToolkit) {
            return new DesktopPropertyChangeSupport(toolkit);
        }
        return new PropertyChangeSupport(toolkit);
    }

    public boolean areExtraMouseButtonsEnabled() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        return Toolkit.getDefaultToolkit().areExtraMouseButtonsEnabled();
    }

    static {
        loaded = false;
        AWTAccessor.setToolkitAccessor(new AWTAccessor.ToolkitAccessor(){

            @Override
            public void setPlatformResources(ResourceBundle resourceBundle) {
                Toolkit.setPlatformResources(resourceBundle);
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    resources = ResourceBundle.getBundle("sun.awt.resources.awt", Locale.getDefault(), ClassLoader.getSystemClassLoader(), CoreResourceBundleControl.getRBControlInstance());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                return null;
            }
        });
        Toolkit.loadLibraries();
        Toolkit.initAssistiveTechnologies();
        if (!GraphicsEnvironment.isHeadless()) {
            Toolkit.initIDs();
        }
    }

    private static class DesktopPropertyChangeSupport
    extends PropertyChangeSupport {
        private static final StringBuilder PROP_CHANGE_SUPPORT_KEY = new StringBuilder("desktop property change support key");
        private final Object source;

        public DesktopPropertyChangeSupport(Object object) {
            super(object);
            this.source = object;
        }

        @Override
        public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)AppContext.getAppContext().get(PROP_CHANGE_SUPPORT_KEY);
            if (null == propertyChangeSupport) {
                propertyChangeSupport = new PropertyChangeSupport(this.source);
                AppContext.getAppContext().put(PROP_CHANGE_SUPPORT_KEY, propertyChangeSupport);
            }
            propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
        }

        @Override
        public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)AppContext.getAppContext().get(PROP_CHANGE_SUPPORT_KEY);
            if (null != propertyChangeSupport) {
                propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
            }
        }

        @Override
        public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)AppContext.getAppContext().get(PROP_CHANGE_SUPPORT_KEY);
            if (null != propertyChangeSupport) {
                return propertyChangeSupport.getPropertyChangeListeners();
            }
            return new PropertyChangeListener[0];
        }

        @Override
        public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)AppContext.getAppContext().get(PROP_CHANGE_SUPPORT_KEY);
            if (null != propertyChangeSupport) {
                return propertyChangeSupport.getPropertyChangeListeners(string);
            }
            return new PropertyChangeListener[0];
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)AppContext.getAppContext().get(PROP_CHANGE_SUPPORT_KEY);
            if (null == propertyChangeSupport) {
                propertyChangeSupport = new PropertyChangeSupport(this.source);
                AppContext.getAppContext().put(PROP_CHANGE_SUPPORT_KEY, propertyChangeSupport);
            }
            propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)AppContext.getAppContext().get(PROP_CHANGE_SUPPORT_KEY);
            if (null != propertyChangeSupport) {
                propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public void firePropertyChange(final PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            String string = propertyChangeEvent.getPropertyName();
            if (object != null && object2 != null && object.equals(object2)) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)AppContext.getAppContext().get(PROP_CHANGE_SUPPORT_KEY);
                    if (null != propertyChangeSupport) {
                        propertyChangeSupport.firePropertyChange(propertyChangeEvent);
                    }
                }
            };
            AppContext appContext = AppContext.getAppContext();
            for (AppContext appContext2 : AppContext.getAppContexts()) {
                if (null == appContext2 || appContext2.isDisposed()) continue;
                if (appContext == appContext2) {
                    runnable.run();
                    continue;
                }
                PeerEvent peerEvent = new PeerEvent(this.source, runnable, 2L);
                SunToolkit.postEvent(appContext2, peerEvent);
            }
        }
    }

    private class SelectiveAWTEventListener
    implements AWTEventListener {
        AWTEventListener listener;
        private long eventMask;
        int[] calls = new int[64];

        public AWTEventListener getListener() {
            return this.listener;
        }

        public long getEventMask() {
            return this.eventMask;
        }

        public int[] getCalls() {
            return this.calls;
        }

        public void orEventMasks(long l) {
            this.eventMask |= l;
            for (int i = 0; i < 64 && l != 0L; l >>>= 1, ++i) {
                if ((l & 1L) == 0L) continue;
                int n = i;
                this.calls[n] = this.calls[n] + 1;
            }
        }

        SelectiveAWTEventListener(AWTEventListener aWTEventListener, long l) {
            this.listener = aWTEventListener;
            this.eventMask = l;
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            long l = 0L;
            l = this.eventMask & 1L;
            if (l != 0L && aWTEvent.id >= 100 && aWTEvent.id <= 103 || (l = this.eventMask & 2L) != 0L && aWTEvent.id >= 300 && aWTEvent.id <= 301 || (l = this.eventMask & 4L) != 0L && aWTEvent.id >= 1004 && aWTEvent.id <= 1005 || (l = this.eventMask & 8L) != 0L && aWTEvent.id >= 400 && aWTEvent.id <= 402 || (l = this.eventMask & 0x20000L) != 0L && aWTEvent.id == 507 || (l = this.eventMask & 0x20L) != 0L && (aWTEvent.id == 503 || aWTEvent.id == 506) || (l = this.eventMask & 0x10L) != 0L && aWTEvent.id != 503 && aWTEvent.id != 506 && aWTEvent.id != 507 && aWTEvent.id >= 500 && aWTEvent.id <= 507 || (l = this.eventMask & 0x40L) != 0L && aWTEvent.id >= 200 && aWTEvent.id <= 209 || (l = this.eventMask & 0x80L) != 0L && aWTEvent.id >= 1001 && aWTEvent.id <= 1001 || (l = this.eventMask & 0x100L) != 0L && aWTEvent.id >= 601 && aWTEvent.id <= 601 || (l = this.eventMask & 0x200L) != 0L && aWTEvent.id >= 701 && aWTEvent.id <= 701 || (l = this.eventMask & 0x400L) != 0L && aWTEvent.id >= 900 && aWTEvent.id <= 900 || (l = this.eventMask & 0x800L) != 0L && aWTEvent.id >= 1100 && aWTEvent.id <= 1101 || (l = this.eventMask & 0x2000L) != 0L && aWTEvent.id >= 800 && aWTEvent.id <= 801 || (l = this.eventMask & 0x4000L) != 0L && aWTEvent.id >= 1200 && aWTEvent.id <= 1200 || (l = this.eventMask & 0x8000L) != 0L && aWTEvent.id == 1400 || (l = this.eventMask & 0x10000L) != 0L && (aWTEvent.id == 1401 || aWTEvent.id == 1402) || (l = this.eventMask & 0x40000L) != 0L && aWTEvent.id == 209 || (l = this.eventMask & 0x80000L) != 0L && (aWTEvent.id == 207 || aWTEvent.id == 208) || (l = this.eventMask & Integer.MIN_VALUE) != 0L && aWTEvent instanceof UngrabEvent) {
                int n = 0;
                long l2 = l;
                while (l2 != 0L) {
                    l2 >>>= 1;
                    ++n;
                }
                --n;
                for (int i = 0; i < this.calls[n]; ++i) {
                    this.listener.eventDispatched(aWTEvent);
                }
            }
        }
    }

    private static class ToolkitEventMulticaster
    extends AWTEventMulticaster
    implements AWTEventListener {
        ToolkitEventMulticaster(AWTEventListener aWTEventListener, AWTEventListener aWTEventListener2) {
            super(aWTEventListener, aWTEventListener2);
        }

        static AWTEventListener add(AWTEventListener aWTEventListener, AWTEventListener aWTEventListener2) {
            if (aWTEventListener == null) {
                return aWTEventListener2;
            }
            if (aWTEventListener2 == null) {
                return aWTEventListener;
            }
            return new ToolkitEventMulticaster(aWTEventListener, aWTEventListener2);
        }

        static AWTEventListener remove(AWTEventListener aWTEventListener, AWTEventListener aWTEventListener2) {
            return (AWTEventListener)ToolkitEventMulticaster.removeInternal(aWTEventListener, aWTEventListener2);
        }

        @Override
        protected EventListener remove(EventListener eventListener) {
            if (eventListener == this.a) {
                return this.b;
            }
            if (eventListener == this.b) {
                return this.a;
            }
            AWTEventListener aWTEventListener = (AWTEventListener)ToolkitEventMulticaster.removeInternal(this.a, eventListener);
            AWTEventListener aWTEventListener2 = (AWTEventListener)ToolkitEventMulticaster.removeInternal(this.b, eventListener);
            if (aWTEventListener == this.a && aWTEventListener2 == this.b) {
                return this;
            }
            return ToolkitEventMulticaster.add(aWTEventListener, aWTEventListener2);
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            ((AWTEventListener)this.a).eventDispatched(aWTEvent);
            ((AWTEventListener)this.b).eventDispatched(aWTEvent);
        }
    }
}

