/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_th extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AL = "\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_AM = "\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_AZ = "\u0e2d\u0e32\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e44\u0e1a\u0e08\u0e32\u0e19";
        final String metaValue_BG = "\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22";
        final String metaValue_BI = "\u0e1a\u0e38\u0e23\u0e38\u0e19\u0e14\u0e35";
        final String metaValue_BW = "\u0e1a\u0e2d\u0e15\u0e2a\u0e27\u0e32\u0e19\u0e32";
        final String metaValue_BY = "\u0e40\u0e1a\u0e25\u0e32\u0e23\u0e38\u0e2a";
        final String metaValue_CN = "\u0e08\u0e35\u0e19";
        final String metaValue_CZ = "\u0e40\u0e0a\u0e47\u0e01";
        final String metaValue_DK = "\u0e40\u0e14\u0e19\u0e21\u0e32\u0e23\u0e4c\u0e01";
        final String metaValue_EE = "\u0e40\u0e2d\u0e2a\u0e42\u0e15\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_ES = "\u0e2a\u0e40\u0e1b\u0e19";
        final String metaValue_FI = "\u0e1f\u0e34\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c";
        final String metaValue_FJ = "\u0e1f\u0e34\u0e08\u0e34";
        final String metaValue_FR = "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a";
        final String metaValue_GE = "\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22";
        final String metaValue_GL = "\u0e01\u0e23\u0e35\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c";
        final String metaValue_HR = "\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22";
        final String metaValue_HU = "\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35";
        final String metaValue_ID = "\u0e2d\u0e34\u0e19\u0e42\u0e14\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22";
        final String metaValue_IS = "\u0e44\u0e2d\u0e0b\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c";
        final String metaValue_IT = "\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35";
        final String metaValue_JP = "\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19";
        final String metaValue_LA = "\u0e25\u0e32\u0e27";
        final String metaValue_LT = "\u0e25\u0e34\u0e17\u0e31\u0e27\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_LU = "\u0e25\u0e31\u0e01\u0e40\u0e0b\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01";
        final String metaValue_LV = "\u0e25\u0e31\u0e15\u0e40\u0e27\u0e35\u0e22";
        final String metaValue_MD = "\u0e21\u0e2d\u0e25\u0e42\u0e14\u0e27\u0e32";
        final String metaValue_MN = "\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22";
        final String metaValue_MT = "\u0e21\u0e2d\u0e25\u0e15\u0e32";
        final String metaValue_NO = "\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c";
        final String metaValue_NP = "\u0e40\u0e19\u0e1b\u0e32\u0e25";
        final String metaValue_NR = "\u0e19\u0e32\u0e2d\u0e39\u0e23\u0e39";
        final String metaValue_PH = "\u0e1f\u0e34\u0e25\u0e34\u0e1b\u0e1b\u0e34\u0e19\u0e2a\u0e4c";
        final String metaValue_PL = "\u0e42\u0e1b\u0e41\u0e25\u0e19\u0e14\u0e4c";
        final String metaValue_PT = "\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a";
        final String metaValue_PW = "\u0e1b\u0e32\u0e40\u0e25\u0e32";
        final String metaValue_RO = "\u0e42\u0e23\u0e21\u0e32\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_RS = "\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22";
        final String metaValue_RU = "\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22";
        final String metaValue_RW = "\u0e23\u0e27\u0e31\u0e19\u0e14\u0e32";
        final String metaValue_SE = "\u0e2a\u0e27\u0e35\u0e40\u0e14\u0e19";
        final String metaValue_SI = "\u0e2a\u0e42\u0e25\u0e27\u0e35\u0e40\u0e19\u0e35\u0e22";
        final String metaValue_SR = "\u0e0b\u0e39\u0e23\u0e34\u0e19\u0e32\u0e40\u0e21";
        final String metaValue_SY = "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22";
        final String metaValue_TH = "\u0e44\u0e17\u0e22";
        final String metaValue_TK = "\u0e42\u0e15\u0e40\u0e01\u0e40\u0e25\u0e32";
        final String metaValue_TO = "\u0e15\u0e2d\u0e07\u0e01\u0e32";
        final String metaValue_TR = "\u0e15\u0e38\u0e23\u0e01\u0e35";
        final String metaValue_TV = "\u0e15\u0e39\u0e27\u0e32\u0e25\u0e39";
        final String metaValue_UA = "\u0e22\u0e39\u0e40\u0e04\u0e23\u0e19";
        final String metaValue_UG = "\u0e22\u0e39\u0e01\u0e31\u0e19\u0e14\u0e32";
        final String metaValue_VN = "\u0e40\u0e27\u0e35\u0e22\u0e14\u0e19\u0e32\u0e21";
        final String metaValue_WS = "\u0e0b\u0e32\u0e21\u0e31\u0e27";
        final String metaValue_ae = "\u0e2d\u0e40\u0e27\u0e2a\u0e15\u0e30";
        final String metaValue_ar = "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a";
        final String metaValue_bo = "\u0e17\u0e34\u0e40\u0e1a\u0e15";
        final String metaValue_el = "\u0e01\u0e23\u0e35\u0e01";
        final String metaValue_gu = "\u0e04\u0e38\u0e0a\u0e23\u0e32\u0e15";
        final String metaValue_jv = "\u0e0a\u0e27\u0e32";
        final String metaValue_km = "\u0e40\u0e02\u0e21\u0e23";
        final String metaValue_kn = "\u0e01\u0e31\u0e19\u0e19\u0e32\u0e14\u0e32";
        final String metaValue_ko = "\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35";
        final String metaValue_la = "\u0e25\u0e30\u0e15\u0e34\u0e19";
        final String metaValue_ml = "\u0e21\u0e32\u0e25\u0e32\u0e22\u0e32\u0e25\u0e31\u0e21";
        final String metaValue_my = "\u0e1e\u0e21\u0e48\u0e32";
        final String metaValue_si = "\u0e2a\u0e34\u0e07\u0e2b\u0e25";
        final String metaValue_su = "\u0e0b\u0e38\u0e19\u0e14\u0e32";
        final String metaValue_ta = "\u0e17\u0e21\u0e34\u0e2c";
        final String metaValue_te = "\u0e40\u0e15\u0e25\u0e39\u0e01\u0e39";
        final String metaValue_tl = "\u0e15\u0e32\u0e01\u0e32\u0e25\u0e47\u0e2d\u0e01";
        final String metaValue_ban = "\u0e1a\u0e32\u0e2b\u0e25\u0e35";
        final String metaValue_bug = "\u0e1a\u0e39\u0e01\u0e34\u0e2a";
        final String metaValue_chr = "\u0e40\u0e0a\u0e2d\u0e42\u0e23\u0e01\u0e35";
        final String metaValue_cop = "\u0e04\u0e2d\u0e1b\u0e15\u0e34\u0e01";
        final String metaValue_got = "\u0e42\u0e01\u0e18\u0e34\u0e01";
        final String metaValue_men = "\u0e40\u0e21\u0e19\u0e40\u0e14";
        final String metaValue_nqo = "\u0e40\u0e2d\u0e47\u0e19\u0e42\u0e01";
        final String metaValue_peo = "\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e35\u0e22\u0e42\u0e1a\u0e23\u0e32\u0e13";
        final String metaValue_phn = "\u0e1f\u0e34\u0e19\u0e34\u0e40\u0e0a\u0e35\u0e22";
        final String metaValue_ssy = "\u0e0b\u0e32\u0e42\u0e2e";
        final String metaValue_uga = "\u0e22\u0e39\u0e01\u0e32\u0e23\u0e34\u0e15";
        final String metaValue_vai = "\u0e44\u0e27";
        final String metaValue_zbl = "\u0e1a\u0e25\u0e34\u0e2a\u0e0b\u0e34\u0e21\u0e42\u0e1a\u0e25\u0e2a\u0e4c";
        final String metaValue_Hans = "\u0e15\u0e31\u0e27\u0e22\u0e48\u0e2d";
        final String metaValue_Hant = "\u0e15\u0e31\u0e27\u0e40\u0e15\u0e47\u0e21";
        final String metaValue_key_nu = "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0e42\u0e04\u0e42\u0e25\u0e0d" },
            { "Ogam", "\u0e42\u0e2d\u0e04\u0e31\u0e21" },
            { "mwl", "\u0e21\u0e35\u0e23\u0e31\u0e19\u0e14\u0e32" },
            { "Zsym", "\u0e2a\u0e31\u0e0d\u0e25\u0e31\u0e01\u0e29\u0e13\u0e4c" },
            { "cch", "\u0e41\u0e2d\u0e15\u0e41\u0e0b\u0e21" },
            { "mwr", "\u0e21\u0e32\u0e23\u0e27\u0e32\u0e11\u0e35" },
            { "type.nu.lanatham", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e17\u0e17\u0e31\u0e21\u0e17\u0e31\u0e21" },
            { "egl", "\u0e40\u0e2d\u0e21\u0e35\u0e40\u0e25\u0e35\u0e22" },
            { "mwv", "\u0e40\u0e21\u0e47\u0e19\u0e15\u0e32\u0e44\u0e27" },
            { "Tagb", "\u0e15\u0e31\u0e01\u0e1a\u0e31\u0e19\u0e27\u0e32" },
            { "Zsye", "\u0e2d\u0e35\u0e42\u0e21\u0e08\u0e34" },
            { "%%NJIVA", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e08\u0e19\u0e35\u0e27\u0e32/\u0e19\u0e08\u0e35\u0e27\u0e32" },
            { "xmf", "\u0e40\u0e21\u0e40\u0e01\u0e23\u0e40\u0e25\u0e35\u0e22" },
            { "egy", "\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "raj", "\u0e23\u0e32\u0e0a\u0e2a\u0e16\u0e32\u0e19" },
            { "Phag", "\u0e1f\u0e32\u0e01\u0e2a\u0e4c-\u0e1b\u0e32" },
            { "tem", "\u0e17\u0e34\u0e21\u0e40\u0e19" },
            { "teo", "\u0e40\u0e15\u0e42\u0e0b" },
            { "rap", "\u0e23\u0e32\u0e1b\u0e32\u0e19\u0e39" },
            { "ter", "\u0e40\u0e17\u0e40\u0e23\u0e42\u0e19" },
            { "AC", "\u0e40\u0e01\u0e32\u0e30\u0e41\u0e2d\u0e2a\u0e40\u0e0b\u0e19\u0e0a\u0e31\u0e19" },
            { "rar", "\u0e23\u0e32\u0e42\u0e23\u0e17\u0e2d\u0e07\u0e01\u0e32" },
            { "tet", "\u0e40\u0e15\u0e15\u0e38\u0e21" },
            { "AD", "\u0e2d\u0e31\u0e19\u0e14\u0e2d\u0e23\u0e4c\u0e23\u0e32" },
            { "AE", "\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e40\u0e2d\u0e21\u0e34\u0e40\u0e23\u0e15\u0e2a\u0e4c" },
            { "nl_BE", "\u0e40\u0e1f\u0e25\u0e21\u0e34\u0e0a" },
            { "AF", "\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "AG", "\u0e41\u0e2d\u0e19\u0e15\u0e34\u0e01\u0e32\u0e41\u0e25\u0e30\u0e1a\u0e32\u0e23\u0e4c\u0e1a\u0e39\u0e14\u0e32" },
            { "type.ca.ethiopic", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22" },
            { "glk", "\u0e01\u0e34\u0e25\u0e32\u0e01\u0e35" },
            { "AI", "\u0e41\u0e2d\u0e07\u0e01\u0e27\u0e34\u0e25\u0e25\u0e32" },
            { "key.tz", "\u0e40\u0e02\u0e15\u0e40\u0e27\u0e25\u0e32" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "Teng", "\u0e40\u0e17\u0e07\u0e01\u0e27\u0e32\u0e23\u0e4c" },
            { "AO", "\u0e41\u0e2d\u0e07\u0e42\u0e01\u0e25\u0e32" },
            { "AQ", "\u0e41\u0e2d\u0e19\u0e15\u0e32\u0e23\u0e4c\u0e01\u0e15\u0e34\u0e01\u0e32" },
            { "AR", "\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32" },
            { "Prti", "\u0e1e\u0e32\u0e23\u0e4c\u0e40\u0e17\u0e35\u0e22\u0e2d\u0e34\u0e19\u0e2a\u0e04\u0e23\u0e34\u0e1b\u0e0a\u0e31\u0e19\u0e41\u0e19\u0e25" },
            { "AS", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19\u0e0b\u0e32\u0e21\u0e31\u0e27" },
            { "AT", "\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e35\u0e22" },
            { "AU", "\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22" },
            { "AW", "\u0e2d\u0e32\u0e23\u0e39\u0e1a\u0e32" },
            { "en_US", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 - \u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19" },
            { "AX", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e2d\u0e25\u0e31\u0e19\u0e14\u0e4c" },
            { "mye", "\u0e21\u0e22\u0e35\u0e19" },
            { "AZ", metaValue_AZ },
            { "%%AREVELA", "\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "BA", "\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22\u0e41\u0e25\u0e30\u0e40\u0e2e\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e42\u0e01\u0e27\u0e35\u0e19\u0e32" },
            { "BB", "\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e1a\u0e42\u0e14\u0e2a" },
            { "ceb", "\u0e40\u0e0b\u0e1a\u0e39" },
            { "BD", "\u0e1a\u0e31\u0e07\u0e01\u0e25\u0e32\u0e40\u0e17\u0e28" },
            { "kum", "\u0e04\u0e39\u0e21\u0e37\u0e22\u0e04\u0e4c" },
            { "BE", "\u0e40\u0e1a\u0e25\u0e40\u0e22\u0e35\u0e22\u0e21" },
            { "gmh", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2a\u0e39\u0e07\u0e01\u0e25\u0e32\u0e07" },
            { "BF", "\u0e1a\u0e39\u0e23\u0e4c\u0e01\u0e34\u0e19\u0e32\u0e1f\u0e32\u0e42\u0e0b" },
            { "BG", metaValue_BG },
            { "BH", "\u0e1a\u0e32\u0e2b\u0e4c\u0e40\u0e23\u0e19" },
            { "BI", metaValue_BI },
            { "BJ", "\u0e40\u0e1a\u0e19\u0e34\u0e19" },
            { "BL", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e18\u0e40\u0e25\u0e21\u0e35" },
            { "BM", "\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e21\u0e34\u0e27\u0e14\u0e32" },
            { "kut", "\u0e04\u0e39\u0e40\u0e17\u0e44\u0e19" },
            { "myv", "\u0e40\u0e2d\u0e35\u0e22\u0e23\u0e4c\u0e0b\u0e22\u0e32" },
            { "BN", "\u0e1a\u0e23\u0e39\u0e44\u0e19" },
            { "BO", "\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22" },
            { "BQ", "\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e41\u0e04\u0e23\u0e34\u0e1a\u0e40\u0e1a\u0e35\u0e22\u0e19" },
            { "BR", "\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25" },
            { "BS", "\u0e1a\u0e32\u0e2e\u0e32\u0e21\u0e32\u0e2a" },
            { "xog", "\u0e42\u0e0b\u0e01\u0e32" },
            { "BT", "\u0e20\u0e39\u0e0f\u0e32\u0e19" },
            { "BV", "\u0e40\u0e01\u0e32\u0e30\u0e1a\u0e39\u0e40\u0e27\u0e15" },
            { "BW", metaValue_BW },
            { "BY", metaValue_BY },
            { "BZ", "\u0e40\u0e1a\u0e25\u0e35\u0e0b" },
            { "Visp", "\u0e04\u0e33\u0e1e\u0e39\u0e14\u0e17\u0e35\u0e48\u0e21\u0e2d\u0e07\u0e40\u0e2b\u0e47\u0e19\u0e44\u0e14\u0e49" },
            { "type.ca.persian", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e40\u0e0a\u0e35\u0e22" },
            { "type.nu.hebr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2e\u0e34\u0e1a\u0e23\u0e39" },
            { "CA", "\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32" },
            { "CC", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e04\u0e42\u0e04\u0e2a (\u0e04\u0e35\u0e25\u0e34\u0e07)" },
            { "mzn", "\u0e21\u0e32\u0e0b\u0e31\u0e19\u0e14\u0e32\u0e23\u0e32\u0e19\u0e35" },
            { "CD", "\u0e04\u0e2d\u0e07\u0e42\u0e01 - \u0e01\u0e34\u0e19\u0e0a\u0e32\u0e0b\u0e32" },
            { "CF", "\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07" },
            { "CG", "\u0e04\u0e2d\u0e07\u0e42\u0e01 - \u0e1a\u0e23\u0e32\u0e0b\u0e0b\u0e32\u0e27\u0e34\u0e25" },
            { "CH", "\u0e2a\u0e27\u0e34\u0e15\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "CI", "\u0e42\u0e01\u0e15\u0e14\u0e34\u0e27\u0e31\u0e27\u0e23\u0e4c" },
            { "CK", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e04\u0e38\u0e01" },
            { "CL", "\u0e0a\u0e34\u0e25\u0e35" },
            { "Kthi", "\u0e01\u0e32\u0e22\u0e15\u0e34" },
            { "CM", "\u0e41\u0e04\u0e40\u0e21\u0e2d\u0e23\u0e39\u0e19" },
            { "CN", metaValue_CN },
            { "CO", "\u0e42\u0e04\u0e25\u0e2d\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "CP", "\u0e40\u0e01\u0e32\u0e30\u0e04\u0e25\u0e34\u0e1b\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e15\u0e31\u0e19" },
            { "CR", "\u0e04\u0e2d\u0e2a\u0e15\u0e32\u0e23\u0e34\u0e01\u0e32" },
            { "CU", "\u0e04\u0e34\u0e27\u0e1a\u0e32" },
            { "CV", "\u0e40\u0e04\u0e1b\u0e40\u0e27\u0e34\u0e23\u0e4c\u0e14" },
            { "CW", "\u0e04\u0e39\u0e23\u0e32\u0e40\u0e0b\u0e32" },
            { "CX", "\u0e40\u0e01\u0e32\u0e30\u0e04\u0e23\u0e34\u0e2a\u0e15\u0e4c\u0e21\u0e32\u0e2a" },
            { "CY", "\u0e44\u0e0b\u0e1b\u0e23\u0e31\u0e2a" },
            { "type.nu.bali", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1a\u0e32\u0e2b\u0e25\u0e35" },
            { "CZ", metaValue_CZ },
            { "eka", "\u0e2d\u0e35\u0e01\u0e32\u0e08\u0e38\u0e01" },
            { "Pauc", "\u0e1b\u0e48\u0e2d\u0e08\u0e34\u0e49\u0e07\u0e2e\u0e2d" },
            { "vls", "\u0e40\u0e1f\u0e25\u0e21\u0e34\u0e0a\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "%%RIGIK", "\u0e42\u0e27\u0e25\u0e32\u0e1e\u0e36\u0e04\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "DE", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e19\u0e35" },
            { "goh", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2a\u0e39\u0e07\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "ace", "\u0e2d\u0e32\u0e40\u0e08\u0e30\u0e2b\u0e4c" },
            { "cgg", "\u0e04\u0e35\u0e01\u0e32" },
            { "DG", "\u0e14\u0e34\u0e40\u0e2d\u0e42\u0e01\u0e01\u0e32\u0e23\u0e4c\u0e40\u0e0b\u0e35\u0e22" },
            { "gom", "\u0e01\u0e2d\u0e19\u0e01\u0e32\u0e19\u0e35\u0e02\u0e2d\u0e07\u0e01\u0e31\u0e27" },
            { "type.nu.deva", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e17\u0e27\u0e19\u0e32\u0e04\u0e23\u0e35" },
            { "DJ", "\u0e08\u0e34\u0e1a\u0e39\u0e15\u0e35" },
            { "DK", metaValue_DK },
            { "ach", "\u0e2d\u0e32\u0e42\u0e04\u0e25\u0e34" },
            { "gon", "\u0e01\u0e2d\u0e19\u0e14\u0e34" },
            { "Brai", "\u0e40\u0e1a\u0e23\u0e25\u0e25\u0e4c" },
            { "Brah", "\u0e1e\u0e23\u0e32\u0e2b\u0e21\u0e35" },
            { "DM", "\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e32" },
            { "type.nu.armnlow", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22\u0e1e\u0e34\u0e21\u0e1e\u0e4c\u0e40\u0e25\u0e47\u0e01" },
            { "DO", "\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e31\u0e19" },
            { "gor", "\u0e01\u0e2d\u0e23\u0e2d\u0e19\u0e17\u0e32\u0e42\u0e25" },
            { "got", metaValue_got },
            { "vmf", "\u0e40\u0e21\u0e19-\u0e1f\u0e23\u0e32\u0e19\u0e42\u0e01\u0e40\u0e19\u0e35\u0e22" },
            { "Mtei", "\u0e40\u0e21\u0e40\u0e17\u0e21\u0e32\u0e40\u0e22\u0e01" },
            { "zun", "\u0e0b\u0e39\u0e19\u0e34" },
            { "tig", "\u0e15\u0e35\u0e40\u0e01\u0e23" },
            { "Takr", "\u0e17\u0e32\u0e04\u0e23\u0e35" },
            { "DZ", "\u0e41\u0e2d\u0e25\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "type.d0.hwidth", metaValue_Hans },
            { "pag", "\u0e1b\u0e32\u0e07\u0e32\u0e0b\u0e35\u0e19\u0e31\u0e19" },
            { "pal", "\u0e1b\u0e30\u0e2b\u0e4c\u0e25\u0e32\u0e27\u0e35" },
            { "EA", "\u0e40\u0e0b\u0e27\u0e15\u0e32\u0e41\u0e25\u0e30\u0e40\u0e21\u0e25\u0e35\u0e22\u0e32" },
            { "chb", "\u0e0a\u0e34\u0e1a\u0e0a\u0e32" },
            { "pam", "\u0e1b\u0e31\u0e21\u0e1b\u0e32\u0e07\u0e32" },
            { "EC", "\u0e40\u0e2d\u0e01\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c" },
            { "pap", "\u0e1b\u0e32\u0e40\u0e1b\u0e35\u0e22\u0e40\u0e21\u0e19\u0e42\u0e15" },
            { "ada", "\u0e2d\u0e32\u0e41\u0e14\u0e07\u0e21\u0e35" },
            { "EE", metaValue_EE },
            { "tiv", "\u0e17\u0e34\u0e1f" },
            { "EG", "\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "EH", "\u0e0b\u0e32\u0e2e\u0e32\u0e23\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "chg", "\u0e0a\u0e30\u0e01\u0e30\u0e44\u0e15" },
            { "pau", metaValue_PW },
            { "chk", "\u0e0a\u0e39\u0e01" },
            { "chn", "\u0e0a\u0e34\u0e19\u0e38\u0e01\u0e08\u0e32\u0e23\u0e4c\u0e01\u0e2d\u0e19" },
            { "chm", "\u0e21\u0e32\u0e23\u0e35" },
            { "chp", "\u0e0a\u0e34\u0e1e\u0e34\u0e27\u0e22\u0e31\u0e19" },
            { "cho", "\u0e0a\u0e47\u0e2d\u0e01\u0e17\u0e2d\u0e27\u0e4c" },
            { "chr", metaValue_chr },
            { "ER", "\u0e40\u0e2d\u0e23\u0e34\u0e40\u0e17\u0e23\u0e35\u0e22" },
            { "ES", metaValue_ES },
            { "ET", "\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22" },
            { "EU", "\u0e2a\u0e2b\u0e20\u0e32\u0e1e\u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "elx", "\u0e2d\u0e35\u0e25\u0e32\u0e44\u0e21\u0e15\u0e4c" },
            { "type.ca.gregorian", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e40\u0e01\u0e23\u0e01\u0e2d\u0e40\u0e23\u0e35\u0e22\u0e19" },
            { "EZ", "\u0e22\u0e39\u0e42\u0e23\u0e42\u0e0b\u0e19" },
            { "chy", "\u0e40\u0e0a\u0e40\u0e22\u0e19\u0e40\u0e19" },
            { "type.nu.gujr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e04\u0e38\u0e0a\u0e23\u0e32\u0e15" },
            { "Inds", "\u0e2d\u0e34\u0e19\u0e14\u0e31\u0e2a" },
            { "ady", "\u0e2d\u0e30\u0e14\u0e37\u0e22\u0e40\u0e01" },
            { "aeb", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e15\u0e39\u0e19\u0e34\u0e40\u0e0b\u0e35\u0e22" },
            { "FI", metaValue_FI },
            { "FJ", metaValue_FJ },
            { "FK", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1f\u0e2d\u0e25\u0e4c\u0e01\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "FM", "\u0e44\u0e21\u0e42\u0e04\u0e23\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "key.va", "\u0e15\u0e31\u0e27\u0e41\u0e1b\u0e23\u0e20\u0e32\u0e29\u0e32\u0e16\u0e34\u0e48\u0e19" },
            { "FO", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e41\u0e1f\u0e42\u0e23" },
            { "Taml", metaValue_ta },
            { "FR", metaValue_FR },
            { "Kpel", "\u0e40\u0e1b\u0e25\u0e40\u0e25" },
            { "pcd", "\u0e1b\u0e34\u0e01\u0e32\u0e23\u0e4c" },
            { "tkl", metaValue_TK },
            { "grb", "\u0e40\u0e01\u0e23\u0e42\u0e1a" },
            { "root", "\u0e23\u0e39\u0e17" },
            { "%%DAJNKO", "\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e14\u0e32\u0e22\u0e19\u0e0a\u0e34\u0e0b\u0e32" },
            { "type.ca.indian", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e41\u0e2b\u0e48\u0e07\u0e0a\u0e32\u0e15\u0e34\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22" },
            { "rgn", "\u0e42\u0e23\u0e21\u0e31\u0e13\u0e42\u0e0d" },
            { "grc", "\u0e01\u0e23\u0e35\u0e01\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "GA", "\u0e01\u0e32\u0e1a\u0e2d\u0e07" },
            { "tkr", "\u0e41\u0e0b\u0e04\u0e40\u0e0b\u0e2d\u0e23\u0e4c" },
            { "vot", "\u0e42\u0e27\u0e17\u0e34\u0e01" },
            { "GB", "\u0e2a\u0e2b\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23" },
            { "pcm", "\u0e1e\u0e34\u0e14\u0e08\u0e34\u0e19" },
            { "GD", "\u0e40\u0e01\u0e23\u0e40\u0e19\u0e14\u0e32" },
            { "GE", metaValue_GE },
            { "GF", "\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e40\u0e01\u0e35\u0e22\u0e19\u0e32" },
            { "GG", "\u0e40\u0e01\u0e34\u0e23\u0e4c\u0e19\u0e0b\u0e35\u0e22\u0e4c" },
            { "GH", "\u0e01\u0e32\u0e19\u0e32" },
            { "Tale", "\u0e44\u0e17\u0e40\u0e25" },
            { "GI", "\u0e22\u0e34\u0e1a\u0e23\u0e2d\u0e25\u0e15\u0e32\u0e23\u0e4c" },
            { "afh", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e2e\u0e35\u0e25\u0e35" },
            { "GL", metaValue_GL },
            { "enm", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e01\u0e25\u0e32\u0e07" },
            { "GM", "\u0e41\u0e01\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "GN", "\u0e01\u0e34\u0e19\u0e35" },
            { "GP", "\u0e01\u0e27\u0e32\u0e40\u0e14\u0e2d\u0e25\u0e39\u0e1b" },
            { "GQ", "\u0e2d\u0e34\u0e40\u0e04\u0e27\u0e17\u0e2d\u0e40\u0e23\u0e35\u0e22\u0e25\u0e01\u0e34\u0e19\u0e35" },
            { "GR", "\u0e01\u0e23\u0e35\u0e0b" },
            { "GS", "\u0e40\u0e01\u0e32\u0e30\u0e40\u0e0b\u0e32\u0e17\u0e4c\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22\u0e41\u0e25\u0e30\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e0b\u0e32\u0e17\u0e4c\u0e41\u0e0b\u0e19\u0e14\u0e4c\u0e27\u0e34\u0e0a" },
            { "GT", "\u0e01\u0e31\u0e27\u0e40\u0e15\u0e21\u0e32\u0e25\u0e32" },
            { "GU", "\u0e01\u0e27\u0e21" },
            { "pdc", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e40\u0e1e\u0e19\u0e0b\u0e34\u0e25\u0e40\u0e27\u0e40\u0e19\u0e35\u0e22" },
            { "GW", "\u0e01\u0e34\u0e19\u0e35-\u0e1a\u0e34\u0e2a\u0e40\u0e0b\u0e32" },
            { "tli", "\u0e17\u0e25\u0e34\u0e07\u0e01\u0e34\u0e15" },
            { "tlh", "\u0e04\u0e25\u0e34\u0e07\u0e07\u0e2d\u0e19" },
            { "Talu", "\u0e44\u0e17\u0e25\u0e37\u0e49\u0e2d\u0e43\u0e2b\u0e21\u0e48" },
            { "GY", "\u0e01\u0e32\u0e22\u0e2d\u0e32\u0e19\u0e32" },
            { "ckb", "\u0e40\u0e04\u0e34\u0e23\u0e4c\u0e14\u0e15\u0e2d\u0e19\u0e01\u0e25\u0e32\u0e07" },
            { "zxx", "\u0e44\u0e21\u0e48\u0e21\u0e35\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e20\u0e32\u0e29\u0e32" },
            { "Jurc", "\u0e08\u0e39\u0e23\u0e4c\u0e40\u0e0a\u0e19" },
            { "tly", "\u0e17\u0e32\u0e25\u0e34\u0e0a" },
            { "pdt", "\u0e40\u0e1e\u0e25\u0e32\u0e17\u0e4c\u0e14\u0e34\u0e0a" },
            { "de_AT", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19 - \u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e35\u0e22" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e2e\u0e48\u0e2d\u0e07\u0e01\u0e07\u0e41\u0e2b\u0e48\u0e07\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e1b\u0e23\u0e30\u0e0a\u0e32\u0e0a\u0e19\u0e08\u0e35\u0e19" },
            { "HM", "\u0e40\u0e01\u0e32\u0e30\u0e40\u0e2e\u0e34\u0e23\u0e4c\u0e14\u0e41\u0e25\u0e30\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e41\u0e21\u0e01\u0e14\u0e2d\u0e19\u0e31\u0e25\u0e14\u0e4c" },
            { "HN", "\u0e2e\u0e2d\u0e19\u0e14\u0e39\u0e23\u0e31\u0e2a" },
            { "HR", metaValue_HR },
            { "agq", "\u0e2d\u0e31\u0e01\u0e40\u0e2e\u0e21" },
            { "gsw", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2a\u0e27\u0e34\u0e2a" },
            { "type.ca.islamic-umalqura", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2d\u0e34\u0e2a\u0e25\u0e32\u0e21 (\u0e2d\u0e38\u0e21\u0e21\u0e4c\u0e2d\u0e31\u0e25\u0e01\u0e38\u0e23\u0e32)" },
            { "HT", "\u0e40\u0e2e\u0e15\u0e34" },
            { "HU", metaValue_HU },
            { "rif", "\u0e23\u0e34\u0e1f\u0e1f\u0e34\u0e2d\u0e31\u0e19" },
            { "tmh", "\u0e17\u0e32\u0e21\u0e32\u0e40\u0e0a\u0e01" },
            { "IC", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e04\u0e32\u0e19\u0e32\u0e23\u0e35" },
            { "nan", "\u0e08\u0e35\u0e19\u0e21\u0e34\u0e19\u0e2b\u0e19\u0e32\u0e19" },
            { "ID", metaValue_ID },
            { "peo", metaValue_peo },
            { "type.nu.kali", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e04\u0e22\u0e32\u0e2b\u0e4c" },
            { "IE", "\u0e44\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "nap", "\u0e19\u0e32\u0e42\u0e1b\u0e25\u0e35" },
            { "%%NDYUKA", "\u0e14\u0e34\u0e27\u0e04\u0e32" },
            { "naq", "\u0e19\u0e32\u0e21\u0e32" },
            { "type.nu.sora", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e2a\u0e23\u0e32\u0e2a\u0e21\u0e40\u0e1b\u0e47\u0e07" },
            { "zza", "\u0e0b\u0e32\u0e0b\u0e32" },
            { "Tang", "\u0e15\u0e31\u0e19\u0e01\u0e31\u0e17" },
            { "IL", "\u0e2d\u0e34\u0e2a\u0e23\u0e32\u0e40\u0e2d\u0e25" },
            { "Nbat", "\u0e19\u0e32\u0e1a\u0e32\u0e17\u0e32\u0e40\u0e2d\u0e35\u0e22\u0e19" },
            { "IM", "\u0e40\u0e01\u0e32\u0e30\u0e41\u0e21\u0e19" },
            { "IN", "\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22" },
            { "type.co.eor", "\u0e01\u0e0e\u0e01\u0e32\u0e23\u0e40\u0e23\u0e35\u0e22\u0e07\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e15\u0e32\u0e21\u0e41\u0e1a\u0e1a\u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "IO", "\u0e1a\u0e23\u0e34\u0e15\u0e34\u0e0a\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22\u0e19\u0e42\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e19\u0e40\u0e17\u0e23\u0e4c\u0e23\u0e34\u0e17\u0e2d\u0e23\u0e35" },
            { "IQ", "\u0e2d\u0e34\u0e23\u0e31\u0e01" },
            { "IR", "\u0e2d\u0e34\u0e2b\u0e23\u0e48\u0e32\u0e19" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "Zmth", "\u0e40\u0e04\u0e23\u0e37\u0e48\u0e2d\u0e07\u0e2b\u0e21\u0e32\u0e22\u0e17\u0e32\u0e07\u0e04\u0e13\u0e34\u0e15\u0e28\u0e32\u0e2a\u0e15\u0e23\u0e4c" },
            { "type.nu.thai", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e17\u0e22" },
            { "vro", "\u0e42\u0e27\u0e42\u0e23" },
            { "guc", "\u0e27\u0e32\u0e22\u0e39" },
            { "%%POSIX", "\u0e04\u0e2d\u0e21\u0e1e\u0e34\u0e27\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "type.nu.beng", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1a\u0e31\u0e07\u0e01\u0e25\u0e32\u0e40\u0e17\u0e28" },
            { "pfl", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e1e\u0e32\u0e25\u0e32\u0e17\u0e34\u0e40\u0e19\u0e15" },
            { "JE", "\u0e40\u0e08\u0e2d\u0e23\u0e4c\u0e0b\u0e35\u0e22\u0e4c" },
            { "type.ca.islamic", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2d\u0e34\u0e2a\u0e25\u0e32\u0e21" },
            { "JM", "\u0e08\u0e32\u0e40\u0e21\u0e01\u0e32" },
            { "Beng", "\u0e40\u0e1a\u0e07\u0e01\u0e32\u0e25\u0e35" },
            { "JO", "\u0e08\u0e2d\u0e23\u0e4c\u0e41\u0e14\u0e19" },
            { "gur", "\u0e1f\u0e23\u0e32\u0e1f\u0e23\u0e32" },
            { "JP", metaValue_JP },
            { "%%1606NICT", "\u0e1b\u0e25\u0e32\u0e22\u0e22\u0e38\u0e04\u0e01\u0e25\u0e32\u0e07\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a\u0e16\u0e36\u0e07\u0e1b\u0e35 \u0e04.\u0e28. 1606" },
            { "ain", "\u0e44\u0e2d\u0e19\u0e38" },
            { "Mend", metaValue_men },
            { "guz", "\u0e01\u0e38\u0e0b\u0e0b\u0e35" },
            { "tog", "\u0e44\u0e19\u0e2d\u0e30\u0e0b\u0e32\u0e15\u0e2d\u0e07\u0e01\u0e32" },
            { "type.nu.knda", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e01\u0e31\u0e19\u0e19\u0e32\u0e14\u0e32" },
            { "Kali", "\u0e04\u0e22\u0e32\u0e2b\u0e4c" },
            { "Sidd", "\u0e2a\u0e34\u0e17\u0e18\u0e31\u0e21" },
            { "de_CH", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2a\u0e39\u0e07 (\u0e2a\u0e27\u0e34\u0e2a)" },
            { "type.co.phonetic", "\u0e25\u0e33\u0e14\u0e31\u0e01\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e04\u0e33\u0e2d\u0e48\u0e32\u0e19" },
            { "izh", "\u0e2d\u0e34\u0e19\u0e40\u0e01\u0e23\u0e35\u0e22\u0e19" },
            { "type.ca.buddhist", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e1e\u0e38\u0e17\u0e18" },
            { "KE", "\u0e40\u0e04\u0e19\u0e22\u0e32" },
            { "419", "\u0e25\u0e30\u0e15\u0e34\u0e19\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "KG", "\u0e04\u0e35\u0e23\u0e4c\u0e01\u0e35\u0e0b\u0e2a\u0e16\u0e32\u0e19" },
            { "KH", "\u0e01\u0e31\u0e21\u0e1e\u0e39\u0e0a\u0e32" },
            { "KI", "\u0e04\u0e34\u0e23\u0e34\u0e1a\u0e32\u0e2a" },
            { "KM", "\u0e04\u0e2d\u0e42\u0e21\u0e42\u0e23\u0e2a" },
            { "Knda", metaValue_kn },
            { "KN", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e04\u0e34\u0e15\u0e2a\u0e4c\u0e41\u0e25\u0e30\u0e40\u0e19\u0e27\u0e34\u0e2a" },
            { "Zinh", "\u0e2d\u0e34\u0e19\u0e40\u0e2e\u0e2d\u0e23\u0e34\u0e15" },
            { "fr_CA", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a - \u0e41\u0e04\u0e19\u0e32\u0e14\u0e32" },
            { "KP", "\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "KR", "\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e43\u0e15\u0e49" },
            { "Plrd", "\u0e2a\u0e31\u0e17\u0e28\u0e32\u0e2a\u0e15\u0e23\u0e4c\u0e1e\u0e2d\u0e25\u0e25\u0e32\u0e23\u0e4c\u0e14" },
            { "fr_CH", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a (\u0e2a\u0e27\u0e34\u0e2a)" },
            { "KW", "\u0e04\u0e39\u0e40\u0e27\u0e15" },
            { "tpi", "\u0e17\u0e47\u0e2d\u0e01\u0e1e\u0e34\u0e0b\u0e34\u0e19" },
            { "KY", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e04\u0e22\u0e4c\u0e41\u0e21\u0e19" },
            { "KZ", "\u0e04\u0e32\u0e0b\u0e31\u0e04\u0e2a\u0e16\u0e32\u0e19" },
            { "Cyrl", "\u0e0b\u0e35\u0e23\u0e34\u0e25\u0e25\u0e34\u0e01" },
            { "LA", metaValue_LA },
            { "LB", "\u0e40\u0e25\u0e1a\u0e32\u0e19\u0e2d\u0e19" },
            { "phn", metaValue_phn },
            { "LC", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e25\u0e39\u0e40\u0e0b\u0e35\u0e22" },
            { "Cyrs", "\u0e40\u0e0a\u0e2d\u0e23\u0e4c\u0e0a\u0e2a\u0e25\u0e32\u0e42\u0e27\u0e19\u0e34\u0e01\u0e0b\u0e35\u0e23\u0e34\u0e25\u0e25\u0e34\u0e01\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "gwi", "\u0e01\u0e27\u0e34\u0e0a\u0e2d\u0e34\u0e19" },
            { "%%LUNA1918", "\u0e25\u0e39\u0e19\u0e48\u0e32 1918" },
            { "nds", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e15\u0e48\u0e33" },
            { "LI", "\u0e25\u0e34\u0e01\u0e40\u0e15\u0e19\u0e2a\u0e44\u0e15\u0e19\u0e4c" },
            { "LK", "\u0e28\u0e23\u0e35\u0e25\u0e31\u0e07\u0e01\u0e32" },
            { "akk", "\u0e2d\u0e31\u0e01\u0e01\u0e32\u0e14" },
            { "cop", metaValue_cop },
            { "LR", "\u0e44\u0e25\u0e1a\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "esu", "\u0e22\u0e39\u0e1e\u0e34\u0e01\u0e01\u0e25\u0e32\u0e07" },
            { "LS", "\u0e40\u0e25\u0e42\u0e0b\u0e42\u0e17" },
            { "Phlv", "\u0e1b\u0e30\u0e2b\u0e4c\u0e25\u0e32\u0e27\u0e35\u0e1a\u0e38\u0e4a\u0e01" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "Kana", "\u0e04\u0e30\u0e15\u0e30\u0e01\u0e30\u0e19\u0e30" },
            { "Sora", "\u0e42\u0e2a\u0e23\u0e32\u0e2a\u0e21\u0e40\u0e1b\u0e47\u0e07" },
            { "LY", "\u0e25\u0e34\u0e40\u0e1a\u0e35\u0e22" },
            { "lad", "\u0e25\u0e32\u0e14\u0e34\u0e42\u0e19" },
            { "vun", "\u0e27\u0e38\u0e19\u0e08\u0e39" },
            { "akz", "\u0e41\u0e2d\u0e25\u0e30\u0e41\u0e1a\u0e21\u0e32" },
            { "%%LAUKIKA", "\u0e25\u0e31\u0e27\u0e01\u0e34\u0e01\u0e32" },
            { "lah", "\u0e25\u0e32\u0e2e\u0e4c\u0e19\u0e14\u0e32" },
            { "Mahj", "\u0e21\u0e2b\u0e32\u0e0a\u0e19\u0e35" },
            { "lag", "\u0e41\u0e25\u0e19\u0e08\u0e35" },
            { "Thaa", "\u0e17\u0e32\u0e19\u0e32" },
            { "MA", "\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01" },
            { "MC", "\u0e42\u0e21\u0e19\u0e32\u0e42\u0e01" },
            { "MD", metaValue_MD },
            { "Nshu", "\u0e19\u0e38\u0e0b\u0e38" },
            { "ME", "\u0e21\u0e2d\u0e19\u0e40\u0e15\u0e40\u0e19\u0e42\u0e01\u0e23" },
            { "MF", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e21\u0e32\u0e23\u0e4c\u0e15\u0e34\u0e19" },
            { "lam", "\u0e41\u0e25\u0e21\u0e1a\u0e32" },
            { "MG", "\u0e21\u0e32\u0e14\u0e32\u0e01\u0e31\u0e2a\u0e01\u0e32\u0e23\u0e4c" },
            { "Thai", metaValue_TH },
            { "MH", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e21\u0e32\u0e23\u0e4c\u0e41\u0e0a\u0e25\u0e25\u0e4c" },
            { "ale", "\u0e2d\u0e32\u0e25\u0e34\u0e27\u0e15\u0e4c" },
            { "type.nu.vaii", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e27" },
            { "MK", "\u0e21\u0e32\u0e0b\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "ML", "\u0e21\u0e32\u0e25\u0e35" },
            { "MM", "\u0e40\u0e21\u0e35\u0e22\u0e19\u0e21\u0e32\u0e23\u0e4c (\u0e1e\u0e21\u0e48\u0e32)" },
            { "MN", metaValue_MN },
            { "new", "\u0e40\u0e19\u0e27\u0e32\u0e23\u0e4c" },
            { "MO", "\u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e21\u0e32\u0e40\u0e01\u0e4a\u0e32\u0e41\u0e2b\u0e48\u0e07\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e1b\u0e23\u0e30\u0e0a\u0e32\u0e0a\u0e19\u0e08\u0e35\u0e19" },
            { "aln", "\u0e40\u0e01\u0e01\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22" },
            { "MP", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e17\u0e34\u0e23\u0e4c\u0e19\u0e21\u0e32\u0e40\u0e23\u0e35\u0e22\u0e19\u0e32" },
            { "MQ", "\u0e21\u0e32\u0e23\u0e4c\u0e15\u0e34\u0e19\u0e35\u0e01" },
            { "MR", "\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e15\u0e40\u0e19\u0e35\u0e22" },
            { "MS", "\u0e21\u0e2d\u0e19\u0e15\u0e4c\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e23\u0e31\u0e15" },
            { "MT", metaValue_MT },
            { "cps", "\u0e01\u0e32\u0e1b\u0e34\u0e0b\u0e19\u0e2d\u0e19" },
            { "type.m0.ungegn", "\u0e0a\u0e37\u0e48\u0e2d\u0e20\u0e39\u0e21\u0e34\u0e28\u0e32\u0e2a\u0e15\u0e23\u0e4c\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19 UN (UNGEGN)" },
            { "MU", "\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e0a\u0e35\u0e22\u0e2a" },
            { "alt", "\u0e2d\u0e31\u0e25\u0e44\u0e15\u0e43\u0e15\u0e49" },
            { "MV", "\u0e21\u0e31\u0e25\u0e14\u0e35\u0e1f\u0e2a\u0e4c" },
            { "MW", "\u0e21\u0e32\u0e25\u0e32\u0e27\u0e35" },
            { "MX", "\u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01" },
            { "type.ca.japanese", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19" },
            { "MY", "\u0e21\u0e32\u0e40\u0e25\u0e40\u0e0b\u0e35\u0e22" },
            { "MZ", "\u0e42\u0e21\u0e0b\u0e31\u0e21\u0e1a\u0e34\u0e01" },
            { "Phli", "\u0e1b\u0e30\u0e2b\u0e4c\u0e25\u0e32\u0e27\u0e35\u0e2d\u0e34\u0e19\u0e2a\u0e04\u0e23\u0e34\u0e1b\u0e0a\u0e31\u0e19\u0e41\u0e19\u0e25" },
            { "NA", "\u0e19\u0e32\u0e21\u0e34\u0e40\u0e1a\u0e35\u0e22" },
            { "202", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49\u0e2a\u0e30\u0e2e\u0e32\u0e23\u0e32" },
            { "type.ca.hebrew", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2e\u0e34\u0e1a\u0e23\u0e39" },
            { "type.co.dictionary", "\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e1e\u0e08\u0e19\u0e32\u0e19\u0e38\u0e01\u0e23\u0e21" },
            { "NC", "\u0e19\u0e34\u0e27\u0e41\u0e04\u0e25\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22" },
            { "%%WADEGILE", "\u0e01\u0e32\u0e23\u0e16\u0e2d\u0e14\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e41\u0e1a\u0e1a\u0e40\u0e27\u0e14-\u0e44\u0e08\u0e25\u0e2a\u0e4c" },
            { "tru", "\u0e15\u0e39\u0e42\u0e23\u0e42\u0e22" },
            { "%%UCRCOR", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e27\u0e34\u0e18\u0e35\u0e41\u0e1a\u0e1a\u0e1b\u0e23\u0e31\u0e1a\u0e1b\u0e23\u0e38\u0e07\u0e04\u0e23\u0e1a\u0e27\u0e07\u0e08\u0e23" },
            { "NE", "\u0e44\u0e19\u0e40\u0e08\u0e2d\u0e23\u0e4c" },
            { "NF", "\u0e40\u0e01\u0e32\u0e30\u0e19\u0e2d\u0e23\u0e4c\u0e1f\u0e2d\u0e25\u0e4c\u0e01" },
            { "NG", "\u0e44\u0e19\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "trv", "\u0e17\u0e32\u0e42\u0e23\u0e42\u0e01" },
            { "Phlp", "\u0e1b\u0e30\u0e2b\u0e4c\u0e25\u0e32\u0e27\u0e35\u0e0b\u0e2d\u0e25\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "NI", "\u0e19\u0e34\u0e01\u0e32\u0e23\u0e32\u0e01\u0e31\u0e27" },
            { "Hmng", "\u0e1b\u0e32\u0e40\u0e2e\u0e32\u0e2b\u0e4c\u0e21\u0e49\u0e07" },
            { "NL", "\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "tsd", "\u0e0b\u0e32\u0e42\u0e04\u0e40\u0e19\u0e35\u0e22" },
            { "Phnx", metaValue_phn },
            { "NU", "\u0e19\u0e35\u0e2d\u0e39\u0e40\u0e2d" },
            { "rof", "\u0e23\u0e2d\u0e21\u0e42\u0e1a" },
            { "tsi", "\u0e0b\u0e34\u0e21\u0e0a\u0e35\u0e41\u0e2d\u0e19" },
            { "NZ", "\u0e19\u0e34\u0e27\u0e0b\u0e35\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "Merc", "\u0e40\u0e04\u0e2d\u0e23\u0e4c\u0e0b\u0e35\u0e1f-\u0e40\u0e21\u0e42\u0e23\u0e2d\u0e34\u0e15\u0e34\u0e01" },
            { "rom", "\u0e42\u0e23\u0e21\u0e32\u0e19\u0e35" },
            { "Mero", "\u0e40\u0e21\u0e42\u0e23\u0e15\u0e34\u0e01" },
            { "crh", "\u0e15\u0e38\u0e23\u0e01\u0e35\u0e44\u0e04\u0e23\u0e40\u0e21\u0e35\u0e22" },
            { "ang", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "OM", "\u0e42\u0e2d\u0e21\u0e32\u0e19" },
            { "%%PETR1708", "\u0e1e\u0e35\u0e17 1708" },
            { "anp", "\u0e2d\u0e31\u0e07\u0e04\u0e34\u0e01\u0e32" },
            { "crs", "\u0e04\u0e23\u0e35\u0e42\u0e2d\u0e25\u0e40\u0e0b\u0e40\u0e0b\u0e25\u0e2a\u0e4c\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u0e1b\u0e32\u0e19\u0e32\u0e21\u0e32" },
            { "type.ca.islamic-civil", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2d\u0e34\u0e2a\u0e25\u0e32\u0e21\u0e0b\u0e35\u0e27\u0e34\u0e25" },
            { "csb", "\u0e04\u0e32\u0e0b\u0e39\u0e40\u0e1a\u0e35\u0e22\u0e19" },
            { "en_GB", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 - \u0e2a\u0e2b\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23" },
            { "PE", "\u0e40\u0e1b\u0e23\u0e39" },
            { "ttt", "\u0e15\u0e31\u0e15\u0e21\u0e38\u0e2a\u0e25\u0e34\u0e21" },
            { "PF", "\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e42\u0e1b\u0e25\u0e34\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "PG", "\u0e1b\u0e32\u0e1b\u0e31\u0e27\u0e19\u0e34\u0e27\u0e01\u0e34\u0e19\u0e35" },
            { "PH", metaValue_PH },
            { "PK", "\u0e1b\u0e32\u0e01\u0e35\u0e2a\u0e16\u0e32\u0e19" },
            { "PL", metaValue_PL },
            { "ewo", "\u0e2d\u0e35\u0e27\u0e31\u0e19\u0e42\u0e14" },
            { "PM", "\u0e41\u0e0b\u0e07\u0e1b\u0e35\u0e41\u0e22\u0e23\u0e4c\u0e41\u0e25\u0e30\u0e21\u0e35\u0e40\u0e01\u0e2d\u0e25\u0e07" },
            { "PN", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1e\u0e34\u0e15\u0e41\u0e04\u0e23\u0e4c\u0e19" },
            { "PR", "\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e42\u0e15\u0e23\u0e34\u0e42\u0e01" },
            { "Bali", metaValue_ban },
            { "PS", "\u0e14\u0e34\u0e19\u0e41\u0e14\u0e19\u0e1b\u0e32\u0e40\u0e25\u0e2a\u0e44\u0e15\u0e19\u0e4c" },
            { "PT", metaValue_PT },
            { "PW", metaValue_PW },
            { "nia", "\u0e19\u0e35\u0e2d\u0e31\u0e2a" },
            { "type.nu.greklow", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e01\u0e23\u0e35\u0e01\u0e1e\u0e34\u0e21\u0e1e\u0e4c\u0e40\u0e25\u0e47\u0e01" },
            { "PY", "\u0e1b\u0e32\u0e23\u0e32\u0e01\u0e27\u0e31\u0e22" },
            { "tum", "\u0e17\u0e38\u0e21\u0e1a\u0e39\u0e01\u0e32" },
            { "Hebr", "\u0e2e\u0e35\u0e1a\u0e23\u0e39" },
            { "QA", "\u0e01\u0e32\u0e15\u0e32\u0e23\u0e4c" },
            { "%%SCOTLAND", "\u0e20\u0e32\u0e29\u0e32\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e21\u0e32\u0e15\u0e23\u0e32\u0e10\u0e32\u0e19\u0e2a\u0e01\u0e4a\u0e2d\u0e15" },
            { "jam", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e04\u0e25\u0e35\u0e42\u0e2d\u0e25\u0e08\u0e32\u0e40\u0e21\u0e01\u0e32" },
            { "pms", "\u0e1e\u0e35\u0e14\u0e21\u0e2d\u0e19\u0e15\u0e4c" },
            { "niu", "\u0e19\u0e35\u0e27\u0e40\u0e27" },
            { "QO", "\u0e40\u0e2d\u0e32\u0e15\u0e4c\u0e44\u0e25\u0e2d\u0e34\u0e07\u0e42\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e40\u0e19\u0e35\u0e22" },
            { "ext", "\u0e40\u0e2d\u0e01\u0e0b\u0e4c\u0e40\u0e15\u0e23\u0e21\u0e32\u0e14\u0e39\u0e23\u0e32" },
            { "lez", "\u0e40\u0e25\u0e0b\u0e40\u0e01\u0e35\u0e22\u0e19" },
            { "%%FONUPA", "\u0e2a\u0e31\u0e17\u0e2d\u0e31\u0e01\u0e29\u0e23 UPA" },
            { "type.nu.takr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e04\u0e23\u0e35" },
            { "tvl", metaValue_TV },
            { "Tavt", "\u0e44\u0e17\u0e40\u0e27\u0e35\u0e22\u0e15" },
            { "001", "\u0e42\u0e25\u0e01" },
            { "002", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32" },
            { "njo", "\u0e2d\u0e4b\u0e32\u0e27\u0e19\u0e32\u0e01\u0e32" },
            { "003", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "RE", "\u0e40\u0e23\u0e2d\u0e39\u0e19\u0e35\u0e22\u0e07" },
            { "005", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49" },
            { "lfn", "\u0e25\u0e34\u0e07\u0e01\u0e31\u0e27\u0e1f\u0e23\u0e31\u0e07\u0e01\u0e32\u0e42\u0e19\u0e27\u0e32" },
            { "jbo", "\u0e42\u0e25\u0e0a\u0e1a\u0e31\u0e19" },
            { "pnt", "\u0e1e\u0e2d\u0e19\u0e15\u0e34\u0e01" },
            { "Rjng", "\u0e40\u0e23\u0e08\u0e31\u0e07" },
            { "009", "\u0e42\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e40\u0e19\u0e35\u0e22" },
            { "%%SURSILV", "\u0e0b\u0e39\u0e23\u0e4c\u0e0b\u0e35\u0e25\u0e1f\u0e4c" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "Mroo", "\u0e21\u0e42\u0e23" },
            { "RU", metaValue_RU },
            { "RW", metaValue_RW },
            { "type.nu.talu", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e17\u0e25\u0e37\u0e49\u0e2d\u0e43\u0e2b\u0e21\u0e48" },
            { "%%METELKO", "\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e40\u0e21\u0e40\u0e15\u0e27\u0e0a\u0e34\u0e0b\u0e32" },
            { "Ugar", metaValue_uga },
            { "Mani", "\u0e21\u0e32\u0e19\u0e34\u0e41\u0e0a\u0e19" },
            { "Khar", "\u0e02\u0e42\u0e23\u0e29\u0e10\u0e35" },
            { "SA", "\u0e0b\u0e32\u0e2d\u0e38\u0e14\u0e35\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22" },
            { "pon", "\u0e1e\u0e2d\u0e2b\u0e4c\u0e19\u0e40\u0e1e" },
            { "Mand", "\u0e41\u0e21\u0e19\u0e40\u0e14\u0e35\u0e22\u0e19" },
            { "SB", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e0b\u0e42\u0e25\u0e21\u0e2d\u0e19" },
            { "twq", "\u0e15\u0e31\u0e2a\u0e0b\u0e32\u0e27\u0e31\u0e04" },
            { "011", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "SC", "\u0e40\u0e0b\u0e40\u0e0a\u0e25\u0e2a\u0e4c" },
            { "SD", "\u0e0b\u0e39\u0e14\u0e32\u0e19" },
            { "SE", metaValue_SE },
            { "013", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07" },
            { "014", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "arc", "\u0e2d\u0e23\u0e32\u0e40\u0e21\u0e2d\u0e34\u0e01" },
            { "Loma", "\u0e42\u0e25\u0e21\u0e32" },
            { "015", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "SG", "\u0e2a\u0e34\u0e07\u0e04\u0e42\u0e1b\u0e23\u0e4c" },
            { "SH", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e40\u0e2e\u0e40\u0e25\u0e19\u0e32" },
            { "type.lb.strict", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e17\u0e35\u0e48\u0e40\u0e04\u0e23\u0e48\u0e07\u0e04\u0e23\u0e31\u0e14\u0e02\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e02\u0e36\u0e49\u0e19\u0e1a\u0e23\u0e23\u0e17\u0e31\u0e14\u0e43\u0e2b\u0e21\u0e48" },
            { "SI", metaValue_SI },
            { "017", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07" },
            { "018", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e15\u0e2d\u0e19\u0e43\u0e15\u0e49" },
            { "SJ", "\u0e2a\u0e1f\u0e32\u0e25\u0e1a\u0e32\u0e23\u0e4c\u0e41\u0e25\u0e30\u0e22\u0e32\u0e19\u0e44\u0e21\u0e40\u0e2d\u0e19" },
            { "019", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "SK", "\u0e2a\u0e42\u0e25\u0e27\u0e30\u0e40\u0e01\u0e35\u0e22" },
            { "Bamu", "\u0e1a\u0e32\u0e21\u0e38\u0e21" },
            { "Wole", "\u0e42\u0e2d\u0e25\u0e35\u0e40\u0e2d" },
            { "SL", "\u0e40\u0e0b\u0e35\u0e22\u0e23\u0e4c\u0e23\u0e32\u0e25\u0e35\u0e42\u0e2d\u0e19" },
            { "SM", "\u0e0b\u0e32\u0e19\u0e21\u0e32\u0e23\u0e34\u0e42\u0e19" },
            { "SN", "\u0e40\u0e0b\u0e40\u0e19\u0e01\u0e31\u0e25" },
            { "SO", "\u0e42\u0e0b\u0e21\u0e32\u0e40\u0e25\u0e35\u0e22" },
            { "arn", "\u0e21\u0e32\u0e1b\u0e39\u0e40\u0e0a" },
            { "arp", "\u0e2d\u0e32\u0e23\u0e32\u0e1b\u0e32\u0e42\u0e2e" },
            { "type.nu.taml", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e21\u0e34\u0e2c\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "SR", metaValue_SR },
            { "aro", "\u0e2d\u0e32\u0e40\u0e23\u0e32\u0e19\u0e32" },
            { "SS", "\u0e0b\u0e39\u0e14\u0e32\u0e19\u0e43\u0e15\u0e49" },
            { "ST", "\u0e40\u0e0b\u0e32\u0e15\u0e39\u0e40\u0e21\u0e41\u0e25\u0e30\u0e1b\u0e23\u0e34\u0e19\u0e0b\u0e34\u0e1b\u0e35" },
            { "arq", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e41\u0e2d\u0e25\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22" },
            { "SV", "\u0e40\u0e2d\u0e25\u0e0b\u0e31\u0e25\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c" },
            { "ars", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e19\u0e31\u0e08\u0e0d\u0e4c\u0e14\u0e35" },
            { "SX", "\u0e0b\u0e34\u0e19\u0e15\u0e4c\u0e21\u0e32\u0e23\u0e4c\u0e40\u0e17\u0e19" },
            { "SY", metaValue_SY },
            { "yao", "\u0e40\u0e22\u0e49\u0e32" },
            { "SZ", "\u0e40\u0e2d\u0e2a\u0e27\u0e32\u0e15\u0e35\u0e19\u0e35" },
            { "arw", "\u0e2d\u0e32\u0e23\u0e32\u0e27\u0e31\u0e01" },
            { "arz", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "ary", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01" },
            { "yap", "\u0e22\u0e31\u0e1b" },
            { "rtm", "\u0e42\u0e23\u0e17\u0e39\u0e21\u0e31\u0e19" },
            { "TA", "\u0e17\u0e23\u0e34\u0e2a\u0e15\u0e31\u0e19\u0e14\u0e32\u0e04\u0e39\u0e19\u0e32" },
            { "asa", "\u0e2d\u0e32\u0e0b\u0e39" },
            { "type.ms.ussystem", "\u0e23\u0e30\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e27\u0e31\u0e14\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19" },
            { "021", "\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32\u0e15\u0e2d\u0e19\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "TC", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e15\u0e34\u0e01\u0e2a\u0e4c\u0e41\u0e25\u0e30\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e04\u0e04\u0e2d\u0e2a" },
            { "yav", "\u0e41\u0e22\u0e07\u0e40\u0e1a\u0e19" },
            { "TD", "\u0e0a\u0e32\u0e14" },
            { "TF", "\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e40\u0e0b\u0e32\u0e40\u0e17\u0e34\u0e23\u0e4c\u0e19\u0e40\u0e17\u0e23\u0e4c\u0e23\u0e34\u0e17\u0e2d\u0e23\u0e35\u0e2a\u0e4c" },
            { "ase", "\u0e20\u0e32\u0e29\u0e32\u0e21\u0e37\u0e2d\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19" },
            { "TG", "\u0e42\u0e15\u0e42\u0e01" },
            { "TH", metaValue_TH },
            { "TJ", "\u0e17\u0e32\u0e08\u0e34\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "TK", metaValue_TK },
            { "029", "\u0e41\u0e04\u0e23\u0e34\u0e1a\u0e40\u0e1a\u0e35\u0e22\u0e19" },
            { "TL", "\u0e15\u0e34\u0e21\u0e2d\u0e23\u0e4c-\u0e40\u0e25\u0e2a\u0e40\u0e15" },
            { "ybb", "\u0e40\u0e22\u0e21\u0e1a\u0e32" },
            { "type.co.searchjl", "\u0e04\u0e49\u0e19\u0e2b\u0e32\u0e15\u0e32\u0e21\u0e1e\u0e22\u0e31\u0e0d\u0e0a\u0e19\u0e30\u0e02\u0e36\u0e49\u0e19\u0e15\u0e49\u0e19\u0e17\u0e35\u0e48\u0e40\u0e1b\u0e47\u0e19\u0e2e\u0e31\u0e19\u0e01\u0e36\u0e25" },
            { "TM", "\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "%%BOONT", "\u0e1a\u0e39\u0e19\u0e17\u0e25\u0e34\u0e48\u0e07" },
            { "TN", "\u0e15\u0e39\u0e19\u0e34\u0e40\u0e0b\u0e35\u0e22" },
            { "TO", metaValue_TO },
            { "%%NULIK", "\u0e42\u0e27\u0e25\u0e32\u0e1e\u0e36\u0e04\u0e2a\u0e21\u0e31\u0e22\u0e43\u0e2b\u0e21\u0e48" },
            { "TR", metaValue_TR },
            { "TT", "\u0e15\u0e23\u0e34\u0e19\u0e34\u0e41\u0e14\u0e14\u0e41\u0e25\u0e30\u0e42\u0e15\u0e40\u0e1a\u0e42\u0e01" },
            { "TV", metaValue_TV },
            { "TW", "\u0e44\u0e15\u0e49\u0e2b\u0e27\u0e31\u0e19" },
            { "ast", "\u0e2d\u0e31\u0e2a\u0e15\u0e39\u0e40\u0e23\u0e35\u0e22\u0e2a" },
            { "rue", "\u0e23\u0e39\u0e0b\u0e34\u0e19" },
            { "rug", "\u0e42\u0e23\u0e40\u0e27\u0e35\u0e22\u0e19\u0e32" },
            { "Orkh", "\u0e2d\u0e2d\u0e23\u0e4c\u0e04\u0e2d\u0e19" },
            { "TZ", "\u0e41\u0e17\u0e19\u0e0b\u0e32\u0e40\u0e19\u0e35\u0e22" },
            { "nmg", "\u0e01\u0e27\u0e32\u0e0b\u0e34\u0e42\u0e2d" },
            { "Zzzz", "\u0e2a\u0e04\u0e23\u0e34\u0e1b\u0e15\u0e4c\u0e17\u0e35\u0e48\u0e44\u0e21\u0e48\u0e23\u0e39\u0e49\u0e08\u0e31\u0e01" },
            { "Sind", "\u0e04\u0e38\u0e14\u0e32\u0e27\u0e32\u0e14\u0e35" },
            { "UA", metaValue_UA },
            { "lij", "\u0e25\u0e34\u0e01\u0e39\u0e40\u0e23\u0e35\u0e22" },
            { "rup", "\u0e2d\u0e32\u0e42\u0e23\u0e21\u0e32\u0e40\u0e19\u0e35\u0e22\u0e19" },
            { "030", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "tyv", "\u0e15\u0e39\u0e27\u0e32" },
            { "sw_CD", "\u0e2a\u0e27\u0e32\u0e2e\u0e35\u0e25\u0e35 - \u0e04\u0e2d\u0e07\u0e42\u0e01" },
            { "034", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e43\u0e15\u0e49" },
            { "hai", "\u0e44\u0e2e\u0e14\u0e32" },
            { "UG", metaValue_UG },
            { "035", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01\u0e40\u0e09\u0e35\u0e22\u0e07\u0e43\u0e15\u0e49" },
            { "hak", "\u0e08\u0e35\u0e19\u0e41\u0e04\u0e30" },
            { "type.co.pinyin", "\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e01\u0e32\u0e23\u0e16\u0e2d\u0e14\u0e40\u0e2a\u0e35\u0e22\u0e07\u0e20\u0e32\u0e29\u0e32\u0e08\u0e35\u0e19" },
            { "039", "\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e43\u0e15\u0e49" },
            { "Sinh", metaValue_si },
            { "UM", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e23\u0e2d\u0e1a\u0e19\u0e2d\u0e01\u0e02\u0e2d\u0e07\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "liv", "\u0e25\u0e34\u0e42\u0e27\u0e40\u0e19\u0e35\u0e22" },
            { "UN", "\u0e2a\u0e2b\u0e1b\u0e23\u0e30\u0e0a\u0e32\u0e0a\u0e32\u0e15\u0e34" },
            { "US", "\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "haw", "\u0e2e\u0e32\u0e27\u0e32\u0e22" },
            { "%%1959ACAD", "\u0e27\u0e34\u0e0a\u0e32\u0e01\u0e32\u0e23" },
            { "type.co.gb2312han", "\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e08\u0e35\u0e19\u0e1b\u0e23\u0e30\u0e22\u0e38\u0e01\u0e15\u0e4c" },
            { "UY", "\u0e2d\u0e38\u0e23\u0e38\u0e01\u0e27\u0e31\u0e22" },
            { "prg", "\u0e1b\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22" },
            { "UZ", "\u0e2d\u0e38\u0e0b\u0e40\u0e1a\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19" },
            { "tzm", "\u0e17\u0e32\u0e21\u0e32\u0e44\u0e0b\u0e15\u0e4c\u0e41\u0e2d\u0e15\u0e25\u0e32\u0e2a\u0e01\u0e25\u0e32\u0e07" },
            { "type.co.stroke", "\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e01\u0e32\u0e23\u0e25\u0e32\u0e01\u0e40\u0e2a\u0e49\u0e19" },
            { "nnh", "\u0e08\u0e35\u0e21\u0e1a\u0e39\u0e19" },
            { "VA", "\u0e19\u0e04\u0e23\u0e27\u0e32\u0e15\u0e34\u0e01\u0e31\u0e19" },
            { "pro", "\u0e42\u0e1b\u0e23\u0e27\u0e2d\u0e07\u0e0b\u0e32\u0e25\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "VC", "\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e27\u0e34\u0e19\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e41\u0e25\u0e30\u0e40\u0e01\u0e23\u0e19\u0e32\u0e14\u0e35\u0e19\u0e2a\u0e4c" },
            { "VE", "\u0e40\u0e27\u0e40\u0e19\u0e0b\u0e38\u0e40\u0e2d\u0e25\u0e32" },
            { "VG", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1a\u0e23\u0e34\u0e15\u0e34\u0e0a\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e08\u0e34\u0e19" },
            { "VI", "\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e08\u0e34\u0e19\u0e02\u0e2d\u0e07\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "VN", metaValue_VN },
            { "VU", "\u0e27\u0e32\u0e19\u0e39\u0e2d\u0e32\u0e15\u0e39" },
            { "nog", "\u0e42\u0e19\u0e44\u0e01" },
            { "rwk", "\u0e23\u0e27\u0e32" },
            { "non", "\u0e19\u0e2d\u0e23\u0e4c\u0e2a\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "053", "\u0e2d\u0e2d\u0e2a\u0e15\u0e23\u0e32\u0e40\u0e25\u0e40\u0e0b\u0e35\u0e22" },
            { "%%AREVMDA", "\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "054", "\u0e40\u0e21\u0e25\u0e32\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "WF", "\u0e27\u0e32\u0e25\u0e25\u0e34\u0e2a\u0e41\u0e25\u0e30\u0e1f\u0e38\u0e15\u0e39\u0e19\u0e32" },
            { "type.co.traditional", "\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e41\u0e1a\u0e1a\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "057", "\u0e40\u0e02\u0e15\u0e44\u0e21\u0e42\u0e04\u0e23\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "jgo", "\u0e2d\u0e36\u0e19\u0e01\u0e2d\u0e21\u0e1a\u0e32" },
            { "lkt", "\u0e25\u0e32\u0e42\u0e01\u0e15\u0e32" },
            { "nov", "\u0e42\u0e19\u0e40\u0e27\u0e35\u0e22\u0e25" },
            { "type.nu.finance", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e07\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19" },
            { "avk", "\u0e42\u0e04\u0e15\u0e32\u0e27\u0e32" },
            { "%%HEPBURN", "\u0e01\u0e32\u0e23\u0e16\u0e2d\u0e14\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e41\u0e1a\u0e1a\u0e40\u0e2e\u0e1b\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e19" },
            { "wae", "\u0e27\u0e31\u0e25\u0e40\u0e0b\u0e2d\u0e23\u0e4c" },
            { "WS", metaValue_WS },
            { "Bass", "\u0e1a\u0e31\u0e2a\u0e0b\u0e32" },
            { "type.nu.mtei", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e21\u0e44\u0e15\u0e21\u0e32\u0e40\u0e22\u0e01" },
            { "wal", "\u0e27\u0e32\u0e25\u0e32\u0e42\u0e21" },
            { "was", "\u0e27\u0e32\u0e42\u0e0a" },
            { "war", "\u0e27\u0e32\u0e40\u0e23\u0e22\u0e4c" },
            { "awa", "\u0e2d\u0e27\u0e18\u0e35" },
            { "061", "\u0e42\u0e1b\u0e25\u0e34\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "%%KSCOR", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e27\u0e34\u0e18\u0e35\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19" },
            { "XK", "\u0e42\u0e04\u0e42\u0e0b\u0e42\u0e27" },
            { "type.nu.brah", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1e\u0e23\u0e32\u0e2b\u0e21\u0e35" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0e44\u0e21\u0e48\u0e21\u0e35\u0e20\u0e32\u0e29\u0e32\u0e40\u0e02\u0e35\u0e22\u0e19" },
            { "Olck", "\u0e42\u0e2d\u0e25\u0e0a\u0e34\u0e01\u0e34" },
            { "wbp", "\u0e27\u0e2d\u0e25\u0e4c\u0e40\u0e1e\u0e2d\u0e23\u0e4c\u0e23\u0e35" },
            { "Batk", "\u0e1a\u0e32\u0e15\u0e31\u0e01" },
            { "Blis", metaValue_zbl },
            { "YE", "\u0e40\u0e22\u0e40\u0e21\u0e19" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e41\u0e1a\u0e1a\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19" },
            { "lmo", "\u0e25\u0e2d\u0e21\u0e1a\u0e32\u0e23\u0e4c\u0e14" },
            { "fan", "\u0e1f\u0e2d\u0e07" },
            { "%%ROZAJ", "\u0e40\u0e23\u0e40\u0e0b\u0e35\u0e22\u0e19" },
            { "%%SUTSILV", "\u0e0b\u0e38\u0e15\u0e0b\u0e35\u0e25\u0e1f\u0e4c" },
            { "fat", "\u0e1f\u0e31\u0e19\u0e15\u0e34" },
            { "Sgnw", "\u0e44\u0e0b\u0e19\u0e4c\u0e44\u0e23\u0e15\u0e34\u0e49\u0e07" },
            { "YT", "\u0e21\u0e32\u0e22\u0e2d\u0e15" },
            { "type.nu.cham", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0a\u0e32\u0e21" },
            { "ZA", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49" },
            { "type.nu.sund", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0b\u0e38\u0e19\u0e14\u0e32" },
            { "type.lb.loose", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e17\u0e35\u0e48\u0e22\u0e37\u0e14\u0e2b\u0e22\u0e38\u0e48\u0e19\u0e02\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e02\u0e36\u0e49\u0e19\u0e1a\u0e23\u0e23\u0e17\u0e31\u0e14\u0e43\u0e2b\u0e21\u0e48" },
            { "Deva", "\u0e40\u0e17\u0e27\u0e19\u0e32\u0e04\u0e23\u0e35" },
            { "type.nu.geor", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22" },
            { "type.co.zhuyin", "\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e01\u0e32\u0e23\u0e2a\u0e30\u0e01\u0e14\u0e41\u0e1a\u0e1a\u0e08\u0e39\u0e49\u0e2d\u0e34\u0e19" },
            { "Hira", "\u0e2e\u0e34\u0e23\u0e30\u0e07\u0e30\u0e19\u0e30" },
            { "ZM", "\u0e41\u0e0b\u0e21\u0e40\u0e1a\u0e35\u0e22" },
            { "%%PINYIN", "\u0e1e\u0e34\u0e19\u0e2d\u0e34\u0e19" },
            { "ZW", "\u0e0b\u0e34\u0e21\u0e1a\u0e31\u0e1a\u0e40\u0e27" },
            { "ZZ", "\u0e20\u0e39\u0e21\u0e34\u0e20\u0e32\u0e04\u0e17\u0e35\u0e48\u0e44\u0e21\u0e48\u0e23\u0e39\u0e49\u0e08\u0e31\u0e01" },
            { "Runr", "\u0e23\u0e39\u0e19\u0e34\u0e01" },
            { "type.ms.metric", "\u0e23\u0e30\u0e1a\u0e1a\u0e40\u0e21\u0e15\u0e23\u0e34\u0e01" },
            { "type.ca.iso8601", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19 ISO-8601" },
            { "lol", "\u0e21\u0e2d\u0e07\u0e42\u0e01" },
            { "nso", "\u0e42\u0e0b\u0e42\u0e17\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "type.nu.telu", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e15\u0e25\u0e39\u0e01\u0e39" },
            { "lou", "\u0e20\u0e32\u0e29\u0e32\u0e04\u0e23\u0e35\u0e42\u0e2d\u0e25\u0e38\u0e22\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e32" },
            { "loz", "\u0e42\u0e25\u0e0b\u0e34" },
            { "Nkgb", "\u0e01\u0e35\u0e1a\u0e32-\u0e19\u0e32\u0e0b\u0e35" },
            { "jmc", "\u0e21\u0e32\u0e0a\u0e32\u0e40\u0e21" },
            { "hif", "\u0e2e\u0e34\u0e19\u0e14\u0e35\u0e1f\u0e34\u0e08\u0e34" },
            { "type.nu.hansfin", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e07\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19\u0e41\u0e1a\u0e1a\u0e15\u0e31\u0e27\u0e22\u0e48\u0e2d\u0e02\u0e2d\u0e07\u0e08\u0e35\u0e19" },
            { "hil", "\u0e2e\u0e35\u0e25\u0e35\u0e01\u0e31\u0e22\u0e19\u0e19" },
            { "type.nu.arabext", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e1a\u0e34\u0e01-\u0e2d\u0e34\u0e19\u0e14\u0e34\u0e01\u0e41\u0e1a\u0e1a\u0e02\u0e22\u0e32\u0e22" },
            { "nus", "\u0e40\u0e19\u0e37\u0e2d\u0e23\u0e4c" },
            { "dak", "\u0e14\u0e32\u0e42\u0e01\u0e17\u0e32" },
            { "type.nu.fullwide", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e41\u0e1a\u0e1a\u0e40\u0e15\u0e47\u0e21\u0e02\u0e19\u0e32\u0e14" },
            { "hit", "\u0e2e\u0e34\u0e15\u0e44\u0e15\u0e15\u0e4c" },
            { "dar", "\u0e14\u0e32\u0e23\u0e4c\u0e01\u0e34\u0e19" },
            { "dav", "\u0e44\u0e17\u0e17\u0e32" },
            { "Maya", "\u0e21\u0e32\u0e22\u0e32\u0e44\u0e2e\u0e42\u0e23\u0e01\u0e25\u0e34\u0e1f\u0e2a\u0e4c" },
            { "lrc", "\u0e25\u0e39\u0e23\u0e35\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "Copt", metaValue_cop },
            { "nwc", "\u0e40\u0e19\u0e27\u0e32\u0e23\u0e4c\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "udm", "\u0e2d\u0e38\u0e14\u0e21\u0e39\u0e23\u0e4c\u0e15" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2d\u0e34\u0e2a\u0e25\u0e32\u0e21 (\u0e0b\u0e32\u0e2d\u0e38\u0e14\u0e35\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22 \u0e41\u0e1a\u0e1a\u0e1e\u0e23\u0e30\u0e08\u0e31\u0e19\u0e17\u0e23\u0e4c\u0e40\u0e2a\u0e35\u0e49\u0e22\u0e27)" },
            { "Limb", "\u0e25\u0e34\u0e21\u0e1a\u0e39" },
            { "sad", "\u0e0b\u0e31\u0e19\u0e14\u0e32\u0e40\u0e27" },
            { "type.nu.roman", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e23\u0e21\u0e31\u0e19" },
            { "sah", "\u0e0b\u0e32\u0e04\u0e32" },
            { "type.nu.shrd", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0a\u0e32\u0e23\u0e32\u0e14\u0e32" },
            { "ltg", "\u0e25\u0e31\u0e15\u0e40\u0e01\u0e25" },
            { "sam", "\u0e2d\u0e23\u0e32\u0e40\u0e21\u0e2d\u0e34\u0e01\u0e0b\u0e32\u0e21\u0e32\u0e40\u0e23\u0e35\u0e22" },
            { "Aghb", "\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22 \u0e04\u0e2d\u0e40\u0e04\u0e40\u0e0b\u0e35\u0e22" },
            { "%%SCOUSE", "\u0e2a\u0e40\u0e01\u0e32\u0e2a\u0e4c" },
            { "saq", "\u0e41\u0e0b\u0e21\u0e1a\u0e39\u0e23\u0e39" },
            { "sas", "\u0e0b\u0e32\u0e0b\u0e31\u0e01" },
            { "sat", "\u0e2a\u0e31\u0e19\u0e15\u0e32\u0e25\u0e35" },
            { "Tfng", "\u0e17\u0e34\u0e1f\u0e34\u0e19\u0e32\u0e01" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "jpr", "\u0e22\u0e34\u0e27-\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e35\u0e22" },
            { "saz", "\u0e40\u0e2a\u0e32\u0e23\u0e32\u0e29\u0e0f\u0e23\u0e4c" },
            { "type.nu.native", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07" },
            { "sba", "\u0e01\u0e31\u0e21\u0e40\u0e1a" },
            { "Guru", "\u0e01\u0e39\u0e23\u0e4c\u0e21\u0e39\u0e04\u0e35" },
            { "%%ALUKU", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e2d\u0e25\u0e39\u0e04\u0e39" },
            { "lua", "\u0e25\u0e39\u0e1a\u0e32-\u0e25\u0e39\u0e25\u0e31\u0e27" },
            { "%%BISCAYAN", "\u0e1a\u0e34\u0e2a\u0e04\u0e32\u0e22\u0e31\u0e19" },
            { "type.d0.fwidth", metaValue_Hant },
            { "sbp", "\u0e41\u0e0b\u0e07\u0e01\u0e39" },
            { "lui", "\u0e25\u0e38\u0e22\u0e40\u0e0b\u0e42\u0e19" },
            { "nyn", "\u0e40\u0e19\u0e35\u0e22\u0e19\u0e42\u0e01\u0e40\u0e25" },
            { "nym", "\u0e40\u0e19\u0e35\u0e22\u0e21\u0e40\u0e27\u0e0b\u0e35" },
            { "lun", "\u0e25\u0e31\u0e19\u0e14\u0e32" },
            { "nyo", "\u0e19\u0e34\u0e42\u0e2d\u0e42\u0e23" },
            { "luo", "\u0e25\u0e31\u0e27" },
            { "fil", metaValue_PH },
            { "hmn", "\u0e21\u0e49\u0e07" },
            { "del", "\u0e40\u0e14\u0e25\u0e32\u0e41\u0e27\u0e23\u0e4c" },
            { "lus", "\u0e21\u0e34\u0e42\u0e0b" },
            { "bal", "\u0e1a\u0e32\u0e25\u0e39\u0e0a\u0e34" },
            { "den", "\u0e2a\u0e40\u0e25\u0e27\u0e35" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "\u0e1f\u0e34\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e17\u0e2d\u0e23\u0e4c\u0e40\u0e19\u0e14\u0e32\u0e40\u0e25\u0e47\u0e19" },
            { "luy", "\u0e25\u0e39\u0e40\u0e22\u0e35\u0e22" },
            { "bar", "\u0e1a\u0e32\u0e27\u0e32\u0e40\u0e23\u0e35\u0e22" },
            { "bas", "\u0e1a\u0e32\u0e2a\u0e32" },
            { "bax", "\u0e1a\u0e32\u0e21\u0e31\u0e19" },
            { "jrb", "\u0e22\u0e34\u0e27-\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a" },
            { "es_ES", "\u0e2a\u0e40\u0e1b\u0e19 - \u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "nzi", "\u0e19\u0e0b\u0e34\u0e21\u0e32" },
            { "sco", "\u0e2a\u0e01\u0e2d\u0e15\u0e2a\u0e4c" },
            { "scn", "\u0e0b\u0e34\u0e0b\u0e34\u0e25\u0e35" },
            { "aa", "\u0e2d\u0e30\u0e1f\u0e32\u0e23\u0e4c" },
            { "ab", "\u0e2d\u0e31\u0e1a\u0e2e\u0e32\u0e40\u0e0b\u0e35\u0e22" },
            { "bbc", "\u0e1a\u0e32\u0e15\u0e31\u0e01\u0e42\u0e17\u0e1a\u0e32" },
            { "ae", metaValue_ae },
            { "af", "\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e19\u0e2a\u0e4c" },
            { "ak", "\u0e2d\u0e32\u0e04\u0e32\u0e19" },
            { "type.nu.cakm", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0a\u0e32\u0e01\u0e21\u0e32" },
            { "bbj", "\u0e42\u0e04\u0e21\u0e32\u0e25\u0e32" },
            { "am", "\u0e2d\u0e31\u0e21\u0e2e\u0e32\u0e23\u0e32" },
            { "Arab", metaValue_ar },
            { "an", "\u0e2d\u0e32\u0e23\u0e32\u0e01\u0e2d\u0e19" },
            { "%%SOLBA", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e2a\u0e42\u0e15\u0e27\u0e35\u0e0b\u0e0b\u0e32/\u0e42\u0e0b\u0e25\u0e1a\u0e35\u0e01\u0e32" },
            { "Jpan", metaValue_JP },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0e04\u0e30\u0e15\u0e30\u0e01\u0e30\u0e19\u0e30\u0e2b\u0e23\u0e37\u0e2d\u0e2e\u0e34\u0e23\u0e30\u0e07\u0e30\u0e19\u0e30" },
            { "as", "\u0e2d\u0e31\u0e2a\u0e2a\u0e31\u0e21" },
            { "sdc", "\u0e0b\u0e32\u0e23\u0e4c\u0e14\u0e34\u0e40\u0e19\u0e35\u0e22\u0e0b\u0e32\u0e2a\u0e0b\u0e32\u0e23\u0e35" },
            { "Lina", "\u0e25\u0e35\u0e40\u0e19\u0e35\u0e22\u0e23\u0e4c\u0e40\u0e2d" },
            { "av", "\u0e2d\u0e32\u0e27\u0e32\u0e23\u0e4c" },
            { "Linb", "\u0e25\u0e35\u0e40\u0e19\u0e35\u0e22\u0e23\u0e4c\u0e1a\u0e35" },
            { "sdh", "\u0e40\u0e04\u0e2d\u0e23\u0e4c\u0e14\u0e34\u0e0a\u0e43\u0e15\u0e49" },
            { "ay", "\u0e44\u0e2d\u0e22\u0e4c\u0e21\u0e32\u0e23\u0e32" },
            { "az", metaValue_AZ },
            { "Khoj", "\u0e04\u0e2d\u0e08\u0e04\u0e35" },
            { "%%OSOJS", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e42\u0e2d\u0e40\u0e0b\u0e35\u0e22\u0e04\u0e42\u0e04/\u0e42\u0e2d\u0e42\u0e0b\u0e22\u0e32\u0e40\u0e19" },
            { "ba", "\u0e1a\u0e31\u0e0a\u0e04\u0e35\u0e23\u0e4c" },
            { "type.co.unihan", "\u0e40\u0e23\u0e35\u0e22\u0e07\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e15\u0e32\u0e21\u0e08\u0e33\u0e19\u0e27\u0e19\u0e02\u0e35\u0e14" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "\u0e1a\u0e34\u0e2a\u0e25\u0e32\u0e21\u0e32" },
            { "type.nu.java", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0a\u0e27\u0e32" },
            { "bm", "\u0e1a\u0e31\u0e21\u0e1a\u0e32\u0e23\u0e32" },
            { "bn", "\u0e1a\u0e31\u0e07\u0e01\u0e25\u0e32" },
            { "bo", metaValue_bo },
            { "dgr", "\u0e42\u0e14\u0e01\u0e23\u0e34\u0e1a" },
            { "br", "\u0e40\u0e1a\u0e23\u0e15\u0e31\u0e19" },
            { "bs", "\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22" },
            { "see", "\u0e40\u0e0b\u0e19\u0e34\u0e01\u0e32" },
            { "Mymr", metaValue_my },
            { "sei", "\u0e40\u0e0b\u0e23\u0e35" },
            { "type.nu.laoo", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e25\u0e32\u0e27" },
            { "seh", "\u0e40\u0e0b\u0e19\u0e32" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0e40\u0e0b\u0e25\u0e04\u0e38\u0e1b" },
            { "ca", "\u0e04\u0e32\u0e15\u0e32\u0e25\u0e31\u0e19" },
            { "ses", "\u0e42\u0e04\u0e22\u0e4c\u0e23\u0e32\u0e42\u0e1a\u0e42\u0e23\u0e40\u0e0b\u0e19\u0e19\u0e35" },
            { "ce", "\u0e40\u0e0a\u0e40\u0e0a\u0e19" },
            { "ch", "\u0e0a\u0e32\u0e21\u0e2d\u0e23\u0e4c\u0e42\u0e23" },
            { "%%REVISED", "\u0e2d\u0e2d\u0e23\u0e4c\u0e42\u0e18\u0e01\u0e23\u0e32\u0e1f\u0e34\u0e1b\u0e23\u0e31\u0e1a\u0e1b\u0e23\u0e38\u0e07" },
            { "co", "\u0e04\u0e2d\u0e23\u0e4c\u0e0b\u0e34\u0e01\u0e32" },
            { "Orya", "\u0e42\u0e2d\u0e23\u0e34\u0e22\u0e32" },
            { "cr", "\u0e04\u0e23\u0e35" },
            { "cs", metaValue_CZ },
            { "cu", "\u0e40\u0e0a\u0e2d\u0e23\u0e4c\u0e0a\u0e2a\u0e25\u0e32\u0e27\u0e34\u0e01" },
            { "yrl", "\u0e40\u0e2b\u0e07\u0e07\u0e01\u0e32\u0e15\u0e38" },
            { "cv", "\u0e0a\u0e39\u0e27\u0e31\u0e0a" },
            { "cy", "\u0e40\u0e27\u0e25\u0e2a\u0e4c" },
            { "type.nu.ethi", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22" },
            { "Yiii", "\u0e22\u0e34" },
            { "da", metaValue_DK },
            { "pt_PT", "\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a - \u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "de", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19" },
            { "type.cf.standard", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19" },
            { "bej", "\u0e40\u0e1a\u0e08\u0e32" },
            { "din", "\u0e14\u0e34\u0e07\u0e01\u0e32" },
            { "jut", "\u0e08\u0e31\u0e17" },
            { "Bugi", metaValue_bug },
            { "bem", "\u0e40\u0e1a\u0e21\u0e1a\u0e32" },
            { "sga", "\u0e44\u0e2d\u0e23\u0e34\u0e0a\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "type.nu.mong", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22" },
            { "dv", "\u0e18\u0e34\u0e40\u0e27\u0e2b\u0e34" },
            { "es_419", "\u0e2a\u0e40\u0e1b\u0e19 - \u0e25\u0e30\u0e15\u0e34\u0e19\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32" },
            { "bew", "\u0e40\u0e1a\u0e15\u0e32\u0e27\u0e35" },
            { "dz", "\u0e0b\u0e2d\u0e07\u0e04\u0e32" },
            { "bez", "\u0e40\u0e1a\u0e19\u0e32" },
            { "type.ca.chinese", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e08\u0e35\u0e19" },
            { "lzh", "\u0e08\u0e35\u0e19\u0e04\u0e25\u0e32\u0e2a\u0e2a\u0e34\u0e01" },
            { "Lisu", "\u0e40\u0e1f\u0e23\u0e40\u0e0b\u0e2d\u0e23\u0e4c" },
            { "dje", "\u0e0b\u0e32\u0e23\u0e4c\u0e21\u0e32" },
            { "sgs", "\u0e0b\u0e32\u0e42\u0e21\u0e08\u0e34\u0e40\u0e15\u0e35\u0e22\u0e19" },
            { "type.nu.grek", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e01\u0e23\u0e35\u0e01" },
            { "ee", "\u0e40\u0e2d\u0e40\u0e27" },
            { "bfd", "\u0e1a\u0e32\u0e1f\u0e31\u0e15" },
            { "type.lb.normal", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e1b\u0e01\u0e15\u0e34\u0e02\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e02\u0e36\u0e49\u0e19\u0e1a\u0e23\u0e23\u0e17\u0e31\u0e14\u0e43\u0e2b\u0e21\u0e48" },
            { "ro_MD", metaValue_MD },
            { "el", metaValue_el },
            { "en", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29" },
            { "eo", "\u0e40\u0e2d\u0e2a\u0e40\u0e1b\u0e23\u0e31\u0e19\u0e42\u0e15" },
            { "bfq", "\u0e1e\u0e17\u0e04\u0e30" },
            { "lzz", "\u0e41\u0e25\u0e0b" },
            { "type.co.big5han", "\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e08\u0e35\u0e19\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "Hanb", "\u0e08\u0e35\u0e19\u0e01\u0e25\u0e32\u0e07" },
            { "eu", "\u0e1a\u0e32\u0e2a\u0e01\u0e4c" },
            { "Buhd", "\u0e1a\u0e39\u0e2e\u0e34\u0e14" },
            { "Hang", "\u0e2e\u0e31\u0e19\u0e01\u0e36\u0e25" },
            { "Samr", "\u0e0b\u0e32\u0e21\u0e32\u0e40\u0e23\u0e35\u0e22" },
            { "shi", "\u0e17\u0e32\u0e40\u0e0a\u0e25\u0e35\u0e2b\u0e4c\u0e17" },
            { "hsb", "\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22\u0e15\u0e2d\u0e19\u0e1a\u0e19" },
            { "Hani", "\u0e2e\u0e31\u0e48\u0e19" },
            { "%%ULSTER", "\u0e2d\u0e31\u0e25\u0e2a\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "shn", "\u0e44\u0e17\u0e43\u0e2b\u0e0d\u0e48" },
            { "Hano", "\u0e2e\u0e32\u0e19\u0e39\u0e42\u0e19\u0e42\u0e2d" },
            { "fa", "\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e35\u0e22" },
            { "Hans", metaValue_Hans },
            { "type.nu.latn", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e1a\u0e34\u0e01" },
            { "Hant", metaValue_Hant },
            { "ff", "\u0e1f\u0e39\u0e25\u0e32\u0e2b\u0e4c" },
            { "shu", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a-\u0e0a\u0e32\u0e14" },
            { "hsn", "\u0e08\u0e35\u0e19\u0e40\u0e0b\u0e35\u0e22\u0e07" },
            { "fi", metaValue_FI },
            { "fj", metaValue_FJ },
            { "fon", "\u0e1f\u0e2d\u0e19" },
            { "bgn", "\u0e1a\u0e32\u0e25\u0e39\u0e08\u0e34\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "yue", "\u0e01\u0e27\u0e32\u0e07\u0e15\u0e38\u0e49\u0e07" },
            { "fo", "\u0e41\u0e1f\u0e42\u0e23" },
            { "type.m0.bgn", "\u0e0a\u0e37\u0e48\u0e2d\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 (BGN)" },
            { "umb", "\u0e2d\u0e38\u0e21\u0e1a\u0e38\u0e19\u0e14\u0e39" },
            { "fr", metaValue_FR },
            { "sid", "\u0e0b\u0e34\u0e14\u0e32\u0e42\u0e21" },
            { "fy", "\u0e1f\u0e23\u0e34\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "ga", "\u0e44\u0e2d\u0e23\u0e34\u0e0a" },
            { "gd", "\u0e40\u0e01\u0e25\u0e34\u0e01\u0e2a\u0e01\u0e2d\u0e15" },
            { "gl", "\u0e01\u0e32\u0e25\u0e34\u0e40\u0e0b\u0e35\u0e22" },
            { "gn", "\u0e01\u0e31\u0e27\u0e23\u0e32\u0e19\u0e35" },
            { "bho", "\u0e42\u0e20\u0e0a\u0e1b\u0e38\u0e23\u0e35" },
            { "und", "\u0e20\u0e32\u0e29\u0e32\u0e17\u0e35\u0e48\u0e44\u0e21\u0e48\u0e23\u0e39\u0e49\u0e08\u0e31\u0e01" },
            { "type.ca.ethiopic-amete-alem", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e1b\u0e35\u0e42\u0e25\u0e01\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e2d\u0e34\u0e2a\u0e25\u0e32\u0e21 (\u0e41\u0e1a\u0e1a\u0e15\u0e32\u0e23\u0e32\u0e07 \u0e2a\u0e21\u0e31\u0e22\u0e14\u0e32\u0e23\u0e32\u0e28\u0e32\u0e2a\u0e15\u0e23\u0e4c)" },
            { "gv", "\u0e21\u0e32\u0e19\u0e0b\u0e4c" },
            { "type.nu.osma", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e2d\u0e2a\u0e21\u0e31\u0e19\u0e22\u0e32" },
            { "ha", "\u0e40\u0e2e\u0e32\u0e0b\u0e32" },
            { "he", "\u0e2e\u0e34\u0e1a\u0e23\u0e39" },
            { "hi", "\u0e2e\u0e34\u0e19\u0e14\u0e35" },
            { "hup", "\u0e2e\u0e39\u0e1b\u0e32" },
            { "bik", "\u0e1a\u0e34\u0e01\u0e2d\u0e25" },
            { "bin", "\u0e1a\u0e34\u0e19\u0e35" },
            { "ho", "\u0e2e\u0e35\u0e23\u0e35\u0e42\u0e21\u0e15\u0e39" },
            { "hr", metaValue_HR },
            { "ht", "\u0e40\u0e2e\u0e15\u0e34\u0e04\u0e23\u0e35\u0e42\u0e2d\u0e25" },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "\u0e40\u0e2e\u0e40\u0e23\u0e42\u0e23" },
            { "frc", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a\u0e01\u0e32\u0e0c\u0e47\u0e2d\u0e07" },
            { "%%FONIPA", "\u0e2a\u0e31\u0e17\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e2a\u0e32\u0e01\u0e25" },
            { "ia", "\u0e2d\u0e34\u0e19\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e25\u0e34\u0e07\u0e01\u0e31\u0e27" },
            { "Jamo", "\u0e08\u0e32\u0e42\u0e21" },
            { "id", metaValue_ID },
            { "type.nu.tibt", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e34\u0e40\u0e1a\u0e15" },
            { "ie", "\u0e2d\u0e34\u0e19\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e25\u0e34\u0e07\u0e01\u0e34\u0e27" },
            { "ig", "\u0e2d\u0e34\u0e01\u0e42\u0e1a" },
            { "ii", "\u0e40\u0e2a\u0e09\u0e27\u0e19\u0e22\u0e34" },
            { "frm", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a\u0e01\u0e25\u0e32\u0e07" },
            { "%%RUMGR", "\u0e23\u0e31\u0e21\u0e01\u0e23\u0e4c" },
            { "ik", "\u0e2d\u0e35\u0e19\u0e39\u0e40\u0e1b\u0e35\u0e22\u0e01" },
            { "fro", "\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "frp", "\u0e2d\u0e32\u0e23\u0e4c\u0e1e\u0e34\u0e15\u0e32" },
            { "io", "\u0e2d\u0e35\u0e42\u0e14" },
            { "frs", "\u0e1f\u0e23\u0e34\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "bjn", "\u0e1a\u0e31\u0e19\u0e08\u0e32\u0e23\u0e4c" },
            { "frr", "\u0e1f\u0e23\u0e34\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "\u0e2d\u0e34\u0e19\u0e38\u0e01\u0e15\u0e34\u0e15\u0e38\u0e15" },
            { "sli", "\u0e44\u0e0b\u0e25\u0e35\u0e40\u0e0b\u0e35\u0e22\u0e15\u0e2d\u0e19\u0e25\u0e48\u0e32\u0e07" },
            { "%%HOGNORSK", "\u0e20\u0e32\u0e29\u0e32\u0e19\u0e2d\u0e23\u0e4c\u0e27\u0e34\u0e40\u0e08\u0e35\u0e22\u0e19\u0e2a\u0e39\u0e07" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "Sarb", "\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22\u0e43\u0e15\u0e49\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "Sara", "\u0e0b\u0e32\u0e23\u0e32\u0e15\u0e34" },
            { "doi", "\u0e42\u0e11\u0e04\u0e23\u0e35" },
            { "sly", "\u0e40\u0e0b\u0e25\u0e32\u0e22\u0e32\u0e23\u0e4c" },
            { "type.nu.lepc", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e25\u0e1b\u0e0a\u0e32" },
            { "bkm", "\u0e01\u0e21" },
            { "sma", "\u0e0b\u0e32\u0e21\u0e34\u0e43\u0e15\u0e49" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0e0b\u0e2d\u0e40\u0e27\u0e35\u0e22\u0e19" },
            { "%%BAUDDHA", "\u0e1e\u0e23\u0e30\u0e1e\u0e38\u0e17\u0e18\u0e40\u0e08\u0e49\u0e32" },
            { "mad", "\u0e21\u0e32\u0e14\u0e39\u0e23\u0e32" },
            { "smj", "\u0e0b\u0e32\u0e21\u0e34\u0e25\u0e39\u0e40\u0e25" },
            { "mag", "\u0e21\u0e04\u0e2b\u0e35" },
            { "maf", "\u0e21\u0e32\u0e1f\u0e32" },
            { "mai", "\u0e44\u0e21\u0e16\u0e34\u0e25\u0e35" },
            { "smn", "\u0e0b\u0e32\u0e21\u0e34\u0e2d\u0e35\u0e19\u0e32\u0e23\u0e35" },
            { "ka", metaValue_GE },
            { "bla", "\u0e2a\u0e34\u0e01\u0e2a\u0e34\u0e01\u0e32" },
            { "mak", "\u0e21\u0e32\u0e01\u0e32\u0e0b\u0e32\u0e23\u0e4c" },
            { "wuu", "\u0e08\u0e35\u0e19\u0e2d\u0e39\u0e4b" },
            { "sms", "\u0e0b\u0e32\u0e21\u0e34\u0e2a\u0e04\u0e2d\u0e25\u0e15\u0e4c" },
            { "man", "\u0e21\u0e31\u0e19\u0e14\u0e34\u0e07\u0e01\u0e32" },
            { "kg", "\u0e04\u0e2d\u0e07\u0e42\u0e01" },
            { "Goth", metaValue_got },
            { "ki", "\u0e01\u0e35\u0e01\u0e39\u0e22\u0e39" },
            { "mas", "\u0e21\u0e32\u0e44\u0e0b" },
            { "kj", "\u0e01\u0e27\u0e19\u0e22\u0e32\u0e21\u0e32" },
            { "kk", "\u0e04\u0e32\u0e0b\u0e31\u0e04" },
            { "kl", metaValue_GL },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0e04\u0e32\u0e19\u0e39\u0e23\u0e35" },
            { "ks", "\u0e41\u0e04\u0e0a\u0e40\u0e21\u0e35\u0e22\u0e23\u0e4c" },
            { "Cirt", "\u0e40\u0e0b\u0e34\u0e23\u0e4c\u0e17" },
            { "Lepc", "\u0e40\u0e25\u0e1b\u0e0a\u0e32" },
            { "Avst", metaValue_ae },
            { "ku", "\u0e40\u0e04\u0e34\u0e23\u0e4c\u0e14" },
            { "kv", "\u0e42\u0e01\u0e21\u0e34" },
            { "kw", "\u0e04\u0e2d\u0e23\u0e4c\u0e19\u0e34\u0e0a" },
            { "ky", "\u0e04\u0e35\u0e23\u0e4c\u0e01\u0e35\u0e0b" },
            { "snk", "\u0e42\u0e0b\u0e19\u0e35\u0e19\u0e40\u0e01" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "type.nu.mlym", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e21\u0e32\u0e25\u0e32\u0e22\u0e32\u0e25\u0e31\u0e21" },
            { "lg", metaValue_UG },
            { "Roro", "\u0e23\u0e2d\u0e07\u0e42\u0e01\u0e23\u0e2d\u0e07\u0e42\u0e01" },
            { "li", "\u0e25\u0e34\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0e25\u0e34\u0e07\u0e01\u0e32\u0e25\u0e32" },
            { "fur", "\u0e1f\u0e23\u0e39\u0e25\u0e35" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "\u0e23\u0e30\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e27\u0e31\u0e14\u0e2d\u0e34\u0e21\u0e1e\u0e35\u0e40\u0e23\u0e35\u0e22\u0e25" },
            { "type.nu.lana", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e44\u0e17\u0e17\u0e31\u0e21\u0e42\u0e2e\u0e23\u0e32" },
            { "lt", metaValue_LT },
            { "lu", "\u0e25\u0e39\u0e1a\u0e32-\u0e01\u0e32\u0e15\u0e2d\u0e07\u0e01\u0e32" },
            { "lv", metaValue_LV },
            { "sog", "\u0e0b\u0e2d\u0e01\u0e14\u0e35\u0e19" },
            { "mg", "\u0e21\u0e32\u0e25\u0e32\u0e01\u0e32\u0e0b\u0e35" },
            { "mh", "\u0e21\u0e32\u0e23\u0e4c\u0e41\u0e0a\u0e25\u0e25\u0e34\u0e2a" },
            { "type.co.ducet", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21 Unicode \u0e40\u0e23\u0e34\u0e48\u0e21\u0e15\u0e49\u0e19" },
            { "mi", "\u0e40\u0e21\u0e32\u0e23\u0e35" },
            { "mk", "\u0e21\u0e32\u0e0b\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22" },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "\u0e21\u0e23\u0e32\u0e10\u0e35" },
            { "ms", "\u0e21\u0e32\u0e40\u0e25\u0e22\u0e4c" },
            { "mt", metaValue_MT },
            { "my", metaValue_my },
            { "Saur", "\u0e42\u0e2a\u0e27\u0e23\u0e31\u0e2a\u0e15\u0e23\u0e30" },
            { "Armn", metaValue_AM },
            { "mdf", "\u0e21\u0e2d\u0e04\u0e0a\u0e32" },
            { "mde", "\u0e21\u0e32\u0e1a\u0e32" },
            { "dsb", "\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22\u0e15\u0e2d\u0e19\u0e25\u0e48\u0e32\u0e07" },
            { "Armi", "\u0e2d\u0e34\u0e21\u0e1e\u0e35\u0e40\u0e23\u0e35\u0e22\u0e25 \u0e2d\u0e23\u0e32\u0e40\u0e21\u0e2d\u0e34\u0e01" },
            { "na", metaValue_NR },
            { "type.co.search", "\u0e01\u0e32\u0e23\u0e04\u0e49\u0e19\u0e2b\u0e32\u0e17\u0e31\u0e48\u0e27\u0e44\u0e1b" },
            { "nb", "\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c\u0e1a\u0e38\u0e04\u0e21\u0e2d\u0e25" },
            { "nd", "\u0e40\u0e2d\u0e47\u0e19\u0e40\u0e14\u0e40\u0e1a\u0e40\u0e25\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "ne", metaValue_NP },
            { "ng", "\u0e14\u0e2d\u0e07\u0e01\u0e32" },
            { "mdr", "\u0e21\u0e32\u0e19\u0e14\u0e32\u0e23\u0e4c" },
            { "nl", "\u0e14\u0e31\u0e15\u0e0a\u0e4c" },
            { "nn", "\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c\u0e19\u0e35\u0e19\u0e2d\u0e2a\u0e01\u0e4c" },
            { "no", metaValue_NO },
            { "nr", "\u0e40\u0e2d\u0e47\u0e19\u0e40\u0e14\u0e40\u0e1a\u0e40\u0e25\u0e43\u0e15\u0e49" },
            { "nv", "\u0e19\u0e32\u0e27\u0e32\u0e42\u0e2e" },
            { "kaa", "\u0e01\u0e32\u0e23\u0e32-\u0e01\u0e32\u0e25\u0e1e\u0e32\u0e01" },
            { "ny", "\u0e40\u0e19\u0e35\u0e22\u0e19\u0e08\u0e32" },
            { "kac", "\u0e01\u0e30\u0e09\u0e34\u0e48\u0e19" },
            { "kab", "\u0e01\u0e32\u0e44\u0e1a\u0e25" },
            { "%%POLYTON", "\u0e42\u0e1e\u0e25\u0e35\u0e42\u0e17\u0e19\u0e34\u0e01" },
            { "oc", "\u0e2d\u0e47\u0e2d\u0e01\u0e0b\u0e34\u0e15\u0e31\u0e19" },
            { "kaj", "\u0e04\u0e08\u0e39" },
            { "kam", "\u0e04\u0e31\u0e21\u0e1a\u0e32" },
            { "men", metaValue_men },
            { "%%EMODENG", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29\u0e2a\u0e21\u0e31\u0e22\u0e43\u0e2b\u0e21\u0e48\u0e15\u0e2d\u0e19\u0e15\u0e49\u0e19" },
            { "oj", "\u0e42\u0e2d\u0e08\u0e34\u0e1a\u0e27\u0e32" },
            { "mer", "\u0e40\u0e21\u0e23\u0e39" },
            { "type.nu.armn", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22" },
            { "om", "\u0e42\u0e2d\u0e42\u0e23\u0e42\u0e21" },
            { "kaw", "\u0e01\u0e27\u0e35" },
            { "dtp", "\u0e14\u0e39\u0e0b\u0e38\u0e19\u0e01\u0e25\u0e32\u0e07" },
            { "or", "\u0e42\u0e2d\u0e14\u0e34\u0e22\u0e32" },
            { "Modi", "\u0e42\u0e21\u0e11\u0e35" },
            { "os", "\u0e2d\u0e2d\u0e2a\u0e40\u0e0b\u0e40\u0e15\u0e35\u0e22" },
            { "%%ALALC97", "\u0e01\u0e32\u0e23\u0e16\u0e2d\u0e14\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e40\u0e1b\u0e47\u0e19\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e42\u0e23\u0e21\u0e31\u0e19\u0e15\u0e32\u0e21\u0e40\u0e01\u0e13\u0e11\u0e4c\u0e02\u0e2d\u0e07\u0e2a\u0e21\u0e32\u0e04\u0e21\u0e2b\u0e49\u0e2d\u0e07\u0e2a\u0e21\u0e38\u0e14\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19\u0e41\u0e25\u0e30\u0e2b\u0e49\u0e2d\u0e07\u0e2a\u0e21\u0e38\u0e14\u0e23\u0e31\u0e10\u0e2a\u0e20\u0e32 \u0e09\u0e1a\u0e31\u0e1a\u0e1e\u0e34\u0e21\u0e1e\u0e4c\u0e1b\u0e35 1997" },
            { "bpy", "\u0e1e\u0e34\u0e28\u0e19\u0e38\u0e1b\u0e23\u0e34\u0e22\u0e30" },
            { "kbd", "\u0e04\u0e32\u0e23\u0e4c\u0e1a\u0e32\u0e40\u0e14\u0e35\u0e22" },
            { "mfe", "\u0e21\u0e2d\u0e23\u0e34\u0e2a\u0e40\u0e22\u0e19" },
            { "srn", metaValue_SR },
            { "pa", "\u0e1b\u0e31\u0e0d\u0e08\u0e32\u0e1a" },
            { "dua", "\u0e14\u0e31\u0e27\u0e25\u0e32" },
            { "srr", "\u0e40\u0e0b\u0e41\u0e23\u0e23\u0e4c" },
            { "%%LIPAW", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e25\u0e34\u0e42\u0e1e\u0e27\u0e32\u0e0b\u0e02\u0e2d\u0e07\u0e40\u0e23\u0e40\u0e0b\u0e35\u0e22\u0e19" },
            { "kbl", "\u0e04\u0e32\u0e40\u0e19\u0e21\u0e1a\u0e39" },
            { "pi", "\u0e1a\u0e32\u0e25\u0e35" },
            { "bqi", "\u0e1a\u0e31\u0e01\u0e15\u0e34\u0e22\u0e32\u0e23\u0e35" },
            { "pl", metaValue_PL },
            { "dum", "\u0e14\u0e31\u0e15\u0e0a\u0e4c\u0e01\u0e25\u0e32\u0e07" },
            { "type.nu.saur", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e28\u0e32\u0e23\u0e31\u0e0a\u0e18\u0e23\u0e32" },
            { "type.ca.dangi", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e17\u0e31\u0e19\u0e01\u0e34" },
            { "%%VALLADER", "\u0e27\u0e31\u0e25\u0e25\u0e32\u0e40\u0e14\u0e2d\u0e23\u0e4c" },
            { "ps", "\u0e1e\u0e31\u0e0a\u0e42\u0e15" },
            { "pt", metaValue_PT },
            { "mga", "\u0e44\u0e2d\u0e23\u0e34\u0e0a\u0e01\u0e25\u0e32\u0e07" },
            { "key.co", "\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e01\u0e32\u0e23\u0e08\u0e31\u0e14\u0e40\u0e23\u0e35\u0e22\u0e07" },
            { "pt_BR", "\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a - \u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25" },
            { "%%BOHORIC", "\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e42\u0e1a\u0e42\u0e2e\u0e23\u0e34\u0e0a" },
            { "kcg", "\u0e17\u0e35\u0e41\u0e22\u0e1b" },
            { "mgh", "\u0e21\u0e32\u0e01\u0e31\u0e27\u0e27\u0e32-\u0e21\u0e35\u0e17\u0e42\u0e17" },
            { "key.cf", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19" },
            { "type.nu.nkoo", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e2d\u0e47\u0e19\u0e42\u0e01" },
            { "bra", "\u0e1e\u0e31\u0e23\u0e0a" },
            { "key.ca", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19" },
            { "%%JAUER", "\u0e40\u0e22\u0e32\u0e40\u0e2d\u0e2d\u0e23\u0e4c" },
            { "Laoo", metaValue_LA },
            { "%%SURMIRAN", "\u0e0b\u0e39\u0e23\u0e4c\u0e21\u0e34\u0e23\u0e32\u0e19" },
            { "mgo", "\u0e40\u0e21\u0e15\u0e32" },
            { "type.hc.h23", "\u0e23\u0e30\u0e1a\u0e1a 24 \u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (0\u201323)" },
            { "type.hc.h24", "\u0e23\u0e30\u0e1a\u0e1a 24 \u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "\u0e1a\u0e23\u0e32\u0e2e\u0e38\u0e22" },
            { "type.nu.mymr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e1e\u0e21\u0e48\u0e32" },
            { "qu", "\u0e40\u0e04\u0e0a\u0e27\u0e32" },
            { "zap", "\u0e0b\u0e32\u0e42\u0e1b\u0e40\u0e15\u0e01" },
            { "brx", "\u0e42\u0e1e\u0e42\u0e11" },
            { "Lana", "\u0e25\u0e49\u0e32\u0e19\u0e19\u0e32" },
            { "kde", "\u0e21\u0e32\u0e04\u0e2d\u0e19\u0e40\u0e14" },
            { "%%VAIDIKA", "\u0e40\u0e27\u0e14\u0e34\u0e04\u0e32" },
            { "stq", "\u0e1f\u0e23\u0e35\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e0b\u0e31\u0e17\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "Ethi", "\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e1b\u0e34\u0e01" },
            { "%%JYUTPING", "\u0e23\u0e30\u0e1a\u0e1a\u0e16\u0e2d\u0e14\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e41\u0e1a\u0e1a\u0e22\u0e27\u0e36\u0e14\u0e1e\u0e34\u0e07" },
            { "type.hc.h12", "\u0e23\u0e30\u0e1a\u0e1a 12 \u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (1\u201312)" },
            { "type.hc.h11", "\u0e23\u0e30\u0e1a\u0e1a 12 \u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (0\u201311)" },
            { "rm", "\u0e42\u0e23\u0e41\u0e21\u0e19\u0e0b\u0e4c" },
            { "rn", metaValue_BI },
            { "key.cu", "\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19" },
            { "ro", metaValue_RO },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e2d\u0e23\u0e34\u0e22\u0e32" },
            { "type.nu.hanidec", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e28\u0e19\u0e34\u0e22\u0e21\u0e08\u0e35\u0e19" },
            { "ru", metaValue_RU },
            { "bss", "\u0e2d\u0e32\u0e42\u0e04\u0e0b\u0e35" },
            { "rw", metaValue_RW },
            { "zbl", metaValue_zbl },
            { "kea", "\u0e04\u0e32\u0e1a\u0e39\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e40\u0e14\u0e35\u0e22\u0e19\u0e39" },
            { "mic", "\u0e21\u0e34\u0e01\u0e41\u0e21\u0e01" },
            { "suk", "\u0e0b\u0e39\u0e04\u0e39\u0e21\u0e32" },
            { "en_AU", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 - \u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22" },
            { "Dupl", "\u0e0a\u0e27\u0e40\u0e25\u0e02\u0e14\u0e31\u0e1b\u0e42\u0e25\u0e22\u0e31\u0e19" },
            { "sa", "\u0e2a\u0e31\u0e19\u0e2a\u0e01\u0e24\u0e15" },
            { "%%UCCOR", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e27\u0e34\u0e18\u0e35\u0e41\u0e1a\u0e1a\u0e04\u0e23\u0e1a\u0e27\u0e07\u0e08\u0e23" },
            { "sc", "\u0e0b\u0e32\u0e23\u0e4c\u0e40\u0e14\u0e0d\u0e32" },
            { "sus", "\u0e0b\u0e39\u0e0b\u0e39" },
            { "sd", "\u0e2a\u0e34\u0e19\u0e18\u0e34" },
            { "se", "\u0e0b\u0e32\u0e21\u0e34\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "min", "\u0e21\u0e35\u0e19\u0e31\u0e07\u0e01\u0e32\u0e40\u0e1a\u0e32" },
            { "sg", "\u0e0b\u0e31\u0e19\u0e42\u0e01" },
            { "sh", "\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e42\u0e1a-\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22" },
            { "ken", "\u0e40\u0e01\u0e34\u0e19\u0e22\u0e32\u0e07" },
            { "si", metaValue_si },
            { "sux", "\u0e0b\u0e39\u0e40\u0e21\u0e2d" },
            { "sk", "\u0e2a\u0e42\u0e25\u0e27\u0e31\u0e01" },
            { "sl", metaValue_SI },
            { "Gran", "\u0e04\u0e24\u0e13\u0e2b\u0e4c" },
            { "sm", metaValue_WS },
            { "sn", "\u0e42\u0e0a\u0e19\u0e32" },
            { "so", "\u0e42\u0e0b\u0e21\u0e32\u0e25\u0e35" },
            { "type.nu.arab", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e2d\u0e32\u0e23\u0e1a\u0e34\u0e01-\u0e2d\u0e34\u0e19\u0e14\u0e34\u0e01" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", "\u0e2a\u0e27\u0e32\u0e15\u0e34" },
            { "type.cf.account", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e2a\u0e01\u0e38\u0e25\u0e40\u0e07\u0e34\u0e19\u0e1a\u0e31\u0e0d\u0e0a\u0e35" },
            { "Java", metaValue_jv },
            { "st", "\u0e42\u0e0b\u0e42\u0e17\u0e43\u0e15\u0e49" },
            { "su", metaValue_su },
            { "%%NEDIS", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e19\u0e32\u0e17\u0e34\u0e42\u0e0b\u0e40\u0e19" },
            { "sv", metaValue_SE },
            { "sw", "\u0e2a\u0e27\u0e32\u0e2e\u0e35\u0e25\u0e35" },
            { "type.nu.hantfin", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e07\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19\u0e41\u0e1a\u0e1a\u0e15\u0e31\u0e27\u0e40\u0e15\u0e47\u0e21\u0e02\u0e2d\u0e07\u0e08\u0e35\u0e19" },
            { "ibb", "\u0e2d\u0e34\u0e1a\u0e34\u0e1a\u0e34\u0e42\u0e2d" },
            { "iba", "\u0e2d\u0e34\u0e1a\u0e32\u0e19" },
            { "ta", metaValue_ta },
            { "142", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22" },
            { "bua", "\u0e1a\u0e39\u0e40\u0e23\u0e35\u0e22\u0e15" },
            { "143", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e01\u0e25\u0e32\u0e07" },
            { "te", metaValue_te },
            { "145", "\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "tg", "\u0e17\u0e32\u0e08\u0e34\u0e01" },
            { "th", metaValue_TH },
            { "bug", metaValue_bug },
            { "ti", "\u0e15\u0e34\u0e01\u0e23\u0e34\u0e0d\u0e0d\u0e32" },
            { "kfo", "\u0e42\u0e04\u0e42\u0e23" },
            { "en_CA", "\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29 - \u0e41\u0e04\u0e19\u0e32\u0e14\u0e32" },
            { "tk", "\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19" },
            { "tl", metaValue_tl },
            { "tn", metaValue_BW },
            { "to", metaValue_TO },
            { "bum", "\u0e1a\u0e39\u0e25\u0e39" },
            { "dyo", "\u0e42\u0e08\u0e25\u0e32-\u0e1f\u0e2d\u0e19\u0e22\u0e35" },
            { "type.nu.jpan", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19" },
            { "tr", metaValue_TR },
            { "ts", "\u0e0b\u0e34\u0e15\u0e0b\u0e2d\u0e07\u0e01\u0e32" },
            { "swb", "\u0e42\u0e04\u0e40\u0e21\u0e2d\u0e40\u0e23\u0e35\u0e22\u0e19" },
            { "Cakm", "\u0e0a\u0e32\u0e01\u0e21\u0e32" },
            { "tt", "\u0e15\u0e32\u0e15\u0e32\u0e23\u0e4c" },
            { "dyu", "\u0e14\u0e34\u0e27\u0e25\u0e32" },
            { "tw", "\u0e17\u0e27\u0e34" },
            { "ty", "\u0e15\u0e32\u0e2e\u0e34\u0e15\u0e35" },
            { "%%BISKE", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e0b\u0e32\u0e19\u0e08\u0e2d\u0e23\u0e4c\u0e42\u0e08/\u0e1a\u0e34\u0e25\u0e32" },
            { "150", "\u0e22\u0e38\u0e42\u0e23\u0e1b" },
            { "151", "\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "154", "\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e40\u0e2b\u0e19\u0e37\u0e2d" },
            { "dzg", "\u0e14\u0e32\u0e0b\u0e32\u0e01\u0e32" },
            { "155", "\u0e22\u0e38\u0e42\u0e23\u0e1b\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "ug", "\u0e2d\u0e38\u0e22\u0e01\u0e39\u0e23\u0e4c" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "kgp", "\u0e40\u0e04\u0e19\u0e01\u0e48\u0e32\u0e07" },
            { "Zyyy", "\u0e2a\u0e32\u0e21\u0e31\u0e0d" },
            { "uk", metaValue_UA },
            { "zea", "\u0e40\u0e0b\u0e41\u0e25\u0e19\u0e14\u0e4c" },
            { "type.ca.coptic", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e04\u0e2d\u0e1b\u0e15\u0e34\u0e01" },
            { "ur", "\u0e2d\u0e39\u0e23\u0e14\u0e39" },
            { "%%1994", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e30\u0e40\u0e23\u0e40\u0e0b\u0e35\u0e22\u0e19\u0e21\u0e32\u0e15\u0e23\u0e32\u0e10\u0e32\u0e19" },
            { "xal", "\u0e04\u0e31\u0e25\u0e21\u0e37\u0e22\u0e04\u0e4c" },
            { "zen", "\u0e40\u0e0b\u0e19\u0e32\u0e01\u0e32" },
            { "uz", "\u0e2d\u0e38\u0e0b\u0e40\u0e1a\u0e01" },
            { "kha", "\u0e01\u0e32\u0e2a\u0e35" },
            { "%%1996", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2d\u0e2d\u0e23\u0e4c\u0e42\u0e18\u0e01\u0e23\u0e32\u0e1f\u0e35\u0e1b\u0e35 1996" },
            { "nds_NL", "\u0e41\u0e0b\u0e01\u0e0b\u0e2d\u0e19\u0e43\u0e15\u0e49" },
            { "Sylo", "\u0e0b\u0e34\u0e42\u0e25\u0e15\u0e34\u0e19\u0e32\u0e01\u0e23\u0e35" },
            { "ve", "\u0e40\u0e27\u0e19\u0e14\u0e32" },
            { "Wara", "\u0e27\u0e32\u0e23\u0e31\u0e07\u0e01\u0e2a\u0e34\u0e15\u0e34" },
            { "type.ca.roc", "\u0e1b\u0e0f\u0e34\u0e17\u0e34\u0e19\u0e44\u0e15\u0e49\u0e2b\u0e27\u0e31\u0e19" },
            { "vi", metaValue_VN },
            { "kho", "\u0e42\u0e04\u0e15\u0e31\u0e19" },
            { "khq", "\u0e42\u0e04\u0e22\u0e4c\u0e23\u0e32\u0e0a\u0e35\u0e19\u0e35" },
            { "key.hc", "\u0e27\u0e07\u0e08\u0e23\u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07 (\u0e40\u0e17\u0e35\u0e22\u0e1a 12 \u0e41\u0e25\u0e30 24)" },
            { "%%TARASK", "\u0e17\u0e32\u0e23\u0e32\u0e0b\u0e40\u0e04\u0e35\u0e22\u0e27\u0e34\u0e0b\u0e32\u0e2d\u0e2d\u0e23\u0e4c\u0e42\u0e18\u0e01\u0e23\u0e32\u0e1f\u0e35" },
            { "vo", "\u0e42\u0e27\u0e25\u0e32\u0e1e\u0e36\u0e04" },
            { "khw", "\u0e42\u0e04\u0e27\u0e32\u0e23\u0e4c" },
            { "syc", "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22\u0e41\u0e1a\u0e1a\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "Osma", "\u0e2d\u0e2d\u0e2a\u0e21\u0e31\u0e19\u0e22\u0e32" },
            { "quc", "\u0e01\u0e35\u0e40\u0e0a" },
            { "qug", "\u0e04\u0e27\u0e34\u0e0a\u0e31\u0e27\u0e44\u0e2e\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e0a\u0e34\u0e21\u0e42\u0e1a\u0e23\u0e32\u0e42\u0e0b" },
            { "gaa", "\u0e01\u0e32" },
            { "wa", "\u0e27\u0e32\u0e42\u0e25\u0e19\u0e35" },
            { "gag", "\u0e01\u0e32\u0e01\u0e32\u0e2d\u0e38\u0e0b" },
            { "syr", metaValue_SY },
            { "Grek", metaValue_el },
            { "gan", "\u0e08\u0e35\u0e19\u0e01\u0e31\u0e49\u0e19" },
            { "kiu", "\u0e40\u0e04\u0e2d\u0e23\u0e4c\u0e21\u0e32\u0e19\u0e34\u0e01\u0e34" },
            { "Lydi", "\u0e25\u0e35\u0e40\u0e14\u0e35\u0e22" },
            { "Xsux", "\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e23\u0e39\u0e1b\u0e25\u0e34\u0e48\u0e21\u0e2a\u0e38\u0e40\u0e21\u0e40\u0e23\u0e35\u0e22-\u0e2d\u0e31\u0e04\u0e04\u0e32\u0e40\u0e14\u0e35\u0e22" },
            { "wo", "\u0e42\u0e27\u0e25\u0e2d\u0e1f" },
            { "zgh", "\u0e17\u0e32\u0e21\u0e32\u0e44\u0e0b\u0e15\u0e4c\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19" },
            { "ar_001", "\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19\u0e2a\u0e21\u0e31\u0e22\u0e43\u0e2b\u0e21\u0e48" },
            { "Cans", "\u0e2a\u0e31\u0e0d\u0e25\u0e31\u0e01\u0e29\u0e13\u0e4c\u0e0a\u0e19\u0e40\u0e1c\u0e48\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32" },
            { "%%FONXSAMP", "\u0e1f\u0e2d\u0e19\u0e0b\u0e4c\u0e41\u0e0b\u0e21\u0e1e\u0e4c" },
            { "gay", "\u0e01\u0e32\u0e42\u0e22" },
            { "Mong", metaValue_MN },
            { "mnc", "\u0e41\u0e21\u0e19\u0e08\u0e39" },
            { "Latf", "\u0e25\u0e32\u0e15\u0e34\u0e19 - \u0e1f\u0e23\u0e31\u0e07\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "szl", "\u0e44\u0e0b\u0e25\u0e35\u0e40\u0e0b\u0e35\u0e22" },
            { "Hluw", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e30\u0e2d\u0e32\u0e19\u0e32\u0e42\u0e15\u0e40\u0e25\u0e35\u0e22" },
            { "gba", "\u0e01\u0e1a\u0e32\u0e22\u0e32" },
            { "mni", "\u0e21\u0e13\u0e35\u0e1b\u0e38\u0e23\u0e30" },
            { "Latn", metaValue_la },
            { "Latg", "\u0e25\u0e32\u0e15\u0e34\u0e19 - \u0e41\u0e01\u0e25\u0e34\u0e01" },
            { "type.nu.hans", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e08\u0e35\u0e19\u0e15\u0e31\u0e27\u0e22\u0e48\u0e2d" },
            { "type.nu.hant", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e08\u0e35\u0e19\u0e15\u0e31\u0e27\u0e40\u0e15\u0e47\u0e21" },
            { "xh", "\u0e04\u0e30\u0e2b\u0e4c\u0e42\u0e2d\u0e0b\u0e32" },
            { "type.nu.romanlow", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e23\u0e21\u0e31\u0e19\u0e1e\u0e34\u0e21\u0e1e\u0e4c\u0e40\u0e25\u0e47\u0e01" },
            { "byn", "\u0e1a\u0e25\u0e34\u0e19" },
            { "%%PAMAKA", "\u0e20\u0e32\u0e29\u0e32\u0e1e\u0e37\u0e49\u0e19\u0e40\u0e21\u0e37\u0e2d\u0e07\u0e1e\u0e32\u0e21\u0e32\u0e04\u0e32" },
            { "Lyci", "\u0e44\u0e25\u0e40\u0e0b\u0e35\u0e22" },
            { "osa", "\u0e42\u0e2d\u0e0b\u0e32\u0e01\u0e35" },
            { "byv", "\u0e40\u0e21\u0e14\u0e38\u0e21\u0e1a\u0e32" },
            { "gbz", "\u0e14\u0e32\u0e23\u0e35\u0e42\u0e0b\u0e42\u0e23\u0e2d\u0e31\u0e2a\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "Moon", "\u0e21\u0e39\u0e19" },
            { "moh", "\u0e42\u0e21\u0e2e\u0e2d\u0e27\u0e4c\u0e01" },
            { "kkj", "\u0e04\u0e32\u0e42\u0e01" },
            { "%%1694ACAD", "\u0e15\u0e2d\u0e19\u0e15\u0e49\u0e19\u0e22\u0e38\u0e04\u0e43\u0e2b\u0e21\u0e48\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a" },
            { "Syrc", metaValue_SY },
            { "yi", "\u0e22\u0e34\u0e14\u0e14\u0e34\u0e0a" },
            { "mos", "\u0e42\u0e21\u0e0b\u0e35" },
            { "Dsrt", "\u0e40\u0e14\u0e40\u0e0b\u0e40\u0e23\u0e17" },
            { "yo", "\u0e42\u0e22\u0e23\u0e39\u0e1a\u0e32" },
            { "type.nu.traditional", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e41\u0e1a\u0e1a\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "es_MX", "\u0e2a\u0e40\u0e1b\u0e19 - \u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01" },
            { "Syrj", "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "ota", "\u0e15\u0e38\u0e23\u0e01\u0e35\u0e2d\u0e2d\u0e15\u0e42\u0e15\u0e21\u0e31\u0e19" },
            { "Syre", "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22\u0e40\u0e2d\u0e2a\u0e17\u0e23\u0e32\u0e19\u0e08\u0e35\u0e42\u0e25" },
            { "vai", metaValue_vai },
            { "za", "\u0e08\u0e49\u0e27\u0e07" },
            { "Cari", "\u0e04\u0e32\u0e40\u0e23\u0e35\u0e22" },
            { "kln", "\u0e04\u0e32\u0e40\u0e25\u0e19\u0e08\u0e34\u0e19" },
            { "zh", metaValue_CN },
            { "Afak", "\u0e2d\u0e30\u0e1f\u0e32\u0e04\u0e32" },
            { "Bopo", "\u0e1b\u0e2d\u0e1e\u0e2d\u0e21\u0e2d\u0e1f\u0e2d" },
            { "Perm", "\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e21\u0e34\u0e01\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "key.lb", "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e02\u0e36\u0e49\u0e19\u0e1a\u0e23\u0e23\u0e17\u0e31\u0e14\u0e43\u0e2b\u0e21\u0e48" },
            { "zu", "\u0e0b\u0e39\u0e25\u0e39" },
            { "type.co.phonebook", "\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e2a\u0e21\u0e38\u0e14\u0e42\u0e17\u0e23\u0e28\u0e31\u0e1e\u0e17\u0e4c" },
            { "%%MONOTON", "\u0e42\u0e21\u0e42\u0e19\u0e42\u0e17\u0e19\u0e34\u0e01" },
            { "Geor", metaValue_GE },
            { "Shrd", "\u0e0a\u0e32\u0e23\u0e32\u0e14\u0e32" },
            { "kmb", "\u0e04\u0e34\u0e21\u0e1a\u0e38\u0e19\u0e14\u0e39" },
            { "type.nu.jpanfin", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e32\u0e07\u0e01\u0e32\u0e23\u0e40\u0e07\u0e34\u0e19\u0e02\u0e2d\u0e07\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19" },
            { "Cham", "\u0e08\u0e32\u0e21" },
            { "gez", "\u0e01\u0e35\u0e0b" },
            { "mrj", "\u0e21\u0e32\u0e23\u0e35\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01" },
            { "Syrn", "\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01" },
            { "type.nu.mymrshan", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e0a\u0e32\u0e19\u0e1e\u0e21\u0e48\u0e32" },
            { "Elba", "\u0e40\u0e2d\u0e25\u0e1a\u0e4c\u0e0b\u0e32\u0e19" },
            { "Narb", "\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22\u0e40\u0e2b\u0e19\u0e37\u0e2d\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "type.nu.olck", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e42\u0e2d\u0e25\u0e08\u0e34\u0e01\u0e34" },
            { "type.co.reformed", "\u0e40\u0e23\u0e35\u0e22\u0e07\u0e15\u0e32\u0e21\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e25\u0e48\u0e32\u0e2a\u0e38\u0e14" },
            { "Tglg", metaValue_tl },
            { "Egyd", "\u0e14\u0e35\u0e42\u0e21\u0e15\u0e34\u0e01\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "Egyh", "\u0e40\u0e2e\u0e35\u0e22\u0e23\u0e32\u0e15\u0e34\u0e01\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "%%ITIHASA", "\u0e2d\u0e34\u0e15\u0e34\u0e2b\u0e32\u0e2a\u0e30" },
            { "Palm", "\u0e1e\u0e32\u0e25\u0e44\u0e21\u0e23\u0e35\u0e19" },
            { "ebu", "\u0e40\u0e2d\u0e47\u0e21\u0e1a\u0e39" },
            { "Egyp", "\u0e40\u0e2e\u0e35\u0e22\u0e42\u0e23\u0e01\u0e25\u0e34\u0e1f\u0e2a\u0e4c\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c" },
            { "Geok", "\u0e04\u0e31\u0e15\u0e0b\u0e39\u0e23\u0e35\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22" },
            { "zh_Hans", "\u0e08\u0e35\u0e19\u0e1b\u0e23\u0e30\u0e22\u0e38\u0e01\u0e15\u0e4c" },
            { "koi", "\u0e42\u0e04\u0e21\u0e34-\u0e40\u0e1b\u0e35\u0e22\u0e23\u0e4c\u0e40\u0e21\u0e35\u0e22\u0e04" },
            { "Hung", "\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35\u0e42\u0e1a\u0e23\u0e32\u0e13" },
            { "kok", "\u0e01\u0e2d\u0e19\u0e01\u0e32\u0e19\u0e35" },
            { "%%1901", "\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19\u0e2d\u0e2d\u0e23\u0e4c\u0e42\u0e18\u0e01\u0e23\u0e32\u0e1f\u0e35\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "kos", "\u0e04\u0e39\u0e2a\u0e44\u0e23" },
            { "vec", "\u0e40\u0e27\u0e40\u0e19\u0e42\u0e15\u0e49" },
            { "type.nu.limb", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e25\u0e34\u0e21\u0e1a\u0e39" },
            { "zh_Hant", "\u0e08\u0e35\u0e19\u0e14\u0e31\u0e49\u0e07\u0e40\u0e14\u0e34\u0e21" },
            { "Sund", metaValue_su },
            { "vep", "\u0e40\u0e27\u0e1b\u0e2a\u0e4c" },
            { "kpe", "\u0e01\u0e32\u0e41\u0e1b\u0e25" },
            { "type.nu.khmr", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e40\u0e02\u0e21\u0e23" },
            { "Tirh", "\u0e40\u0e17\u0e2d\u0e2e\u0e38\u0e17\u0e32" },
            { "ilo", "\u0e2d\u0e35\u0e42\u0e25\u0e42\u0e01" },
            { "%%VALENCIA", "\u0e27\u0e32\u0e40\u0e25\u0e19\u0e40\u0e0b\u0e35\u0e22" },
            { "Cprt", "\u0e44\u0e0b\u0e40\u0e1b\u0e23\u0e35\u0e22\u0e17" },
            { "%%BAKU1926", "\u0e15\u0e31\u0e27\u0e2d\u0e31\u0e01\u0e29\u0e23\u0e25\u0e30\u0e15\u0e34\u0e19\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e01\u0e34\u0e01\u0e41\u0e1a\u0e1a\u0e04\u0e23\u0e1a\u0e27\u0e07\u0e08\u0e23" },
            { "mua", "\u0e21\u0e31\u0e19\u0e14\u0e31\u0e07" },
            { "type.nu.guru", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e01\u0e39\u0e23\u0e4c\u0e21\u0e39\u0e04\u0e35" },
            { "mul", "\u0e2b\u0e25\u0e32\u0e22\u0e20\u0e32\u0e29\u0e32" },
            { "%%PUTER", "\u0e1e\u0e34\u0e27\u0e40\u0e15\u0e2d\u0e23\u0e4c" },
            { "cad", "\u0e04\u0e31\u0e14\u0e42\u0e14" },
            { "key.ms", "\u0e23\u0e30\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e27\u0e31\u0e14" },
            { "mus", "\u0e04\u0e23\u0e35\u0e01" },
            { "Glag", "\u0e01\u0e25\u0e32\u0e42\u0e01\u0e25\u0e34\u0e15\u0e34\u0e01" },
            { "gil", "\u0e01\u0e34\u0e25\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e15" },
            { "%%KKCOR", "\u0e2d\u0e31\u0e01\u0e02\u0e23\u0e27\u0e34\u0e18\u0e35\u0e2a\u0e32\u0e21\u0e31\u0e0d" },
            { "Cher", metaValue_chr },
            { "car", "\u0e04\u0e32\u0e23\u0e34\u0e1a" },
            { "cay", "\u0e04\u0e32\u0e22\u0e39\u0e01\u0e32" },
            { "type.nu.tamldec", "\u0e15\u0e31\u0e27\u0e40\u0e25\u0e02\u0e17\u0e21\u0e34\u0e2c" },
            { "krc", "\u0e04\u0e32\u0e23\u0e32\u0e44\u0e0a-\u0e1a\u0e31\u0e25\u0e04\u0e32\u0e23\u0e4c" },
            { "inh", "\u0e2d\u0e34\u0e19\u0e01\u0e38\u0e0a" },
            { "krj", "\u0e01\u0e34\u0e19\u0e32\u0e23\u0e32\u0e22\u0e2d\u0e32" },
            { "kri", "\u0e04\u0e23\u0e34\u0e42\u0e2d" },
            { "krl", "\u0e41\u0e01\u0e23\u0e40\u0e25\u0e35\u0e22\u0e19" },
            { "efi", "\u0e2d\u0e35\u0e1f\u0e34\u0e01" },
            { "key.nu", metaValue_key_nu },
            { "tcy", "\u0e15\u0e39\u0e25\u0e39" },
            { "kru", "\u0e01\u0e38\u0e23\u0e38\u0e02" },
            { "ksb", "\u0e0a\u0e31\u0e21\u0e1a\u0e32\u0e25\u0e32" },
            { "Telu", metaValue_te },
            { "ksf", "\u0e1a\u0e32\u0e40\u0e1f\u0e35\u0e22" },
        };
        return data;
    }
}
