# Copyright 2010 28msec Inc.

# - Try to find Graphviz and the libraries it depends on
# Once done this will define
#
#  GRAPHVIZ_FOUND         - system has graphviz
#  GRAPHVIZ_INCLUDE_DIRS  - the graphviz include directory
#  GRAPHVIZ_LIBRARIES     - Link these to use graphviz

IF (GRAPHVIZ_INCLUDE AND GRAPHVIZ_LIBRARY AND GVC_LIBRARY AND CDT_LIBRARY AND PATHPLAN_LIBRARY AND EXPAT_LIBRARY)
   # in cache already
   SET(GRAPHVIZ_FIND_QUIETLY TRUE)
ENDIF (GRAPHVIZ_INCLUDE AND GRAPHVIZ_LIBRARY AND GVC_LIBRARY AND CDT_LIBRARY AND PATHPLAN_LIBRARY AND EXPAT_LIBRARY)

FIND_PATH(
  GRAPHVIZ_INCLUDE 
  NAMES graph.h
  PATHS ${GRAPHVIZ_INCLUDE_DIR}
  PATH_SUFFIXES graphviz)

FIND_LIBRARY(
	GRAPHVIZ_LIBRARY 
	NAMES graph
	PATHS ${GRAPHVIZ_LIBRARY_DIR})


IF(GRAPHVIZ_LIBRARY)
  GET_FILENAME_COMPONENT(GRAPHVIZ_LIBRARY_DIR_ ${GRAPHVIZ_LIBRARY} PATH)
  
  FIND_LIBRARY(
    GVC_LIBRARY
    NAMES gvc
    PATHS ${GRAPHVIZ_LIBRARY_DIR_} ${GVC_LIBRARY_DIR})
  
  FIND_LIBRARY(
    CDT_LIBRARY
    NAMES cdt
    PATHS ${GRAPHVIZ_LIBRARY_DIR_} ${CDT_LIBRARY_DIR})
  
  FIND_LIBRARY(
    PATHPLAN_LIBRARY
    NAMES pathplan
    PATHS ${GRAPHVIZ_LIBRARY_DIR_} ${PATHPLAN_LIBRARY_DIR})
  
  # for expat and libz and xdot, we have to make sure that we use the library that is used by gvc
  GET_FILENAME_COMPONENT(GVC_DIR ${GVC_LIBRARY} PATH)
  FIND_LIBRARY(
    Z_LIBRARY
    NAMES z
    HINTS ${GVC_DIR})
  
  FIND_LIBRARY(
    EXPAT_LIBRARY
    NAMES expat
    HINTS ${GVC_DIR})
  
  # On Mac, libgvc has a dependency to libxdot. Therefore, the library is search here to enable the install command in coreSDK/OSX.cmake
  FIND_LIBRARY(
    XDOT_LIBRARY
    NAMES xdot
    HINTS ${GVC_DIR})
  
ENDIF(GRAPHVIZ_LIBRARY)

IF (GRAPHVIZ_INCLUDE AND GRAPHVIZ_LIBRARY AND GVC_LIBRARY AND CDT_LIBRARY AND PATHPLAN_LIBRARY)
   SET(GRAPHVIZ_FOUND TRUE)
   SET(GRAPHVIZ_LIBRARIES "${GRAPHVIZ_LIBRARY}" "${GVC_LIBRARY}" "${CDT_LIBRARY}" "${PATHPLAN_LIBRARY}")

   SET(GRAPHVIZ_INCLUDE_DIRS "${GRAPHVIZ_INCLUDE}")
ELSE (GRAPHVIZ_INCLUDE AND GRAPHVIZ_LIBRARY AND GVC_LIBRARY AND CDT_LIBRARY AND PATHPLAN_LIBRARY)
   SET(GRAPHVIZ_FOUND FALSE)
ENDIF (GRAPHVIZ_INCLUDE AND GRAPHVIZ_LIBRARY AND GVC_LIBRARY AND CDT_LIBRARY AND PATHPLAN_LIBRARY)

IF (GRAPHVIZ_FOUND)
  IF (EXPAT_LIBRARY)
    LIST(APPEND GRAPHVIZ_LIBRARIES "${EXPAT_LIBRARY}")
  ELSE (EXPAT_LIBRARY)
    IF(NOT WIN32)
      #SET(GRAPHVIZ_FOUND FALSE)
    ENDIF(NOT WIN32)
  ENDIF (EXPAT_LIBRARY)

  IF (Z_LIBRARY)
     LIST(APPEND GRAPHVIZ_LIBRARIES "${Z_LIBRARY}")
  ELSE (Z_LIBRARY)
    IF(NOT WIN32)
      #SET(GRAPHVIZ_FOUND FALSE)
    ENDIF(NOT WIN32)
  ENDIF (Z_LIBRARY)
ENDIF (GRAPHVIZ_FOUND)

IF(GRAPHVIZ_FOUND)
  IF(NOT GRAPHVIZ_FIND_QUIETLY)
    MESSAGE(STATUS "Found Graphviz: ${GRAPHVIZ_LIBRARY}")
    MESSAGE(STATUS "              : ${GRAPHVIZ_INCLUDE}")
    MESSAGE(STATUS "              : ${GVC_LIBRARY}")
    MESSAGE(STATUS "              : ${CDT_LIBRARY}")
    MESSAGE(STATUS "              : ${PATHPLAN_LIBRARY}")
    MESSAGE(STATUS "              : ${Z_LIBRARY}")
    MESSAGE(STATUS "              : ${EXPAT_LIBRARY}")
    MESSAGE(STATUS "              : ${XDOT_LIBRARY}")
  ENDIF(NOT GRAPHVIZ_FIND_QUIETLY)
ELSE(GRAPHVIZ_FOUND)
  MESSAGE(STATUS "Could not find Graphviz")
ENDIF(GRAPHVIZ_FOUND)

MARK_AS_ADVANCED(GRAPHVIZ_INCLUDE GRAPHVIZ_LIBRARY GRAPHVIZ_INCLUDE_DIRS GRAPHVIZ_LIBRARIES GVC_LIBRARY CDT_LIBRARY PATHPLAN_LIBRARY EXPAT_LIBRARY Z_LIBRARY)
