/*
 * Copyright 2006-2008 The FLWOR Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ZORBA_FULL_TEXT_UTF8_CHARS_H
#define ZORBA_FULL_TEXT_UTF8_CHARS_H

//
// UTF-8 byte sequences for ISO 8859-1 characters.
//
#define aacute  "\xC3\xA1"
#define acirc   "\xC3\xA2"
#define aelig   "\xC3\xA6"
#define agrave  "\xC3\xA0"
#define aring   "\xC3\xA5"
#define atilde  "\xC3\xA3"
#define auml    "\xC3\xA4"
#define eacute  "\xC3\xA9"
#define ecirc   "\xC3\xAA"
#define egrave  "\xC3\xA8"
#define iacute  "\xC3\xAD"
#define oacute  "\xC3\xB3"
#define ocirc   "\xC3\xB4"
#define ograve  "\xC3\xB2"
#define oslash  "\xC3\xB8"
#define otilde  "\xC3\xB5"
#define ouml    "\xC3\xB6"
#define szlig   "\xC3\x9F"
#define uacute  "\xC3\xBA"
#define ucirc   "\xC3\xBB"
#define ugrave  "\xC3\xB9"
#define uuml    "\xC3\xBC"

#endif /* ZORBA_FULL_TEXT_UTF8_CHARS_H */
/* vim:set et sw=2 ts=2: */
