/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQStaticContext;
import junit.framework.Assert;

public class XQStaticContextTest
extends XQJTestCase {
    public void testGetNamespacePrefixes() throws XQException {
        String[] prefixes = null;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            prefixes = xqsc.getNamespacePrefixes();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-1.1: getNamespacePrefixes() failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQSC-1.1: getNamespacePrefixes() returns a non-null array of prefixes.", (Object)prefixes);
    }

    public void testGetNamespaceURI() throws XQException {
        String[] prefixes = null;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        prefixes = xqsc.getNamespacePrefixes();
        try {
            xqsc.getNamespaceURI(null);
            Assert.fail((String)"A-XQSC-2.1: getNamespaceURI() with null argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-2.1: getNamespaceURI() with null argument must throw an XQException.");
        }
        try {
            xqsc.getNamespaceURI("a prefix with spaces can never be valid and is thus never returned by getNamespacePrefixes()");
            Assert.fail((String)"A-XQSC-2.2: getNamespaceURI() with an unknow prefix argument must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        for (int i = 0; i < prefixes.length; ++i) {
            String uri = null;
            try {
                uri = xqsc.getNamespaceURI(prefixes[i]);
            }
            catch (XQException e) {
                Assert.fail((String)("A-XQSC-2.3: : getNamespaceURI() failed with message: " + e.getMessage()));
            }
            Assert.assertNotNull((String)"A-XQSC-2.3: Every prefix returned by getNamespacePrefixes() results in a non-null namesapce URI", (Object)uri);
        }
    }

    public void testDeclareNamespace() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.declareNamespace("p", null);
            Assert.fail((String)"A-XQSC-3.1: declareNamespace() with null argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-3.1: declareNamespace() with null argument must throw an XQException.");
        }
        try {
            xqsc.declareNamespace("p", "http://www.xqj.org");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-3.2: declareNamespace() failed with message: " + e.getMessage()));
        }
        String[] prefixes = xqsc.getNamespacePrefixes();
        boolean found = false;
        for (int i = 0; i < prefixes.length && !found; ++i) {
            found = "p".equals(prefixes[i]);
        }
        Assert.assertTrue((String)"A-XQSC-3.2: Successfully declare a namespace.", (boolean)found);
        Assert.assertEquals((String)"A-XQSC-3.2: Successfully declare a namespace.", (String)"http://www.xqj.org", (String)xqsc.getNamespaceURI("p"));
        try {
            xqsc.declareNamespace("p", "");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-3.3: declareNamespace() failed with message: " + e.getMessage()));
        }
        prefixes = xqsc.getNamespacePrefixes();
        found = false;
        for (int i = 0; i < prefixes.length && !found; ++i) {
            found = "p".equals(prefixes[i]);
        }
        Assert.assertFalse((String)"A-XQSC-3.2: Successfully undeclare a namespace.", (boolean)found);
        try {
            xqsc.getNamespaceURI("p");
            Assert.fail((String)"A-XQSC-3.2: Successfully undeclare a namespace.");
        }
        catch (XQException e) {
            // empty catch block
        }
    }

    public void testGetDefaultElementTypeNamespace() throws XQException {
        String uri = null;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            uri = xqsc.getDefaultElementTypeNamespace();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-4.1: getDefaultElementTypeNamespace() failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQSC-4.1: getDefaultElementTypeNamespace() returns a non-null namespace URI.", (Object)uri);
    }

    public void testSetDefaultElementTypeNamespace() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setDefaultElementTypeNamespace(null);
            Assert.fail((String)"A-XQSC-5.1: setDefaultElementTypeNamespace() with null argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-5.1: setDefaultElementTypeNamespace() with null argument must throw an XQException.");
        }
        try {
            xqsc.setDefaultElementTypeNamespace("http://www.xqj.org");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-5.2: setDefaultElementTypeNamespace() failed with message: " + e.getMessage()));
        }
        String uri = xqsc.getDefaultElementTypeNamespace();
        Assert.assertEquals((String)"A-XQSC-5.2: Successfully declare the default element/type namespace.", (String)"http://www.xqj.org", (String)uri);
        try {
            xqsc.setDefaultElementTypeNamespace("");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-5.3: setDefaultElementTypeNamespace() failed with message: " + e.getMessage()));
        }
        uri = xqsc.getDefaultElementTypeNamespace();
        Assert.assertEquals((String)"A-XQSC-5.3: Successfully undeclare the default element/type namespace.", (String)"", (String)uri);
    }

    public void testGetDefaultFunctionNamespace() throws XQException {
        String uri = null;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            uri = xqsc.getDefaultFunctionNamespace();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-6.1: getDefaultFunctionNamespace() failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQSC-6.1: getDefaultFunctionNamespace() returns a non-null namespace URI.", (Object)uri);
    }

    public void testSetDefaultFunctionNamespace() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setDefaultFunctionNamespace(null);
            Assert.fail((String)"A-XQSC-7.1: setDefaultFunctionNamespace() with null argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-7.1: setDefaultFunctionNamespace() with null argument must throw an XQException.");
        }
        try {
            xqsc.setDefaultFunctionNamespace("");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-7.3: setDefaultFunctionNamespace() failed with message: " + e.getMessage()));
        }
        String uri = xqsc.getDefaultFunctionNamespace();
        Assert.assertEquals((String)"A-XQSC-7.3: Successfully undeclare the default element/type namespace.", (String)"", (String)uri);
        try {
            xqsc.setDefaultFunctionNamespace("http://www.xqj.org");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-7.2: setDefaultFunctionNamespace() failed with message: " + e.getMessage()));
        }
        uri = xqsc.getDefaultFunctionNamespace();
        Assert.assertEquals((String)"A-XQSC-7.2: Successfully declare the default function namespace.", (String)"http://www.xqj.org", (String)uri);
    }

    public void testGetContextItemStaticType() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.getContextItemStaticType();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-8.1: getContextItemStaticType() failed with message: " + e.getMessage()));
        }
    }

    public void testSetContextItemStaticType() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        XQItemType xsstring = this.xqc.createAtomicType(29);
        try {
            xqsc.setContextItemStaticType(xsstring);
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-9.1: setContextItemStaticType() failed with message: " + e.getMessage()));
        }
        XQItemType xqtype = xqsc.getContextItemStaticType();
        Assert.assertNotNull((String)"A-XQSC-9.1: Successfully declare the static type of the context item.", (Object)xqtype);
        Assert.assertEquals((String)"A-XQSC-9.1: Successfully declare the static type of the context item.", (int)2, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQSC-9.1: Successfully declare the static type of the context item.", (int)1, (int)xqtype.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQSC-9.1: Successfully declare the static type of the context item.", (int)29, (int)xqtype.getItemType().getBaseType());
        try {
            xqsc.setContextItemStaticType(null);
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-9.2: setContextItemStaticType() failed with message: " + e.getMessage()));
        }
        xqtype = xqsc.getContextItemStaticType();
        Assert.assertNull((String)"A-XQSC-9.2: Successfully undeclare the static type of the context item.", (Object)xqtype);
    }

    public void testGetDefaultCollation() throws XQException {
        String uri = null;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            uri = xqsc.getDefaultCollation();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-10.1: getDefaultCollation() failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQSC-10.1: getDefaultCollation() returns a non-null collation URI.", (Object)uri);
    }

    public void testSetDefaultCollation() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setDefaultCollation(null);
            Assert.fail((String)"A-XQSC-11.1: setDefaultCollation() with null argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-11.1: setDefaultCollation() with null argument must throw an XQException.");
        }
        try {
            xqsc.setDefaultCollation("http://www.w3.org/2005/xpath-functions/collation/codepoint");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-11.2: setDefaultCollation() failed with message: " + e.getMessage()));
        }
        String uri = xqsc.getDefaultCollation();
        Assert.assertEquals((String)"A-XQSC-11.2: Successfully set the default collation.", (String)"http://www.w3.org/2005/xpath-functions/collation/codepoint", (String)uri);
    }

    public void testGetConstructionMode() throws XQException {
        int mode = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            mode = xqsc.getConstructionMode();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-12.1: getConstructionMode() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-12.1: getConstructionMode() returns CONSTRUCTION_MODE_PRESERVE or CONSTRUCTION_MODE_STRIP.", (mode == 1 || mode == 2 ? 1 : 0) != 0);
    }

    public void testSetConstructionMode() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setConstructionMode(-1);
            Assert.fail((String)"A-XQSC-13.1: setConstructionMode() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-13.1: setConstructionMode() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setConstructionMode(1);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-13.2: setConstructionMode() failed with message: " + e.getMessage()));
        }
        int mode = xqsc.getConstructionMode();
        Assert.assertEquals((String)"A-XQSC-13.2: Successfully set the construction mode.", (int)1, (int)mode);
    }

    public void testGetOrderingMode() throws XQException {
        int mode = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            mode = xqsc.getOrderingMode();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-14.1: getOrderingMode() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-14.1: getOrderingMode() returns ORDERING_MODE_ORDERED or ORDERING_MODE_UNORDERED.", (mode == 1 || mode == 2 ? 1 : 0) != 0);
    }

    public void testSetOrderingMode() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setOrderingMode(-1);
            Assert.fail((String)"A-XQSC-15.1: setOrderingMode() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-15.1: setOrderingMode() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setOrderingMode(1);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-15.2: setOrderingMode() failed with message: " + e.getMessage()));
        }
        int mode = xqsc.getOrderingMode();
        Assert.assertEquals((String)"A-XQSC-15.2: Successfully set the ordering mode.", (int)1, (int)mode);
    }

    public void testGetDefaultOrderForEmptySequences() throws XQException {
        int mode = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            mode = xqsc.getDefaultOrderForEmptySequences();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-16.1: getDefaultOrderForEmptySequences() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-16.1: getDefaultOrderForEmptySequences() returns DEFAULT_ORDER_FOR_EMPTY_SEQUENCES_GREATEST or DEFAULT_ORDER_FOR_EMPTY_SEQUENCES_LEAST.", (mode == 1 || mode == 2 ? 1 : 0) != 0);
    }

    public void testSetDefaultOrderForEmptySequences() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setDefaultOrderForEmptySequences(-1);
            Assert.fail((String)"A-XQSC-17.1: setDefaultOrderForEmptySequences(() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-17.1: setDefaultOrderForEmptySequences(() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setDefaultOrderForEmptySequences(1);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-17.2: setDefaultOrderForEmptySequences() failed with message: " + e.getMessage()));
        }
        int mode = xqsc.getDefaultOrderForEmptySequences();
        Assert.assertEquals((String)"A-XQSC-17.2: Successfully set the default order for empty sequences.", (int)1, (int)mode);
    }

    public void testGetBoundarySpacePolicy() throws XQException {
        int policy = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            policy = xqsc.getBoundarySpacePolicy();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-18.1: getBoundarySpacePolicy() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-18.1: getBoundarySpacePolicy() returns BOUNDARY_SPACE_PRESERVE or BOUNDARY_SPACE_STRIP.", (policy == 1 || policy == 2 ? 1 : 0) != 0);
    }

    public void testSetBoundarySpacePolicy() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setBoundarySpacePolicy(-1);
            Assert.fail((String)"A-XQSC-19.1: setBoundarySpacePolicy(() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-19.1: setBoundarySpacePolicy(() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setBoundarySpacePolicy(1);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-19.2: setBoundarySpacePolicy() failed with message: " + e.getMessage()));
        }
        int policy = xqsc.getBoundarySpacePolicy();
        Assert.assertEquals((String)"A-XQSC-19.2: Successfully set the boundary space policy.", (int)1, (int)policy);
    }

    public void testGetCopyNamespacesModePreserve() throws XQException {
        int mode = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            mode = xqsc.getCopyNamespacesModePreserve();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-20.1: getCopyNamespacesModePreserve() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-20.1: getCopyNamespacesModePreserve() returns COPY_NAMESPACES_MODE_PRESERVE or COPY_NAMESPACES_MODE_NO_PRESERVE.", (mode == 1 || mode == 2 ? 1 : 0) != 0);
    }

    public void testSetCopyNamespacesModePreserve() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setCopyNamespacesModePreserve(-1);
            Assert.fail((String)"A-XQSC-21.1: setCopyNamespacesModePreserve(() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-21.1: setCopyNamespacesModePreserve(() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setCopyNamespacesModePreserve(1);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-21.2: setCopyNamespacesModePreserve() failed with message: " + e.getMessage()));
        }
        int mode = xqsc.getCopyNamespacesModePreserve();
        Assert.assertEquals((String)"A-XQSC-21.2: Successfully set the (no)preserve copy namespace mode.", (int)1, (int)mode);
    }

    public void testGetCopyNamespacesModeInherit() throws XQException {
        int mode = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            mode = xqsc.getCopyNamespacesModeInherit();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-22.1: getCopyNamespacesModeInherit() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-22.1: getCopyNamespacesModeInherit() returns COPY_NAMESPACES_MODE_INHERIT or COPY_NAMESPACES_MODE_NO_INHERIT.", (mode == 1 || mode == 2 ? 1 : 0) != 0);
    }

    public void testSetCopyNamespacesModeInherit() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setCopyNamespacesModeInherit(-1);
            Assert.fail((String)"A-XQSC-23.1: setCopyNamespacesModeInherit(() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-23.1: setCopyNamespacesModeInherit(() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setCopyNamespacesModeInherit(1);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-23.2: setCopyNamespacesModeInherit() failed with message: " + e.getMessage()));
        }
        int mode = xqsc.getCopyNamespacesModeInherit();
        Assert.assertEquals((String)"A-XQSC-23.2: Successfully set the (no)inherit copy namespace mode.", (int)1, (int)mode);
    }

    public void testGetBaseURI() throws XQException {
        String uri = null;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            uri = xqsc.getBaseURI();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-24.1: getBaseURI() failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQSC-24.1: getBaseURI() returns a non-null URI.", (Object)uri);
    }

    public void testSetBaseURI() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setBaseURI(null);
            Assert.fail((String)"A-XQSC-25.1: setBaseURI() with null argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-25.1: setBaseURI() with null argument must throw an XQException.");
        }
        try {
            xqsc.setBaseURI("");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-25.2: setBaseURI() failed with message: " + e.getMessage()));
        }
        String uri = xqsc.getBaseURI();
        Assert.assertEquals((String)"A-XQSC-25.2: Successfully declare the base uri.", (String)"", (String)uri);
    }

    public void testGetBindingMode() throws XQException {
        int mode = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            mode = xqsc.getBindingMode();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-26.1: getBindingMode() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQSC-26.1: getBindingMode() returns by default XQConstants.BINDING_MODE_IMMEDIATE", (int)0, (int)mode);
    }

    public void testSetBindingMode() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setBindingMode(-1);
            Assert.fail((String)"A-XQSC-27.1: setBindingMode(() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-27.1: setBindingMode(() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setBindingMode(1);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-27.2: setBindingMode() failed with message: " + e.getMessage()));
        }
        int mode = xqsc.getBindingMode();
        Assert.assertEquals((String)"A-XQSC-27.2: Successfully set the binding mode.", (int)1, (int)mode);
        try {
            xqsc.setBindingMode(0);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-27.2: setBindingMode() failed with message: " + e.getMessage()));
        }
        mode = xqsc.getBindingMode();
        Assert.assertEquals((String)"A-XQSC-27.2: Successfully set the binding mode.", (int)0, (int)mode);
    }

    public void testGetHoldability() throws XQException {
        int mode = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            mode = xqsc.getHoldability();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-28.1: getHoldability() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-28.1: getHoldability() returns HOLDTYPE_HOLD_CURSORS_OVER_COMMIT or HOLDTYPE_CLOSE_CURSORS_AT_COMMIT.", (mode == 1 || mode == 2 ? 1 : 0) != 0);
    }

    public void testSetHoldability() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setHoldability(-1);
            Assert.fail((String)"A-XQSC-29.1: setHoldability() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-29.1: setHoldability() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setHoldability(1);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-29.2: setHoldability() failed with message: " + e.getMessage()));
        }
        int mode = xqsc.getHoldability();
        Assert.assertEquals((String)"A-XQSC-29.2: Successfully set the holdability.", (int)1, (int)mode);
    }

    public void testGetQueryLanguageTypeAndVersion() throws XQException {
        int lang = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            lang = xqsc.getQueryLanguageTypeAndVersion();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-30.1: getQueryLanguageTypeAndVersion() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-30.1: getQueryLanguageTypeAndVersion() returns LANGTYPE_XQUERY, LANGTYPE_XQUERYX or a negative value", (lang == 1 || lang == 2 || lang < 0 ? 1 : 0) != 0);
    }

    public void testSetQueryLanguageTypeAndVersion() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setQueryLanguageTypeAndVersion(999);
            Assert.fail((String)"A-XQSC-31.1: setQueryLanguageTypeAndVersion() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-31.1: setQueryLanguageTypeAndVersion() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setQueryLanguageTypeAndVersion(1);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-31.2: setQueryLanguageTypeAndVersion() failed with message: " + e.getMessage()));
        }
        int lang = xqsc.getQueryLanguageTypeAndVersion();
        Assert.assertEquals((String)"A-XQSC-31.2: Successfully set the query language.", (int)1, (int)lang);
        if (this.xqc.getMetaData().isXQueryXSupported()) {
            try {
                xqsc.setQueryLanguageTypeAndVersion(2);
            }
            catch (XQException e) {
                Assert.fail((String)("A-XQSC-31.2: setQueryLanguageTypeAndVersion() failed with message: " + e.getMessage()));
            }
            lang = xqsc.getQueryLanguageTypeAndVersion();
            Assert.assertEquals((String)"A-XQSC-31.2: Successfully set the query language.", (int)2, (int)lang);
        }
    }

    public void testGetScrollability() throws XQException {
        int mode = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            mode = xqsc.getScrollability();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-32.1: getScrollability() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-32.1: getScrollability() returns SCROLLTYPE_FORWARD_ONLY or SCROLLTYPE_SCROLLABLE.", (mode == 1 || mode == 2 ? 1 : 0) != 0);
    }

    public void testSetScrollability() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqsc.setScrollability(-1);
            Assert.fail((String)"A-XQSC-33.1: setScrollability() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-33.1: setScrollability() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setScrollability(2);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-33.2: setScrollability() failed with message: " + e.getMessage()));
        }
        int mode = xqsc.getScrollability();
        Assert.assertEquals((String)"A-XQSC-33.2: Successfully set the scrollability.", (int)2, (int)mode);
    }

    public void testGetQueryTimeout() throws XQException {
        int timeout = -1;
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            timeout = xqsc.getQueryTimeout();
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQSC-34.1: getQueryTimeout() failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)"A-XQSC-34.1: getQueryTimeout() returns a non negative value.", (timeout >= 0 ? 1 : 0) != 0);
    }

    public void testSetQueryTimeout() throws XQException {
        XQStaticContext xqsc = this.xqc.getStaticContext();
        int originalTimeout = xqsc.getQueryTimeout();
        try {
            xqsc.setQueryTimeout(-1);
            Assert.fail((String)"A-XQSC-35.1: setQueryTimeout() with invalid argument must throw an XQException.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQSC-35.1: setQueryTimeout() with invalid argument must throw an XQException.");
        }
        try {
            xqsc.setQueryTimeout(10);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQSC-35.2: setQueryTimeout() failed with message: " + e.getMessage()));
        }
        int timeout = xqsc.getQueryTimeout();
        Assert.assertTrue((String)"A-XQSC-35.2: Successfully set the timeout.", (timeout == 10 || timeout == originalTimeout ? 1 : 0) != 0);
    }
}

