/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.TestContentHandler;
import com.oracle.xqj.tck.testcases.XQJTestCase;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQResultItem;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQStaticContext;
import junit.framework.Assert;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XQSequenceTest
extends XQJTestCase {
    public void testAbsolute() throws XQException {
        boolean b = false;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.absolute(2);
            Assert.fail((String)"A-XQS-1.1: SCROLLTYPE_FORWARD_ONLY sequence supports absolute()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.close();
        try {
            xqs.absolute(2);
            Assert.fail((String)"A-XQS-1.2: closed sequence supports absolute()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            b = xqs.absolute(2);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-2.1: absolute() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-2.1: absolute(2) failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-2.1: absolute(2) failed", (int)2, (int)xqs.getInt());
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            b = xqs.absolute(5);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-2.4: absolute() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-2.4: absolute(5) failed", (boolean)false, (boolean)b);
        Assert.assertEquals((String)"A-XQS-2.4: absolute(5) failed", (boolean)true, (boolean)xqs.isAfterLast());
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            b = xqs.absolute(0);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-2.3: absolute() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-2.3: absolute(0) failed", (boolean)false, (boolean)b);
        Assert.assertEquals((String)"A-XQS-2.3: absolute(0) failed", (boolean)true, (boolean)xqs.isBeforeFirst());
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            b = xqs.absolute(-2);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-2.2: absolute() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-2.2: absolute(-2) failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-2.2: absolute(-2) failed", (int)3, (int)xqs.getInt());
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            b = xqs.absolute(-5);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-2.4: absolute() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-2.4: absolute(-5) failed", (boolean)false, (boolean)b);
        Assert.assertEquals((String)"A-XQS-2.4: absolute(-5) failed", (boolean)true, (boolean)xqs.isBeforeFirst());
        xqe.close();
    }

    public void testAfterLast() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.afterLast();
            Assert.fail((String)"A-XQS-1.1: SCROLLTYPE_FORWARD_ONLY sequence supports afterLast()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.close();
        try {
            xqs.afterLast();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports afterLast()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.afterLast();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-3.1: afterLast() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-3.1: afterLast() failed", (boolean)true, (boolean)xqs.isAfterLast());
        xqe.close();
    }

    public void testBeforeFirst() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.beforeFirst();
            Assert.fail((String)"A-XQS-1.1: SCROLLTYPE_FORWARD_ONLY sequence supports beforeFirst()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.close();
        try {
            xqs.beforeFirst();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports beforeFirst()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.beforeFirst();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-4.1: beforeFirst() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-4.1: beforeFirst() failed", (boolean)true, (boolean)xqs.isBeforeFirst());
        xqe.close();
    }

    public void testClose() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        xqs.next();
        XQItem xqi = xqs.getItem();
        try {
            xqs.close();
            xqs.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-5.1: close() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-5.1: close() doesn't close sequence", (boolean)true, (boolean)xqs.isClosed());
        Assert.assertEquals((String)"A-XQS-5.2: close() doesn't close items obtained from the sequence", (boolean)true, (boolean)xqi.isClosed());
        xqe.close();
    }

    public void testIsClosed() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        Assert.assertEquals((String)"A-XQS-6.1: isClosed() on open sequence", (boolean)false, (boolean)xqs.isClosed());
        xqs.close();
        Assert.assertEquals((String)"A-XQS-6.2: isClosed() on closed sequence", (boolean)true, (boolean)xqs.isClosed());
        xqe.close();
    }

    public void testCount() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.count();
            Assert.fail((String)"A-XQS-7.1: SCROLLTYPE_FORWARD_ONLY sequence supports count()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.close();
        try {
            xqs.count();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports count()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            Assert.assertEquals((String)"A-XQS-7.2: count() failed", (int)xqs.count(), (int)4);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-7.2: count() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetPosition() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1");
        try {
            xqs.getPosition();
            Assert.fail((String)"A-XQS-8.1: SCROLLTYPE_FORWARD_ONLY sequence supports getPosition()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        xqs.close();
        try {
            xqs.getPosition();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports getPosition()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        try {
            Assert.assertEquals((String)"A-XQS-8.3: getPosition() failed when before first item", (int)0, (int)xqs.getPosition());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-8.3: getPosition() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-8.2: getPosition() failed when on item", (int)1, (int)xqs.getPosition());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-8.2: getPosition() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-8.4: getPosition() failed when after last item", (int)2, (int)xqs.getPosition());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-8.4: getPosition() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testIsOnItem() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1");
        xqs.close();
        try {
            xqs.isOnItem();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports isOnItem()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        try {
            Assert.assertEquals((String)"A-XQS-9.2: isOnItem() failed when before first item", (boolean)false, (boolean)xqs.isOnItem());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-9.2: isOnItem() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-9.1: isOnItem() failed when on item", (boolean)true, (boolean)xqs.isOnItem());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-9.1: isOnItem() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-9.2: isOnItem() failed when after last item", (boolean)false, (boolean)xqs.isOnItem());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-9.2: isOnItem() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testIsScrollable() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1");
        xqs.close();
        try {
            xqs.isScrollable();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports isScrollable()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        try {
            Assert.assertEquals((String)"A-XQS-10.2: isScrollable() failed for SCROLLTYPE_FORWARD_ONLY sequence", (boolean)false, (boolean)xqs.isScrollable());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-10.2: isScrollable() failed with message: " + e.getMessage()));
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        try {
            Assert.assertEquals((String)"A-XQS-10.1: isScrollable() failed for SCROLLTYPE_SCROLLABLE sequence", (boolean)true, (boolean)xqs.isScrollable());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-10.1: isScrollable() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testFirst() throws XQException {
        boolean b = false;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.first();
            Assert.fail((String)"A-XQS-1.1: SCROLLTYPE_FORWARD_ONLY sequence supports first()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.close();
        try {
            xqs.first();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports first()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            b = xqs.first();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-11.1: first() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-11.1: first() failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-11.1: first() failed", (int)1, (int)xqs.getInt());
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("()");
        try {
            b = xqs.first();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-11.2: first() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-11.2: first() failed", (boolean)false, (boolean)b);
        xqe.close();
    }

    public void testGetItem() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        xqs.next();
        xqs.getInt();
        try {
            xqs.getItem();
            Assert.fail((String)"A-XQS-12.1: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.getItem();
            Assert.fail((String)"A-XQS-12.2: sequence supports getItem() when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.next();
        xqs.close();
        try {
            xqs.getItem();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports getItem()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.next();
        try {
            xqs.getItem();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-12.3: getItem() failed with message: " + e.getMessage()));
        }
        try {
            xqs.getItem();
        }
        catch (XQException e) {
            Assert.fail((String)"A-XQS-12.4: SCROLLTYPE_SCROLLABLE sequence doesn't supports getting item twice()");
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.next();
        Assert.assertTrue((String)"A-XQS-12.5: Item must be XQResultItem", (boolean)(xqs.getItem() instanceof XQResultItem));
    }

    public void testGetSequenceAsStream() throws XQException {
        XMLStreamReader xmlReader = null;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.close();
        try {
            xqs.getSequenceAsStream();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports getSequenceAsStream()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        try {
            xmlReader = xqs.getSequenceAsStream();
            while (xmlReader.hasNext()) {
                xmlReader.next();
            }
            Assert.fail((String)"A-XQS-21.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
        }
        catch (XMLStreamException xml) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getSequenceAsStream();
            Assert.fail((String)"A-XQS-21.2: SCROLLTYPE_FORWARD_ONLY sequence, getXXX() or write() method has been invoked already on the current item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xmlReader = xqs.getSequenceAsStream();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-22.1: getSequenceAsStream failed with message: " + e.getMessage()));
        }
        try {
            Assert.assertNotNull((String)"A-XQS-22.1: getSequenceAsStream returned a null XMLStreamReader", (Object)xmlReader);
            Assert.assertEquals((String)"A-XQS-22.1: unexpected first event returned by XMLStreamReader", (int)7, (int)xmlReader.getEventType());
            Assert.assertEquals((String)"A-XQS-22.1: unexpected second event returned by XMLStreamReader", (int)1, (int)xmlReader.next());
            Assert.assertEquals((String)"A-XQS-22.1: unexpected third event returned by XMLStreamReader", (int)4, (int)xmlReader.next());
            Assert.assertEquals((String)"A-XQS-22.1: unexpected fourth event returned by XMLStreamReader", (int)2, (int)xmlReader.next());
            Assert.assertEquals((String)"A-XQS-22.1: unexpected fifth event returned by XMLStreamReader", (int)8, (int)xmlReader.next());
        }
        catch (XMLStreamException e) {
            Assert.fail((String)("A-XQS-22.1: XMLStreamReader.next() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetSequenceAsString() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.close();
        try {
            xqs.getSequenceAsString(new Properties());
            Assert.fail((String)"A-XQS-1.2: closed sequence supports getSequenceAsString()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        try {
            xqs.getSequenceAsString(new Properties());
            Assert.fail((String)"A-XQS-21.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getSequenceAsString(new Properties());
            Assert.fail((String)"A-XQS-21.2: SCROLLTYPE_FORWARD_ONLY sequence, getXXX() or write() method has been invoked already on the current item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        String result = null;
        try {
            result = xqs.getSequenceAsString(new Properties());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-23.1: getSequenceAsString failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQS-23.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            Assert.assertEquals((String)"A-XQS-23.2: null properties argument is equivalent to empty properties argument", (String)result, (String)xqs.getSequenceAsString(null));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-23.2: getSequenceAsString failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testIsAfterLast() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1");
        try {
            xqs.isAfterLast();
            Assert.fail((String)"A-XQS-13.1: SCROLLTYPE_FORWARD_ONLY sequence supports isAfterLast()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        xqs.close();
        try {
            xqs.isAfterLast();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports isAfterLast()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        try {
            Assert.assertEquals((String)"A-XQS-13.3: isAfterLast() failed when before first item", (boolean)false, (boolean)xqs.isAfterLast());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-13.3: isAfterLast() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-13.3: isAfterLast() failed when on item", (boolean)false, (boolean)xqs.isAfterLast());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-13.3: isAfterLast() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-13.2: isAfterLast() failed when after last item", (boolean)true, (boolean)xqs.isAfterLast());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-13.2: isAfterLast() failed with message: " + e.getMessage()));
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("()");
        try {
            Assert.assertEquals((String)"A-XQS-13.3: isAfterLast() failed in case of empty sequence", (boolean)false, (boolean)xqs.isAfterLast());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-13.4: isAfterLast() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testIsBeforeFirst() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1");
        try {
            xqs.isBeforeFirst();
            Assert.fail((String)"A-XQS-14.1: SCROLLTYPE_FORWARD_ONLY sequence supports isBeforeFirst()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        xqs.close();
        try {
            xqs.isBeforeFirst();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports isBeforeFirst()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        try {
            Assert.assertEquals((String)"A-XQS-14.2: isBeforeFirst() failed when before first item", (boolean)true, (boolean)xqs.isBeforeFirst());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-14.2: isBeforeFirst() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-14.3: isBeforeFirst() failed when on item", (boolean)false, (boolean)xqs.isBeforeFirst());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-14.3: isBeforeFirst() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-14.3: isBeforeFirst() failed when after last item", (boolean)false, (boolean)xqs.isBeforeFirst());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-14.3: isBeforeFirst() failed with message: " + e.getMessage()));
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("()");
        try {
            Assert.assertEquals((String)"A-XQS-14.2: isBeforeFirst() failed in case of empty sequence", (boolean)false, (boolean)xqs.isBeforeFirst());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-14.1: isBeforeFirst() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testIsFirst() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1");
        try {
            xqs.isFirst();
            Assert.fail((String)"A-XQS-15.1: SCROLLTYPE_FORWARD_ONLY sequence supports isFirst()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        xqs.close();
        try {
            xqs.isFirst();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports isFirst()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        try {
            Assert.assertEquals((String)"A-XQS-15.3: isFirst() failed when before first item", (boolean)false, (boolean)xqs.isFirst());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-15.3: isFirst() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-15.2: isFirst() failed when on item", (boolean)true, (boolean)xqs.isFirst());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-15.2: isFirst() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-15.3: isFirst() failed when after last item", (boolean)false, (boolean)xqs.isFirst());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-15.3: isFirst() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testIsLast() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1");
        try {
            xqs.isLast();
            Assert.fail((String)"A-XQS-16.1: SCROLLTYPE_FORWARD_ONLY sequence supports isLast()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        xqs.close();
        try {
            xqs.isLast();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports isLast()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        try {
            Assert.assertEquals((String)"A-XQS-16.3: isLast() failed when before first item", (boolean)false, (boolean)xqs.isLast());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-16.3: isLast() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-16.2: isLast() failed when on item", (boolean)true, (boolean)xqs.isLast());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-16.2: isLast() failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQS-16.3: isLast() failed when after last item", (boolean)false, (boolean)xqs.isLast());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-16.3: isLast() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testLast() throws XQException {
        boolean b = false;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.last();
            Assert.fail((String)"A-XQS-1.1: SCROLLTYPE_FORWARD_ONLY sequence supports last()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.close();
        try {
            xqs.last();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports last()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            b = xqs.last();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-17.1: last() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-17.1: last() failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-17.1: last() failed", (int)4, (int)xqs.getInt());
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("()");
        try {
            b = xqs.last();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-17.2: last() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-17.2: last() failed", (boolean)false, (boolean)b);
        xqe.close();
    }

    public void testNext() throws XQException {
        boolean b = false;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2");
        xqs.close();
        try {
            xqs.next();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports last()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2");
        try {
            b = xqs.next();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-18.1: next() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-18.1: next() failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-18.1: next() failed", (int)1, (int)xqs.getInt());
        try {
            b = xqs.next();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-18.1: next() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-18.1: next() failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-18.1: next() failed", (int)2, (int)xqs.getInt());
        try {
            b = xqs.next();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-18.2: next() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-18.2: next() failed", (boolean)false, (boolean)b);
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("()");
        b = xqs.next();
        Assert.assertEquals((String)"next() failed", (boolean)false, (boolean)b);
        xqe.close();
    }

    public void testPrevious() throws XQException {
        boolean b = false;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2");
        try {
            xqs.previous();
            Assert.fail((String)"A-XQS-1.1: SCROLLTYPE_FORWARD_ONLY sequence supports previous()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2");
        xqs.close();
        try {
            xqs.previous();
            Assert.fail((String)"A-XQS-1.2: closed sequence supports previous()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2");
        xqs.afterLast();
        try {
            b = xqs.previous();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-19.1: previous() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-19.1: previous() failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-19.1: previous() failed", (int)2, (int)xqs.getInt());
        try {
            b = xqs.previous();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-19.1: previous() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-19.1: previous() failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-19.1: previous() failed", (int)1, (int)xqs.getInt());
        try {
            b = xqs.previous();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-19.2: previous() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-19.2: previous() failed", (boolean)false, (boolean)b);
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("()");
        xqs.afterLast();
        b = xqs.previous();
        Assert.assertEquals((String)"previous() failed", (boolean)false, (boolean)b);
        xqe.close();
    }

    public void testRelative() throws XQException {
        boolean b = false;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3,4");
        try {
            xqs.relative(2);
            Assert.fail((String)"A-XQS-1.1: SCROLLTYPE_FORWARD_ONLY sequence supports relative()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        XQStaticContext xqsc = this.xqc.getStaticContext();
        xqsc.setScrollability(2);
        this.xqc.setStaticContext(xqsc);
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.close();
        try {
            xqs.relative(2);
            Assert.fail((String)"A-XQS-1.2: closed sequence supports absolute()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            b = xqs.relative(2);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-20.1: relative() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-20.1: relative(2) failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-20.1: relative(2) failed", (int)2, (int)xqs.getInt());
        try {
            b = xqs.relative(2);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-20.1: relative() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-20.1: relative(2) failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-20.1: relative(2) failed", (int)4, (int)xqs.getInt());
        try {
            b = xqs.relative(2);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-20.4: relative() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-20.4: relative(2) failed", (boolean)false, (boolean)b);
        Assert.assertEquals((String)"A-XQS-20.4: relative(2) failed", (boolean)true, (boolean)xqs.isAfterLast());
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        try {
            b = xqs.relative(0);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-20.3: relative() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-20.3: relative(0) failed", (boolean)false, (boolean)b);
        Assert.assertEquals((String)"A-XQS-20.3: relative(0) failed", (boolean)true, (boolean)xqs.isBeforeFirst());
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1,2,3,4");
        xqs.afterLast();
        try {
            b = xqs.relative(-2);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-20.2: relative() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-20.2: relative(-2) failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-20.2: relative(-2) failed", (int)3, (int)xqs.getInt());
        try {
            b = xqs.relative(-2);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-20.2: relative() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-20.2: relative(-2) failed", (boolean)true, (boolean)b);
        Assert.assertEquals((String)"A-XQS-20.2: relative(-2) failed", (int)1, (int)xqs.getInt());
        try {
            b = xqs.relative(-2);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-20.4: relative() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-20.4: relative(-2) failed", (boolean)false, (boolean)b);
        Assert.assertEquals((String)"A-XQS-20.4: relative(-2) failed", (boolean)true, (boolean)xqs.isBeforeFirst());
        xqe.close();
    }

    public void testWriteSequence_OutputStream() throws XQException, UnsupportedEncodingException {
        Properties prop = new Properties();
        prop.setProperty("encoding", "UTF-8");
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.close();
        try {
            xqs.writeSequence((OutputStream)new ByteArrayOutputStream(), prop);
            Assert.fail((String)"A-XQS-1.2: closed sequence supports writeSequence()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.writeSequence((OutputStream)new ByteArrayOutputStream(), prop);
            Assert.fail((String)"A-XQS-21.2: SCROLLTYPE_FORWARD_ONLY sequence, getXXX() or write() method has been invoked already on the current item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        try {
            xqs.writeSequence((OutputStream)new ByteArrayOutputStream(), prop);
            Assert.fail((String)"A-XQS-21.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.writeSequence((OutputStream)null, prop);
            Assert.fail((String)"A-XQS-24.3: writeSequence accepts a null buffer as first argument");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            xqs.writeSequence((OutputStream)result, prop);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-24.1: writeSequence failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQS-24.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result.toString("UTF-8") + "'"), (result.toString("UTF-8").indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        ByteArrayOutputStream otherResult = new ByteArrayOutputStream();
        try {
            xqs.writeSequence((OutputStream)otherResult, prop);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-24.2: writeSequence failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-24.2: null properties argument is equivalent to empty properties argument", (String)result.toString("UTF-8"), (String)otherResult.toString("UTF-8"));
        xqe.close();
    }

    public void testWriteSequence_Writer() throws XQException {
        Properties prop = new Properties();
        prop.setProperty("encoding", "UTF-8");
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.close();
        try {
            xqs.writeSequence((Writer)new StringWriter(), prop);
            Assert.fail((String)"A-XQS-1.2: closed sequence supports writeSequence()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.writeSequence((Writer)new StringWriter(), prop);
            Assert.fail((String)"A-XQS-21.2: SCROLLTYPE_FORWARD_ONLY sequence, getXXX() or write() method has been invoked already on the current item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        try {
            xqs.writeSequence((Writer)new StringWriter(), prop);
            Assert.fail((String)"A-XQS-21.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.writeSequence((Writer)null, prop);
            Assert.fail((String)"A-XQS-24.3: writeSequence accepts a null buffer as first argument");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        StringWriter result = new StringWriter();
        try {
            xqs.writeSequence((Writer)result, prop);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-24.1: writeSequence failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQS-24.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result.toString() + "'"), (result.toString().indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        StringWriter otherResult = new StringWriter();
        try {
            xqs.writeSequence((Writer)otherResult, prop);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-24.2: writeSequence failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQS-24.2: null properties argument is equivalent to empty properties argument", (String)result.toString(), (String)otherResult.toString());
        xqe.close();
    }

    public void testWriteSequenceToSAX() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.close();
        try {
            xqs.writeSequenceToSAX((ContentHandler)new DefaultHandler());
            Assert.fail((String)"A-XQS-1.2: closed sequence supports writeSequenceToSAX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.writeSequenceToSAX((ContentHandler)new DefaultHandler());
            Assert.fail((String)"A-XQS-21.2: SCROLLTYPE_FORWARD_ONLY sequence, getXXX() or write() method has been invoked already on the current item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        try {
            xqs.writeSequenceToSAX((ContentHandler)new DefaultHandler());
            Assert.fail((String)"A-XQS-21.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.writeSequenceToSAX((ContentHandler)null);
            Assert.fail((String)"A-XQS-24.3: writeSequence accepts a null buffer as first argument");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        TestContentHandler result = new TestContentHandler();
        try {
            xqs.writeSequenceToSAX((ContentHandler)result);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-24.1: writeSequence failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQS-24.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result.buffer.toString() + "'"), (result.buffer.toString().indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
    }

    public void testWriteSequenceToResult() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.close();
        try {
            xqs.writeSequenceToResult((Result)new StreamResult(new StringWriter()));
            Assert.fail((String)"A-XQS-1.2: closed sequence supports writeSequence()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.writeSequenceToResult((Result)new StreamResult(new StringWriter()));
            Assert.fail((String)"A-XQS-21.2: SCROLLTYPE_FORWARD_ONLY sequence, getXXX() or write() method has been invoked already on the current item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.writeSequenceToResult((Result)null);
            Assert.fail((String)"A-XQS-24.3: writeSequence accepts a null buffer as first argument");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        StringWriter result = new StringWriter();
        try {
            xqs.writeSequenceToResult((Result)new StreamResult(result));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQS-24.1: writeSequence failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQS-24.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result.toString() + "'"), (result.toString().indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
    }
}

