/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQQueryException;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQStackTraceElement;
import junit.framework.Assert;

public class XQQueryExceptionTest
extends XQJTestCase {
    public void testConstructor1() {
        try {
            XQQueryException ex = new XQQueryException("Hello world!");
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (String)"Hello world!", (String)ex.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-1.1: Creating XQQueryException faild with message: " + e.getMessage()));
        }
    }

    public void testConstructor2() {
        try {
            XQQueryException ex = new XQQueryException("Hello world!", new QName("foo"));
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (String)"Hello world!", (String)ex.getMessage());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (Object)new QName("foo"), (Object)ex.getErrorCode());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-1.1: Creating XQQueryException faild with message: " + e.getMessage()));
        }
    }

    public void testConstructor5() {
        try {
            XQQueryException ex = new XQQueryException("Hello world!", new QName("foo"), 7, 8, 56);
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (String)"Hello world!", (String)ex.getMessage());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (Object)new QName("foo"), (Object)ex.getErrorCode());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (int)7, (int)ex.getLineNumber());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (int)8, (int)ex.getColumnNumber());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (int)56, (int)ex.getPosition());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-1.1: Creating XQQueryException faild with message: " + e.getMessage()));
        }
    }

    public void testConstructor6() {
        try {
            XQQueryException ex = new XQQueryException("Hello world!", "VendorCode", new QName("foo"), 7, 8, 56);
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (String)"Hello world!", (String)ex.getMessage());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (String)"VendorCode", (String)ex.getVendorCode());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (Object)new QName("foo"), (Object)ex.getErrorCode());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (int)7, (int)ex.getLineNumber());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (int)8, (int)ex.getColumnNumber());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (int)56, (int)ex.getPosition());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-1.1: Creating XQQueryException faild with message: " + e.getMessage()));
        }
    }

    public void testConstructor9() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2");
        try {
            XQQueryException ex = new XQQueryException("Hello world!", "VendorCode", new QName("foo"), 7, 8, 56, "moduleuri", (XQSequence)xqs, (XQStackTraceElement[])null);
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (String)"Hello world!", (String)ex.getMessage());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (String)"VendorCode", (String)ex.getVendorCode());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (Object)new QName("foo"), (Object)ex.getErrorCode());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (int)7, (int)ex.getLineNumber());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (int)8, (int)ex.getColumnNumber());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (int)56, (int)ex.getPosition());
            Assert.assertEquals((String)"A-XQQEX-1.1: XQQueryException successfully created", (String)"moduleuri", (String)ex.getModuleURI());
            Assert.assertTrue((String)"A-XQQEX-1.1: XQQueryException successfully created", (xqs == ex.getErrorObject() ? 1 : 0) != 0);
            Assert.assertTrue((String)"A-XQQEX-1.1: XQQueryException successfully created", (null == ex.getQueryStackTrace() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-1.1: Creating XQQueryException faild with message: " + e.getMessage()));
        }
        xqs.close();
    }

    public void testGetErrorCode() {
        XQQueryException ex;
        try {
            ex = new XQQueryException("Hello world!", new QName("foo"));
            Assert.assertEquals((String)"A-XQQEX-2.1: Retrieve error code from an XQQueryException", (Object)new QName("foo"), (Object)ex.getErrorCode());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-2.1: Retrieve error code from an XQQueryException failed with message: " + e.getMessage()));
        }
        try {
            ex = new XQQueryException("Hello world!");
            Assert.assertEquals((String)"A-XQQEX-2.2: Error code is null when not available", null, (Object)ex.getErrorCode());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-2.2: Retrieve error code from an XQQueryException failed with message: " + e.getMessage()));
        }
    }

    public void testGetErrorObject() throws XQException {
        XQQueryException ex;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2");
        try {
            ex = new XQQueryException("Hello world!", "VendorCode", new QName("foo"), 7, 8, 56, "moduleuri", (XQSequence)xqs, (XQStackTraceElement[])null);
            XQSequence errorObject = ex.getErrorObject();
            errorObject.next();
            Assert.assertEquals((String)"A-XQQEX-3.1: Retrieve error object from an XQQueryException", (int)1, (int)errorObject.getInt());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-3.1: Retrieve error object from an XQQueryException failed with message: " + e.getMessage()));
        }
        try {
            ex = new XQQueryException("Hello world!");
            Assert.assertEquals((String)"A-XQQEX-3.2: Error object is null when not available", null, (Object)ex.getErrorObject());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-3.2: Retrieve error object from an XQQueryException failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetPosition() {
        XQQueryException ex;
        try {
            ex = new XQQueryException("Hello world!", "VendorCode", new QName("foo"), 7, 8, 56);
            Assert.assertEquals((String)"A-XQQEX-4.1: Retrieve position from an XQQueryException", (int)56, (int)ex.getPosition());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-4.1: Retrieve position from an XQQueryException failed with message: " + e.getMessage()));
        }
        try {
            ex = new XQQueryException("Hello world!");
            Assert.assertEquals((String)"A-XQQEX-4.2: Position is -1 when not available", (int)-1, (int)ex.getPosition());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-4.2: Retrieve position from an XQQueryException failed with message: " + e.getMessage()));
        }
    }

    public void testGetQueryStackTrace() {
        XQQueryException ex;
        try {
            ex = new XQQueryException("Hello world!", "VendorCode", new QName("foo"), 7, 8, 56, "moduleuri", null, new XQStackTraceElement[0]);
            Assert.assertEquals((String)"A-XQQEX-5.1: Retrieve query stack trace from an XQQueryException", (int)0, (int)ex.getQueryStackTrace().length);
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-5.1: Retrieve query stack trace from an XQQueryException failed with message: " + e.getMessage()));
        }
        try {
            ex = new XQQueryException("Hello world!");
            Assert.assertEquals((String)"A-XQQEX-5.2: Query stack trace is null when not available", null, (Object)ex.getQueryStackTrace());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-5.2: Retrieve Query stack trace from an XQQueryException failed with message: " + e.getMessage()));
        }
    }

    public void testGetModuleURI() {
        XQQueryException ex;
        try {
            ex = new XQQueryException("Hello world!", "VendorCode", new QName("foo"), 7, 8, 56, "moduleuri", null, null);
            Assert.assertEquals((String)"A-XQQEX-6.1: Retrieve module uri from an XQQueryException", (String)"moduleuri", (String)ex.getModuleURI());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-6.1: Retrieve module uri from an XQQueryException failed with message: " + e.getMessage()));
        }
        try {
            ex = new XQQueryException("Hello world!");
            Assert.assertEquals((String)"A-XQQEX-6.2: module uri is null when not available", null, (String)ex.getModuleURI());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-6.2: Retrieve module uri from an XQQueryException failed with message: " + e.getMessage()));
        }
    }

    public void testGetLineNumber() {
        XQQueryException ex;
        try {
            ex = new XQQueryException("Hello world!", "VendorCode", new QName("foo"), 7, 8, 56);
            Assert.assertEquals((String)"A-XQQEX-7.1: Retrieve line number from an XQQueryException", (int)7, (int)ex.getLineNumber());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-7.1: Retrieve line number from an XQQueryException failed with message: " + e.getMessage()));
        }
        try {
            ex = new XQQueryException("Hello world!");
            Assert.assertEquals((String)"A-XQQEX-7.2: Line number is -1 when not available", (int)-1, (int)ex.getLineNumber());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-7.2: Retrieve line number from an XQQueryException failed with message: " + e.getMessage()));
        }
    }

    public void testGetColumnNumber() {
        XQQueryException ex;
        try {
            ex = new XQQueryException("Hello world!", "VendorCode", new QName("foo"), 7, 8, 56);
            Assert.assertEquals((String)"A-XQQEX-8.1: Retrieve column number from an XQQueryException", (int)8, (int)ex.getColumnNumber());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-8.1: Retrieve column number from an XQQueryException failed with message: " + e.getMessage()));
        }
        try {
            ex = new XQQueryException("Hello world!");
            Assert.assertEquals((String)"A-XQQEX-8.2: Column number is -1 when not available", (int)-1, (int)ex.getColumnNumber());
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQQEX-8.2: Retrieve column number from an XQQueryException failed with message: " + e.getMessage()));
        }
    }
}

