/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import junit.framework.Assert;

public class XQPreparedExpressionTest
extends XQJTestCase {
    public void testCancel() throws XQException {
        XQPreparedExpression xqpe = this.xqc.prepareExpression("'Hello world!'");
        try {
            xqpe.cancel();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-1.1: cancellation of prepared expression failed with message: " + e.getMessage()));
        }
        xqpe.close();
        try {
            xqpe.cancel();
            Assert.fail((String)"A-XQPE-1.2: closed prepared expression supports cancel()");
        }
        catch (XQException xQException) {
            // empty catch block
        }
    }

    public void testIsClosed() throws XQException {
        XQPreparedExpression xqpe = this.xqc.prepareExpression("'Hello world!'");
        xqpe.executeQuery();
        Assert.assertEquals((String)"A-XQPE-2.1: isClosed() on open prepared expression", (boolean)false, (boolean)xqpe.isClosed());
        xqpe.close();
        Assert.assertEquals((String)"A-XQPE-2.2: isClosed() on closed prepared expressions", (boolean)true, (boolean)xqpe.isClosed());
    }

    public void testClose() throws XQException {
        XQPreparedExpression xqpe = this.xqc.prepareExpression("'Hello world!'");
        XQResultSequence xqs = xqpe.executeQuery();
        try {
            xqpe.close();
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-3.1: closing prepared expression failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQPE-3.2: Closing an expression, closes any result sequences obtained from this expression", (boolean)true, (boolean)xqs.isClosed());
    }

    public void testExecuteQuery() throws XQException {
        XQResultSequence xqs = null;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("'Hello world!'");
        xqpe.close();
        try {
            xqpe.executeQuery();
            Assert.fail((String)"A-XQPE-8.1: closed prepared expression supports executeQuery()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("'Hello world!'");
        try {
            xqs = xqpe.executeQuery();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-8.2: executeQuery() failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQPE-8.2: executeQuery() failed", (Object)xqs);
        xqpe.close();
    }

    public void testGetAllExternalVariables() throws XQException {
        QName[] extVars = null;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("'Hello world!'");
        xqpe.close();
        try {
            xqpe.getAllExternalVariables();
            Assert.fail((String)"A-XQPE-4.1: closed prepared expression supports getAllExternalVariables()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("'Hello world!'");
        try {
            extVars = xqpe.getAllExternalVariables();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-4.2: getAllExternalVariables on prepared expression without external variables failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQPE-4.2: getAllExternalVariables on prepared expression without external variables", (Object)extVars);
        Assert.assertEquals((String)"A-XQPE-4.2: getAllExternalVariables on prepared expression without external variables", (int)0, (int)extVars.length);
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            extVars = xqpe.getAllExternalVariables();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-4.3: getAllExternalVariables on prepared expression with external variables failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQPE-4.3: getAllExternalVariables on prepared expression with external variables", (Object)extVars);
        Assert.assertEquals((String)"A-XQPE-4.3: getAllExternalVariables on prepared expression with external variables", (int)1, (int)extVars.length);
        Assert.assertEquals((String)"A-XQPE-4.3: getAllExternalVariables on prepared expression with external variables", (String)"v", (String)extVars[0].getLocalPart());
        Assert.assertEquals((String)"A-XQPE-4.3: getAllExternalVariables on prepared expression with external variables", (String)"", (String)extVars[0].getNamespaceURI());
        xqpe.close();
    }

    public void testGetAllUnboundExternalVariables() throws XQException {
        QName[] extVars = null;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("'Hello world!'");
        xqpe.close();
        try {
            xqpe.getAllUnboundExternalVariables();
            Assert.fail((String)"A-XQPE-9.1: closed prepared expression supports getAllUnboundExternalVariables()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            extVars = xqpe.getAllUnboundExternalVariables();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-9.2: getAllUnboundExternalVariables on prepared expression with unbound variables failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQPE-9.2: getAllUnboundExternalVariables on prepared expression with unbound variables", (Object)extVars);
        Assert.assertEquals((String)"A-XQPE-9.2: getAllUnboundExternalVariables on prepared expression with unbound variables", (int)1, (int)extVars.length);
        Assert.assertEquals((String)"A-XQPE-9.2: getAllUnboundExternalVariables on prepared expression with unbound variables", (String)"v", (String)extVars[0].getLocalPart());
        Assert.assertEquals((String)"A-XQPE-9.2: getAllUnboundExternalVariables on prepared expression with unbound variables", (String)"", (String)extVars[0].getNamespaceURI());
        xqpe.bindString(new QName("v"), "Hello world!", null);
        try {
            extVars = xqpe.getAllUnboundExternalVariables();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-9.3: getAllUnboundExternalVariables on prepared expression without unbound variables failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQPE-9.3: getAllUnboundExternalVariables on prepared expression without unbound variables", (Object)extVars);
        Assert.assertEquals((String)"A-XQPE-9.3: getAllUnboundExternalVariables on prepared expression without unbound variables", (int)0, (int)extVars.length);
        xqpe.close();
    }

    public void testGetStaticResultType() throws XQException {
        XQSequenceType xqtype = null;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("'Hello world!'");
        xqpe.close();
        try {
            xqpe.getStaticResultType();
            Assert.fail((String)"A-XQPE-5.1: closed prepared expression supports getStaticResultType()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqtype = xqpe.getStaticResultType();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-5.2: getStaticResultType() failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQPE-5.2: getStaticResultType() failed", (Object)xqtype);
        Assert.assertEquals((String)"A-XQPE-5.2: getStaticResultType() failed", (int)3, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQPE-5.2: getStaticResultType() failed", (int)8, (int)xqtype.getItemType().getItemKind());
        xqpe.close();
    }

    public void testGetStaticVariableType() throws XQException {
        XQSequenceType xqtype = null;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.getStaticVariableType(new QName("v"));
            Assert.fail((String)"A-XQPE-6.1: closed prepared expression supports getStaticVariableType()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.getStaticVariableType(new QName("foo"));
            Assert.fail((String)"A-XQPE-6.2: getStaticVariableType() specifying undeclared variable");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.getStaticVariableType(null);
            Assert.fail((String)"A-XQPE-6.3: getStaticVariableType() specifying null");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqtype = xqpe.getStaticVariableType(new QName("v"));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-6.4: getStaticVariableType() failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQPE-6.4: getStaticVariableType() failed", (Object)xqtype);
        Assert.assertEquals((String)"A-XQPE-6.4: getStaticResultType() failed", (int)3, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQPE-6.4: getStaticResultType() failed", (int)8, (int)xqtype.getItemType().getItemKind());
        xqpe.close();
    }

    public void testGetStaticContext() throws XQException {
        XQStaticContext xqsc = null;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("'Hello world!'");
        xqpe.close();
        try {
            xqpe.getStaticContext();
            Assert.fail((String)"A-XQPE-7.1: closed prepared expression supports getStaticContext()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("'Hello world!'");
        try {
            xqsc = xqpe.getStaticContext();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQPE-7.2: getting static context failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQPE-7.2: getting static context failed", (Object)xqsc);
        xqpe.close();
    }
}

