/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import junit.framework.Assert;

public class XQItemTypeTest
extends XQJTestCase {
    private void testSimpleType(XQItemType xqtype, int itemKind) throws XQException {
        try {
            xqtype.getBaseType();
            Assert.fail((String)"A-XQIT-1.2: getBaseType() must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"A-XQIT-2.1: getItemKind() returns the correct item kind.", (int)itemKind, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQIT-3.1: getItemOccurrence() returns OCC_EXACTLY_ONE.", (int)2, (int)xqtype.getItemOccurrence());
        xqtype.toString();
        try {
            xqtype.getNodeName();
            Assert.fail((String)"A-XQIT-5.2: getNodeName() must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"A-XQIT-6.2: getSchemaURI() returns null.", null, (Object)xqtype.getSchemaURI());
        try {
            xqtype.getTypeName();
            Assert.fail((String)"A-XQIT-7.2: getTypeName() must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        Assert.assertFalse((String)"A-XQIT-8.1: isAnonymousType() reports if the type is anonymous.", (boolean)xqtype.isAnonymousType());
        Assert.assertFalse((String)"A-XQIT-9.1: isElementNillable() reports if the element is nillable.", (boolean)xqtype.isElementNillable());
        try {
            xqtype.getPIName();
            Assert.fail((String)"A-XQIT-10.2: getPIName() must throw an XQException.");
        }
        catch (XQException xQException) {
            // empty catch block
        }
    }

    public void testItemKindAtomic() throws XQException {
        XQItemType xqtype = this.xqc.createAtomicType(29);
        Assert.assertEquals((String)"A-XQIT-1.1: getBaseType() returns the correct base type.", (int)29, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQIT-2.1: getItemKind() returns the correct item kind.", (int)1, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQIT-3.1: getItemOccurrence() returns OCC_EXACTLY_ONE.", (int)2, (int)xqtype.getItemOccurrence());
        xqtype.toString();
        try {
            xqtype.getNodeName();
            Assert.fail((String)"A-XQIT-5.2: getNodeName() must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"A-XQIT-6.2: getSchemaURI() returns null.", null, (Object)xqtype.getSchemaURI());
        Assert.assertEquals((String)"A-XQIT-7.1: getTypeName() returns the correct QName.", (String)"string", (String)xqtype.getTypeName().getLocalPart());
        Assert.assertEquals((String)"A-XQIT-7.1: getTypeName() returns the correct QName.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertFalse((String)"A-XQIT-8.1: isAnonymousType() reports if the type is anonymous.", (boolean)xqtype.isAnonymousType());
        Assert.assertFalse((String)"A-XQIT-9.1: isElementNillable() reports if the element is nillable.", (boolean)xqtype.isElementNillable());
        try {
            xqtype.getPIName();
            Assert.fail((String)"A-XQIT-10.2: getPIName() must throw an XQException.");
        }
        catch (XQException xQException) {
            // empty catch block
        }
    }

    public void testItemKindAttribute() throws XQException {
        XQItemType xqtype = this.xqc.createAttributeType(new QName("http://www.xqj.org", "a"), 29);
        Assert.assertEquals((String)"A-XQIT-1.1: getBaseType() returns the correct base type.", (int)29, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQIT-2.1: getItemKind() returns the correct item kind.", (int)2, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQIT-3.1: getItemOccurrence() returns OCC_EXACTLY_ONE.", (int)2, (int)xqtype.getItemOccurrence());
        xqtype.toString();
        Assert.assertEquals((String)"A-XQIT-5.1: getNodeName() returns the correct QName.", (String)"a", (String)xqtype.getNodeName().getLocalPart());
        Assert.assertEquals((String)"A-XQIT-5.1: getNodeName() returns the correct QName.", (String)"http://www.xqj.org", (String)xqtype.getNodeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQIT-6.2: getSchemaURI() returns null.", null, (Object)xqtype.getSchemaURI());
        Assert.assertEquals((String)"A-XQIT-7.1: getTypeName() returns the correct QName.", (String)"string", (String)xqtype.getTypeName().getLocalPart());
        Assert.assertEquals((String)"A-XQIT-7.1: getTypeName() returns the correct QName.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertFalse((String)"A-XQIT-8.1: isAnonymousType() reports if the type is anonymous.", (boolean)xqtype.isAnonymousType());
        Assert.assertFalse((String)"A-XQIT-9.1: isElementNillable() reports if the element is nillable.", (boolean)xqtype.isElementNillable());
        try {
            xqtype.getPIName();
            Assert.fail((String)"A-XQIT-10.2: getPIName() must throw an XQException.");
        }
        catch (XQException xQException) {
            // empty catch block
        }
    }

    public void testItemKindComment() throws XQException {
        XQItemType xqtype = this.xqc.createCommentType();
        this.testSimpleType(xqtype, 3);
    }

    public void testItemKindDocument() throws XQException {
        XQItemType xqtype = this.xqc.createDocumentType();
        this.testSimpleType(xqtype, 4);
    }

    public void testItemKindDocumentElement() throws XQException {
        XQItemType xqtype_element = this.xqc.createElementType(new QName("http://www.xqj.org", "e"), 29);
        XQItemType xqtype = this.xqc.createDocumentElementType(xqtype_element);
        Assert.assertEquals((String)"A-XQIT-1.1: getBaseType() returns the correct base type.", (int)29, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQIT-2.1: getItemKind() returns the correct item kind.", (int)5, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQIT-3.1: getItemOccurrence() returns OCC_EXACTLY_ONE.", (int)2, (int)xqtype.getItemOccurrence());
        xqtype.toString();
        Assert.assertEquals((String)"A-XQIT-5.1: getNodeName() returns the correct QName.", (String)"e", (String)xqtype.getNodeName().getLocalPart());
        Assert.assertEquals((String)"A-XQIT-5.1: getNodeName() returns the correct QName.", (String)"http://www.xqj.org", (String)xqtype.getNodeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQIT-6.2: getSchemaURI() returns null", null, (Object)xqtype.getSchemaURI());
        Assert.assertEquals((String)"A-XQIT-7.1: getTypeName() returns the correct QName.", (String)"string", (String)xqtype.getTypeName().getLocalPart());
        Assert.assertEquals((String)"A-XQIT-7.1: getTypeName() returns the correct QName.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertFalse((String)"A-XQIT-8.1: isAnonymousType() reports if the type is anonymous.", (boolean)xqtype.isAnonymousType());
        Assert.assertFalse((String)"A-XQIT-9.1: isElementNillable() reports if the element is nillable.", (boolean)xqtype.isElementNillable());
        try {
            xqtype.getPIName();
            Assert.fail((String)"A-XQIT-10.2: getPIName() must throw an XQException.");
        }
        catch (XQException xQException) {
            // empty catch block
        }
    }

    public void testItemKindDocumentSchemaElement() throws XQException {
    }

    public void testItemKindElement() throws XQException {
        XQItemType xqtype = this.xqc.createElementType(new QName("http://www.xqj.org", "e"), 29);
        Assert.assertEquals((String)"A-XQIT-1.1: getBaseType() returns the correct base type.", (int)29, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQIT-2.1: getItemKind() returns the correct item kind.", (int)7, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQIT-3.1: getItemOccurrence() returns OCC_EXACTLY_ONE.", (int)2, (int)xqtype.getItemOccurrence());
        xqtype.toString();
        Assert.assertEquals((String)"A-XQIT-5.1: getNodeName() returns the correct QName.", (String)"e", (String)xqtype.getNodeName().getLocalPart());
        Assert.assertEquals((String)"A-XQIT-5.1: getNodeName() returns the correct QName.", (String)"http://www.xqj.org", (String)xqtype.getNodeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQIT-6.2: getSchemaURI() returns null", null, (Object)xqtype.getSchemaURI());
        Assert.assertEquals((String)"A-XQIT-7.1: getTypeName() returns the correct QName.", (String)"string", (String)xqtype.getTypeName().getLocalPart());
        Assert.assertEquals((String)"A-XQIT-7.1: getTypeName() returns the correct QName.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertFalse((String)"A-XQIT-8.1: isAnonymousType() reports if the type is anonymous.", (boolean)xqtype.isAnonymousType());
        Assert.assertFalse((String)"A-XQIT-9.1: isElementNillable() reports if the element is nillable.", (boolean)xqtype.isElementNillable());
        try {
            xqtype.getPIName();
            Assert.fail((String)"A-XQIT-10.2: getPIName() must throw an XQException.");
        }
        catch (XQException xQException) {
            // empty catch block
        }
    }

    public void testItemKindItem() throws XQException {
        XQItemType xqtype = this.xqc.createItemType();
        this.testSimpleType(xqtype, 8);
    }

    public void testItemKindNode() throws XQException {
        XQItemType xqtype = this.xqc.createNodeType();
        this.testSimpleType(xqtype, 9);
    }

    public void testItemKindPI() throws XQException {
        XQItemType xqtype = this.xqc.createProcessingInstructionType("pi");
        try {
            xqtype.getBaseType();
            Assert.fail((String)"A-XQIT-1.2: getBaseType() must throw an XQException");
        }
        catch (XQException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"A-XQIT-2.1: getItemKind() returns the correct item kind.", (int)10, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQIT-3.1: getItemOccurrence() returns OCC_EXACTLY_ONE.", (int)2, (int)xqtype.getItemOccurrence());
        xqtype.toString();
        try {
            xqtype.getNodeName();
            Assert.fail((String)"A-XQIT-5.2: getNodeName() must throw an XQException");
        }
        catch (XQException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"A-XQIT-6.2: getSchemaURI() returns null", null, (Object)xqtype.getSchemaURI());
        try {
            xqtype.getTypeName();
            Assert.fail((String)"A-XQIT-7.2: getTypeName() must throw an XQException.");
        }
        catch (XQException xQException) {
            // empty catch block
        }
        Assert.assertFalse((String)"A-XQIT-8.1: isAnonymousType() reports if the type is anonymous.", (boolean)xqtype.isAnonymousType());
        Assert.assertFalse((String)"A-XQIT-9.1: isElementNillable() reports if the element is nillable.", (boolean)xqtype.isElementNillable());
        Assert.assertEquals((String)"A-XQIT-10.1: getPIName() returns the correct name.", (String)"pi", (String)xqtype.getPIName());
    }

    public void testItemKindSchemaAttribute() throws XQException {
    }

    public void testItemKindSchemaElement() throws XQException {
    }

    public void testItemKindText() throws XQException {
        XQItemType xqtype = this.xqc.createTextType();
        this.testSimpleType(xqtype, 11);
    }
}

