/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.TestContentHandler;
import com.oracle.xqj.tck.testcases.XQJTestCase;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQResultSequence;
import junit.framework.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XQItemAccessorTest
extends XQJTestCase {
    public void testGetBoolean() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'true'");
        xqs.next();
        try {
            xqs.getBoolean();
            Assert.fail((String)"A-XQIA-1.1: conversion to boolean should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:boolean('true')");
        try {
            xqs.getBoolean();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:boolean('true')");
        xqs.next();
        xqs.close();
        try {
            xqs.getBoolean();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:boolean('true')");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getBoolean();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:boolean('true')");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getBoolean on xs:boolean failed", (boolean)true, (boolean)xqs.getBoolean());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getBoolean on xs:boolean failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetByte() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        xqs.next();
        try {
            xqs.getByte();
            Assert.fail((String)"A-XQIA-1.1: conversion to byte should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:byte('1')");
        try {
            xqs.getByte();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:byte('1')");
        xqs.next();
        xqs.close();
        try {
            xqs.getByte();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:byte('1')");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getByte();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:decimal('1.1')");
        xqs.next();
        try {
            xqs.getByte();
            Assert.fail((String)"A-XQIA-1.5: getByte on xs:decimal out of value space of byte should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:byte('1'), 10.0");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getByte on xs:byte failed", (int)1, (int)xqs.getByte());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getByte on xs:byte failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getByte on xs:decimal failed", (int)10, (int)xqs.getByte());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getByte on xs:decimal failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetDouble() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        xqs.next();
        try {
            xqs.getDouble();
            Assert.fail((String)"A-XQIA-1.1: conversion to double should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:double('1')");
        try {
            xqs.getDouble();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:double('1')");
        xqs.next();
        xqs.close();
        try {
            xqs.getDouble();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:double('1')");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getDouble();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:double('1')");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getDouble on xs:double failed", (double)1.0, (double)xqs.getDouble(), (double)0.0);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6:  getDouble on xs:double failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetFloat() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        xqs.next();
        try {
            xqs.getFloat();
            Assert.fail((String)"A-XQIA-1.1: conversion to float should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:float('1')");
        try {
            xqs.getFloat();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:float('1')");
        xqs.next();
        xqs.close();
        try {
            xqs.getFloat();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:float('1')");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getFloat();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:float('1')");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getFloat on xs:float failed", (double)1.0, (double)xqs.getFloat(), (double)0.0);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getFloat on xs:float failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetInt() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        xqs.next();
        try {
            xqs.getInt();
            Assert.fail((String)"A-XQIA-1.1: conversion to int should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:int('1')");
        try {
            xqs.getInt();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:int('1')");
        xqs.next();
        xqs.close();
        try {
            xqs.getInt();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:int('1')");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getInt();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:decimal('1.1')");
        xqs.next();
        try {
            xqs.getInt();
            Assert.fail((String)"A-XQIA-1.5: getInt on xs:decimal out of value space of int should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:int('1'), 10.0");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getInt on xs:int failed", (int)1, (int)xqs.getInt());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getInt on xs:int failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getInt on xs:decimal failed", (int)10, (int)xqs.getInt());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getInt on xs:decimal failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetItemType() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        try {
            xqs.getItemType();
            Assert.fail((String)"A-XQIA-6.1: getItemType() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("'1'");
        xqs.next();
        xqs.close();
        try {
            xqs.getItemType();
            Assert.fail((String)"A-XQIA-6.2: closed item accessor supports getItemType()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("'Hello world!'");
        xqs.next();
        try {
            XQItemType xqtype = xqs.getItemType();
            Assert.assertNotNull((String)"A-XQIA-6.3: getItemType() failed", (Object)xqtype);
            Assert.assertEquals((String)"A-XQIA-6.3: getItemType() failed", (int)1, (int)xqtype.getItemKind());
            Assert.assertEquals((String)"A-XQIA-6.3: getItemType() failed", (int)29, (int)xqtype.getBaseType());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-6.3: getItemType() failed with message: " + e.getMessage()));
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getItemType();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-6.4: getItemType() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetAtomicValue() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        try {
            xqs.getAtomicValue();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("'1'");
        xqs.next();
        xqs.close();
        try {
            xqs.getAtomicValue();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("'1'");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getAtomicValue();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("1, 1.1");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-2.1: getAtomicValue on xs:string failed", (String)"1", (String)xqs.getAtomicValue());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-2.1: getAtomicValue on xs:string failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-2.1: getAtomicValue on xs:decimal failed", (String)"1.1", (String)xqs.getAtomicValue());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-2.1: getAtomicValue on xs:decimal failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetLong() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        xqs.next();
        try {
            xqs.getLong();
            Assert.fail((String)"A-XQIA-1.1: conversion to long should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:long('1')");
        try {
            xqs.getLong();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:long('1')");
        xqs.next();
        xqs.close();
        try {
            xqs.getLong();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:long('1')");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getLong();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:decimal('1.1')");
        xqs.next();
        try {
            xqs.getLong();
            Assert.fail((String)"A-XQIA-1.5: getLong on xs:decimal out of value space of long should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:long('1'), 10.0");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getLong on xs:long failed", (long)1L, (long)xqs.getLong());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getLong on xs:long failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getLong on xs:decimal failed", (long)10L, (long)xqs.getLong());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getLong on xs:decimal failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetNode() throws XQException {
        Node node = null;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        xqs.next();
        try {
            xqs.getNode();
            Assert.fail((String)"A-XQIA-1.1: conversion to org.w3c.dom.Node should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>");
        try {
            xqs.getNode();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>");
        xqs.next();
        xqs.close();
        try {
            xqs.getNode();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getNode();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>, <e a=''/>/@*");
        xqs.next();
        try {
            node = xqs.getNode();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-3.1: getNode on element() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQIA-3.1: getNode on element() failed", (boolean)true, (boolean)(node instanceof Element));
        Assert.assertEquals((String)"A-XQIA-3.1: getNode on element() failed", (String)"e", (String)node.getLocalName());
        xqs.next();
        try {
            node = xqs.getNode();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-3.1: getNode on attribute() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQIA-3.1: getNode on attribute() failed", (boolean)true, (boolean)(node instanceof Attr));
        Assert.assertEquals((String)"A-XQIA-3.1: getNode on attribute() failed", (String)"a", (String)node.getLocalName());
        xqe.close();
    }

    public void testGetNodeUri() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        xqs.next();
        try {
            xqs.getNodeUri();
            Assert.fail((String)"A-XQIA-5.1: getNodeUri() should fail if current item is not a node");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>");
        try {
            xqs.getNodeUri();
            Assert.fail((String)"A-XQIA-5.2: getNodeUri() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>");
        xqs.next();
        xqs.close();
        try {
            xqs.getNodeUri();
            Assert.fail((String)"A-XQIA-5.3: closed item accessor supports getNodeUri()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>");
        xqs.next();
        try {
            xqs.getNodeUri();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-5.4: getNodeUri() failed with message: " + e.getMessage()));
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getNodeUri();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-5.5: getNodeUri() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetObject() throws XQException {
        Object object = null;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e/>");
        try {
            xqs.getObject();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>");
        xqs.next();
        xqs.close();
        try {
            xqs.getObject();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getObject();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e/>, 'Hello world!'");
        xqs.next();
        try {
            object = xqs.getObject();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-4.1: getObject on element() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQIA-4.1: getObject on element() failed", (boolean)true, (boolean)(object instanceof Element));
        Assert.assertEquals((String)"A-XQIA-4.1: getObject on element() failed", (String)"e", (String)((Node)object).getLocalName());
        xqs.next();
        try {
            object = xqs.getObject();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-4.1: getObject on xs:string failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQIA-4.1: getObject on xs:string failed", (boolean)true, (boolean)(object instanceof String));
        Assert.assertEquals((String)"A-XQIA-4.1: getObject on xs:string failed", (String)"Hello world!", (String)((String)object));
        xqe.close();
    }

    public void testGetObject_AllTypes() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("xs:anyURI('http://www.foo.org'),xs:base64Binary('AAAA'),xs:boolean('true'),xs:byte('1'),xs:date('2000-12-31'),xs:dateTime('2000-12-31T12:00:00'),xs:decimal('1'),xs:double('1'),xs:ENTITY('AAA'),xs:float('1'),xs:gDay('---11'),xs:gMonth('--11'),xs:gMonthDay('--01-01'),xs:gYear('2000'),xs:gYearMonth('2000-01'),xs:hexBinary('AA'),xs:ID('AA'),xs:IDREF('AA'),xs:int('1'),xs:integer('1'),xs:language('en-US'),xs:long('1'),xs:Name('AAA'),xs:NCName('AAA'),xs:negativeInteger('-1'),xs:NMTOKEN('AAA'),xs:nonNegativeInteger('1'),xs:nonPositiveInteger('-1'),xs:normalizedString('AAA'),xs:positiveInteger('1'),xs:QName('AAA'),xs:short('1'),xs:string('AAA'),xs:time('12:12:12'),xs:token('AAA'),xs:unsignedByte('1'),xs:unsignedInt('1'),xs:unsignedLong('1'),xs:unsignedShort('1'),xs:dayTimeDuration('PT5H'),xs:untypedAtomic('AAA'),xs:yearMonthDuration('P1M'),<e a=\"{''}\"/>/@a,<!-- comment -->, document{<e/>},<e/>, processing-instruction {'a'} {'b'},<e>text</e>/text()");
        Class<?> xmlGregorianCalendar = null;
        Class<?> duration = null;
        try {
            xmlGregorianCalendar = Class.forName("javax.xml.datatype.XMLGregorianCalendar");
            duration = Class.forName("javax.xml.datatype.Duration");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String msg = "A-XQIA-4.1: getObject implements casting rules of '14.4 Mapping an XQuery Atomic Value to a Java Object Type' ";
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:anyURI"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:base64Binary"), (boolean)(xqs.getObject() instanceof byte[]));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:boolean"), (boolean)(xqs.getObject() instanceof Boolean));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:byte"), (boolean)(xqs.getObject() instanceof Byte));
            xqs.next();
            if (xmlGregorianCalendar != null) {
                Assert.assertTrue((String)(msg + "for xs:date"), (boolean)xmlGregorianCalendar.isInstance(xqs.getObject()));
            }
            xqs.next();
            if (xmlGregorianCalendar != null) {
                Assert.assertTrue((String)(msg + "for xs:dateTime"), (boolean)xmlGregorianCalendar.isInstance(xqs.getObject()));
            }
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:decimal"), (boolean)(xqs.getObject() instanceof BigDecimal));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:double"), (boolean)(xqs.getObject() instanceof Double));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:ENTITY"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:float"), (boolean)(xqs.getObject() instanceof Float));
            xqs.next();
            if (xmlGregorianCalendar != null) {
                Assert.assertTrue((String)(msg + "for xs:gDay"), (boolean)xmlGregorianCalendar.isInstance(xqs.getObject()));
            }
            xqs.next();
            if (xmlGregorianCalendar != null) {
                Assert.assertTrue((String)(msg + "for xs:gMonth"), (boolean)xmlGregorianCalendar.isInstance(xqs.getObject()));
            }
            xqs.next();
            if (xmlGregorianCalendar != null) {
                Assert.assertTrue((String)(msg + "for xs:MonthDay"), (boolean)xmlGregorianCalendar.isInstance(xqs.getObject()));
            }
            xqs.next();
            if (xmlGregorianCalendar != null) {
                Assert.assertTrue((String)(msg + "for xs:Year"), (boolean)xmlGregorianCalendar.isInstance(xqs.getObject()));
            }
            xqs.next();
            if (xmlGregorianCalendar != null) {
                Assert.assertTrue((String)(msg + "for xs:YearMonth"), (boolean)xmlGregorianCalendar.isInstance(xqs.getObject()));
            }
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:hexBinary"), (boolean)(xqs.getObject() instanceof byte[]));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:ID"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:IDREF"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:int"), (boolean)(xqs.getObject() instanceof Integer));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:integer"), (boolean)(xqs.getObject() instanceof BigInteger));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:language"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:long"), (boolean)(xqs.getObject() instanceof Long));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:Name"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:NCName"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:negativeInteger"), (boolean)(xqs.getObject() instanceof BigInteger));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:NMTOKEN"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:nonNegativeInteger"), (boolean)(xqs.getObject() instanceof BigInteger));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:nonPostiveInteger"), (boolean)(xqs.getObject() instanceof BigInteger));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:normalizedString"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:postiveInteger"), (boolean)(xqs.getObject() instanceof BigInteger));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:QName"), (boolean)(xqs.getObject() instanceof QName));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:short"), (boolean)(xqs.getObject() instanceof Short));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:string"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            if (xmlGregorianCalendar != null) {
                Assert.assertTrue((String)(msg + "for xs:time"), (boolean)xmlGregorianCalendar.isInstance(xqs.getObject()));
            }
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:token"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:unsignedByte"), (boolean)(xqs.getObject() instanceof Short));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:unsignedInt"), (boolean)(xqs.getObject() instanceof Long));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:unsignedLong"), (boolean)(xqs.getObject() instanceof BigInteger));
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:unsignedShort"), (boolean)(xqs.getObject() instanceof Integer));
            xqs.next();
            if (duration != null) {
                Assert.assertTrue((String)(msg + "for xs:dayTimeDuration"), (boolean)duration.isInstance(xqs.getObject()));
            }
            xqs.next();
            Assert.assertTrue((String)(msg + "for xs:untypedAtomic"), (boolean)(xqs.getObject() instanceof String));
            xqs.next();
            if (duration != null) {
                Assert.assertTrue((String)(msg + "for xs:yearMonthDuration"), (boolean)duration.isInstance(xqs.getObject()));
            }
            xqs.next();
            Assert.assertTrue((String)(msg + "for attribute"), (boolean)(xqs.getObject() instanceof Attr));
            xqs.next();
            Assert.assertTrue((String)(msg + "for comment"), (boolean)(xqs.getObject() instanceof Comment));
            xqs.next();
            Assert.assertTrue((String)(msg + "for document"), (boolean)(xqs.getObject() instanceof Document));
            xqs.next();
            Assert.assertTrue((String)(msg + "for element"), (boolean)(xqs.getObject() instanceof Element));
            xqs.next();
            Assert.assertTrue((String)(msg + "for processing instruction"), (boolean)(xqs.getObject() instanceof ProcessingInstruction));
            xqs.next();
            Assert.assertTrue((String)(msg + "for text"), (boolean)(xqs.getObject() instanceof Text));
        }
        catch (XQException e) {
            e.printStackTrace();
            Assert.fail((String)("A-XQIA-4.1: getObject on element() failed with message: " + e.getMessage()));
        }
    }

    public void testGetItemAsStream() throws XQException {
        XMLStreamReader xmlReader = null;
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.getItemAsStream();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.close();
        try {
            xqs.getItemAsStream();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getItemAsStream();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        xqs.next();
        try {
            xmlReader = xqs.getItemAsStream();
            while (xmlReader.hasNext()) {
                xmlReader.next();
            }
            Assert.fail((String)"A-XQIA-8.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
        }
        catch (XMLStreamException xml) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        try {
            xmlReader = xqs.getItemAsStream();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-9.1: getItemAsStream failed with message: " + e.getMessage()));
        }
        try {
            Assert.assertNotNull((String)"A-XQIA-9.1: getItemAsStream returned a null XMLStreamReader", (Object)xmlReader);
            Assert.assertEquals((String)"A-XQIA-9.1: unexpected first event returned by XMLStreamReader", (int)7, (int)xmlReader.getEventType());
            Assert.assertEquals((String)"A-XQIA-9.1: unexpected second event returned by XMLStreamReader", (int)1, (int)xmlReader.next());
            Assert.assertEquals((String)"A-XQIA-9.1: unexpected third event returned by XMLStreamReader", (int)4, (int)xmlReader.next());
            Assert.assertEquals((String)"A-XQIA-9.1: unexpected fourth event returned by XMLStreamReader", (int)2, (int)xmlReader.next());
            Assert.assertEquals((String)"A-XQIA-9.1: unexpected fifth event returned by XMLStreamReader", (int)8, (int)xmlReader.next());
        }
        catch (XMLStreamException e) {
            Assert.fail((String)("A-XQIA-9.1: XMLStreamReader.next() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetItemAsString() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.getItemAsString(new Properties());
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.close();
        try {
            xqs.getItemAsString(new Properties());
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getItemAsString(new Properties());
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        xqs.next();
        try {
            xqs.getItemAsString(new Properties());
            Assert.fail((String)"A-XQIA-8.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        String result = null;
        try {
            result = xqs.getItemAsString(new Properties());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-10.1: getItemAsString failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQIA-10.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-10.2: null properties argument is equivalent to empty properties argument", (String)result, (String)xqs.getItemAsString(null));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-10.2: getItemAsString failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetShort() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        xqs.next();
        try {
            xqs.getShort();
            Assert.fail((String)"A-XQIA-1.1: conversion to short should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:short('1')");
        try {
            xqs.getShort();
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:short('1')");
        xqs.next();
        xqs.close();
        try {
            xqs.getShort();
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:short('1')");
        xqs.next();
        xqs.getItem();
        try {
            xqs.getShort();
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:decimal('1.1')");
        xqs.next();
        try {
            xqs.getShort();
            Assert.fail((String)"A-XQIA-1.5: getShort on xs:decimal out of value space of short should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("xs:short('1'), 10.0");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getShort on xs:short failed", (int)1, (int)xqs.getShort());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getShort on xs:short failed with message: " + e.getMessage()));
        }
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-1.6: getShort on xs:decimal failed", (int)10, (int)xqs.getShort());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-1.6: getShort on xs:decimal failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testInstanceOf() throws XQException {
        XQItemType xqstringtype = this.xqc.createAtomicType(29);
        XQItemType xqinttype = this.xqc.createAtomicType(12);
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'1'");
        try {
            xqs.instanceOf(xqstringtype);
            Assert.fail((String)"A-XQIA-7.1: instanceOf() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("'1'");
        xqs.next();
        xqs.close();
        try {
            xqs.instanceOf(xqstringtype);
            Assert.fail((String)"A-XQIA-7.2: closed item accessor supports instanceOf()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("'Hello world!'");
        xqs.next();
        try {
            Assert.assertEquals((String)"A-XQIA-7.3: instanceOf failed", (boolean)true, (boolean)xqs.instanceOf(xqstringtype));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-7.3: instanceOf() failed with message: " + e.getMessage()));
        }
        try {
            Assert.assertEquals((String)"A-XQIA-7.4: instanceOf failed", (boolean)false, (boolean)xqs.instanceOf(xqinttype));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-7.4: instanceOf() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testWriteItem_OutputStream() throws XQException, UnsupportedEncodingException {
        Properties prop = new Properties();
        prop.setProperty("encoding", "UTF-8");
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.writeItem((OutputStream)new ByteArrayOutputStream(), prop);
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.close();
        try {
            xqs.writeItem((OutputStream)new ByteArrayOutputStream(), prop);
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.writeItem((OutputStream)new ByteArrayOutputStream(), prop);
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        xqs.next();
        try {
            xqs.writeItem((OutputStream)new ByteArrayOutputStream(), prop);
            Assert.fail((String)"A-XQIA-8.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        try {
            xqs.writeItem((OutputStream)null, prop);
            Assert.fail((String)"A-XQIA-11.3: writeItem accepts a null buffer as first argument");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            xqs.writeItem((OutputStream)result, prop);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-11.1: writeItem failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQIA-11.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result.toString("UTF-8") + "'"), (result.toString("UTF-8").indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        ByteArrayOutputStream otherResult = new ByteArrayOutputStream();
        try {
            xqs.writeItem((OutputStream)otherResult, prop);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-11.2: writeItem failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQIA-11.2: null properties argument is equivalent to empty properties argument", (String)result.toString("UTF-8"), (String)otherResult.toString("UTF-8"));
        xqe.close();
    }

    public void testWriteItem_Writer() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.writeItem((Writer)new StringWriter(), new Properties());
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.close();
        try {
            xqs.writeItem((Writer)new StringWriter(), new Properties());
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.writeItem((Writer)new StringWriter(), new Properties());
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        xqs.next();
        try {
            xqs.writeItem((Writer)new StringWriter(), new Properties());
            Assert.fail((String)"A-XQIA-8.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        try {
            xqs.writeItem((Writer)null, new Properties());
            Assert.fail((String)"A-XQIA-11.3: writeItem accepts a null buffer as first argument");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        StringWriter result = new StringWriter();
        try {
            xqs.writeItem((Writer)result, new Properties());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-11.1: writeItem failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQIA-11.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result.toString() + "'"), (result.toString().indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        StringWriter otherResult = new StringWriter();
        try {
            xqs.writeItem((Writer)otherResult, new Properties());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-11.2: writeItem failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQIA-11.2: null properties argument is equivalent to empty properties argument", (String)result.toString(), (String)otherResult.toString());
        xqe.close();
    }

    public void testWriteItemToSAX() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.writeItemToSAX((ContentHandler)new DefaultHandler());
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.close();
        try {
            xqs.writeItemToSAX((ContentHandler)new DefaultHandler());
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.writeItemToSAX((ContentHandler)new DefaultHandler());
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e a='Hello world!'/>/@*");
        xqs.next();
        try {
            xqs.writeItemToSAX((ContentHandler)new DefaultHandler());
            Assert.fail((String)"A-XQIA-8.1: serialization process fails when sequence contains a top-level attribute");
        }
        catch (XQException xq) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        try {
            xqs.writeItemToSAX((ContentHandler)null);
            Assert.fail((String)"A-XQIA-11.3: writeItem accepts a null buffer as first argument");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        TestContentHandler result = new TestContentHandler();
        try {
            xqs.writeItemToSAX((ContentHandler)result);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-11.1: writeItem failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQIA-11.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result.buffer.toString() + "'"), (result.buffer.toString().indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
    }

    public void testWriteItemToResult() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("<e>Hello world!</e>");
        try {
            xqs.writeItemToResult((Result)new StreamResult(new StringWriter()));
            Assert.fail((String)"A-XQIA-1.2: getXXX() should fail when not positioned on an item");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.close();
        try {
            xqs.writeItemToResult((Result)new StreamResult(new StringWriter()));
            Assert.fail((String)"A-XQIA-1.3: closed item accessor supports getXXX()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        xqs.getItem();
        try {
            xqs.writeItemToResult((Result)new StreamResult(new StringWriter()));
            Assert.fail((String)"A-XQIA-1.4: SCROLLTYPE_FORWARD_ONLY sequence supports getting item twice()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        try {
            xqs.writeItemToResult((Result)null);
            Assert.fail((String)"A-XQIA-11.3: writeItemToResult accepts a null buffer as first argument");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqs = xqe.executeQuery("<e>Hello world!</e>");
        xqs.next();
        StringWriter result = new StringWriter();
        try {
            xqs.writeItemToResult((Result)new StreamResult(result));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQIA-11.1: writeItemToResult failed with message: " + e.getMessage()));
        }
        Assert.assertTrue((String)("A-XQIA-11.1: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result.toString() + "'"), (result.toString().indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
    }
}

