/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQStaticContext;
import junit.framework.Assert;

public class XQExpressionTest
extends XQJTestCase {
    public void testCancel() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        try {
            xqe.cancel();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQE-1.1: cancellation of expression failed with message: " + e.getMessage()));
        }
        xqe.close();
        try {
            xqe.cancel();
            Assert.fail((String)"A-XQE-1.2: closed expression supports cancel()");
        }
        catch (XQException xQException) {
            // empty catch block
        }
    }

    public void testIsClosed() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        xqe.executeQuery("'Hello world!'");
        Assert.assertEquals((String)"A-XQE-2.1: isClosed() on open expression", (boolean)false, (boolean)xqe.isClosed());
        xqe.close();
        Assert.assertEquals((String)"A-XQE-2.2: isClosed() on closed expressions", (boolean)true, (boolean)xqe.isClosed());
    }

    public void testClose() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("'Hello world!'");
        try {
            xqe.close();
            xqe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQE-3.1: closing expression failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQE-3.2: Closing an expression, closes any result sequences obtained from this expression", (boolean)true, (boolean)xqs.isClosed());
    }

    public void testExecuteCommand_String() throws XQException {
    }

    public void testExecuteCommand_Reader() throws XQException {
    }

    public void testExecuteQuery_String() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        try {
            xqe.executeQuery("'Hello world!");
            Assert.fail((String)"A-XQE-5.1: executeQuery() should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.executeQuery("'Hello world!'");
            Assert.fail((String)"A-XQE-5.2: closed expression supports executeQuery()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.executeQuery((String)null);
            Assert.fail((String)"A-XQE-5.3: expression supports executeQuery() with null argument");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQE-5.3: executeQuery() with null argument doesn't throw XQException");
        }
        xqe = this.xqc.createExpression();
        try {
            xqe.executeQuery("'Hello world!'");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQE-5.4: executing expression failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testExecuteQuery_Reader() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        try {
            xqe.executeQuery((Reader)new StringReader("'Hello world!"));
            Assert.fail((String)"A-XQE-5.1: executeQuery() should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.executeQuery((Reader)new StringReader("'Hello world!'"));
            Assert.fail((String)"A-XQE-5.2: closed expression supports executeQuery()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.executeQuery((Reader)null);
            Assert.fail((String)"A-XQE-5.3: expression supports executeQuery() with null argument");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQE-5.3: expression supports executeQuery() with null argument doesn't throw XQException");
        }
        xqe = this.xqc.createExpression();
        try {
            xqe.executeQuery((Reader)new StringReader("'Hello world!'"));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQE-5.4: executing expression failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testExecuteQuery_InputStream() throws XQException, UnsupportedEncodingException {
        XQExpression xqe = this.xqc.createExpression();
        try {
            xqe.executeQuery((InputStream)new ByteArrayInputStream("'Hello world!".getBytes("UTF-8")));
            Assert.fail((String)"A-XQE-5.1: executeQuery() should fail");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe.close();
        xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.executeQuery((InputStream)new ByteArrayInputStream("'Hello world!'".getBytes("UTF-8")));
            Assert.fail((String)"A-XQE-5.2: closed expression supports executeQuery()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.executeQuery((InputStream)null);
            Assert.fail((String)"A-XQE-5.3: expression supports executeQuery() with null argument");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQE-5.3: expression supports executeQuery() with null argument doesn't throw XQException");
        }
        xqe = this.xqc.createExpression();
        try {
            xqe.executeQuery((InputStream)new ByteArrayInputStream("'Hello world!'".getBytes("UTF-8")));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQE-5.4: executing expression failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testGetStaticContext() throws XQException {
        XQStaticContext xqsc = null;
        XQExpression xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.getStaticContext();
            Assert.fail((String)"A-XQE-6.1: closed expression supports getStaticContext()");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe = this.xqc.createExpression();
        try {
            xqsc = xqe.getStaticContext();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQE-6.2: getting static context failed with message: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"A-XQPE-6.2: getting static context failed", (Object)xqsc);
        xqe.close();
    }
}

