/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequence;
import junit.framework.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XQDynamicContextTest
extends XQJTestCase {
    public void testGetImplicitTimeZone() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.getImplicitTimeZone();
            Assert.fail((String)"A-XQDC-1.1: getImplicitTimeZone() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe = this.xqc.createExpression();
        try {
            xqe.getImplicitTimeZone();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-2.1: getImplicitTimeZone() failed with message: " + e.getMessage()));
        }
        xqe.close();
    }

    public void testBindAtomicValue() throws XQException {
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindAtomicValue(new QName("v"), "Hello world!", null);
            Assert.fail((String)"A-XQDC-1.1: bindAtomicValue() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindAtomicValue(null, "Hello world!", null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindAtomicValue(new QName("v"), "Hello world!", this.xqc.createCommentType());
            Assert.fail((String)"A-XQDC-1.3: An invalid type of the value to be bound must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindAtomicValue(new QName("v"), "Hello world!", this.xqc.createAtomicType(17));
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindAtomicValue(new QName("foo"), "Hello world!", this.xqc.createAtomicType(29));
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindAtomicValue(new QName("v"), "Hello world!", this.xqc.createAtomicType(29));
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindAtomicValue(new QName("v"), "Hello world!", this.xqc.createAtomicType(29));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindAtomicValue() failed with message: " + e.getMessage()));
        }
        XQResultSequence xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"Hello world!", (String)xqs.getAtomicValue());
        xqpe.close();
    }

    public void testBindString() throws XQException {
        XQResultSequence xqs;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindString(new QName("v"), "Hello world!", null);
            Assert.fail((String)"A-XQDC-1.1: bindString() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindString(null, "Hello world!", null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindString(new QName("v"), "Hello world!", this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindString(new QName("v"), "123", this.xqc.createAtomicType(44));
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindString(new QName("foo"), "Hello world!", this.xqc.createAtomicType(29));
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindString(new QName("v"), "Hello world!", null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindString(new QName("v"), "Hello world!", this.xqc.createAtomicType(29));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindString() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"Hello world!", (String)xqs.getAtomicValue());
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindString(new QName("v"), "Hello", this.xqc.createAtomicType(44));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindString() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)1, (int)xqs.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)44, (int)xqs.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (Object)"Hello", (Object)xqs.getObject());
        xqpe.close();
    }

    public void testBindDocument_String() throws XQException {
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindDocument(new QName("v"), "<e>Hello world!</e>", null, null);
            Assert.fail((String)"A-XQDC-1.1: bindDocument() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(null, "<e>Hello world!</e>", null, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), "<e>Hello world!</e>", null, this.xqc.createAtomicType(10));
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            XQResultSequence xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 1) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
            if (xqs.getItemType().getBaseType() != 10) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), "<e>", null, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("foo"), "<e>Hello world!</e>", null, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindDocument(new QName("v"), "<e>Hello world!</e>", null, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), "<e>Hello world!</e>", null, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindDocument() failed with message: " + e.getMessage()));
        }
        String result = xqpe.executeQuery().getSequenceAsString(null);
        Assert.assertTrue((String)("A-XQDC-1.7: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqpe.close();
    }

    public void testBindDocument_Reader() throws XQException {
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindDocument(new QName("v"), (Reader)new StringReader("<e>Hello world!</e>"), null, null);
            Assert.fail((String)"A-XQDC-1.1: bindDocument() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(null, (Reader)new StringReader("<e>Hello world!</e>"), null, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (Reader)new StringReader("<e>Hello world!</e>"), null, this.xqc.createAtomicType(10));
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            XQResultSequence xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 1) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
            if (xqs.getItemType().getBaseType() != 10) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (Reader)new StringReader("<e>"), null, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("foo"), (Reader)new StringReader("<e>Hello world!</e>"), null, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (Reader)new StringReader("<e>Hello world!</e>"), null, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (Reader)new StringReader("<e>Hello world!</e>"), null, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindDocument() failed with message: " + e.getMessage()));
        }
        String result = xqpe.executeQuery().getSequenceAsString(null);
        Assert.assertTrue((String)("A-XQDC-1.7: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqpe.close();
    }

    public void testBindDocument_InputStream() throws XQException, UnsupportedEncodingException {
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindDocument(new QName("v"), (InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>Hello world!</e>".getBytes("UTF-8")), null, null);
            Assert.fail((String)"A-XQDC-1.1: bindDocument() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(null, (InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>Hello world!</e>".getBytes("UTF-8")), null, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>Hello world!</e>".getBytes("UTF-8")), null, this.xqc.createAtomicType(10));
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            XQResultSequence xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 1) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
            if (xqs.getItemType().getBaseType() != 10) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>".getBytes("UTF-8")), null, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("foo"), (InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>Hello world!</e>".getBytes("UTF-8")), null, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>Hello world!</e>".getBytes("UTF-8")), null, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>Hello world!</e>".getBytes("UTF-8")), null, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindDocument() failed with message: " + e.getMessage()));
        }
        String result = xqpe.executeQuery().getSequenceAsString(null);
        Assert.assertTrue((String)("A-XQDC-1.7: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqpe.close();
    }

    public void testBindDocument_XMLStreamReader() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindDocument(new QName("v"), xqe.executeQuery("<e>Hello world!</e>").getSequenceAsStream(), null);
            Assert.fail((String)"A-XQDC-1.1: bindDocument() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(null, xqe.executeQuery("<e>Hello world!</e>").getSequenceAsStream(), null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), xqe.executeQuery("<e>Hello world!</e>").getSequenceAsStream(), this.xqc.createAtomicType(10));
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            XQResultSequence xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 1) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
            if (xqs.getItemType().getBaseType() != 10) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("foo"), xqe.executeQuery("<e>Hello world!</e>").getSequenceAsStream(), null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindDocument(new QName("v"), xqe.executeQuery("<e>Hello world!</e>").getSequenceAsStream(), null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), xqe.executeQuery("<e>Hello world!</e>").getSequenceAsStream(), null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindDocument() failed with message: " + e.getMessage()));
        }
        String result = xqpe.executeQuery().getSequenceAsString(null);
        Assert.assertTrue((String)("A-XQDC-1.7: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqpe.close();
        xqe.close();
    }

    public void testBindDocument_Source() throws XQException {
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindDocument(new QName("v"), (Source)new StreamSource(new StringReader("<e>Hello world!</e>")), null);
            Assert.fail((String)"A-XQDC-1.1: bindDocument() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(null, (Source)new StreamSource(new StringReader("<e>Hello world!</e>")), null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (Source)new StreamSource(new StringReader("<e>Hello world!</e>")), this.xqc.createAtomicType(10));
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            XQResultSequence xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 1) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
            if (xqs.getItemType().getBaseType() != 10) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (Source)new StreamSource(new StringReader("<e>")), null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("foo"), (Source)new StreamSource(new StringReader("<e>Hello world!</e>")), null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (Source)new StreamSource(new StringReader("<e>Hello world!</e>")), null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDocument(new QName("v"), (Source)new StreamSource(new StringReader("<e>Hello world!</e>")), null);
        }
        catch (XQException e) {
            e.printStackTrace();
            Assert.fail((String)("A-XQDC-1.7: bindDocument() failed with message: " + e.getMessage()));
        }
        String result = xqpe.executeQuery().getSequenceAsString(null);
        Assert.assertTrue((String)("A-XQDC-1.7: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqpe.close();
    }

    public void testSetImplicitTimeZone() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.setImplicitTimeZone((TimeZone)new SimpleTimeZone(-28800000, "America/Los_Angeles"));
            Assert.fail((String)"A-XQDC-1.1: setImplicitTimeZone() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe = this.xqc.createExpression();
        xqe.close();
        try {
            xqe.setImplicitTimeZone(null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqe = this.xqc.createExpression();
        try {
            xqe.setImplicitTimeZone((TimeZone)new SimpleTimeZone(-28800000, "America/Los_Angeles"));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-2.1: setImplicitTimeZone() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDC-2.1: setImplicitTimeZone() sets the timezone for this dynamic context.", (int)-28800000, (int)xqe.getImplicitTimeZone().getRawOffset());
        xqe.close();
    }

    public void testBindItem() throws XQException {
        XQItem xqi = this.xqc.createItemFromString("Hello world!", null);
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindItem(new QName("v"), xqi);
            Assert.fail((String)"A-XQDC-1.1: bindItem() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindItem(null, xqi);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindItem(new QName("foo"), xqi);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindItem(new QName("v"), xqi);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindItem(new QName("v"), xqi);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindItem() failed with message: " + e.getMessage()));
        }
        XQResultSequence xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"Hello world!", (String)xqs.getAtomicValue());
        xqpe.close();
        xqi.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindItem(new QName("v"), xqi);
            Assert.fail((String)"A-XQDC-1.8: Passing a closed XQItem or XQSequence object as argument must result in an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
    }

    public void testBindSequence() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQSequence xqs = this.xqc.createSequence((XQSequence)xqe.executeQuery("'Hello world!'"));
        xqe.close();
        xqs.beforeFirst();
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindSequence(new QName("v"), xqs);
            Assert.fail((String)"A-XQDC-1.1: bindSequence() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqs.beforeFirst();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindSequence(null, xqs);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqs.beforeFirst();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindSequence(new QName("foo"), xqs);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqs.beforeFirst();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindSequence(new QName("v"), xqs);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqs.beforeFirst();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindSequence(new QName("v"), xqs);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindSequence() failed with message: " + e.getMessage()));
        }
        XQResultSequence xqs2 = xqpe.executeQuery();
        xqs2.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"Hello world!", (String)xqs2.getAtomicValue());
        xqpe.close();
        xqs.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindSequence(new QName("v"), xqs);
            Assert.fail((String)"A-XQDC-1.8: Passing a closed XQItem or XQSequence object as argument must result in an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
    }

    public void testBindObject() throws XQException {
        XQResultSequence xqs;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindObject(new QName("v"), (Object)"Hello world!", null);
            Assert.fail((String)"A-XQDC-1.1: bindObject() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindObject(null, (Object)"Hello world!", null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindObject(new QName("v"), (Object)"Hello world!", this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindObject(new QName("v"), (Object)"123", this.xqc.createAtomicType(44));
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindObject(new QName("foo"), (Object)"Hello world!", this.xqc.createAtomicType(29));
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindObject(new QName("v"), (Object)"Hello world!", null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindObject(new QName("v"), (Object)"Hello world!", this.xqc.createAtomicType(29));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindObject() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"Hello world!", (String)xqs.getAtomicValue());
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindObject(new QName("v"), (Object)"Hello", this.xqc.createAtomicType(44));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindObject() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)1, (int)xqs.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)44, (int)xqs.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (Object)"Hello", (Object)xqs.getObject());
        xqpe.close();
    }

    public void testBindObject_AllTypes() throws Exception {
        boolean jdk14;
        String msg = "A-XQDC-4.1: bindObject implements casting rules of '14.2 Mapping a Java Data Type to an XQuery Data Type'";
        try {
            Class.forName("javax.xml.datatype.XMLGregorianCalendar");
            jdk14 = false;
        }
        catch (Exception e) {
            jdk14 = true;
        }
        XQExpression xqe = this.xqc.createExpression();
        xqe.bindObject(new QName("v"), (Object)true, null);
        XQResultSequence xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:boolean");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)new Byte(1), null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:byte");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)new Float(1.0f), null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:float");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)new Double(1.0), null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:double");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)new Integer(1), null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:int");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)new Long(1L), null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:long");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)new Short(1), null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:short");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)"Hello world!", null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:string");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)new BigDecimal("1"), null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:decimal");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)new BigInteger("1"), null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:integer");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        if (!jdk14) {
            XQExpression xqe_temp = this.xqc.createExpression();
            XQResultSequence xqs_temp = xqe_temp.executeQuery("xs:dayTimeDuration('PT5H'), xs:yearMonthDuration('P1M'), xs:date('2000-12-31'),xs:dateTime('2000-12-31T12:00:00'),xs:gDay('---11'),xs:gMonth('--11'),xs:gMonthDay('--01-01'),xs:gYear('2000'),xs:gYearMonth('2000-01'),xs:time('12:12:12')");
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:dayTimeDuration");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:yearMonthDuration");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:date");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:dateTime");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:gDay");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:gMonth");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:gMonthDay");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:gYear");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:gYearMonth");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqs_temp.next();
            xqe.bindObject(new QName("v"), xqs_temp.getObject(), null);
            xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:time");
            xqs.next();
            Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
            xqe_temp.close();
        }
        xqe.bindObject(new QName("v"), (Object)new QName("abc"), null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of xs:QName");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = document.createElement("e");
        document.appendChild(element);
        DocumentFragment documentFragment = document.createDocumentFragment();
        Attr attribute = document.createAttribute("a");
        Comment comment = document.createComment("comment");
        ProcessingInstruction pi = document.createProcessingInstruction("target", "data");
        Text text = document.createTextNode("text");
        xqe.bindObject(new QName("v"), (Object)document, null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of document-node()");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)documentFragment, null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of document-node()");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)element, null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of element()");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)attribute, null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of attribute()");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)comment, null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of comment()");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)pi, null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of processing-instruction()");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.bindObject(new QName("v"), (Object)text, null);
        xqs = xqe.executeQuery("declare variable $v external; $v instance of text()");
        xqs.next();
        Assert.assertTrue((String)msg, (boolean)xqs.getBoolean());
        xqe.close();
    }

    public void testBindBoolean() throws XQException {
        XQResultSequence xqs;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindBoolean(new QName("v"), true, null);
            Assert.fail((String)"A-XQDC-1.1: bindBoolean() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindBoolean(null, true, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindBoolean(new QName("v"), true, this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindBoolean(new QName("foo"), true, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindBoolean(new QName("v"), true, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindBoolean(new QName("v"), true, this.xqc.createAtomicType(10));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindBoolean() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"true", (String)xqs.getAtomicValue());
        xqpe.close();
        xqpe.close();
    }

    public void testBindByte() throws XQException {
        XQResultSequence xqs;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindByte(new QName("v"), (byte)1, null);
            Assert.fail((String)"A-XQDC-1.1: bindByte() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindByte(null, (byte)1, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindByte(new QName("v"), (byte)1, this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindByte(new QName("foo"), (byte)1, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:string external; $v");
        try {
            xqpe.bindByte(new QName("v"), (byte)1, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindByte(new QName("v"), (byte)1, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindByte() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"1", (String)xqs.getAtomicValue());
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindByte(new QName("v"), (byte)1, this.xqc.createAtomicType(13));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindByte() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)1, (int)xqs.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)13, (int)xqs.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"1", (String)xqs.getAtomicValue());
        xqpe.close();
    }

    public void testBindDouble() throws XQException {
        XQResultSequence xqs;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindDouble(new QName("v"), 1.0, null);
            Assert.fail((String)"A-XQDC-1.1: bindDouble() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDouble(null, 1.0, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDouble(new QName("v"), 1.0, this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDouble(new QName("foo"), 1.0, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:string external; $v");
        try {
            xqpe.bindDouble(new QName("v"), 1.0, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindDouble(new QName("v"), 1.0, this.xqc.createAtomicType(18));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindDouble() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)1, (int)xqs.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)18, (int)xqs.getItemType().getBaseType());
        Assert.assertTrue((String)"A-XQDC-1.7: Successful bindXXX.", (1.0 == xqs.getDouble() ? 1 : 0) != 0);
        xqpe.close();
    }

    public void testBindFloat() throws XQException {
        XQResultSequence xqs;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindFloat(new QName("v"), 1.0f, null);
            Assert.fail((String)"A-XQDC-1.1: bindFloat() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindFloat(null, 1.0f, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindFloat(new QName("v"), 1.0f, this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindFloat(new QName("foo"), 1.0f, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:string external; $v");
        try {
            xqpe.bindFloat(new QName("v"), 1.0f, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindFloat(new QName("v"), 1.0f, this.xqc.createAtomicType(20));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindFloat() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)1, (int)xqs.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)20, (int)xqs.getItemType().getBaseType());
        Assert.assertTrue((String)"A-XQDC-1.7: Successful bindXXX.", (1.0f == xqs.getFloat() ? 1 : 0) != 0);
        xqpe.close();
    }

    public void testBindInt() throws XQException {
        XQResultSequence xqs;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindInt(new QName("v"), 1, null);
            Assert.fail((String)"A-XQDC-1.1: bindInt() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindInt(null, 1, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindInt(new QName("v"), 1, this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindInt(new QName("v"), 128, this.xqc.createAtomicType(31));
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindInt(new QName("foo"), 1, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:string external; $v");
        try {
            xqpe.bindInt(new QName("v"), 1, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindInt(new QName("v"), 1, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindInt() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"1", (String)xqs.getAtomicValue());
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindInt(new QName("v"), 1, this.xqc.createAtomicType(13));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindInt() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)1, (int)xqs.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)13, (int)xqs.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"1", (String)xqs.getAtomicValue());
        xqpe.close();
    }

    public void testBindLong() throws XQException {
        XQResultSequence xqs;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindLong(new QName("v"), 1L, null);
            Assert.fail((String)"A-XQDC-1.1: bindLong() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindLong(null, 1L, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindLong(new QName("v"), 1L, this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindLong(new QName("v"), 128L, this.xqc.createAtomicType(31));
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindLong(new QName("foo"), 1L, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:string external; $v");
        try {
            xqpe.bindLong(new QName("v"), 1L, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindLong(new QName("v"), 1L, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindLong() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"1", (String)xqs.getAtomicValue());
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindLong(new QName("v"), 1L, this.xqc.createAtomicType(13));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindLong() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)1, (int)xqs.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)13, (int)xqs.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"1", (String)xqs.getAtomicValue());
        xqpe.close();
    }

    public void testBindNode() throws XQException, IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(new InputSource(new StringReader("<e>Hello world!</e>")));
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindNode(new QName("v"), (Node)document, null);
            Assert.fail((String)"A-XQDC-1.1: bindNode() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindNode(null, (Node)document, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindNode(new QName("v"), (Node)document, this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            XQResultSequence xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindNode(new QName("foo"), (Node)document, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:decimal external; $v");
        try {
            xqpe.bindNode(new QName("v"), (Node)document, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindNode(new QName("v"), (Node)document, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindNode() failed with message: " + e.getMessage()));
        }
        String result = xqpe.executeQuery().getSequenceAsString(null);
        Assert.assertTrue((String)("A-XQDC-1.7: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqpe.close();
    }

    public void testBindShort() throws XQException {
        XQResultSequence xqs;
        XQPreparedExpression xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        xqpe.close();
        try {
            xqpe.bindShort(new QName("v"), (short)1, null);
            Assert.fail((String)"A-XQDC-1.1: bindShort() throws an XQException when the dynamic context is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindShort(null, (short)1, null);
            Assert.fail((String)"A-XQDC-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        boolean bindFailed = false;
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindShort(new QName("v"), (short)1, this.xqc.createCommentType());
        }
        catch (XQException e) {
            bindFailed = true;
        }
        if (!bindFailed) {
            xqs = xqpe.executeQuery();
            xqs.next();
            if (xqs.getItemType().getItemKind() != 3) {
                Assert.fail((String)"A-XQDC-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
            }
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindShort(new QName("v"), (short)128, this.xqc.createAtomicType(31));
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindShort(new QName("foo"), (short)1, null);
            Assert.fail((String)"A-XQDC-1.5: The bound variable must be declared external in the prepared expression.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v as xs:string external; $v");
        try {
            xqpe.bindShort(new QName("v"), (short)1, null);
            xqpe.executeQuery().getSequenceAsString(null);
            Assert.fail((String)"A-XQDC-1.6: The dynamic type of the bound value is not compatible with the static type of the variable and must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindShort(new QName("v"), (short)1, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindShort() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"1", (String)xqs.getAtomicValue());
        xqpe.close();
        xqpe = this.xqc.prepareExpression("declare variable $v external; $v");
        try {
            xqpe.bindShort(new QName("v"), (short)1, this.xqc.createAtomicType(13));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDC-1.7: bindShort() failed with message: " + e.getMessage()));
        }
        xqs = xqpe.executeQuery();
        xqs.next();
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)1, (int)xqs.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (int)13, (int)xqs.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDC-1.7: Successful bindXXX.", (String)"1", (String)xqs.getAtomicValue());
        xqpe.close();
    }
}

