/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import junit.framework.Assert;

public class XQDataSourceTest
extends XQJTestCase {
    public void testGetConnection() throws XQException {
        try {
            XQConnection my_xqc = this.xqds.getConnection();
            my_xqc.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDS-1.1: Creating an XQConnection failed with message: " + e.getMessage()));
        }
    }

    public void testGetConnection_jdbc() throws XQException {
    }

    public void testGetConnection_uid_pwd() throws XQException {
        boolean testIt = true;
        String uid = null;
        String pwd = null;
        try {
            uid = this.xqds.getProperty("user");
            pwd = this.xqds.getProperty("password");
        }
        catch (XQException e) {
            testIt = false;
        }
        if (testIt) {
            try {
                XQConnection my_xqc = this.xqds.getConnection(uid, pwd);
                my_xqc.close();
            }
            catch (XQException e) {
                Assert.fail((String)("A-XQDS-3.1: Creating an XQConnection specifying a uid/pwd failed with message: " + e.getMessage()));
            }
        }
    }

    public void testGetLoginTimeout() throws XQException {
        try {
            this.xqds.getLoginTimeout();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDS-4.1: Retrieving the login timeout failed with message: " + e.getMessage()));
        }
    }

    public void testGetLogWriter() throws XQException {
        try {
            PrintWriter log = this.xqds.getLogWriter();
            Assert.assertNull((String)"A-XQDS-5.2: The default log writer is null", (Object)log);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDS-5.1: Retrieving the log writer failed with message: " + e.getMessage()));
        }
    }

    public void testGetSupportedPropertyNames() throws XQException {
        try {
            String[] propertyNames = this.xqds.getSupportedPropertyNames();
            Assert.assertNotNull((String)"A-XQDS-6.2: getSupportedPropertyNames returns a non null array of String objects", (Object)propertyNames);
        }
        catch (Exception e) {
            Assert.fail((String)("A-XQDS-6.1: Retrieving the supported property names failed with message: " + e.getMessage()));
        }
    }

    public void testSetProperty() throws XQException {
        try {
            this.xqds.setProperty(null, "foo");
            Assert.fail((String)"A-XQDS-7.1: setProperty() throws an XQException when a null value is specified for the name parameter.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQDS-7.1: setProperty() throws an XQException when a null value is specified for the name parameter.");
        }
        try {
            this.xqds.setProperty("the_property_that_not_known_to_any_implementation", "foo");
            Assert.fail((String)"A-XQDS-7.2: setProperty() throws an XQException when an invalid property name is specified.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQDS-7.2: setProperty() throws an XQException when an invalid property name is specified.");
        }
    }

    public void testGetProperty() throws XQException {
        try {
            this.xqds.getProperty(null);
            Assert.fail((String)"A-XQDS-8.1: getProperty() throws an XQException when a null value is specified for the name parameter.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQDS-8.1: getProperty() throws an XQException when a null value is specified for the name parameter.");
        }
        try {
            this.xqds.getProperty("the_property_that_not_known_to_any_implementation");
            Assert.fail((String)"A-XQDS-8.2: getProperty() throws an XQException when an invalid property name is specified.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQDS-8.2: getProperty() throws an XQException when an invalid property name is specified.");
        }
        String[] propertyNames = this.xqds.getSupportedPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            try {
                this.xqds.getProperty(propertyNames[i]);
                continue;
            }
            catch (XQException e) {
                Assert.fail((String)("A-XQDS-8.3: getProperty() failed for property '" + propertyNames[i] + "' with message: " + e.getMessage()));
            }
        }
    }

    public void testSetProperties() throws XQException {
        try {
            this.xqds.setProperties(null);
            Assert.fail((String)"A-XQDS-9.1: setProperties() throws an XQException when a null value is specified for the properties.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQDS-9.1: setProperties() throws an XQException when a null value is specified for the propertiesr.");
        }
        try {
            Properties p = new Properties();
            p.put("the_property_that_not_known_to_any_implementation", "foo");
            this.xqds.setProperties(p);
            Assert.fail((String)"A-XQDS-9.2: setProperties() throws an XQException when an invalid property name is specified.");
        }
        catch (XQException e) {
        }
        catch (Exception other_e) {
            Assert.fail((String)"A-XQDS-9.2: setProperties() throws an XQException when an invalid property name is specified.");
        }
    }

    public void testSetLoginTimeout() throws XQException {
        try {
            int timeout = this.xqds.getLoginTimeout();
            this.xqds.setLoginTimeout(timeout);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDS-10.1: setting the login timeout failed with message: " + e.getMessage()));
        }
    }

    public void testSetLogWriter() throws XQException {
        try {
            this.xqds.setLogWriter(new PrintWriter(new StringWriter()));
            PrintWriter log = this.xqds.getLogWriter();
            Assert.assertNotNull((String)"A-XQDS-11.1: Successfully set the log writer.", (Object)log);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDS-11.1: Setting the log writer failed with message: " + e.getMessage()));
        }
    }
}

