/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQSequenceType;
import junit.framework.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XQDataFactoryTest
extends XQJTestCase {
    public void testCreateItemFromAtomicValue() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromAtomicValue("Hello world!", null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromAtomicValue() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromAtomicValue(null, null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e2) {
            Object e2 = null;
        }
        try {
            this.xqc.createItemFromAtomicValue("Hello world!", this.xqc.createCommentType());
            Assert.fail((String)"A-XQDF-1.3: An invalid type of the value to be bound must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromAtomicValue("Hello world!", this.xqc.createAtomicType(17));
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromAtomicValue("Hello world!", this.xqc.createAtomicType(29));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromAtomicValue() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (String)"Hello world!", (String)xqi.getAtomicValue());
    }

    public void testCreateItemFromString() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromString("Hello world!", null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromString() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromString(null, null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromString("Hello world!", this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        try {
            this.xqc.createItemFromString("123", this.xqc.createAtomicType(44));
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromString("Hello world!", this.xqc.createAtomicType(29));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromString() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (String)"Hello world!", (String)xqi.getAtomicValue());
        try {
            xqi = this.xqc.createItemFromString("Hello", this.xqc.createAtomicType(44));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromString() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)1, (int)xqi.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)44, (int)xqi.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (Object)"Hello", (Object)xqi.getObject());
    }

    public void testCreateItemFromDocument_String() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromDocument("<e>Hello world!</e>", null, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromDocument() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromDocument((String)null, null, null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromDocument("<e>Hello world!</e>", null, this.xqc.createAtomicType(10));
            if (xqitem.getItemType().getItemKind() != 1) {
                failed = true;
            }
            if (xqitem.getItemType().getBaseType() != 10) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        try {
            this.xqc.createItemFromDocument("<e>", null, null);
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromDocument("<e>Hello world!</e>", null, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromDocument() failed with message: " + e.getMessage()));
        }
        String result = xqi.getItemAsString(null);
        Assert.assertTrue((String)("A-XQDF-1.5: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
    }

    public void testCreateItemFromDocument_Reader() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromDocument((Reader)new StringReader("<e>Hello world!</e>"), null, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromDocument() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromDocument((Reader)null, null, null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromDocument((Reader)new StringReader("<e>Hello world!</e>"), null, this.xqc.createAtomicType(10));
            if (xqitem.getItemType().getItemKind() != 1) {
                failed = true;
            }
            if (xqitem.getItemType().getBaseType() != 10) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        try {
            this.xqc.createItemFromDocument((Reader)new StringReader("<e>"), null, null);
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromDocument((Reader)new StringReader("<e>Hello world!</e>"), null, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromDocument() failed with message: " + e.getMessage()));
        }
        String result = xqi.getItemAsString(null);
        Assert.assertTrue((String)("A-XQDF-1.5: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
    }

    public void testCreateItemFromDocument_InputStream() throws XQException, UnsupportedEncodingException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromDocument((InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>Hello world!</e>".getBytes("UTF-8")), null, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromDocument() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromDocument((InputStream)null, null, null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromDocument((InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>Hello world!</e>".getBytes("UTF-8")), null, this.xqc.createAtomicType(10));
            if (xqitem.getItemType().getItemKind() != 1) {
                failed = true;
            }
            if (xqitem.getItemType().getBaseType() != 10) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        try {
            this.xqc.createItemFromDocument((InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>".getBytes("UTF-8")), null, null);
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromDocument((InputStream)new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><e>Hello world!</e>".getBytes("UTF-8")), null, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromDocument() failed with message: " + e.getMessage()));
        }
        String result = xqi.getItemAsString(null);
        Assert.assertTrue((String)("A-XQDF-1.5: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
    }

    public void testCreateItemFromDocument_XMLStreamReader() throws XQException {
        XQExpression xqe = this.xqc.createExpression();
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromDocument(xqe.executeQuery("<e>Hello world!</e>").getSequenceAsStream(), null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromDocument() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromDocument((XMLStreamReader)null, null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromDocument(xqe.executeQuery("<e>Hello world!</e>").getSequenceAsStream(), this.xqc.createAtomicType(10));
            if (xqitem.getItemType().getItemKind() != 1) {
                failed = true;
            }
            if (xqitem.getItemType().getBaseType() != 10) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromDocument(xqe.executeQuery("<e>Hello world!</e>").getSequenceAsStream(), null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromDocument() failed with message: " + e.getMessage()));
        }
        String result = xqi.getItemAsString(null);
        Assert.assertTrue((String)("A-XQDF-1.5: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
        xqe.close();
    }

    public void testCreateItemFromDocument_Source() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromDocument((Source)new StreamSource(new StringReader("<e>Hello world!</e>")), null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromDocument() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromDocument((Source)null, null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromDocument((Source)new StreamSource(new StringReader("<e>Hello world!</e>")), this.xqc.createAtomicType(10));
            if (xqitem.getItemType().getItemKind() != 1) {
                failed = true;
            }
            if (xqitem.getItemType().getBaseType() != 10) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        try {
            this.xqc.createItemFromDocument((Source)new StreamSource(new StringReader("<e>")), null);
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromDocument((Source)new StreamSource(new StringReader("<e>Hello world!</e>")), null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromDocument() failed with message: " + e.getMessage()));
        }
        String result = xqi.getItemAsString(null);
        Assert.assertTrue((String)("A-XQDF-1.5: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
    }

    public void testCreateItemFromObject() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromObject((Object)"Hello world!", null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromObject() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromObject(null, null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromObject((Object)"Hello world!", this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        try {
            this.xqc.createItemFromObject((Object)"123", this.xqc.createAtomicType(44));
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromObject((Object)"Hello world!", this.xqc.createAtomicType(29));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromObject() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful bindXXX.", (String)"Hello world!", (String)xqi.getAtomicValue());
        try {
            xqi = this.xqc.createItemFromObject((Object)"Hello", this.xqc.createAtomicType(44));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromObject() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)1, (int)xqi.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)44, (int)xqi.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (Object)"Hello", (Object)xqi.getObject());
    }

    public void testCreateItemFromBoolean() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromBoolean(true, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromBoolean() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromBoolean(true, this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromBoolean(true, this.xqc.createAtomicType(10));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromBoolean() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (String)"true", (String)xqi.getAtomicValue());
    }

    public void testCreateItemFromByte() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromByte((byte)1, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromByte() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromByte((byte)1, this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromByte((byte)1, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromByte() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (String)"1", (String)xqi.getAtomicValue());
        try {
            xqi = this.xqc.createItemFromByte((byte)1, this.xqc.createAtomicType(13));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromByte() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)1, (int)xqi.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)13, (int)xqi.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (String)"1", (String)xqi.getAtomicValue());
    }

    public void testCreateItemFromDouble() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromDouble(1.0, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromDouble() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromDouble(1.0, this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromDouble(1.0, this.xqc.createAtomicType(18));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromDouble() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)1, (int)xqi.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)18, (int)xqi.getItemType().getBaseType());
        Assert.assertTrue((String)"A-XQDF-1.5: Successful createItemFromXXX.", (1.0 == xqi.getDouble() ? 1 : 0) != 0);
    }

    public void testCreateItemFromFloat() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromFloat(1.0f, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromFloat() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromFloat(1.0f, this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromFloat(1.0f, this.xqc.createAtomicType(20));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromDouble() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)1, (int)xqi.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)20, (int)xqi.getItemType().getBaseType());
        Assert.assertTrue((String)"A-XQDF-1.5: Successful createItemFromXXX.", (1.0 == (double)xqi.getFloat() ? 1 : 0) != 0);
    }

    public void testCreateItemFromInt() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromInt(1, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromInt() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromInt(1, this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        try {
            this.xqc.createItemFromInt(128, this.xqc.createAtomicType(31));
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromInt(1, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromInt() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful bindXXX.", (String)"1", (String)xqi.getAtomicValue());
        try {
            xqi = this.xqc.createItemFromInt(1, this.xqc.createAtomicType(13));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromInt() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)1, (int)xqi.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)13, (int)xqi.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (String)"1", (String)xqi.getAtomicValue());
    }

    public void testCreateItemFromLong() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromLong(1L, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromLong() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromLong(1L, this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        try {
            this.xqc.createItemFromLong(128L, this.xqc.createAtomicType(31));
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromLong(1L, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromLong() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful bindXXX.", (String)"1", (String)xqi.getAtomicValue());
        try {
            xqi = this.xqc.createItemFromLong(1L, this.xqc.createAtomicType(13));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromLong() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)1, (int)xqi.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)13, (int)xqi.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (String)"1", (String)xqi.getAtomicValue());
    }

    public void testCreateItemFromNode() throws XQException, IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(new InputSource(new StringReader("<e>Hello world!</e>")));
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromNode((Node)document, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromNode() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItemFromNode(null, null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromNode((Node)document, this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromNode((Node)document, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromNode() failed with message: " + e.getMessage()));
        }
        String result = xqi.getItemAsString(null);
        Assert.assertTrue((String)("A-XQDF-1.5: Expects serialized result contains '<e>Hello world!</e>', but it is '" + result + "'"), (result.indexOf("<e>Hello world!</e>") != -1 ? 1 : 0) != 0);
    }

    public void testCreateItemFromShort() throws XQException {
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemFromShort((short)1, null);
            Assert.fail((String)"A-XQDF-1.1: createItemFromShort() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        boolean failed = false;
        try {
            XQItem xqitem = this.xqc.createItemFromShort((short)1, this.xqc.createCommentType());
            if (xqitem.getItemType().getItemKind() != 3) {
                failed = true;
            }
        }
        catch (XQException e) {
            // empty catch block
        }
        if (failed) {
            Assert.fail((String)"A-XQDF-1.3: The conversion is subject to the following constraints. Either it fails with an XQException, either it is successful in which case it must result in an instance of XDT.");
        }
        try {
            this.xqc.createItemFromShort((short)128, this.xqc.createAtomicType(31));
            Assert.fail((String)"A-XQDF-1.4: The conversion of the value to an XDM instance must fail.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqi = null;
        try {
            xqi = this.xqc.createItemFromShort((short)1, null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromShort() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful bindXXX.", (String)"1", (String)xqi.getAtomicValue());
        try {
            xqi = this.xqc.createItemFromShort((short)1, this.xqc.createAtomicType(13));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItemFromLong() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)1, (int)xqi.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (int)13, (int)xqi.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItemFromXXX.", (String)"1", (String)xqi.getAtomicValue());
    }

    public void testCreateItem() throws XQException {
        XQItem xqi = this.xqc.createItemFromString("Hello world!", null);
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItem(xqi);
            Assert.fail((String)"A-XQDF-1.1: createItem() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createItem(null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQItem xqresult = null;
        try {
            xqresult = this.xqc.createItem(xqi);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createItem() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-1.5: Successful createItem().", (String)"Hello world!", (String)xqresult.getAtomicValue());
        xqi.close();
        try {
            this.xqc.createItem(xqi);
            Assert.fail((String)"A-XQDF-1.6: Passing a closed XQItem or XQSequence object as argument msut result in an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
    }

    public void testCreateSequence_FromSequence() throws XQException {
        XQPreparedExpression xqpe = this.xqc.prepareExpression("'Hello world!'");
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        XQResultSequence xqs = xqpe.executeQuery();
        try {
            xqdf.createSequence((XQSequence)xqs);
            Assert.fail((String)"A-XQDF-1.1: createSequence() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqs.close();
        try {
            this.xqc.createSequence((XQSequence)null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQSequence xqsresult = null;
        xqs = xqpe.executeQuery();
        try {
            xqsresult = this.xqc.createSequence((XQSequence)xqs);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createSequence() failed with message: " + e.getMessage()));
        }
        String result = xqsresult.getSequenceAsString(null);
        Assert.assertTrue((String)("A-XQDF-1.5: Expects serialized result contains 'Hello world!', but it is '" + result + "'"), (result.indexOf("Hello world!") != -1 ? 1 : 0) != 0);
        xqs.close();
        try {
            this.xqc.createSequence((XQSequence)xqs);
            Assert.fail((String)"A-XQDF-1.6: Passing a closed XQItem or XQSequence object as argument msut result in an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        xqpe.close();
    }

    public void testCreateSequence_FromIterator() throws XQException {
        LinkedList<String> list = new LinkedList<String>();
        list.add("Hello world!");
        list.add((String)this.xqc.createItemFromString("Hello world!", null));
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createSequence(list.iterator());
            Assert.fail((String)"A-XQDF-1.1: createSequence() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createSequence((Iterator)null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQSequence xqsresult = null;
        try {
            xqsresult = this.xqc.createSequence(list.iterator());
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-1.5: createSequence() failed with message: " + e.getMessage()));
        }
        String result = xqsresult.getSequenceAsString(null);
        Assert.assertTrue((String)("A-XQDF-1.5: Expects serialized result contains 'Hello world!', but it is '" + result + "'"), (result.indexOf("Hello world!") != -1 ? 1 : 0) != 0);
    }

    public void testCreateAtomicType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createAtomicType(5);
            Assert.fail((String)"A-XQDF-1.1: createAtomicType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createAtomicType(1);
            Assert.fail((String)"A-XQDF-2.1: createAtomicType() detects invalid xqbasetype arguments.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createAtomicType(5);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-2.2: createAtomicType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (int)1, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (int)5, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (int)2, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (String)"untypedAtomic", (String)xqtype.getTypeName().getLocalPart());
        try {
            xqtype = this.xqc.createAtomicType(5, new QName("http://www.w3.org/2001/XMLSchema", "untypedAtomic"), null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-2.2: createAtomicType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (int)1, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (int)5, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (int)2, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQDF-2.2: Successful createAtomicType.", (String)"untypedAtomic", (String)xqtype.getTypeName().getLocalPart());
    }

    public void testCreateAttributeType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createAttributeType(new QName("a"), 13);
            Assert.fail((String)"A-XQDF-1.1: createAttributeType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createAttributeType(new QName("a"), 1);
            Assert.fail((String)"A-XQDF-3.1: createAtomicType() detects invalid xqbasetype arguments.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createAttributeType(new QName("a"), 13);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-3.2: createAttributeType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (int)2, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (int)13, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (int)2, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (Object)new QName("a"), (Object)xqtype.getNodeName());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (String)"integer", (String)xqtype.getTypeName().getLocalPart());
        try {
            xqtype = this.xqc.createAttributeType(new QName("a"), 13, new QName("http://www.w3.org/2001/XMLSchema", "integer"), null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-3.2: createAtomicType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (int)2, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (int)13, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (int)2, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (Object)new QName("a"), (Object)xqtype.getNodeName());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQDF-3.2: Successful createAttributeType.", (String)"integer", (String)xqtype.getTypeName().getLocalPart());
    }

    public void testCreateSchemaAttributeType() throws XQException {
    }

    public void testCreateCommentType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createCommentType();
            Assert.fail((String)"A-XQDF-1.1: createCommentType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createCommentType();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-4.1: createCommentType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-4.1: Successful createCommentType.", (int)3, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-4.1: Successful createCommentType.", (int)2, (int)xqtype.getItemOccurrence());
    }

    public void testCreateDocumentElementType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createDocumentElementType(this.xqc.createElementType(new QName("e"), 1));
            Assert.fail((String)"A-XQDF-1.1: createDocumentElementType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createDocumentElementType(this.xqc.createCommentType());
            Assert.fail((String)"A-XQDF-5.1: createDocumentElementType() detects invalid elementType argument.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createDocumentElementType(null);
            Assert.fail((String)"A-XQDF-1.2: null argument is invalid and throws an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createDocumentElementType(this.xqc.createElementType(new QName("e"), 13));
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-5.2: createDocumentElementType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-5.2: Successful createDocumentElementType.", (int)5, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-5.2: Successful createDocumentElementType.", (int)13, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQDF-5.2: Successful createDocumentElementType.", (int)2, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQDF-5.2: Successful createDocumentElementType.", (Object)new QName("e"), (Object)xqtype.getNodeName());
        Assert.assertEquals((String)"A-XQDF-5.2: Successful createDocumentElementType.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQDF-5.2: Successful createDocumentElementType.", (String)"integer", (String)xqtype.getTypeName().getLocalPart());
    }

    public void testCreateDocumentSchemaElementType() throws XQException {
    }

    public void testDocumentType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createDocumentType();
            Assert.fail((String)"A-XQDF-1.1: createDocumentType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createDocumentType();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-6.1: createDocumentType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-6.1: Successful createDocumentType.", (int)4, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-6.1: Successful createDocumentType.", (int)2, (int)xqtype.getItemOccurrence());
    }

    public void testCreateElementType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createElementType(new QName("a"), 13);
            Assert.fail((String)"A-XQDF-1.1: createElementType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createElementType(new QName("a"), 13);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-7.1: createElementType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (int)7, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (int)13, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (int)2, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (Object)new QName("a"), (Object)xqtype.getNodeName());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (String)"integer", (String)xqtype.getTypeName().getLocalPart());
        try {
            xqtype = this.xqc.createElementType(new QName("a"), 13, new QName("http://www.w3.org/2001/XMLSchema", "integer"), null, true);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-7.1: createElementType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (int)7, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (int)13, (int)xqtype.getBaseType());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (int)2, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (Object)new QName("a"), (Object)xqtype.getNodeName());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getTypeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQDF-7.1: Successful createElementType.", (String)"integer", (String)xqtype.getTypeName().getLocalPart());
    }

    public void testCreateSchemaElementType() throws XQException {
    }

    public void testCreateItemType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createItemType();
            Assert.fail((String)"A-XQDF-1.1: createItemType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createItemType();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-8.1: createItemType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-8.1: Successful createItemType.", (int)8, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-8.1: Successful createItemType.", (int)2, (int)xqtype.getItemOccurrence());
    }

    public void testCreateNodeType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createNodeType();
            Assert.fail((String)"A-XQDF-1.1: createNodeType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createNodeType();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-9.1: createNodeType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-9.1: Successful createNodeType.", (int)9, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-9.1: Successful createNodeType.", (int)2, (int)xqtype.getItemOccurrence());
    }

    public void testCreateProcessingInstructionType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createProcessingInstructionType(null);
            Assert.fail((String)"A-XQDF-1.1: createProcessingInstructionType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createProcessingInstructionType(null);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-9.1: createProcessingInstructionType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-9.1: Successful createProcessingInstructionType.", (int)10, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-9.1: Successful createProcessingInstructionType.", (String)null, (String)xqtype.getPIName());
        Assert.assertEquals((String)"A-XQDF-9.1: Successful createProcessingInstructionType.", (int)2, (int)xqtype.getItemOccurrence());
        try {
            xqtype = this.xqc.createProcessingInstructionType("Hello");
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-9.1: createProcessingInstructionType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-9.1: Successful createProcessingInstructionType.", (int)10, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-9.1: Successful createProcessingInstructionType.", (String)"Hello", (String)xqtype.getPIName());
        Assert.assertEquals((String)"A-XQDF-9.1: Successful createProcessingInstructionType.", (int)2, (int)xqtype.getItemOccurrence());
    }

    public void testCreateTextType() throws XQException {
        XQItemType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createTextType();
            Assert.fail((String)"A-XQDF-1.1: createTextType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createTextType();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-10.1: createTextType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-10.1: Successful createTextType.", (int)11, (int)xqtype.getItemKind());
        Assert.assertEquals((String)"A-XQDF-10.1: Successful createTextType.", (int)2, (int)xqtype.getItemOccurrence());
    }

    public void testCreateSequenceType() throws XQException {
        XQSequenceType xqtype = null;
        XQConnection xqdf = this.xqds.getConnection();
        xqdf.close();
        try {
            xqdf.createSequenceType(this.xqc.createElementType(new QName("e"), 1), 2);
            Assert.fail((String)"A-XQDF-1.1: createSequenceType() throws an XQException when the data factory is in closed state.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createSequenceType(this.xqc.createElementType(new QName("e"), 1), 5);
            Assert.fail((String)"A-XQDF-11.1: item type parameter of createSequenceType() must be null with occurrence indicator empty.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createSequenceType(null, 2);
            Assert.fail((String)"A-XQDF-11.2: item type parameter of createSequenceType() must be not null with occurrence indicator different from empty.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createSequenceType(this.xqc.createElementType(new QName("e"), 1), 777);
            Assert.fail((String)"A-XQDF-11.3: createSequenceType() detects invalid occurrence indicator.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqtype = this.xqc.createSequenceType(this.xqc.createElementType(new QName("e"), 13), 4);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQDF-11.4: createSequenceType() failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQDF-11.4: Successful createSequenceType.", (int)7, (int)xqtype.getItemType().getItemKind());
        Assert.assertEquals((String)"A-XQDF-11.4: Successful createSequenceType.", (int)13, (int)xqtype.getItemType().getBaseType());
        Assert.assertEquals((String)"A-XQDF-11.4: Successful createSequenceType.", (int)4, (int)xqtype.getItemOccurrence());
        Assert.assertEquals((String)"A-XQDF-11.4: Successful createSequenceType.", (Object)new QName("e"), (Object)xqtype.getItemType().getNodeName());
        Assert.assertEquals((String)"A-XQDF-11.4: Successful createSequenceType.", (String)"http://www.w3.org/2001/XMLSchema", (String)xqtype.getItemType().getTypeName().getNamespaceURI());
        Assert.assertEquals((String)"A-XQDF-11.4: Successful createSequenceType.", (String)"integer", (String)xqtype.getItemType().getTypeName().getLocalPart());
    }
}

