/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQStaticContext;
import junit.framework.Assert;

public class XQConnectionTest
extends XQJTestCase {
    public void testClose() throws XQException {
        XQConnection my_xqc = this.xqds.getConnection();
        XQExpression xqe = my_xqc.createExpression();
        XQResultSequence xqs = xqe.executeQuery("1,2,3");
        try {
            my_xqc.close();
            my_xqc.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-1.1: closing connection failed with message: " + e.getMessage()));
        }
        Assert.assertEquals((String)"A-XQC-1.2: closing a connection, closes dependent objects", (boolean)true, (boolean)xqe.isClosed());
        Assert.assertEquals((String)"A-XQC-1.2: closing a connection, closes dependent objects", (boolean)true, (boolean)xqs.isClosed());
    }

    public void testSetAutoCommit() throws XQException {
        if (this.xqc.getMetaData().isTransactionSupported()) {
            XQConnection my_xqc = this.xqds.getConnection();
            my_xqc.close();
            try {
                my_xqc.setAutoCommit(true);
                Assert.fail((String)"A-XQC-2.1: closed connection supports setAutoCommit()");
            }
            catch (XQException e) {
                // empty catch block
            }
            try {
                this.xqc.setAutoCommit(false);
                this.xqc.setAutoCommit(true);
            }
            catch (XQException e) {
                Assert.fail((String)("A-XQC-2.2: changing auto commit mode failed with message: " + e.getMessage()));
            }
        }
    }

    public void testGetAutoCommit() throws XQException {
        if (this.xqc.getMetaData().isTransactionSupported()) {
            XQConnection my_xqc = this.xqds.getConnection();
            my_xqc.close();
            try {
                my_xqc.getAutoCommit();
                Assert.fail((String)"A-XQC-3.1: closed connection supports getAutoCommit()");
            }
            catch (XQException e) {
                // empty catch block
            }
            boolean mode = false;
            try {
                mode = this.xqc.getAutoCommit();
            }
            catch (XQException e) {
                Assert.fail((String)("A-XQC-3.2: getAutoCommit() failed with message: " + e.getMessage()));
            }
            Assert.assertTrue((String)"A-XQC-3.2: The default auto commit mode is true.", (boolean)mode);
            mode = true;
            try {
                this.xqc.setAutoCommit(false);
                mode = this.xqc.getAutoCommit();
            }
            catch (XQException e) {
                Assert.fail((String)("A-XQC-3.3: Retrieve the auto commit mode failed with message: " + e.getMessage()));
            }
            Assert.assertFalse((String)"A-XQC-3.3: Successfully retrieve the auto commit mode.", (boolean)mode);
        }
    }

    public void testCommit() throws XQException {
        if (this.xqc.getMetaData().isTransactionSupported()) {
            XQConnection my_xqc = this.xqds.getConnection();
            my_xqc.close();
            try {
                my_xqc.commit();
                Assert.fail((String)"A-XQC-4.1: closed connection supports commit()");
            }
            catch (XQException e) {
                // empty catch block
            }
            try {
                this.xqc.commit();
                Assert.fail((String)"A-XQC-4.2: commit() on a connection in auto commit mode must fail");
            }
            catch (XQException e) {
                // empty catch block
            }
            try {
                this.xqc.setAutoCommit(false);
                this.xqc.commit();
            }
            catch (XQException e) {
                Assert.fail((String)("A-XQC-4.3: commit() failed with message: " + e.getMessage()));
            }
        }
    }

    public void testCreateExpression() throws XQException {
        XQExpression xqe;
        XQConnection my_xqc = this.xqds.getConnection();
        my_xqc.close();
        try {
            my_xqc.createExpression();
            Assert.fail((String)"A-XQC-5.1: closed connection supports creating expressions");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqe = this.xqc.createExpression();
            xqe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-5.2: creating an expression failed with message: " + e.getMessage()));
        }
        try {
            XQStaticContext xqsc = this.xqc.getStaticContext();
            xqsc.declareNamespace("foo", "http://www.foo1.com");
            this.xqc.setStaticContext(xqsc);
            xqe = this.xqc.createExpression();
            xqe.executeQuery("<foo:e/>");
            xqe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-5.3: Failed to copy the default static context with message: " + e.getMessage()));
        }
    }

    public void testCreateExpression_XQStaticContext() throws XQException {
        XQExpression xqe;
        XQConnection my_xqc = this.xqds.getConnection();
        XQStaticContext my_xqsc = my_xqc.getStaticContext();
        my_xqc.close();
        try {
            my_xqc.createExpression(my_xqsc);
            Assert.fail((String)"A-XQC-5.1: closed connection supports creating expressions");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.createExpression(null);
            Assert.fail((String)"A-XQC-5.5: createExpression() with a null XQStaticContext must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqe = this.xqc.createExpression(xqsc);
            xqe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-5.2: creating an expression failed with message: " + e.getMessage()));
        }
        try {
            xqsc.declareNamespace("foo", "http://www.foo7.com");
            xqe = this.xqc.createExpression(xqsc);
            xqe.executeQuery("<foo:e/>");
            xqe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-5.4: Properties of the explicitly specified static context are used- failed with message: " + e.getMessage()));
        }
    }

    public void testGetMetaData() throws XQException {
        XQConnection my_xqc = this.xqds.getConnection();
        my_xqc.close();
        try {
            my_xqc.getMetaData();
            Assert.fail((String)"A-XQC-6.1: closed connection supports getting meta data");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.getMetaData();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-6.2: getting the meta data failed with message: " + e.getMessage()));
        }
    }

    public void testIsClosed() throws XQException {
        XQConnection my_xqc = this.xqds.getConnection();
        Assert.assertEquals((String)"A-XQC-7.1: isClosed() on open connection", (boolean)false, (boolean)my_xqc.isClosed());
        my_xqc.close();
        Assert.assertEquals((String)"A-XQC-7.2: isClosed() on closed connection", (boolean)true, (boolean)my_xqc.isClosed());
    }

    public void testPrepareExpression() throws XQException {
        XQPreparedExpression xqpe;
        XQConnection my_xqc = this.xqds.getConnection();
        my_xqc.close();
        try {
            my_xqc.prepareExpression("'Hello world!'");
            Assert.fail((String)"A-XQC-8.1: closed connection supports preparing expressions");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression("'Hello world!");
            xqpe.close();
            Assert.fail((String)"A-XQC-8.7: prepareExpression() with invalid XQuery expression must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((String)null);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.6: prepareExpression() with a null xquery argument must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression("'Hello world!'");
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.2: preparing an expression failed with message: " + e.getMessage()));
        }
        try {
            XQStaticContext xqsc = this.xqc.getStaticContext();
            xqsc.declareNamespace("foo", "http://www.foo2.com");
            this.xqc.setStaticContext(xqsc);
            xqpe = this.xqc.prepareExpression("<foo:e/>");
            xqpe.executeQuery();
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.3: Failed to copy the default static context with message: " + e.getMessage()));
        }
    }

    public void testPrepareExpression_XQStaticContext() throws XQException {
        XQPreparedExpression xqpe;
        XQConnection my_xqc = this.xqds.getConnection();
        XQStaticContext my_xqsc = my_xqc.getStaticContext();
        my_xqc.close();
        try {
            my_xqc.prepareExpression("'Hello world!'", my_xqsc);
            Assert.fail((String)"A-XQC-8.1: closed connection supports preparing expressions");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqpe = this.xqc.prepareExpression("'Hello world!", xqsc);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.7: prepareExpression() with invalid XQuery expression must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression("'Hello world!'", (XQStaticContext)null);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.5: prepareExpression() with a null XQStaticContext must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((String)null, xqsc);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.6: prepareExpression() with a null xquery argument must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression("'Hello world!'", xqsc);
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.2: preparing an expression failed with message: " + e.getMessage()));
        }
        try {
            xqsc.declareNamespace("foo", "http://www.foo3.com");
            xqpe = this.xqc.prepareExpression("<foo:e/>");
            xqpe.executeQuery();
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.4: Properties of the explicitly specified static context are used - failed with message: " + e.getMessage()));
        }
    }

    public void testPrepareExpression_Reader() throws XQException {
        XQPreparedExpression xqpe;
        XQConnection my_xqc = this.xqds.getConnection();
        my_xqc.close();
        try {
            my_xqc.prepareExpression((Reader)new StringReader("'Hello world!'"));
            Assert.fail((String)"A-XQC-8.1: closed connection supports preparing expressions");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((Reader)new StringReader("'Hello world!"));
            xqpe.close();
            Assert.fail((String)"A-XQC-8.7: prepareExpression() with invalid XQuery expression must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((Reader)null);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.6: prepareExpression() with a null xquery argument must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((Reader)new StringReader("'Hello world!'"));
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.2: preparing an expression failed with message: " + e.getMessage()));
        }
        try {
            XQStaticContext xqsc = this.xqc.getStaticContext();
            xqsc.declareNamespace("foo", "http://www.foo8.com");
            this.xqc.setStaticContext(xqsc);
            xqpe = this.xqc.prepareExpression((Reader)new StringReader("<foo:e/>"));
            xqpe.executeQuery();
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.3: Failed to copy the default static context with message: " + e.getMessage()));
        }
    }

    public void testPrepareExpression_Reader_XQStaticContext() throws XQException {
        XQPreparedExpression xqpe;
        XQConnection my_xqc = this.xqds.getConnection();
        XQStaticContext my_xqsc = my_xqc.getStaticContext();
        my_xqc.close();
        try {
            my_xqc.prepareExpression((Reader)new StringReader("'Hello world!'"), my_xqsc);
            Assert.fail((String)"A-XQC-8.1: closed connection supports preparing expressions");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqpe = this.xqc.prepareExpression((Reader)new StringReader("'Hello world!"), xqsc);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.7: prepareExpression() with invalid XQuery expression must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((Reader)new StringReader("'Hello world!'"), (XQStaticContext)null);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.5: prepareExpression() with a null XQStaticContext must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((Reader)null, xqsc);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.6: prepareExpression() with a null xquery argument must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((Reader)new StringReader("'Hello world!'"), xqsc);
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.2: preparing an expression failed with message: " + e.getMessage()));
        }
        try {
            xqsc.declareNamespace("foo", "http://www.foo4.com");
            xqpe = this.xqc.prepareExpression((Reader)new StringReader("<foo:e/>"), xqsc);
            xqpe.executeQuery();
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.4: Properties of the explicitly specified static context are used - failed with message: " + e.getMessage()));
        }
    }

    public void testPrepareExpression_InputStream() throws XQException, UnsupportedEncodingException {
        XQPreparedExpression xqpe;
        XQConnection my_xqc = this.xqds.getConnection();
        my_xqc.close();
        try {
            my_xqc.prepareExpression((InputStream)new ByteArrayInputStream("'Hello world!'".getBytes("UTF-8")));
            Assert.fail((String)"A-XQC-8.1: closed connection supports preparing expressions");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((InputStream)new ByteArrayInputStream("'Hello world!".getBytes("UTF-8")));
            xqpe.close();
            Assert.fail((String)"A-XQC-8.7: prepareExpression() with invalid XQuery expression must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((InputStream)null);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.6: prepareExpression() with a null xquery argument must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((InputStream)new ByteArrayInputStream("'Hello world!'".getBytes("UTF-8")));
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.2: preparing an expression failed with message: " + e.getMessage()));
        }
        try {
            XQStaticContext xqsc = this.xqc.getStaticContext();
            xqsc.declareNamespace("foo", "http://www.foo5.com");
            this.xqc.setStaticContext(xqsc);
            xqpe = this.xqc.prepareExpression((InputStream)new ByteArrayInputStream("<foo:e/>".getBytes("UTF-8")));
            xqpe.executeQuery();
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.3: Failed to copy the default static context with message: " + e.getMessage()));
        }
    }

    public void testPrepareExpression_InputStream_XQStaticContext() throws XQException, UnsupportedEncodingException {
        XQPreparedExpression xqpe;
        XQConnection my_xqc = this.xqds.getConnection();
        XQStaticContext my_xqsc = my_xqc.getStaticContext();
        my_xqc.close();
        try {
            my_xqc.prepareExpression((InputStream)new ByteArrayInputStream("'Hello world!'".getBytes("UTF-8")), my_xqsc);
            Assert.fail((String)"A-XQC-8.1: closed connection supports preparing expressions");
        }
        catch (XQException e) {
            // empty catch block
        }
        XQStaticContext xqsc = this.xqc.getStaticContext();
        try {
            xqpe = this.xqc.prepareExpression((InputStream)new ByteArrayInputStream("'Hello world!".getBytes("UTF-8")), xqsc);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.7: prepareExpression() with invalid XQuery expression must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((InputStream)new ByteArrayInputStream("'Hello world!'".getBytes("UTF-8")), (XQStaticContext)null);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.5: prepareExpression() with a null XQStaticContext must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((InputStream)null, xqsc);
            xqpe.close();
            Assert.fail((String)"A-XQC-8.6: prepareExpression() with a null xquery argument must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            xqpe = this.xqc.prepareExpression((InputStream)new ByteArrayInputStream("'Hello world!'".getBytes("UTF-8")), xqsc);
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.2: preparing an expression failed with message: " + e.getMessage()));
        }
        try {
            xqsc.declareNamespace("foo", "http://www.foo6.com");
            xqpe = this.xqc.prepareExpression((InputStream)new ByteArrayInputStream("<foo:e/>".getBytes("UTF-8")), xqsc);
            xqpe.executeQuery();
            xqpe.close();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-8.4: Properties of the explicitly specified static context are used - failed with message: " + e.getMessage()));
        }
    }

    public void testRollback() throws XQException {
        if (this.xqc.getMetaData().isTransactionSupported()) {
            XQConnection my_xqc = this.xqds.getConnection();
            my_xqc.close();
            try {
                my_xqc.rollback();
                Assert.fail((String)"A-XQC-9.1: closed connection supports rollback()");
            }
            catch (XQException e) {
                // empty catch block
            }
            try {
                this.xqc.rollback();
                Assert.fail((String)"A-XQC-9.2: rollback() on a connection in auto commit mode must fail");
            }
            catch (XQException e) {
                // empty catch block
            }
            try {
                this.xqc.setAutoCommit(false);
                this.xqc.rollback();
            }
            catch (XQException e) {
                Assert.fail((String)("A-XQC-9.3: rollback() failed with message: " + e.getMessage()));
            }
        }
    }

    public void testGetStaticContext() throws XQException {
        XQConnection my_xqc = this.xqds.getConnection();
        my_xqc.close();
        try {
            my_xqc.getStaticContext();
            Assert.fail((String)"A-XQC-10.1: closed connection supports getting the static context");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.getStaticContext();
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-10.2: getting the static context failed with message: " + e.getMessage()));
        }
    }

    public void testSetStaticContext() throws XQException {
        XQConnection my_xqc = this.xqds.getConnection();
        XQStaticContext my_xqsc = my_xqc.getStaticContext();
        my_xqc.close();
        try {
            my_xqc.setStaticContext(my_xqsc);
            Assert.fail((String)"A-XQC-11.1: closed connection supports setting the static context");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            this.xqc.setStaticContext(null);
            Assert.fail((String)"A-XQC-11.2: setStaticContext() with a null argument must throw an XQException.");
        }
        catch (XQException e) {
            // empty catch block
        }
        try {
            XQStaticContext xqsc = this.xqc.getStaticContext();
            this.xqc.setStaticContext(xqsc);
        }
        catch (XQException e) {
            Assert.fail((String)("A-XQC-11.3: getting the static context failed with message: " + e.getMessage()));
        }
    }
}

