/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.xqj.tck.testcases;

import com.oracle.xqj.tck.testcases.XQJTestCase;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.TreeSet;
import junit.framework.Assert;

public class SignatureTest
extends XQJTestCase {
    public static final String signatureFile__ = "xqj.sig";

    private static String logClass(StringBuffer sb, String name) throws Exception {
        Iterator it;
        Class<?> c = Class.forName("javax.xml.xquery." + name);
        sb.append(Modifier.toString(c.getModifiers()));
        sb.append(" ");
        sb.append(c.getName());
        if (c.getSuperclass() != null) {
            sb.append(" extends ");
            sb.append(c.getSuperclass().getName());
        }
        Class<?>[] interfaces = c.getInterfaces();
        TreeSet<String> set = new TreeSet<String>();
        if (interfaces != null && interfaces.length > 0) {
            for (int i = 0; i < interfaces.length; ++i) {
                set.add(interfaces[i].getName());
            }
            sb.append(" implements ");
            it = set.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
        }
        sb.append("\r\n{\r\n");
        set = new TreeSet();
        Field[] fields = c.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getDeclaringClass().equals(c)) continue;
            StringBuffer tmp = new StringBuffer();
            tmp.append(Modifier.toString(fields[i].getModifiers()));
            tmp.append(" ");
            tmp.append(fields[i].getType().getName());
            tmp.append(" ");
            tmp.append(fields[i].getName());
            tmp.append("\r\n");
            set.add(tmp.toString());
        }
        it = set.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
        }
        set = new TreeSet();
        Constructor<?>[] constructors = c.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(Modifier.toString(constructors[i].getModifiers()));
            tmp.append(" ");
            tmp.append(c.getName());
            tmp.append(" (");
            Class<?>[] parameters = constructors[i].getParameterTypes();
            for (int j = 0; j < parameters.length; ++j) {
                tmp.append(parameters[j].getName());
                if (j == parameters.length - 1) continue;
                tmp.append(",");
            }
            tmp.append(")");
            Class<?>[] exceptions = constructors[i].getExceptionTypes();
            if (exceptions != null && exceptions.length > 0) {
                tmp.append(" throws ");
                for (int j = 0; j < exceptions.length; ++j) {
                    tmp.append(exceptions[j].getName());
                    if (j == exceptions.length - 1) continue;
                    tmp.append(",");
                }
            }
            tmp.append("\r\n");
            set.add(tmp.toString());
        }
        it = set.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
        }
        set = new TreeSet();
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            StringBuffer tmp = new StringBuffer();
            if (!methods[i].getDeclaringClass().equals(c)) continue;
            tmp.append(Modifier.toString(methods[i].getModifiers()));
            tmp.append(" ");
            tmp.append(methods[i].getReturnType().getName());
            tmp.append(" ");
            tmp.append(methods[i].getName());
            tmp.append(" (");
            Class<?>[] parameters = methods[i].getParameterTypes();
            for (int j = 0; j < parameters.length; ++j) {
                tmp.append(parameters[j].getName());
                if (j == parameters.length - 1) continue;
                tmp.append(",");
            }
            tmp.append(")");
            Class<?>[] exceptions = methods[i].getExceptionTypes();
            if (exceptions != null && exceptions.length > 0) {
                tmp.append(" throws ");
                for (int j = 0; j < exceptions.length; ++j) {
                    tmp.append(exceptions[j].getName());
                    if (j == exceptions.length - 1) continue;
                    tmp.append(",");
                }
            }
            tmp.append("\r\n");
            set.add(tmp.toString());
        }
        it = set.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
        }
        sb.append("}\r\n\r\n");
        return sb.toString();
    }

    public void testSignatures() throws Exception {
        int ch;
        StringBuffer sb = new StringBuffer();
        SignatureTest.logClass(sb, "ConnectionPoolXQDataSource");
        SignatureTest.logClass(sb, "PooledXQConnection");
        SignatureTest.logClass(sb, "XQCancelledException");
        SignatureTest.logClass(sb, "XQConnection");
        SignatureTest.logClass(sb, "XQConnectionEvent");
        SignatureTest.logClass(sb, "XQConnectionEventListener");
        SignatureTest.logClass(sb, "XQConstants");
        SignatureTest.logClass(sb, "XQDataFactory");
        SignatureTest.logClass(sb, "XQDataSource");
        SignatureTest.logClass(sb, "XQDynamicContext");
        SignatureTest.logClass(sb, "XQException");
        SignatureTest.logClass(sb, "XQExpression");
        SignatureTest.logClass(sb, "XQItem");
        SignatureTest.logClass(sb, "XQItemAccessor");
        SignatureTest.logClass(sb, "XQItemType");
        SignatureTest.logClass(sb, "XQMetaData");
        SignatureTest.logClass(sb, "XQPreparedExpression");
        SignatureTest.logClass(sb, "XQQueryException");
        SignatureTest.logClass(sb, "XQResultItem");
        SignatureTest.logClass(sb, "XQResultSequence");
        SignatureTest.logClass(sb, "XQSequence");
        SignatureTest.logClass(sb, "XQSequenceType");
        SignatureTest.logClass(sb, "XQStackTraceElement");
        SignatureTest.logClass(sb, "XQStackTraceVariable");
        SignatureTest.logClass(sb, "XQStaticContext");
        InputStream signatureStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(signatureFile__);
        Assert.assertNotNull((String)"Signature file 'xqj.sig' not found in classpath.", (Object)signatureStream);
        InputStreamReader signatureReader = new InputStreamReader(signatureStream, "UTF-8");
        BufferedReader in = new BufferedReader(signatureReader);
        StringBuffer expected = new StringBuffer();
        while ((ch = ((Reader)in).read()) > -1) {
            expected.append((char)ch);
        }
        ((Reader)in).close();
        Assert.assertEquals((String)"ZZZ", (String)expected.toString(), (String)sb.toString());
    }
}

