/*
    Copyright (c) 2020 Contributors as noted in the AUTHORS file

    This file is part of libzmq, the ZeroMQ core engine in C++.

    libzmq is free software; you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License (LGPL) as published
    by the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    As a special exception, the Contributors give you permission to link
    this library with independent modules to produce an executable,
    regardless of the license terms of these independent modules, and to
    copy and distribute the resulting executable under terms of your choice,
    provided that you also meet, for each linked independent module, the
    terms and conditions of the license of that module. An independent
    module is a module which is not derived from or based on this library.
    If you modify this library, you must extend this exception to your
    version of the library.

    libzmq is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
    License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifdef ZMQ_USE_FUZZING_ENGINE
#include <fuzzer/FuzzedDataProvider.h>
#endif

#include <string>
#include <stdlib.h>

#include "testutil.hpp"
#include "testutil_unity.hpp"

extern "C" int LLVMFuzzerTestOneInput (const uint8_t *data, size_t size)
{
    uint8_t *secret_key;

    // As per API definition, input must be divisible by 5, so truncate it if it's not
    size -= size % 5;
    // As per API definition, the destination must be at least 0.8 times the input data
    TEST_ASSERT_NOT_NULL (secret_key = (uint8_t *) malloc (size * 4 / 5));

    std::string z85_secret_key (reinterpret_cast<const char *> (data), size);
    TEST_ASSERT_NOT_NULL (zmq_z85_decode (secret_key, z85_secret_key.c_str ()));

    free (secret_key);

    return 0;
}

#ifndef ZMQ_USE_FUZZING_ENGINE
void test_bind_null_fuzzer ()
{
    uint8_t buffer[32] = {0};

    TEST_ASSERT_SUCCESS_ERRNO (
      LLVMFuzzerTestOneInput (buffer, sizeof (buffer)));
}

int main (int argc, char **argv)
{
    setup_test_environment ();

    UNITY_BEGIN ();
    RUN_TEST (test_bind_null_fuzzer);

    return UNITY_END ();
}
#endif
