/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.zinc;

import com.typesafe.zinc.JarFile;
import com.typesafe.zinc.JarFile$;
import com.typesafe.zinc.SbtJars;
import com.typesafe.zinc.ScalaJars;
import com.typesafe.zinc.ScalaLocation;
import com.typesafe.zinc.Settings;
import com.typesafe.zinc.Setup;
import com.typesafe.zinc.Setup$;
import com.typesafe.zinc.Setup$Defaults$;
import com.typesafe.zinc.Util$;
import java.io.File;
import java.util.List;
import java.util.Properties;
import sbt.FileFilter;
import sbt.FileFilter$;
import sbt.Logger;
import sbt.Logger$;
import sbt.Path$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Setup$
implements Serializable {
    public static final Setup$ MODULE$;
    private final String Command;
    private final String Description;
    private final String HomeProperty;
    private final String DirProperty;
    private final JarFile ScalaCompiler;
    private final JarFile ScalaLibrary;
    private final JarFile ScalaReflect;
    private final JarFile SbtInterface;
    private final JarFile CompilerInterfaceSources;
    private Setup.Version zincVersion;
    private String versionString;
    private volatile byte bitmap$0;

    static {
        new Setup$();
    }

    private Setup.Version zincVersion$lzycompute() {
        Setup$ setup$ = this;
        synchronized (setup$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Properties props = Util$.MODULE$.propertiesFromResource("zinc.version.properties", this.getClass().getClassLoader());
                this.zincVersion = new Setup.Version(props.getProperty("version", "unknown"), props.getProperty("timestamp", ""), props.getProperty("commit", ""));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.zincVersion;
        }
    }

    private String versionString$lzycompute() {
        Setup$ setup$ = this;
        synchronized (setup$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.versionString = this.zincVersion().published().endsWith("-SNAPSHOT") ? new StringOps(Predef$.MODULE$.augmentString("%s %s-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zincVersion().published(), this.zincVersion().timestamp(), new StringOps(Predef$.MODULE$.augmentString(this.zincVersion().commit())).take(10)})) : this.zincVersion().published();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.versionString;
        }
    }

    public String Command() {
        return this.Command;
    }

    public String Description() {
        return this.Description;
    }

    public String HomeProperty() {
        return this.HomeProperty;
    }

    public String DirProperty() {
        return this.DirProperty;
    }

    public JarFile ScalaCompiler() {
        return this.ScalaCompiler;
    }

    public JarFile ScalaLibrary() {
        return this.ScalaLibrary;
    }

    public JarFile ScalaReflect() {
        return this.ScalaReflect;
    }

    public JarFile SbtInterface() {
        return this.SbtInterface;
    }

    public JarFile CompilerInterfaceSources() {
        return this.CompilerInterfaceSources;
    }

    public Setup apply(Settings settings) {
        ScalaJars scalaJars = this.selectScalaJars(settings.scala());
        Tuple2<File, File> tuple2 = this.selectSbtJars(settings.sbt());
        if (tuple2 != null) {
            Tuple2 tuple22;
            File sbtInterface = (File)tuple2._1();
            File compilerInterfaceSrc = (File)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sbtInterface, (Object)compilerInterfaceSrc);
            File sbtInterface2 = (File)tuple23._1();
            File compilerInterfaceSrc2 = (File)tuple23._2();
            return this.setup(scalaJars.compiler(), scalaJars.library(), scalaJars.extra(), sbtInterface2, compilerInterfaceSrc2, settings.javaHome(), settings.forkJava());
        }
        throw new MatchError(tuple2);
    }

    public Setup setup(File scalaCompiler, File scalaLibrary, Seq<File> scalaExtra, File sbtInterface, File compilerInterfaceSrc, Option<File> javaHomeDir, boolean forkJava) {
        Serializable normalise = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(File x$3) {
                return x$3.getAbsoluteFile();
            }
        };
        File compilerJar = (File)normalise.apply((Object)scalaCompiler);
        File libraryJar = (File)normalise.apply((Object)scalaLibrary);
        Seq extraJars = (Seq)scalaExtra.map((Function1)normalise, Seq$.MODULE$.canBuildFrom());
        File sbtInterfaceJar = (File)normalise.apply((Object)sbtInterface);
        File compilerInterfaceJar = (File)normalise.apply((Object)compilerInterfaceSrc);
        Option javaHome = javaHomeDir.map((Function1)normalise);
        File cacheDir = this.zincCacheDir();
        return new Setup(compilerJar, libraryJar, (Seq<File>)extraJars, sbtInterfaceJar, compilerInterfaceJar, (Option<File>)javaHome, forkJava, cacheDir);
    }

    public Setup create(File scalaCompiler, File scalaLibrary, List<File> scalaExtra, File sbtInterface, File compilerInterfaceSrc, File javaHome, boolean forkJava) {
        return this.setup(scalaCompiler, scalaLibrary, (Seq<File>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(scalaExtra).asScala()), sbtInterface, compilerInterfaceSrc, (Option<File>)Option$.MODULE$.apply((Object)javaHome), forkJava);
    }

    public Setup create(File scalaCompiler, File scalaLibrary, List<File> scalaExtra, File sbtInterface, File compilerInterfaceSrc, File javaHome) {
        return this.create(scalaCompiler, scalaLibrary, scalaExtra, sbtInterface, compilerInterfaceSrc, javaHome, false);
    }

    public Setup create(ScalaLocation scalaLocation, SbtJars sbtJars, File javaHome, boolean forkJava) {
        ScalaJars scalaJars = this.selectScalaJars(scalaLocation);
        Tuple2<File, File> tuple2 = this.selectSbtJars(sbtJars);
        if (tuple2 != null) {
            Tuple2 tuple22;
            File sbtInterface = (File)tuple2._1();
            File compilerInterfaceSrc = (File)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sbtInterface, (Object)compilerInterfaceSrc);
            File sbtInterface2 = (File)tuple23._1();
            File compilerInterfaceSrc2 = (File)tuple23._2();
            return this.setup(scalaJars.compiler(), scalaJars.library(), scalaJars.extra(), sbtInterface2, compilerInterfaceSrc2, (Option<File>)Option$.MODULE$.apply((Object)javaHome), forkJava);
        }
        throw new MatchError(tuple2);
    }

    public Setup create(ScalaLocation scalaLocation, SbtJars sbtJars, File javaHome) {
        return this.create(scalaLocation, sbtJars, javaHome, false);
    }

    public ScalaJars selectScalaJars(ScalaLocation scala) {
        ScalaJars jars = (ScalaJars)this.splitScala(scala.path(), this.splitScala$default$2()).orElse((Function0)new Serializable(scala){
            public static final long serialVersionUID = 0L;
            private final ScalaLocation scala$1;

            public final Option<ScalaJars> apply() {
                return Setup$.MODULE$.splitScala(Setup$.MODULE$.allLibs(this.scala$1.home()), Setup$Defaults$.MODULE$.scalaExcluded());
            }
            {
                this.scala$1 = scala$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScalaJars apply() {
                return Setup$Defaults$.MODULE$.scalaJars();
            }
        });
        return new ScalaJars((File)scala.compiler().getOrElse((Function0)new Serializable(jars){
            public static final long serialVersionUID = 0L;
            private final ScalaJars jars$1;

            public final File apply() {
                return this.jars$1.compiler();
            }
            {
                this.jars$1 = jars$1;
            }
        }), (File)scala.library().getOrElse((Function0)new Serializable(jars){
            public static final long serialVersionUID = 0L;
            private final ScalaJars jars$1;

            public final File apply() {
                return this.jars$1.library();
            }
            {
                this.jars$1 = jars$1;
            }
        }), (Seq<File>)((Seq)scala.extra().$plus$plus(jars.extra(), Seq$.MODULE$.canBuildFrom())));
    }

    public Option<ScalaJars> splitScala(Seq<File> jars, Set<String> excluded) {
        Seq filtered = (Seq)jars.filterNot((Function1)new Serializable(excluded){
            public static final long serialVersionUID = 0L;
            private final Set excluded$1;

            public final boolean apply(File x$5) {
                return this.excluded$1.contains((Object)x$5.getName());
            }
            {
                this.excluded$1 = excluded$1;
            }
        });
        Tuple2 tuple2 = filtered.partition((Function1)new anonfun.7());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq compiler = (Seq)tuple2._1();
            Seq other = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)compiler, (Object)other);
            Seq compiler2 = (Seq)tuple23._1();
            Seq other2 = (Seq)tuple23._2();
            Tuple2 tuple24 = other2.partition((Function1)new anonfun.8());
            if (tuple24 != null) {
                Tuple2 tuple25;
                Seq library = (Seq)tuple24._1();
                Seq extra = (Seq)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)library, (Object)extra);
                Seq library2 = (Seq)tuple26._1();
                Seq extra2 = (Seq)tuple26._2();
                return compiler2.nonEmpty() && library2.nonEmpty() ? new Some((Object)new ScalaJars((File)compiler2.apply(0), (File)library2.apply(0), (Seq<File>)extra2)) : None$.MODULE$;
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public Set<String> splitScala$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public Tuple2<File, File> selectSbtJars(SbtJars sbt) {
        File sbtInterface = (File)sbt.sbtInterface().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply() {
                return Setup$Defaults$.MODULE$.sbtInterface();
            }
        });
        File compilerInterfaceSrc = (File)sbt.compilerInterfaceSrc().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply() {
                return Setup$Defaults$.MODULE$.compilerInterfaceSrc();
            }
        });
        return new Tuple2((Object)sbtInterface, (Object)compilerInterfaceSrc);
    }

    public File zincCacheDir() {
        return Path$.MODULE$.richFile(Setup$Defaults$.MODULE$.zincDir()).$div(this.zincVersion().published());
    }

    public boolean verify(Setup setup, Logger log) {
        return this.requireFile(setup.scalaCompiler(), log) && this.requireFile(setup.scalaLibrary(), log) && this.requireFile(setup.sbtInterface(), log) && this.requireFile(setup.compilerInterfaceSrc(), log);
    }

    /*
     * WARNING - void declaration
     */
    public boolean requireFile(File file, Logger log) {
        void var3_3;
        boolean exists = file.exists();
        if (!exists) {
            log.error((Function0)new Serializable(file){
                public static final long serialVersionUID = 0L;
                private final File file$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Required file not found: ").append((Object)this.file$1.getName()).toString();
                }
                {
                    this.file$1 = file$1;
                }
            });
        }
        return (boolean)var3_3;
    }

    public String prop(String name) {
        return new StringBuilder().append((Object)this.Command()).append((Object)".").append((Object)name).toString();
    }

    public Seq<File> allLibs(Option<File> homeDir) {
        return (Seq)homeDir.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply(File home) {
                return Path$.MODULE$.singleFileFinder(Path$.MODULE$.richFile(home).$div("lib")).$times$times((FileFilter)FileFilter$.MODULE$.globFilter("*.jar")).get();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Option<File> optLib(Option<File> homeDir, JarFile jar) {
        return this.allLibs(homeDir).find((Function1)new Serializable(jar){
            public static final long serialVersionUID = 0L;
            private final JarFile jar$2;

            public final boolean apply(File x$11) {
                return x$11.getName().matches(this.jar$2.pattern());
            }
            {
                this.jar$2 = jar$2;
            }
        });
    }

    public File optLibOrDefault(Option<File> homeDir, JarFile jar) {
        return (File)this.optLib(homeDir, jar).getOrElse((Function0)new Serializable(jar){
            public static final long serialVersionUID = 0L;
            private final JarFile jar$1;

            public final File apply() {
                return new File(this.jar$1.default());
            }
            {
                this.jar$1 = jar$1;
            }
        });
    }

    public Setup.Version zincVersion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.zincVersion$lzycompute() : this.zincVersion;
    }

    public String versionString() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.versionString$lzycompute() : this.versionString;
    }

    public void printVersion() {
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s (%s) %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Command(), this.Description(), this.versionString()})));
    }

    public void debug(Setup setup, xsbti.Logger log) {
        this.show(setup, (Function1<String, BoxedUnit>)new Serializable(log){
            public static final long serialVersionUID = 0L;
            private final xsbti.Logger log$1;

            public final void apply(String s) {
                this.log$1.debug(Logger$.MODULE$.f0((Function0)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final String s$1;

                    public final String apply() {
                        return this.s$1;
                    }
                    {
                        this.s$1 = s$1;
                    }
                }));
            }
            {
                this.log$1 = log$1;
            }
        });
    }

    public void show(Setup setup, Function1<String, BoxedUnit> output) {
        Seq values = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"scala compiler"), (Object)setup.scalaCompiler()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"scala library"), (Object)setup.scalaLibrary()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"scala extra"), setup.scalaExtra()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sbt interface"), (Object)setup.sbtInterface()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"compiler interface sources"), (Object)setup.compilerInterfaceSrc()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"java home"), setup.javaHome()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fork java"), (Object)BoxesRunTime.boxToBoolean((boolean)setup.forkJava())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"cache directory"), (Object)setup.cacheDir())}));
        Util$.MODULE$.show(new Tuple2((Object)"Setup", (Object)values), output, Util$.MODULE$.show$default$3(), Util$.MODULE$.show$default$4());
    }

    public Setup apply(File scalaCompiler, File scalaLibrary, Seq<File> scalaExtra, File sbtInterface, File compilerInterfaceSrc, Option<File> javaHome, boolean forkJava, File cacheDir) {
        return new Setup(scalaCompiler, scalaLibrary, scalaExtra, sbtInterface, compilerInterfaceSrc, javaHome, forkJava, cacheDir);
    }

    public Option<Tuple8<File, File, Seq<File>, File, File, Option<File>, Object, File>> unapply(Setup x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.scalaCompiler(), (Object)x$0.scalaLibrary(), x$0.scalaExtra(), (Object)x$0.sbtInterface(), (Object)x$0.compilerInterfaceSrc(), x$0.javaHome(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.forkJava()), (Object)x$0.cacheDir()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Setup$() {
        MODULE$ = this;
        this.Command = "zinc";
        this.Description = "scala incremental compiler";
        this.HomeProperty = this.prop("home");
        this.DirProperty = this.prop("dir");
        this.ScalaCompiler = new JarFile("scala-compiler", JarFile$.MODULE$.apply$default$2());
        this.ScalaLibrary = new JarFile("scala-library", JarFile$.MODULE$.apply$default$2());
        this.ScalaReflect = new JarFile("scala-reflect", JarFile$.MODULE$.apply$default$2());
        this.SbtInterface = new JarFile("sbt-interface", JarFile$.MODULE$.apply$default$2());
        this.CompilerInterfaceSources = JarFile$.MODULE$.apply("compiler-interface", "sources");
    }
}

