const ctz = @import("count0bits.zig");
const testing = @import("std").testing;

fn test__ctzti2(a: u128, expected: i32) !void {
    var x = @bitCast(i128, a);
    var result = ctz.__ctzti2(x);
    try testing.expectEqual(expected, result);
}

test "ctzti2" {
    try test__ctzti2(0x00000000_00000000_00000000_00000001, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000002, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000003, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000004, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000005, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000006, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000007, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000008, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000009, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000000A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000000B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000000C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000000D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000000E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000000F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000010, 4);
    try test__ctzti2(0x00000000_00000000_00000000_00000011, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000012, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000013, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000014, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000015, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000016, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000017, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000018, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000019, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000001A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000001B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000001C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000001D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000001E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000001F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000020, 5);
    try test__ctzti2(0x00000000_00000000_00000000_00000021, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000022, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000023, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000024, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000025, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000026, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000027, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000028, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000029, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000002A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000002B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000002C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000002D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000002E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000002F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000030, 4);
    try test__ctzti2(0x00000000_00000000_00000000_00000031, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000032, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000033, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000034, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000035, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000036, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000037, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000038, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000039, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000003A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000003B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000003C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000003D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000003E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000003F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000040, 6);
    try test__ctzti2(0x00000000_00000000_00000000_00000041, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000042, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000043, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000044, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000045, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000046, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000047, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000048, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000049, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000004A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000004B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000004C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000004D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000004E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000004F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000050, 4);
    try test__ctzti2(0x00000000_00000000_00000000_00000051, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000052, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000053, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000054, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000055, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000056, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000057, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000058, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000059, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000005A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000005B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000005C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000005D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000005E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000005F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000060, 5);
    try test__ctzti2(0x00000000_00000000_00000000_00000061, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000062, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000063, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000064, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000065, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000066, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000067, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000068, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000069, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000006A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000006B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000006C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000006D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000006E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000006F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000070, 4);
    try test__ctzti2(0x00000000_00000000_00000000_00000071, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000072, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000073, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000074, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000075, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000076, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000077, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000078, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000079, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000007A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000007B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000007C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000007D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000007E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000007F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000080, 7);
    try test__ctzti2(0x00000000_00000000_00000000_00000081, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000082, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000083, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000084, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000085, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000086, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000087, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000088, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000089, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000008A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000008B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000008C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000008D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000008E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000008F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000090, 4);
    try test__ctzti2(0x00000000_00000000_00000000_00000091, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000092, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000093, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000094, 2);
    try test__ctzti2(0x00000000_00000000_00000000_00000095, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000096, 1);
    try test__ctzti2(0x00000000_00000000_00000000_00000097, 0);
    try test__ctzti2(0x00000000_00000000_00000000_00000098, 3);
    try test__ctzti2(0x00000000_00000000_00000000_00000099, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000009A, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000009B, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000009C, 2);
    try test__ctzti2(0x00000000_00000000_00000000_0000009D, 0);
    try test__ctzti2(0x00000000_00000000_00000000_0000009E, 1);
    try test__ctzti2(0x00000000_00000000_00000000_0000009F, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000A0, 5);
    try test__ctzti2(0x00000000_00000000_00000000_000000A1, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000A2, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000A3, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000A4, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000A5, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000A6, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000A7, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000A8, 3);
    try test__ctzti2(0x00000000_00000000_00000000_000000A9, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000AA, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000AB, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000AC, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000AD, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000AE, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000AF, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000B0, 4);
    try test__ctzti2(0x00000000_00000000_00000000_000000B1, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000B2, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000B3, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000B4, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000B5, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000B6, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000B7, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000B8, 3);
    try test__ctzti2(0x00000000_00000000_00000000_000000B9, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000BA, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000BB, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000BC, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000BD, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000BE, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000BF, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000C0, 6);
    try test__ctzti2(0x00000000_00000000_00000000_000000C1, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000C2, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000C3, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000C4, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000C5, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000C6, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000C7, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000C8, 3);
    try test__ctzti2(0x00000000_00000000_00000000_000000C9, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000CA, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000CB, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000CC, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000CD, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000CE, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000CF, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000D0, 4);
    try test__ctzti2(0x00000000_00000000_00000000_000000D1, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000D2, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000D3, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000D4, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000D5, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000D6, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000D7, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000D8, 3);
    try test__ctzti2(0x00000000_00000000_00000000_000000D9, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000DA, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000DB, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000DC, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000DD, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000DE, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000DF, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000E0, 5);
    try test__ctzti2(0x00000000_00000000_00000000_000000E1, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000E2, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000E3, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000E4, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000E5, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000E6, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000E7, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000E8, 3);
    try test__ctzti2(0x00000000_00000000_00000000_000000E9, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000EA, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000EB, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000EC, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000ED, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000EE, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000EF, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000F0, 4);
    try test__ctzti2(0x00000000_00000000_00000000_000000F1, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000F2, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000F3, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000F4, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000F5, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000F6, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000F7, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000F8, 3);
    try test__ctzti2(0x00000000_00000000_00000000_000000F9, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000FA, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000FB, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000FC, 2);
    try test__ctzti2(0x00000000_00000000_00000000_000000FD, 0);
    try test__ctzti2(0x00000000_00000000_00000000_000000FE, 1);
    try test__ctzti2(0x00000000_00000000_00000000_000000FF, 0);

    try test__ctzti2(0x00000000_00000000_00000000_00000000, 128);
    try test__ctzti2(0x80000000_00000000_00000000_00000000, 127);
    try test__ctzti2(0x40000000_00000000_00000000_00000000, 126);
    try test__ctzti2(0x20000000_00000000_00000000_00000000, 125);
    try test__ctzti2(0x10000000_00000000_00000000_00000000, 124);
    try test__ctzti2(0x08000000_00000000_00000000_00000000, 123);
    try test__ctzti2(0x04000000_00000000_00000000_00000000, 122);
    try test__ctzti2(0x02000000_00000000_00000000_00000000, 121);
    try test__ctzti2(0x01000000_00000000_00000000_00000000, 120);
    try test__ctzti2(0x00800000_00000000_00000000_00000000, 119);
    try test__ctzti2(0x00400000_00000000_00000000_00000000, 118);
    try test__ctzti2(0x00200000_00000000_00000000_00000000, 117);
    try test__ctzti2(0x00100000_00000000_00000000_00000000, 116);
    try test__ctzti2(0x00080000_00000000_00000000_00000000, 115);
    try test__ctzti2(0x00040000_00000000_00000000_00000000, 114);
    try test__ctzti2(0x00020000_00000000_00000000_00000000, 113);
    try test__ctzti2(0x00010000_00000000_00000000_00000000, 112);
    try test__ctzti2(0x00008000_00000000_00000000_00000000, 111);
    try test__ctzti2(0x00004000_00000000_00000000_00000000, 110);
    try test__ctzti2(0x00002000_00000000_00000000_00000000, 109);
    try test__ctzti2(0x00001000_00000000_00000000_00000000, 108);
    try test__ctzti2(0x00000800_00000000_00000000_00000000, 107);
    try test__ctzti2(0x00000400_00000000_00000000_00000000, 106);
    try test__ctzti2(0x00000200_00000000_00000000_00000000, 105);
    try test__ctzti2(0x00000100_00000000_00000000_00000000, 104);
    try test__ctzti2(0x00000080_00000000_00000000_00000000, 103);
    try test__ctzti2(0x00000040_00000000_00000000_00000000, 102);
    try test__ctzti2(0x00000020_00000000_00000000_00000000, 101);
    try test__ctzti2(0x00000010_00000000_00000000_00000000, 100);
    try test__ctzti2(0x00000008_00000000_00000000_00000000, 99);
    try test__ctzti2(0x00000004_00000000_00000000_00000000, 98);
    try test__ctzti2(0x00000002_00000000_00000000_00000000, 97);
    try test__ctzti2(0x00000001_00000000_00000000_00000000, 96);

    try test__ctzti2(0x00000000_80000000_00000000_00000000, 95);
    try test__ctzti2(0x00000000_40000000_00000000_00000000, 94);
    try test__ctzti2(0x00000000_20000000_00000000_00000000, 93);
    try test__ctzti2(0x00000000_10000000_00000000_00000000, 92);
    try test__ctzti2(0x00000000_08000000_00000000_00000000, 91);
    try test__ctzti2(0x00000000_04000000_00000000_00000000, 90);
    try test__ctzti2(0x00000000_02000000_00000000_00000000, 89);
    try test__ctzti2(0x00000000_01000000_00000000_00000000, 88);
    try test__ctzti2(0x00000000_00800000_00000000_00000000, 87);
    try test__ctzti2(0x00000000_00400000_00000000_00000000, 86);
    try test__ctzti2(0x00000000_00200000_00000000_00000000, 85);
    try test__ctzti2(0x00000000_00100000_00000000_00000000, 84);
    try test__ctzti2(0x00000000_00080000_00000000_00000000, 83);
    try test__ctzti2(0x00000000_00040000_00000000_00000000, 82);
    try test__ctzti2(0x00000000_00020000_00000000_00000000, 81);
    try test__ctzti2(0x00000000_00010000_00000000_00000000, 80);
    try test__ctzti2(0x00000000_00008000_00000000_00000000, 79);
    try test__ctzti2(0x00000000_00004000_00000000_00000000, 78);
    try test__ctzti2(0x00000000_00002000_00000000_00000000, 77);
    try test__ctzti2(0x00000000_00001000_00000000_00000000, 76);
    try test__ctzti2(0x00000000_00000800_00000000_00000000, 75);
    try test__ctzti2(0x00000000_00000400_00000000_00000000, 74);
    try test__ctzti2(0x00000000_00000200_00000000_00000000, 73);
    try test__ctzti2(0x00000000_00000100_00000000_00000000, 72);
    try test__ctzti2(0x00000000_00000080_00000000_00000000, 71);
    try test__ctzti2(0x00000000_00000040_00000000_00000000, 70);
    try test__ctzti2(0x00000000_00000020_00000000_00000000, 69);
    try test__ctzti2(0x00000000_00000010_00000000_00000000, 68);
    try test__ctzti2(0x00000000_00000008_00000000_00000000, 67);
    try test__ctzti2(0x00000000_00000004_00000000_00000000, 66);
    try test__ctzti2(0x00000000_00000002_00000000_00000000, 65);
    try test__ctzti2(0x00000000_00000001_00000000_00000000, 64);

    try test__ctzti2(0x00000000_00000000_80000000_00000000, 63);
    try test__ctzti2(0x00000000_00000000_40000000_00000000, 62);
    try test__ctzti2(0x00000000_00000000_20000000_00000000, 61);
    try test__ctzti2(0x00000000_00000000_10000000_00000000, 60);
    try test__ctzti2(0x00000000_00000000_08000000_00000000, 59);
    try test__ctzti2(0x00000000_00000000_04000000_00000000, 58);
    try test__ctzti2(0x00000000_00000000_02000000_00000000, 57);
    try test__ctzti2(0x00000000_00000000_01000000_00000000, 56);
    try test__ctzti2(0x00000000_00000000_00800000_00000000, 55);
    try test__ctzti2(0x00000000_00000000_00400000_00000000, 54);
    try test__ctzti2(0x00000000_00000000_00200000_00000000, 53);
    try test__ctzti2(0x00000000_00000000_00100000_00000000, 52);
    try test__ctzti2(0x00000000_00000000_00080000_00000000, 51);
    try test__ctzti2(0x00000000_00000000_00040000_00000000, 50);
    try test__ctzti2(0x00000000_00000000_00020000_00000000, 49);
    try test__ctzti2(0x00000000_00000000_00010000_00000000, 48);
    try test__ctzti2(0x00000000_00000000_00008000_00000000, 47);
    try test__ctzti2(0x00000000_00000000_00004000_00000000, 46);
    try test__ctzti2(0x00000000_00000000_00002000_00000000, 45);
    try test__ctzti2(0x00000000_00000000_00001000_00000000, 44);
    try test__ctzti2(0x00000000_00000000_00000800_00000000, 43);
    try test__ctzti2(0x00000000_00000000_00000400_00000000, 42);
    try test__ctzti2(0x00000000_00000000_00000200_00000000, 41);
    try test__ctzti2(0x00000000_00000000_00000100_00000000, 40);
    try test__ctzti2(0x00000000_00000000_00000080_00000000, 39);
    try test__ctzti2(0x00000000_00000000_00000040_00000000, 38);
    try test__ctzti2(0x00000000_00000000_00000020_00000000, 37);
    try test__ctzti2(0x00000000_00000000_00000010_00000000, 36);
    try test__ctzti2(0x00000000_00000000_00000008_00000000, 35);
    try test__ctzti2(0x00000000_00000000_00000004_00000000, 34);
    try test__ctzti2(0x00000000_00000000_00000002_00000000, 33);
    try test__ctzti2(0x00000000_00000000_00000001_00000000, 32);

    try test__ctzti2(0x00000000_00000000_00000000_80000000, 31);
    try test__ctzti2(0x00000000_00000000_00000000_40000000, 30);
    try test__ctzti2(0x00000000_00000000_00000000_20000000, 29);
    try test__ctzti2(0x00000000_00000000_00000000_10000000, 28);
    try test__ctzti2(0x00000000_00000000_00000000_08000000, 27);
    try test__ctzti2(0x00000000_00000000_00000000_04000000, 26);
    try test__ctzti2(0x00000000_00000000_00000000_02000000, 25);
    try test__ctzti2(0x00000000_00000000_00000000_01000000, 24);
    try test__ctzti2(0x00000000_00000000_00000000_00800000, 23);
    try test__ctzti2(0x00000000_00000000_00000000_00400000, 22);
    try test__ctzti2(0x00000000_00000000_00000000_00200000, 21);
    try test__ctzti2(0x00000000_00000000_00000000_00100000, 20);
    try test__ctzti2(0x00000000_00000000_00000000_00080000, 19);
    try test__ctzti2(0x00000000_00000000_00000000_00040000, 18);
    try test__ctzti2(0x00000000_00000000_00000000_00020000, 17);
    try test__ctzti2(0x00000000_00000000_00000000_00010000, 16);
    try test__ctzti2(0x00000000_00000000_00000000_00008000, 15);
    try test__ctzti2(0x00000000_00000000_00000000_00004000, 14);
    try test__ctzti2(0x00000000_00000000_00000000_00002000, 13);
    try test__ctzti2(0x00000000_00000000_00000000_00001000, 12);
    try test__ctzti2(0x00000000_00000000_00000000_00000800, 11);
    try test__ctzti2(0x00000000_00000000_00000000_00000400, 10);
    try test__ctzti2(0x00000000_00000000_00000000_00000200, 9);
    try test__ctzti2(0x00000000_00000000_00000000_00000100, 8);
}
