const clz = @import("count0bits.zig");
const testing = @import("std").testing;

fn test__clzti2(a: u128, expected: i64) !void {
    var x = @bitCast(i128, a);
    var result = clz.__clzti2(x);
    try testing.expectEqual(expected, result);
}

test "clzti2" {
    try test__clzti2(0x00800000_00000000_00000000_00000000, 8);
    try test__clzti2(0x01000000_00000000_00000000_00000000, 7);
    try test__clzti2(0x02000000_00000000_00000000_00000000, 6);
    try test__clzti2(0x03000000_00000000_00000000_00000000, 6);
    try test__clzti2(0x04000000_00000000_00000000_00000000, 5);
    try test__clzti2(0x05000000_00000000_00000000_00000000, 5);
    try test__clzti2(0x06000000_00000000_00000000_00000000, 5);
    try test__clzti2(0x07000000_00000000_00000000_00000000, 5);
    try test__clzti2(0x08000000_00000000_00000000_00000000, 4);
    try test__clzti2(0x09000000_00000000_00000000_00000000, 4);
    try test__clzti2(0x0A000000_00000000_00000000_00000000, 4);
    try test__clzti2(0x0B000000_00000000_00000000_00000000, 4);
    try test__clzti2(0x0C000000_00000000_00000000_00000000, 4);
    try test__clzti2(0x0D000000_00000000_00000000_00000000, 4);
    try test__clzti2(0x0E000000_00000000_00000000_00000000, 4);
    try test__clzti2(0x0F000000_00000000_00000000_00000000, 4);
    try test__clzti2(0x10000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x11000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x12000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x13000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x14000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x15000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x16000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x17000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x18000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x19000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x1A000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x1B000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x1C000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x1D000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x1E000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x1F000000_00000000_00000000_00000000, 3);
    try test__clzti2(0x20000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x21000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x22000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x23000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x24000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x25000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x26000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x27000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x28000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x29000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x2A000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x2B000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x2C000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x2D000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x2E000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x2F000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x30000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x31000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x32000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x33000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x34000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x35000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x36000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x37000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x38000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x39000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x3A000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x3B000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x3C000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x3D000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x3E000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x3F000000_00000000_00000000_00000000, 2);
    try test__clzti2(0x40000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x41000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x42000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x43000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x44000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x45000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x46000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x47000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x48000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x49000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x4A000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x4B000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x4C000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x4D000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x4E000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x4F000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x50000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x51000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x52000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x53000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x54000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x55000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x56000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x57000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x58000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x59000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x5A000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x5B000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x5C000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x5D000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x5E000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x5F000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x60000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x61000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x62000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x63000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x64000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x65000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x66000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x67000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x68000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x69000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x6A000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x6B000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x6C000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x6D000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x6E000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x6F000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x70000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x71000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x72000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x73000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x74000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x75000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x76000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x77000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x78000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x79000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x7A000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x7B000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x7C000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x7D000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x7E000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x7F000000_00000000_00000000_00000000, 1);
    try test__clzti2(0x80000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x81000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x82000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x83000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x84000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x85000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x86000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x87000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x88000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x89000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x8A000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x8B000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x8C000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x8D000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x8E000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x8F000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x90000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x91000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x92000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x93000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x94000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x95000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x96000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x97000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x98000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x99000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x9A000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x9B000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x9C000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x9D000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x9E000000_00000000_00000000_00000000, 0);
    try test__clzti2(0x9F000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA0000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA1000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA2000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA3000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA4000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA5000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA6000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA7000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA8000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xA9000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xAA000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xAB000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xAC000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xAD000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xAE000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xAF000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB0000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB1000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB2000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB3000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB4000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB5000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB6000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB7000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB8000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xB9000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xBA000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xBB000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xBC000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xBD000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xBE000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xBF000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC0000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC1000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC2000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC3000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC4000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC5000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC6000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC7000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC8000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xC9000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xCA000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xCB000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xCC000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xCD000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xCE000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xCF000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD0000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD1000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD2000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD3000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD4000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD5000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD6000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD7000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD8000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xD9000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xDA000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xDB000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xDC000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xDD000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xDE000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xDF000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE0000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE1000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE2000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE3000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE4000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE5000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE6000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE7000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE8000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xE9000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xEA000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xEB000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xEC000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xED000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xEE000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xEF000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF0000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF1000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF2000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF3000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF4000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF5000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF6000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF7000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF8000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xF9000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xFA000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xFB000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xFC000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xFD000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xFE000000_00000000_00000000_00000000, 0);
    try test__clzti2(0xFF000000_00000000_00000000_00000000, 0);

    try test__clzti2(0x00000000_00000000_00000000_00000000, 128);
    try test__clzti2(0x00000000_00000000_00000000_00000001, 127);
    try test__clzti2(0x00000000_00000000_00000000_00000002, 126);
    try test__clzti2(0x00000000_00000000_00000000_00000004, 125);
    try test__clzti2(0x00000000_00000000_00000000_00000008, 124);
    try test__clzti2(0x00000000_00000000_00000000_00000010, 123);
    try test__clzti2(0x00000000_00000000_00000000_00000020, 122);
    try test__clzti2(0x00000000_00000000_00000000_00000040, 121);
    try test__clzti2(0x00000000_00000000_00000000_00000080, 120);
    try test__clzti2(0x00000000_00000000_00000000_00000100, 119);
    try test__clzti2(0x00000000_00000000_00000000_00000200, 118);
    try test__clzti2(0x00000000_00000000_00000000_00000400, 117);
    try test__clzti2(0x00000000_00000000_00000000_00000800, 116);
    try test__clzti2(0x00000000_00000000_00000000_00001000, 115);
    try test__clzti2(0x00000000_00000000_00000000_00002000, 114);
    try test__clzti2(0x00000000_00000000_00000000_00004000, 113);
    try test__clzti2(0x00000000_00000000_00000000_00008000, 112);
    try test__clzti2(0x00000000_00000000_00000000_00010000, 111);
    try test__clzti2(0x00000000_00000000_00000000_00020000, 110);
    try test__clzti2(0x00000000_00000000_00000000_00040000, 109);
    try test__clzti2(0x00000000_00000000_00000000_00080000, 108);
    try test__clzti2(0x00000000_00000000_00000000_00100000, 107);
    try test__clzti2(0x00000000_00000000_00000000_00200000, 106);
    try test__clzti2(0x00000000_00000000_00000000_00400000, 105);
    try test__clzti2(0x00000000_00000000_00000000_00800000, 104);
    try test__clzti2(0x00000000_00000000_00000000_01000000, 103);
    try test__clzti2(0x00000000_00000000_00000000_02000000, 102);
    try test__clzti2(0x00000000_00000000_00000000_04000000, 101);
    try test__clzti2(0x00000000_00000000_00000000_08000000, 100);
    try test__clzti2(0x00000000_00000000_00000000_10000000, 99);
    try test__clzti2(0x00000000_00000000_00000000_20000000, 98);
    try test__clzti2(0x00000000_00000000_00000000_40000000, 97);
    try test__clzti2(0x00000000_00000000_00000000_80000000, 96);

    try test__clzti2(0x00000000_00000000_00000001_00000000, 95);
    try test__clzti2(0x00000000_00000000_00000002_00000000, 94);
    try test__clzti2(0x00000000_00000000_00000004_00000000, 93);
    try test__clzti2(0x00000000_00000000_00000008_00000000, 92);
    try test__clzti2(0x00000000_00000000_00000010_00000000, 91);
    try test__clzti2(0x00000000_00000000_00000020_00000000, 90);
    try test__clzti2(0x00000000_00000000_00000040_00000000, 89);
    try test__clzti2(0x00000000_00000000_00000080_00000000, 88);
    try test__clzti2(0x00000000_00000000_00000100_00000000, 87);
    try test__clzti2(0x00000000_00000000_00000200_00000000, 86);
    try test__clzti2(0x00000000_00000000_00000400_00000000, 85);
    try test__clzti2(0x00000000_00000000_00000800_00000000, 84);
    try test__clzti2(0x00000000_00000000_00001000_00000000, 83);
    try test__clzti2(0x00000000_00000000_00002000_00000000, 82);
    try test__clzti2(0x00000000_00000000_00004000_00000000, 81);
    try test__clzti2(0x00000000_00000000_00008000_00000000, 80);
    try test__clzti2(0x00000000_00000000_00010000_00000000, 79);
    try test__clzti2(0x00000000_00000000_00020000_00000000, 78);
    try test__clzti2(0x00000000_00000000_00040000_00000000, 77);
    try test__clzti2(0x00000000_00000000_00080000_00000000, 76);
    try test__clzti2(0x00000000_00000000_00100000_00000000, 75);
    try test__clzti2(0x00000000_00000000_00200000_00000000, 74);
    try test__clzti2(0x00000000_00000000_00400000_00000000, 73);
    try test__clzti2(0x00000000_00000000_00800000_00000000, 72);
    try test__clzti2(0x00000000_00000000_01000000_00000000, 71);
    try test__clzti2(0x00000000_00000000_02000000_00000000, 70);
    try test__clzti2(0x00000000_00000000_04000000_00000000, 69);
    try test__clzti2(0x00000000_00000000_08000000_00000000, 68);
    try test__clzti2(0x00000000_00000000_10000000_00000000, 67);
    try test__clzti2(0x00000000_00000000_20000000_00000000, 66);
    try test__clzti2(0x00000000_00000000_40000000_00000000, 65);
    try test__clzti2(0x00000000_00000000_80000000_00000000, 64);

    try test__clzti2(0x00000000_00000001_00000000_00000000, 63);
    try test__clzti2(0x00000000_00000002_00000000_00000000, 62);
    try test__clzti2(0x00000000_00000004_00000000_00000000, 61);
    try test__clzti2(0x00000000_00000008_00000000_00000000, 60);
    try test__clzti2(0x00000000_00000010_00000000_00000000, 59);
    try test__clzti2(0x00000000_00000020_00000000_00000000, 58);
    try test__clzti2(0x00000000_00000040_00000000_00000000, 57);
    try test__clzti2(0x00000000_00000080_00000000_00000000, 56);
    try test__clzti2(0x00000000_00000100_00000000_00000000, 55);
    try test__clzti2(0x00000000_00000200_00000000_00000000, 54);
    try test__clzti2(0x00000000_00000400_00000000_00000000, 53);
    try test__clzti2(0x00000000_00000800_00000000_00000000, 52);
    try test__clzti2(0x00000000_00001000_00000000_00000000, 51);
    try test__clzti2(0x00000000_00002000_00000000_00000000, 50);
    try test__clzti2(0x00000000_00004000_00000000_00000000, 49);
    try test__clzti2(0x00000000_00008000_00000000_00000000, 48);
    try test__clzti2(0x00000000_00010000_00000000_00000000, 47);
    try test__clzti2(0x00000000_00020000_00000000_00000000, 46);
    try test__clzti2(0x00000000_00040000_00000000_00000000, 45);
    try test__clzti2(0x00000000_00080000_00000000_00000000, 44);
    try test__clzti2(0x00000000_00100000_00000000_00000000, 43);
    try test__clzti2(0x00000000_00200000_00000000_00000000, 42);
    try test__clzti2(0x00000000_00400000_00000000_00000000, 41);
    try test__clzti2(0x00000000_00800000_00000000_00000000, 40);
    try test__clzti2(0x00000000_01000000_00000000_00000000, 39);
    try test__clzti2(0x00000000_02000000_00000000_00000000, 38);
    try test__clzti2(0x00000000_04000000_00000000_00000000, 37);
    try test__clzti2(0x00000000_08000000_00000000_00000000, 36);
    try test__clzti2(0x00000000_10000000_00000000_00000000, 35);
    try test__clzti2(0x00000000_20000000_00000000_00000000, 34);
    try test__clzti2(0x00000000_40000000_00000000_00000000, 33);
    try test__clzti2(0x00000000_80000000_00000000_00000000, 32);

    try test__clzti2(0x00000001_00000000_00000000_00000000, 31);
    try test__clzti2(0x00000002_00000000_00000000_00000000, 30);
    try test__clzti2(0x00000004_00000000_00000000_00000000, 29);
    try test__clzti2(0x00000008_00000000_00000000_00000000, 28);
    try test__clzti2(0x00000010_00000000_00000000_00000000, 27);
    try test__clzti2(0x00000020_00000000_00000000_00000000, 26);
    try test__clzti2(0x00000040_00000000_00000000_00000000, 25);
    try test__clzti2(0x00000080_00000000_00000000_00000000, 24);
    try test__clzti2(0x00000100_00000000_00000000_00000000, 23);
    try test__clzti2(0x00000200_00000000_00000000_00000000, 22);
    try test__clzti2(0x00000400_00000000_00000000_00000000, 21);
    try test__clzti2(0x00000800_00000000_00000000_00000000, 20);
    try test__clzti2(0x00001000_00000000_00000000_00000000, 19);
    try test__clzti2(0x00002000_00000000_00000000_00000000, 18);
    try test__clzti2(0x00004000_00000000_00000000_00000000, 17);
    try test__clzti2(0x00008000_00000000_00000000_00000000, 16);
    try test__clzti2(0x00010000_00000000_00000000_00000000, 15);
    try test__clzti2(0x00020000_00000000_00000000_00000000, 14);
    try test__clzti2(0x00040000_00000000_00000000_00000000, 13);
    try test__clzti2(0x00080000_00000000_00000000_00000000, 12);
    try test__clzti2(0x00100000_00000000_00000000_00000000, 11);
    try test__clzti2(0x00200000_00000000_00000000_00000000, 10);
    try test__clzti2(0x00400000_00000000_00000000_00000000, 9);
}
