const negv = @import("negv.zig");
const testing = @import("std").testing;

fn test__negvti2(a: i128, expected: i128) !void {
    var result = negv.__negvti2(a);
    try testing.expectEqual(expected, result);
}

test "negvti2" {
    // -2^127 <= i128 <= 2^127-1
    // 2^127 = 170141183460469231731687303715884105728
    // 2^127+1 = 170141183460469231731687303715884105727
    // TODO write panic handler for testing panics
    //try test__negvti2(-170141183460469231731687303715884105728, -5); // tested with return -5; and panic
    try test__negvti2(-170141183460469231731687303715884105727, 170141183460469231731687303715884105727);
    try test__negvti2(-170141183460469231731687303715884105726, 170141183460469231731687303715884105726);
    try test__negvti2(-170141183460469231731687303715884105725, 170141183460469231731687303715884105725);
    try test__negvti2(-170141183460469231731687303715884105724, 170141183460469231731687303715884105724);
    try test__negvti2(-42, 42);
    try test__negvti2(-7, 7);
    try test__negvti2(-1, 1);
    try test__negvti2(0, 0);
    try test__negvti2(1, -1);
    try test__negvti2(7, -7);
    try test__negvti2(42, -42);
    try test__negvti2(170141183460469231731687303715884105724, -170141183460469231731687303715884105724);
    try test__negvti2(170141183460469231731687303715884105725, -170141183460469231731687303715884105725);
    try test__negvti2(170141183460469231731687303715884105726, -170141183460469231731687303715884105726);
    try test__negvti2(170141183460469231731687303715884105727, -170141183460469231731687303715884105727);
}
