/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.IOException;
import org.zanata.adapter.po.PoWriter2;
import org.zanata.client.commands.pull.AbstractPullStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;

public abstract class AbstractGettextPullStrategy
extends AbstractPullStrategy {
    private final PoWriter2 poWriter;
    private StringSet extensions = new StringSet("gettext;comment");

    protected AbstractGettextPullStrategy(PullOptions opts) {
        super(opts);
        this.poWriter = new PoWriter2.Builder().encodeTabs(opts.getEncodeTabs()).continueAfterError(opts.isContinueAfterError()).approvedOnly(opts.getApprovedOnly()).create();
    }

    protected PoWriter2 getPoWriter() {
        return this.poWriter;
    }

    @Override
    public StringSet getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean needsDocToWriteTrans() {
        return true;
    }

    @Override
    public void writeSrcFile(Resource doc) throws IOException {
        File potDir = this.getOpts().getSrcDir();
        File potFile = new File(potDir, doc.getName() + ".pot");
        this.getPoWriter().writePotToFile(potFile, doc);
    }
}

