/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.ProjectConfigHandler;
import org.zanata.client.commands.init.ProjectIterationPrompt;
import org.zanata.client.commands.init.ProjectPrompt;
import org.zanata.client.commands.init.SourceConfigPrompt;
import org.zanata.client.commands.init.TransConfigPrompt;
import org.zanata.client.commands.init.UserConfigHandler;
import org.zanata.client.config.ZanataConfig;
import org.zanata.client.util.VersionComparator;
import org.zanata.rest.client.ProjectIterationClient;
import org.zanata.rest.client.RestClientFactory;

public class InitCommand
extends ConfigurableCommand<InitOptions> {
    private static final Logger log = LoggerFactory.getLogger(InitCommand.class);
    private static final String ITERATION_URL = "%siteration/view/%s/%s";
    private ConsoleInteractor console;
    private ProjectConfigHandler projectConfigHandler;
    private UserConfigHandler userConfigHandler;

    public InitCommand(InitOptions opts) {
        super(opts, new RestClientFactory(){
            private static final long serialVersionUID = 1L;
        });
        this.console = new ConsoleInteractorImpl(opts);
        this.projectConfigHandler = new ProjectConfigHandler(this.console, (InitOptions)this.getOpts());
        this.userConfigHandler = new UserConfigHandler(this.console, (InitOptions)this.getOpts());
    }

    @VisibleForTesting
    protected InitCommand(InitOptions opts, ConsoleInteractor console) {
        this(opts, console, new RestClientFactory(){
            private static final long serialVersionUID = 1L;
        });
    }

    @VisibleForTesting
    protected InitCommand(InitOptions opts, ConsoleInteractor console, RestClientFactory restClientFactory) {
        super(opts, restClientFactory);
        this.console = console;
        this.projectConfigHandler = new ProjectConfigHandler(console, (InitOptions)this.getOpts());
        this.userConfigHandler = new UserConfigHandler(console, (InitOptions)this.getOpts());
    }

    @Override
    protected void run() throws Exception {
        if (((InitOptions)this.getOpts()).getUsername() == null) {
            log.info("Username not specified, trying config file");
            this.userConfigHandler.verifyUserConfig();
        }
        this.setClientFactory(OptionsUtil.createClientFactory(this.getOpts()));
        this.ensureServerVersion();
        this.projectConfigHandler.handleExistingProjectConfig();
        new ProjectPrompt(this.console, (InitOptions)this.getOpts(), new ProjectIterationPrompt(this.console, (InitOptions)this.getOpts(), this.getClientFactory()), this.getClientFactory()).selectOrCreateNewProjectAndVersion();
        this.advancedSettingsReminder();
        this.downloadZanataXml(((InitOptions)this.getOpts()).getProj(), ((InitOptions)this.getOpts()).getProjectVersion(), new File("zanata.xml"));
        this.applyConfigFileSilently();
        SourceConfigPrompt sourceConfigPrompt = new SourceConfigPrompt(this.console, (ConfigurableProjectOptions)this.getOpts()).promptUser();
        new TransConfigPrompt(this.console, (ConfigurableProjectOptions)this.getOpts(), sourceConfigPrompt.getDocNames()).promptUser();
        this.writeToConfig(((InitOptions)this.getOpts()).getSrcDir(), sourceConfigPrompt.getIncludes(), sourceConfigPrompt.getExcludes(), ((InitOptions)this.getOpts()).getTransDir(), ((InitOptions)this.getOpts()).getProjectConfig());
        this.displayAdviceAboutWhatIsNext(this.projectConfigHandler.hasOldConfig());
    }

    @VisibleForTesting
    protected void ensureServerVersion() {
        String serverVersion = this.getClientFactory().getServerVersionInfo().getVersionNo();
        if (new VersionComparator().compare(serverVersion, "3.4.0") < 0) {
            this.console.printfln(ConsoleInteractor.DisplayMode.Warning, Messages.get("server.incompatible"), new Object[0]);
            this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("server.incompatible.hint"), new Object[0]);
            throw new RuntimeException(Messages.get("server.incompatible"));
        }
    }

    private void displayAdviceAboutWhatIsNext(boolean hasOldConfig) {
        this.console.printfln(Messages.get("what.next"), new Object[0]);
        if (hasOldConfig) {
            this.console.printfln(Messages.get("compare.project.config"), this.projectConfigHandler.getBackup());
        }
        this.console.printfln(Messages.get("view.project"), InitCommand.getProjectIterationUrl(((InitOptions)this.getOpts()).getUrl(), ((InitOptions)this.getOpts()).getProj(), ((InitOptions)this.getOpts()).getProjectVersion()));
        if (this.isInvokedByMaven()) {
            this.console.printfln(Messages.get("mvn.push.source"), new Object[0]);
            this.console.printfln(Messages.get("mvn.push.both"), new Object[0]);
            this.console.printfln(Messages.get("mvn.push.trans"), new Object[0]);
            this.console.printfln(Messages.get("mvn.help"), new Object[0]);
        } else {
            this.console.printfln(Messages.get("cli.push.source"), new Object[0]);
            this.console.printfln(Messages.get("cli.push.both"), new Object[0]);
            this.console.printfln(Messages.get("cli.push.trans"), new Object[0]);
            this.console.printfln(Messages.get("cli.help"), new Object[0]);
        }
        this.console.printfln(Messages.get("browse.online.help"), new Object[0]);
    }

    private void advancedSettingsReminder() {
        ConfigurableProjectOptions opts = (ConfigurableProjectOptions)this.getOpts();
        this.console.printfln(ConsoleInteractor.DisplayMode.Warning, Messages.get("customize.languages.warning"), new Object[0]);
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("view.project"), InitCommand.getProjectIterationUrl(opts.getUrl(), opts.getProj(), opts.getProjectVersion()));
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("continue.yes.no"), new Object[0]);
        this.console.expectYes();
    }

    private void applyConfigFileSilently() throws ConfigurationException, JAXBException {
        ConfigurableProjectOptions opts = (ConfigurableProjectOptions)this.getOpts();
        org.apache.log4j.Logger logger = LogManager.getLogger(OptionsUtil.class);
        Level preLevel = logger.getLevel();
        logger.setLevel(Level.OFF);
        OptionsUtil.applyConfigFiles(opts);
        logger.setLevel(preLevel);
        this.console.printfln(ConsoleInteractor.DisplayMode.Confirmation, Messages.get("project.version.type.confirmation"), opts.getProjectType(), opts.getProj(), opts.getProjectVersion());
    }

    private boolean isInvokedByMaven() {
        return ((InitOptions)this.getOpts()).getClass().getPackage().getName().contains("maven");
    }

    private static String getProjectIterationUrl(URL server, String projectSlug, String iterationSlug) {
        return String.format(ITERATION_URL, server, projectSlug, iterationSlug);
    }

    public static void offerRetryOnServerError(Exception e, ConsoleInteractor consoleInteractor) {
        consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Warning, Messages.get("server.error"), Throwables.getRootCause((Throwable)e).getMessage());
        consoleInteractor.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("server.error.try.again"), new Object[0]);
        consoleInteractor.expectYes();
    }

    @VisibleForTesting
    protected void downloadZanataXml(String projectId, String iterationId, File configFileDest) throws IOException {
        String content;
        ProjectIterationClient projectIterationClient = this.getClientFactory().getProjectIterationClient(projectId, iterationId);
        try {
            content = projectIterationClient.sampleConfiguration();
        }
        catch (Exception e) {
            InitCommand.offerRetryOnServerError(e, this.console);
            this.downloadZanataXml(projectId, iterationId, configFileDest);
            return;
        }
        boolean created = configFileDest.createNewFile();
        Preconditions.checkState((boolean)created, (String)"Can not create %s. Make sure permission is writable.", (Object[])new Object[]{configFileDest});
        log.debug("project config from the server:\n{}", (Object)content);
        FileUtils.write((File)configFileDest, (CharSequence)content, (Charset)Charsets.UTF_8);
        ((InitOptions)this.getOpts()).setProjectConfig(configFileDest);
    }

    @VisibleForTesting
    protected void writeToConfig(File srcDir, String includes, String excludes, File transDir, File configFile) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ZanataConfig.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        ZanataConfig currentConfig = (ZanataConfig)unmarshaller.unmarshal(configFile);
        currentConfig.setSrcDir(srcDir.getPath());
        currentConfig.setIncludes(Strings.emptyToNull((String)includes));
        currentConfig.setExcludes(Strings.emptyToNull((String)excludes));
        currentConfig.setHooks(null);
        if (currentConfig.getLocales().isEmpty()) {
            currentConfig.setLocales(null);
        }
        currentConfig.setTransDir(transDir.getPath());
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)currentConfig, configFile);
        this.console.printfln(ConsoleInteractor.DisplayMode.Confirmation, "Project config created at:%s", ((InitOptions)this.getOpts()).getProjectConfig());
    }
}

