/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.zanata.common.DocumentType;
import org.zanata.common.FileTypeInfo;
import org.zanata.rest.DocumentFileUploadForm;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.ChunkUploadResponse;

public class FileResourceClient {
    private final RestClientFactory factory;
    private final URI baseUri;
    private final Annotation[] multipartFormAnnotations = new Annotation[]{new MultipartFormLiteral()};

    FileResourceClient(RestClientFactory restClientFactory) {
        this.factory = restClientFactory;
        this.baseUri = restClientFactory.getBaseUri();
    }

    @Deprecated
    public List<DocumentType> acceptedFileTypes() {
        List types = (List)this.factory.getClient().target(this.baseUri).path("/file/accepted_document_types").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)new GenericType<List<DocumentType>>(){});
        return types;
    }

    public List<FileTypeInfo> fileTypeInfoList() {
        List types = (List)this.factory.getClient().target(this.baseUri).path("/file/file_type_info").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)new GenericType<List<FileTypeInfo>>(){});
        return types;
    }

    public ChunkUploadResponse uploadSourceFile(String projectSlug, String iterationSlug, String docId, DocumentFileUploadForm documentFileUploadForm) {
        Client client = this.factory.getClient();
        Invocation.Builder builder = client.target(this.baseUri).path("file").path("source").path(projectSlug).path(iterationSlug).queryParam("docId", new Object[]{docId}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Response response = builder.post(Entity.entity((Object)documentFileUploadForm, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE, (Annotation[])this.multipartFormAnnotations));
        response.bufferEntity();
        return (ChunkUploadResponse)response.readEntity(ChunkUploadResponse.class);
    }

    public ChunkUploadResponse uploadTranslationFile(String projectSlug, String iterationSlug, String locale, String docId, String mergeType, DocumentFileUploadForm documentFileUploadForm) {
        Client client = this.factory.getClient();
        Invocation.Builder builder = client.target(this.baseUri).path("/file").path("translation").path(projectSlug).path(iterationSlug).path(locale).queryParam("docId", new Object[]{docId}).queryParam("merge", new Object[]{mergeType}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Response response = builder.post(Entity.entity((Object)documentFileUploadForm, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE, (Annotation[])this.multipartFormAnnotations));
        response.bufferEntity();
        return (ChunkUploadResponse)response.readEntity(ChunkUploadResponse.class);
    }

    public Response downloadSourceFile(String projectSlug, String iterationSlug, String fileType, String docId) {
        WebTarget webResource = this.factory.getClient().target(this.baseUri).path("/file").path("source").path(projectSlug).path(iterationSlug).path(fileType);
        return webResource.queryParam("docId", new Object[]{docId}).request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get();
    }

    public Response downloadTranslationFile(String projectSlug, String iterationSlug, String locale, String fileExtension, String docId) {
        return this.downloadTranslationFile(projectSlug, iterationSlug, locale, fileExtension, docId, false);
    }

    public Response downloadTranslationFile(String projectSlug, String iterationSlug, String locale, String fileExtension, String docId, boolean approvedOnly) {
        WebTarget webResource = this.factory.getClient().target(this.baseUri).path("/file").path("translation").path(projectSlug).path(iterationSlug).path(locale).path(fileExtension);
        return webResource.queryParam("docId", new Object[]{docId}).queryParam("approvedOnly", new Object[]{approvedOnly}).request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get();
    }

    private static class MultipartFormLiteral
    implements MultipartForm {
        private MultipartFormLiteral() {
        }

        public Class<? extends Annotation> annotationType() {
            return MultipartForm.class;
        }
    }
}

