/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.glossary;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.zanata.adapter.glossary.AbstractGlossaryPushReader;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.GlossaryTerm;
import org.zanata.rest.dto.QualifiedName;

public class GlossaryCSVReader
extends AbstractGlossaryPushReader {
    private final LocaleId srcLang;
    private static final String POS = "POS";
    private static final String[] POSSYNONYMS = new String[]{"POS", "PARTOFSPEECH", "PART OF SPEECH"};
    private static final String DESC = "DESCRIPTION";
    private static final String[] DESCSYNONYMS = new String[]{"DESCRIPTION", "DESC", "DEFINITION"};
    private static final int TERM = 0;

    public GlossaryCSVReader(LocaleId srcLang) {
        this.srcLang = srcLang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<LocaleId, List<GlossaryEntry>> extractGlossary(Reader reader, String qualifiedName) throws IOException {
        try {
            CSVParser rawRecords = CSVFormat.RFC4180.parse(reader);
            ArrayList records = Lists.newArrayList((Iterable)rawRecords);
            this.validateCSVEntries(records);
            Map<String, Integer> descriptionMap = this.setupDescMap(records);
            Map<Integer, LocaleId> localeColMap = this.setupLocalesMap(records, descriptionMap);
            LocaleId srcLocale = localeColMap.get(0);
            if (!this.srcLang.equals((Object)srcLocale)) {
                throw new RuntimeException("input source language '" + this.srcLang + "' does not match source language in file '" + srcLocale + "'");
            }
            HashMap results = Maps.newHashMap();
            for (CSVRecord row : records.subList(1, records.size())) {
                GlossaryEntry entry = new GlossaryEntry();
                entry.setSrcLang(srcLocale);
                if (descriptionMap.containsKey(POS)) {
                    entry.setPos(row.get(descriptionMap.get(POS).intValue()));
                }
                if (descriptionMap.containsKey(DESC)) {
                    entry.setDescription(row.get(descriptionMap.get(DESC).intValue()));
                }
                entry.setQualifiedName(new QualifiedName(qualifiedName));
                for (int x = 1; x < row.size() && localeColMap.containsKey(x); ++x) {
                    GlossaryTerm srcTerm = new GlossaryTerm();
                    srcTerm.setLocale(srcLocale);
                    srcTerm.setContent(row.get(0));
                    entry.getGlossaryTerms().add(srcTerm);
                    LocaleId transLocaleId = localeColMap.get(x);
                    String transContent = row.get(x);
                    GlossaryTerm transTerm = new GlossaryTerm();
                    transTerm.setLocale(transLocaleId);
                    transTerm.setContent(transContent);
                    entry.getGlossaryTerms().add(transTerm);
                    List list = (List)results.get(transLocaleId);
                    if (list == null) {
                        list = Lists.newArrayList();
                    }
                    list.add(entry);
                    results.put(transLocaleId, list);
                }
            }
            HashMap hashMap = results;
            return hashMap;
        }
        finally {
            reader.close();
        }
    }

    private void validateCSVEntries(@Nonnull List<CSVRecord> records) {
        if (records.isEmpty()) {
            throw new RuntimeException("Invalid CSV file - empty file");
        }
        if (records.size() < 2) {
            throw new RuntimeException("Invalid CSV file - no entries found");
        }
        for (int i = 1; i < records.size(); ++i) {
            CSVRecord record = records.get(i);
            if (records.get(0).size() == record.size()) continue;
            throw new RuntimeException("Invalid CSV file - inconsistency of columns with header");
        }
    }

    private Map<Integer, LocaleId> setupLocalesMap(List<CSVRecord> records, Map<String, Integer> descriptionMap) {
        HashMap<Integer, LocaleId> localeColMap = new HashMap<Integer, LocaleId>();
        CSVRecord headerRow = records.get(0);
        for (int column = 0; column < headerRow.size() && !descriptionMap.containsValue(column); ++column) {
            LocaleId locale = new LocaleId(StringUtils.trim((String)headerRow.get(column)));
            localeColMap.put(column, locale);
        }
        return localeColMap;
    }

    private Map<String, Integer> setupDescMap(List<CSVRecord> records) {
        HashMap<String, Integer> descMap = new HashMap<String, Integer>();
        CSVRecord headerRow = records.get(0);
        for (int position = 1; position < headerRow.size(); ++position) {
            String headerItem = headerRow.get(position);
            if (headerItem.trim().length() == 0) continue;
            if (Arrays.asList(POSSYNONYMS).contains(headerItem.toUpperCase())) {
                descMap.put(POS, position);
                continue;
            }
            if (!Arrays.asList(DESCSYNONYMS).contains(headerItem.toUpperCase())) continue;
            descMap.put(DESC, position);
        }
        return descMap;
    }
}

