/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.zanata.client.commands.stats.ContainerStatisticsCommandOutput;
import org.zanata.rest.dto.Link;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.dto.stats.TranslationStatistics;

public class ConsoleStatisticsOutput
implements ContainerStatisticsCommandOutput {
    @Override
    public void write(ContainerTranslationStatistics statistics) {
        Link sourceRef;
        ArrayList stats = statistics.getStats();
        if (stats == null) {
            stats = new ArrayList();
        }
        if ((sourceRef = statistics.getRefs().findLinkByRel("statSource")).getType().equals("PROJ_ITER")) {
            System.out.println("Project Version: " + statistics.getId());
        } else if (sourceRef.getType().equals("DOC")) {
            System.out.println();
            System.out.println("Document: " + statistics.getId());
        }
        Collections.sort(stats, new Comparator<TranslationStatistics>(){

            @Override
            public int compare(TranslationStatistics o1, TranslationStatistics o2) {
                int localeComparisson = o1.getLocale().compareTo(o2.getLocale());
                if (localeComparisson == 0) {
                    return o1.getUnit().toString().compareTo(o2.getUnit().toString());
                }
                return localeComparisson;
            }
        });
        String[] headers = new String[]{"Locale", "Unit", "Total", "Translated", "Need Review", "Untranslated", "Last Translated"};
        Object[][] data = new Object[stats.size()][headers.length];
        int statsSize = stats.size();
        for (int i = 0; i < statsSize; ++i) {
            TranslationStatistics s = (TranslationStatistics)stats.get(i);
            data[i] = new Object[]{s.getLocale(), s.getUnit(), s.getTotal(), s.getTranslatedAndApproved(), s.getDraft(), s.getUntranslated(), s.getLastTranslated()};
        }
        ConsoleStatisticsOutput.printTable(headers, data);
        if (statistics.getDetailedStats() != null) {
            for (ContainerTranslationStatistics detailedStats : statistics.getDetailedStats()) {
                this.write(detailedStats);
            }
        }
    }

    private static void printTable(String[] headers, Object[][] rows) {
        int i;
        int[] colWidths = new int[headers.length];
        int tableWidth = 0;
        for (i = 0; i < headers.length; ++i) {
            int maxWidth = headers[i].length() + 3;
            for (Object[] row : rows) {
                if (row[i].toString().length() + 3 <= maxWidth) continue;
                maxWidth = row[i].toString().length() + 3;
            }
            colWidths[i] = maxWidth;
            tableWidth += maxWidth;
        }
        System.out.println();
        for (i = 0; i < tableWidth; ++i) {
            System.out.print("=");
        }
        System.out.println();
        for (i = 0; i < headers.length; ++i) {
            System.out.printf("%1$" + colWidths[i] + "s", headers[i]);
        }
        System.out.println();
        for (i = 0; i < tableWidth; ++i) {
            System.out.print("=");
        }
        System.out.println();
        for (Object[] row : rows) {
            int rowLength = row.length;
            for (int i2 = 0; i2 < rowLength; ++i2) {
                Object column = row[i2];
                System.out.printf("%1$" + colWidths[i2] + "s", column);
            }
            System.out.println();
        }
        for (int i3 = 0; i3 < tableWidth; ++i3) {
            System.out.print("=");
        }
        System.out.println();
    }
}

