/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.collect.ImmutableList;
import java.io.File;
import org.apache.tools.ant.DirectoryScanner;
import org.zanata.client.commands.push.PushOptions;

public abstract class AbstractCommonPushStrategy<O extends PushOptions> {
    private O opts;

    public O getOpts() {
        return this.opts;
    }

    public void setPushOptions(O opts) {
        this.opts = opts;
    }

    public String[] getSrcFiles(File srcDir, ImmutableList<String> includes, ImmutableList<String> excludes, ImmutableList<String> fileExtensions, boolean useDefaultExcludes, boolean isCaseSensitive) {
        if (includes.isEmpty()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String fileExtension : fileExtensions) {
                builder.add((Object)("**/*" + fileExtension));
            }
            includes = builder.build();
        }
        ImmutableList.Builder emptyFileExcludesBuilder = ImmutableList.builder();
        for (String fileExtension : fileExtensions) {
            emptyFileExcludesBuilder.add((Object)("**/" + fileExtension));
        }
        DirectoryScanner dirScanner = new DirectoryScanner();
        if (useDefaultExcludes) {
            dirScanner.addDefaultExcludes();
        }
        dirScanner.setBasedir(srcDir);
        dirScanner.setCaseSensitive(isCaseSensitive);
        emptyFileExcludesBuilder.addAll(excludes);
        ImmutableList allExcludes = emptyFileExcludesBuilder.build();
        dirScanner.setExcludes((String[])allExcludes.toArray((Object[])new String[allExcludes.size()]));
        dirScanner.setIncludes((String[])includes.toArray((Object[])new String[includes.size()]));
        dirScanner.scan();
        String[] includedFiles = dirScanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            includedFiles[i] = includedFiles[i].replace(File.separator, "/");
        }
        return includedFiles;
    }
}

