/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import org.zanata.client.commands.DocNameWithExt;
import org.zanata.common.ProjectType;

public class DocNameWithoutExt {
    private final String name;

    DocNameWithoutExt(String name) {
        this.name = name;
    }

    public static DocNameWithoutExt from(String docName) {
        return new DocNameWithoutExt(docName);
    }

    public DocNameWithExt toDocNameWithExt(ProjectType projectType) {
        switch (projectType) {
            case Utf8Properties: 
            case Properties: {
                return DocNameWithExt.from(this.name, "properties");
            }
            case Gettext: 
            case Podir: {
                return DocNameWithExt.from(this.name, "pot");
            }
            case Xliff: 
            case Xml: {
                return DocNameWithExt.from(this.name, "xml");
            }
            case File: {
                throw new IllegalArgumentException("You cannot use document name without extension with FILE project type");
            }
        }
        throw new IllegalStateException("Cannot determine file extension for this project type: " + projectType);
    }
}

