/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.net.URI;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Response;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Account;

public class AccountClient {
    private final RestClientFactory factory;
    private final URI baseUri;

    AccountClient(RestClientFactory factory) {
        this.factory = factory;
        this.baseUri = factory.getBaseUri();
    }

    @Nullable
    public Account get(String username) {
        try {
            return (Account)this.webResource(username).get(Account.class);
        }
        catch (ResponseProcessingException e) {
            if (e.getResponse().getStatusInfo().equals(Response.Status.NOT_FOUND)) {
                return null;
            }
            throw e;
        }
    }

    public Response put(String username, Account account) {
        Response response = this.webResource(username).put(Entity.entity((Object)account, (String)"application/vnd.zanata.account+xml"));
        response.close();
        return response;
    }

    private Invocation.Builder webResource(String username) {
        return this.factory.getClient().target(this.baseUri).path("accounts").path("u").path(username).request(new String[]{"application/vnd.zanata.account+xml"});
    }
}

