/*-
 * Copyright (c) 2001-2003 Allan Saddi <allan@saddi.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY ALLAN SADDI AND HIS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL ALLAN SADDI OR HIS CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: yafic.h 906 2003-12-06 00:05:14Z asaddi $
 */

#ifndef _YAFIC_H
#define _YAFIC_H

#include <sys/types.h>
#include <sys/stat.h>

#if HAVE_INTTYPES_H
# include <inttypes.h>
#else
# if HAVE_STDINT_H
#  include <stdint.h>
# endif
#endif

#define DEFAULT_CONF "yafic.conf"
#define DEFAULT_ROOT ""
#define DEFAULT_CHECK_DB "yafic.db"
#define DEFAULT_UPDATE_DB "yafic_new.db"

#define RULESET_TABLE_SIZE 1021

#define RFLAG_PERM	1
#define RFLAG_INODE	2
#define RFLAG_NLINK	4
#define RFLAG_UID	8
#define RFLAG_GID	16
#define RFLAG_SIZE	32
#define RFLAG_ATIME	64
#define RFLAG_MTIME	128
#define RFLAG_CTIME	256
#define RFLAG_HASH	512

#define RFLAG_IGNORE	1024
#define RFLAG_UPDATE	2048

#define RFLAG_DEFAULT	(RFLAG_PERM | RFLAG_INODE | RFLAG_NLINK | \
			 RFLAG_UID | RFLAG_GID | RFLAG_MTIME | \
			 RFLAG_CTIME | RFLAG_HASH)

#define RFLAG_MAX	10

enum {
  RMASK_DIR = 0,
  RMASK_FILE,
  RMASK_LINK,
  RMASK_SPECIAL,

  RMASK_MAX
};

#define RMASK_DEFAULT	(RFLAG_PERM | RFLAG_INODE | RFLAG_NLINK | \
			 RFLAG_UID | RFLAG_GID | RFLAG_SIZE | RFLAG_ATIME | \
			 RFLAG_MTIME | RFLAG_CTIME | RFLAG_HASH)

typedef unsigned short rflag_t;

struct RuleEntry {
  struct RuleEntry *next; /* Next entry in hash chain. */

  char *path; /* Pathname of entry. */
  rflag_t entryFlags; /* Entry's flags. */
  rflag_t descFlags; /* Flags of any descendents. */
  rflag_t masks[RMASK_MAX]; /* Per-type masks for descendents. */
};

#define CONFIG_DIRMASK "%dirmask"
#define CONFIG_FILEMASK "%filemask"
#define CONFIG_LINKMASK "%linkmask"
#define CONFIG_SPECIALMASK "%specialmask"

/* yafic.c */
extern int Verbosity;
extern int DisplayHashes;
extern int SignVerifyFiles;

/* yafic.c */
const char *ToHexStr (const uint8_t *data, int len);
void DisplayFileHash (int fd, const char *filename);

/* ruleset.c */
void InitRuleSet (void);
int ParseRuleSet (const char *conf);
struct RuleEntry *FindRuleEntry (const char *path);
struct RuleEntry *FindClosestRuleEntry (const char *path);
void ApplyRuleSet (void (*func) (struct RuleEntry *re));
void DumpClassFlags (void);
void DumpRuleEntry (struct RuleEntry *re);
void CleanRuleSet (void);

/* view.c */
void ViewDB (const char *root, const char *dbName, const char *type);

/* statpack.c */
void PackStat (struct stat *sb, uint8_t *buf);
void UnpackStat (uint8_t *buf, struct stat *sb);

#endif /* !_YAFIC_H */
