// Copyright (c) 2020, QuantStack and XVega Contributors
//
// Distributed under the terms of the BSD 3-Clause License.
//
// The full license is in the file LICENSE, distributed with this software.

#ifndef XVEGA_ENCODING_COLUMN_HPP
#define XVEGA_ENCODING_COLUMN_HPP

#include <xproperty/xobserved.hpp>

#include <xtl/xoptional.hpp>
#include <xtl/xjson.hpp>

#include <nlohmann/json.hpp>

#include "../../encoding-channel-options/aggregate.hpp"
#include "../../encoding-channel-options/bin.hpp"
#include "../../encoding-channel-options/field.hpp"
#include "../../encoding-channel-options/header.hpp"
#include "../../encoding-channel-options/sort.hpp"
#include "../../encoding-channel-options/timeunit.hpp"
#include "../../../../utils/custom_datatypes.hpp"

namespace nl = nlohmann;

namespace xv
{
    struct Column : public xp::xobserved<Column>
    {
        XPROPERTY(xtl::xoptional<agg_type>, Column, aggregate);
        XPROPERTY(xtl::xoptional<std::string>, Column, align);
        XPROPERTY(xtl::xoptional<bin_type>, Column, bin);
        XPROPERTY(xtl::xoptional<bool>, Column, center);
        XPROPERTY(xtl::xoptional<field_type>, Column, field);
        XPROPERTY(xtl::xoptional<Header>, Column, header);
        XPROPERTY(xtl::xoptional<sort_type>, Column, sort);
        XPROPERTY(xtl::xoptional<double>, Column, spacing);
        XPROPERTY(xtl::xoptional<time_unit_type>, Column, timeUnit);
        XPROPERTY(xtl::xoptional<string_vec_none_type>, Column, title);
        XPROPERTY(xtl::xoptional<std::string>, Column, type);
    };

    XVEGA_API void to_json(nl::json& j, const Column& data);
}

#endif
