/*_
 * Copyright (c) 2005, 2006 Markus W. Weissmann <mww@opendarwin.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of OpenDarwin nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: pkg.h,v 1.8 2006/02/09 07:37:34 mww Exp $
 *
 */

#ifndef _XPKG_PKG_H_
#define _XPKG_PKG_H_

#include <stdint.h>
#include <sys/queue.h>
#include <xar/xar.h>

#include "file.h"
#include "item.h"
#include "xpkg.h"

/* strcuture of a package, incl. name, version, requirements, etc. */
struct xpkg_pkg_t {
	LIST_ENTRY(xpkg_pkg_t) entries;
	xar_t archive;
	char *name;
	char *version;
	int32_t revision;
	int32_t major;
	int32_t minor;
	char *xpkg_version;
	xpkg_items_t requires;
	xpkg_items_t provides;
	xpkg_files_t files;
};

/* declare the list-header structure */
LIST_HEAD(xpkg_pkgs_t, xpkg_pkg_t);

/* allocate a new package (xpkg_pkg_t) */
xpkg_pkg_t
pkg_create(const char *name, const char* version, int32_t revision, int32_t major, int32_t minor);

/* create a list if packages (xpkg_pkg_t) */
xpkg_pkgs_t
pkgs_create();

/* insert pkg into the the pkgs-list */
void
pkg_to_pkgs(xpkg_pkgs_t pkgs, xpkg_pkg_t pkg);

#endif
