/*_
 * Copyright (c) 2005, Markus W. Weissmann <mww@opendarwin.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of OpenDarwin nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: file.h,v 1.6 2005/09/07 10:48:38 mww Exp $
 *
 */

#ifndef _XPKG_FILE_H_
#define _XPKG_FILE_H_
#include <stdint.h>
#include <sys/queue.h>
#include "xpkg.h"

typedef enum {
	XPKG_FILE_REG=1,	/* regular file */
	XPKG_FILE_DIR=2,	/* directory */
	XPKG_FILE_LNK=3		/* symlink */
} XPKG_FILE_TYPE;

struct xpkg_file_t {
	LIST_ENTRY(xpkg_file_t) entries;
	char* path;			/* complete path of file */
	char* chksum;		/* checksum (if available) */
	XPKG_FILE_TYPE ftype;
};

typedef struct xpkg_file_t *xpkg_file_t;

LIST_HEAD(xpkg_files_t, xpkg_file_t);

xpkg_file_t
file_create(const char *name, XPKG_FILE_TYPE ftype, const char *chksum);

xpkg_files_t
files_create();

void
file_to_files(xpkg_files_t files, xpkg_file_t file);

void
file_print(xpkg_file_t file);

#endif
