/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;

public class SourceCodeSerializer
extends Serializer {
    private Stack parents = new Stack();
    private int count = 1;

    public SourceCodeSerializer(OutputStream outputStream) {
        super(outputStream);
    }

    public SourceCodeSerializer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
    }

    public void write(Document document) throws IOException {
        int n;
        this.parents.push("doc");
        Element element = document.getRootElement();
        this.write(element);
        for (n = 0; n < document.indexOf((Node)element); ++n) {
            this.writeChild(document.getChild(n));
        }
        for (n = document.indexOf((Node)element) + 1; n < document.getChildCount(); ++n) {
            this.writeChild(document.getChild(n));
        }
        this.flush();
    }

    protected void writeStartTag(Element element) throws IOException {
        String string = "e" + this.count;
        this.writeRaw("Element " + string + " = new Element(\"" + element.getQualifiedName() + "\", \"" + element.getNamespaceURI() + "\");");
        this.breakLine();
        if (this.count == 1) {
            this.writeRaw("Document doc = new Document(e1);");
        } else {
            this.writeRaw(this.parents.peek() + ".appendChild(" + string + ");");
        }
        this.breakLine();
        this.parents.push(string);
        this.writeAttributes(element);
        this.writeNamespaceDeclarations(element);
        ++this.count;
    }

    protected void writeEndTag(Element element) throws IOException {
        this.parents.pop();
    }

    protected void writeEmptyElementTag(Element element) throws IOException {
        this.writeStartTag(element);
        this.writeEndTag(element);
    }

    protected void writeAttributes(Element element) throws IOException {
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            Attribute attribute = element.getAttribute(i);
            this.write(attribute);
        }
    }

    protected void write(Attribute attribute) throws IOException {
        String string = (String)this.parents.peek();
        this.writeRaw(string + ".addAttribute(new Attribute(\"" + attribute.getQualifiedName() + "\", " + "\"" + attribute.getNamespaceURI() + "\", \"" + SourceCodeSerializer.escapeText(attribute.getValue()) + "\"));");
        this.breakLine();
    }

    private static String escapeText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block6;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block6;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected void writeNamespaceDeclarations(Element element) throws IOException {
        block0: for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            String string = element.getNamespacePrefix(i);
            if (string.equals(element.getNamespacePrefix())) continue;
            for (int j = 0; j < element.getAttributeCount(); ++j) {
                if (string.equals(element.getAttribute(j).getNamespacePrefix())) continue block0;
            }
            String string2 = (String)this.parents.peek();
            this.writeRaw(string2 + ".addNamespaceDeclaration(\"" + string + "\", \"" + element.getNamespaceURI(string) + "\");");
            this.breakLine();
        }
    }

    protected void write(ProcessingInstruction processingInstruction) throws IOException {
        String string = (String)this.parents.peek();
        if (string.equals("doc")) {
            Document document = processingInstruction.getDocument();
            int n = document.indexOf((Node)processingInstruction);
            this.writeRaw(string + ".insertChild(new ProcessingInstruction(\"" + processingInstruction.getTarget() + "\", \"" + SourceCodeSerializer.escapeText(processingInstruction.getValue()) + "\"), " + n + ");");
        } else {
            this.writeRaw(string + ".appendChild(new ProcessingInstruction(\"" + processingInstruction.getTarget() + "\", \"" + SourceCodeSerializer.escapeText(processingInstruction.getValue()) + "\"));");
        }
        this.breakLine();
    }

    protected void write(DocType docType) throws IOException {
        this.writeRaw("DocType doctype = new DocType(\"" + docType.getRootElementName() + "\", \"" + docType.getPublicID() + "\", \"" + docType.getSystemID() + "\");");
        this.breakLine();
        Document document = docType.getDocument();
        int n = document.indexOf((Node)document.getRootElement());
        this.writeRaw("doc.insertChild(doctype, " + n + ");");
        this.breakLine();
    }

    protected void write(Comment comment) throws IOException {
        String string = (String)this.parents.peek();
        if (string.equals("doc")) {
            Document document = comment.getDocument();
            int n = document.indexOf((Node)comment);
            this.writeRaw(string + ".insertChild(new Comment(\"" + SourceCodeSerializer.escapeText(comment.getValue()) + "\"), " + n + ");");
        } else {
            this.writeRaw(string + ".appendChild(new Comment(\"" + SourceCodeSerializer.escapeText(comment.getValue()) + "\");");
        }
        this.breakLine();
    }

    protected void write(Text text) throws IOException {
        String string = (String)this.parents.peek();
        this.writeRaw(string + ".appendChild(new Text(\"" + SourceCodeSerializer.escapeText(text.getValue()) + "\"));");
        this.breakLine();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.SourceCodeSerializer URL");
            return;
        }
        try {
            Builder builder = new Builder();
            Document document = builder.build(stringArray[0]);
            SourceCodeSerializer sourceCodeSerializer = new SourceCodeSerializer(System.out, "ISO-8859-1");
            sourceCodeSerializer.write(document);
            sourceCodeSerializer.flush();
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + stringArray[0]);
        }
    }
}

