/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Serializer;

public final class NonRecursiveSerializer
extends Serializer {
    public NonRecursiveSerializer(OutputStream outputStream) {
        super(outputStream);
    }

    public NonRecursiveSerializer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
    }

    protected void write(Element element) throws IOException {
        if (element.getChildCount() == 0) {
            super.writeEmptyElementTag(element);
        } else {
            Element element2 = element;
            boolean bl = false;
            int n = -1;
            while (true) {
                if (!bl && element2.getChildCount() > 0) {
                    this.writeStartTag(element2);
                    element2 = element2.getChild(0);
                    n = 0;
                    continue;
                }
                if (bl) {
                    this.writeEndTag(element2);
                    if (element2 == element) {
                        break;
                    }
                } else {
                    this.writeChild((Node)element2);
                }
                bl = false;
                ParentNode parentNode = element2.getParent();
                if (parentNode.getChildCount() - 1 == n) {
                    element2 = parentNode;
                    if (element2 != element) {
                        parentNode = element2.getParent();
                        n = parentNode.indexOf((Node)element2);
                    }
                    bl = true;
                    continue;
                }
                element2 = parentNode.getChild(++n);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.PrettyPrinter URL");
            return;
        }
        try {
            Builder builder = new Builder();
            Document document = builder.build(stringArray[0]);
            Serializer serializer = new Serializer((OutputStream)System.out, "ISO-8859-1");
            serializer.setIndent(4);
            serializer.setMaxLength(64);
            serializer.setPreserveBaseURI(true);
            serializer.write(document);
            serializer.flush();
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not check " + stringArray[0]);
        }
    }
}

